# ----------------------------------------------------------------------
#  PURPOSE:  Tracking for hazardous products manufactured by the
#            "toaster" company.
#
#   AUTHOR:  Michael J. McLennan       Phone: (215)770-2842
#            AT&T Bell Laboratories   E-mail: aluxpo!mmc@att.com
#
#     SCCS:  @(#)Hazard.tcl	1.2 (8/24/93)
# ----------------------------------------------------------------------
#            Copyright (c) 1993  AT&T  All Rights Reserved
# ======================================================================

itcl_class HazardRec {
	constructor {cname} {
		set class $cname
	}
	method change {var inc} {
		if {![info exists $var]} {
			error "bad field \"$var\""
		}
		incr $var $inc
	}
	method report {} {
		return "$class: $total produced, $actives active, $accidents accidents"
	}
	protected class {}
	protected total 0
	protected actives 0
	protected accidents 0
}

itcl_class Hazard {

	constructor {} {
		set class [virtual info class]
		if {![info exists recs($class)]} {
			set recs($class) [HazardRec #auto $class]
		}
		$recs($class) change total +1
		$recs($class) change actives +1
	}
	destructor {
		set class [virtual info class]
		$recs($class) change actives -1
	}

	method accident {mesg} {
		set class [virtual info class]
		$recs($class) change accidents +1
		puts stderr $mesg
	}

	proc report {class} {
		if {[info exists recs($class)]} {
			return [$recs($class) report]
		} else {
			error "no information for class \"$class\""
		}
	}
    common recs
}
