# ----------------------------------------------------------------------
#  PURPOSE:  Class definition for handling toasters via [incr Tcl].
#
#   AUTHOR:  Michael J. McLennan       Phone: (215)770-2842
#            AT&T Bell Laboratories   E-mail: aluxpo!mmc@att.com
#
#     SCCS:  @(#)Toaster.tcl	1.1 (7/22/93)
# ----------------------------------------------------------------------
#            Copyright (c) 1993  AT&T  All Rights Reserved
# ======================================================================

itcl_class Toaster {
	inherit Appliance Hazard

	constructor {config} {}
	destructor {
		if {$crumbs > 0} {
			puts stdout "$crumbs crumbs ... what a mess!"
		}
	}
	method config {config} {}

	method toast {nslices} {
		power [expr 0.03*$heat]
		if {$nslices < 1 || $nslices > 2} {
			error "bad number of slices: should be 1 or 2"
		}
		set crumbs [expr $crumbs+$heat*$nslices]
		if {$crumbs >= $maxcrumbs} {
			accident "== FIRE! FIRE! =="
			set crumbs $maxcrumbs
		}
		return [check]
	}

	method clean {} {
		power 0.5
		set crumbs 0
		return [check]
	}

	method check {} {
		set level [expr $crumbs*100.0/$maxcrumbs]
		return [format "crumb tray: %.0f%% full" $level]
	}

	proc resize {newsize} {
		set maxcrumbs $newsize
	}

	public heat 3 {
		if {$heat < 1 || $heat > 5} {
			error "invalid setting $heat: should be 1-5"
		}
	}
	protected crumbs 0
	common maxcrumbs 40
}
