'\"
'\" Copyright (C) 1993 Daniel Simmons, Michael Hewitt & Idaho State University
'\" For distribution terms see the file COPYING (GNU GPL).
'\"
'\" Copyright (c) 1990 The Regents of the University of California.
'\" All rights reserved.
'\"
'\" Permission is hereby granted, without written agreement and without
'\" license or royalty fees, to use, copy, modify, and distribute this
'\" documentation for any purpose, provided that the above copyright
'\" notice and the following two paragraphs appear in all copies.
'\"
'\" IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY
'\" FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
'\" ARISING OUT OF THE USE OF THIS DOCUMENTATION, EVEN IF THE UNIVERSITY OF
'\" CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
'\"
'\" THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
'\" INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY
'\" AND FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS
'\" ON AN "AS IS" BASIS, AND THE UNIVERSITY OF CALIFORNIA HAS NO OBLIGATION TO
'\" PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
'\" 
'/" 
.\" The definitions below are for supplemental macros used in Tcl/Tk
.\" manual entries.
.\"
.\" .HS name section [date [version]]
.\"	Replacement for .TH in other man pages.  See below for valid
.\"	section names.
.\"
.\" .AP type name in/out [indent]
.\"	Start paragraph describing an argument to a library procedure.
.\"	type is type of argument (int, etc.), in/out is either "in", "out",
.\"	or "in/out" to describe whether procedure reads or modifies arg,
.\"	and indent is equivalent to second arg of .IP (shouldn't ever be
.\"	needed;  use .AS below instead)
.\"
.\" .AS [type [name]]
.\"	Give maximum sizes of arguments for setting tab stops.  Type and
.\"	name are examples of largest possible arguments that will be passed
.\"	to .AP later.  If args are omitted, default tab stops are used.
.\"
.\" .BS
.\"	Start box enclosure.  From here until next .BE, everything will be
.\"	enclosed in one large box.
.\"
.\" .BE
.\"	End of box enclosure.
.\"
.\" .VS
.\"	Begin vertical sidebar, for use in marking newly-changed parts
.\"	of man pages.
.\"
.\" .VE
.\"	End of vertical sidebar.
.\"
.\" .DS
.\"	Begin an indented unfilled display.
.\"
.\" .DE
.\"	End of indented unfilled display.
.\"
'\"	# Heading for Tcl/Tk man pages
.de HS
.ds ^3 \\0
.if !"\\$3"" .ds ^3 \\$3
.if '\\$2'cmds'       .TH \\$1 1 \\*(^3 \\$4
.if '\\$2'lib'        .TH \\$1 3 \\*(^3 \\$4
.if '\\$2'tcl'        .TH \\$1 n \\*(^3 Tcl "Tcl Built-In Commands"
.if '\\$2'tk'         .TH \\$1 n \\*(^3 Tk "Tk Commands"
.if '\\$2'tclc'        .TH \\$1 3 \\*(^3 Tcl "Tcl Library Procedures"
.if '\\$2'tkc'         .TH \\$1 3 \\*(^3 Tk "Tk Library Procedures"
.if '\\$2'tclcmds'         .TH \\$1 1 \\*(^3 Tk "Tcl Applications"
.if '\\$2'tkcmds'         .TH \\$1 1 \\*(^3 Tk "Tk Applications"
.if t .wh -1.3i ^B
.nr ^l \\n(.l
.ad b
..
'\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ie !"\\$3"" \{\
.ta \\n()Au \\n()Bu
\&\\$1	\\fI\\$2\\fP	(\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
'\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
'\"	# BS - start boxed text
'\"	# ^y = starting y location
'\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
'\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
'\"	# VS - start vertical sidebar
'\"	# ^Y = starting y location
'\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
'\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
'\"	# Special macro to handle page bottom:  finish off current
'\"	# box/sidebar if in box/sidebar mode, then invoked standard
'\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
'\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
'\"	# DE - end display
.de DE
.fi
.RE
.sp .5
..
.HS tributton tk
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
tributton \- Create and manipulate triangular button widgets
.SH SYNOPSIS
\fBtributton\fI \fIpathName \fR?\fIoptions\fR?
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 4c 8c 12c
\fBactiveBackground\fR	\fBbackground\fR	\fBforeground\fR
\fBactiveForeground\fR	\fBborderWidth\fR	\fBrelief\fR
\fBanchor\fR	\fBcursor\fR
.fi
.LP
See the ``options'' manual entry for details on the standard options.
.SH "WIDGET-SPECIFIC OPTIONS"
.ta 4c
.LP
.nf
Name:	\fBcommand\fR
Class:	\fBCommand\fR
Command-Line Switch:	\fB\-command\fR
.fi
.IP
Specifies a Tcl command to associate with the tributton.  This command
is typically invoked when mouse button 1 is released over the tributton
window.
.LP
.nf
Name:	\fBdirection\fR
Class:	\fBDirection\fR
Command-Line Switch:	\fB\-direction\fR
.fi
.IP
Specifies a desired direction for the tributton.
The direction indicates which way the point of the triangle will face,
and must be one of \fBn\fR, \fBe\fR, \fBs\fR, or \fBw\fR.
.LP
.nf
Name:	\fBlength\fR
Class:	\fBLength\fR
Command-Line Switch:	\fB\-length\fR
.fi
.IP
Specifies the length of the tributton along the "longer" axis.  That is to
say, the length of the line bisecting the angle of the point.
.LP
.nf
Name:	\fBstate\fR
Class:	\fBwidth\fR
Command-Line Switch:	\fB\-state\fR
.fi
.IP
Specifies one of three states for the tributton:  \fBnormal\fR, \fBactive\fR,
or \fBdisabled\fR.  In normal state the tributton is displayed using the
\fBforeground\fR and \fBbackground\fR options.  The active state is
typically used when the pointer is over the tributton.  In active state
the tributton is displayed using the \fBactiveForeground\fR and
\fBactiveBackground\fR options.  Disabled state means that the tributton
is insensitive:  it doesn't activate and doesn't respond to mouse
button presses.
.BE

.SH DESCRIPTION
.PP
The \fBtributton\fR command creates a new window (given by the
\fIpathName\fR argument) and makes it into a tributton widget.
Additional
options, described above, may be specified on the command line
or in the option database
to configure aspects of the tributton such as its colors, direction,
and initial relief.  The \fBtributton\fR command returns its
\fIpathName\fR argument.  At the time this command is invoked,
there must not exist a window named \fIpathName\fR, but
\fIpathName\fR's parent must exist.
.PP
A tributton is a widget
that displays a triangle modelled after the arrow buttons at the ends
of a scrollbar.
It can display itself in either of three different ways, according
to
the \fBstate\fR option; 
it can be made to appear raised, sunken, or flat;
and it can be made to flash.  When a user invokes the
tributton (by pressing mouse button 1 with the cursor over the
tributton), then the Tcl command specified in the \fB\-command\fR
option is invoked.

.SH "WIDGET COMMAND"
.PP
The \fBtributton\fR command creates a new Tcl command whose
name is \fIpathName\fR.  This
command may be used to invoke various
operations on the widget.  It has the following general form:
.DS C
\fIpathName option \fR?\fIarg arg ...\fR?
.DE
\fIOption\fR and the \fIarg\fRs
determine the exact behavior of the command.  The following
commands are possible for tributton widgets:
.TP
\fIpathName \fBactivate\fR
Change the tributton's state to \fBactive\fR and redisplay the tributton
using its active foreground and background colors instead of normal
colors.
This command is ignored if the tributton's state is \fBdisabled\fR.
This command is obsolete and will eventually be removed;
use ``\fIpathName \fBconfigure \-state active\fR'' instead.
.TP
\fIpathName \fBconfigure\fR ?\fIoption\fR? ?\fIvalue option value ...\fR?
Query or modify the configuration options of the widget.
If no \fIoption\fR is specified, returns a list describing all of
the available options for \fIpathName\fR (see \fBTk_ConfigureInfo\fR for
information on the format of this list).  If \fIoption\fR is specified
with no \fIvalue\fR, then the command returns a list describing the
one named option (this list will be identical to the corresponding
sublist of the value returned if no \fIoption\fR is specified).  If
one or more \fIoption\-value\fR pairs are specified, then the command
modifies the given widget option(s) to have the given value(s);  in
this case the command returns an empty string.
\fIOption\fR may have any of the values accepted by the \fBtributton\fR
command.
.TP
\fIpathName \fBdeactivate\fR
Change the tributton's state to \fBnormal\fR and redisplay the tributton
using its normal foreground and background colors.
This command is ignored if the tributton's state is \fBdisabled\fR.
This command is obsolete and will eventually be removed;
use ``\fIpathName \fBconfigure \-state normal\fR'' instead.
.TP
\fIpathName \fBflash\fR
Flash the tributton.  This is accomplished by redisplaying the tributton
several times, alternating between active and normal colors.  At
the end of the flash the tributton is left in the same normal/active
state as when the command was invoked.
This command is ignored if the tributton's state is \fBdisabled\fR.
.TP
\fIpathName \fBinvoke\fR
Invoke the Tcl command associated with the tributton, if there is one.
The return value is the return value from the Tcl command, or an
empty string if there is no command associated with the tributton.
This command is ignored if the tributton's state is \fBdisabled\fR.

.SH "DEFAULT BINDINGS"
.PP
Tk automatically creates class bindings for tributtons that give them
the following default behavior:
.IP [1]
The tributton activates whenever the mouse passes over it and deactivates
whenever the mouse leaves the tributton.
.IP [2]
The tributton's relief is changed to sunken whenever mouse button 1 is
pressed over the tributton, and the relief is restored to its original
value when button 1 is later released.
.IP [3]
If mouse button 1 is pressed over the tributton and later released over
the tributton, the tributton is invoked.  However, if the mouse is not
over the tributton when button 1 is released, then no invocation occurs.
.PP
If the tributton's state is \fBdisabled\fR then none of the above
actions occur:  the tributton is completely non-responsive.
.PP
The behavior of tributtons can be changed by defining new bindings for
individual widgets or by redefining the class bindings.

.SH KEYWORDS
button, widget
