/* 
 * vxCompat.c --
 *
 *	This file contains compatibility procedures required for VxWorks.
 *
 * Copyright (c) 1987-1993 The Regents of the University of California.
 * All rights reserved.
 *
 * Permission is hereby granted, without written agreement and without
 * license or royalty fees, to use, copy, modify, and distribute this
 * software and its documentation for any purpose, provided that the
 * above copyright notice and the following two paragraphs appear in
 * all copies of this software.
 * 
 * IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY FOR
 * DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT
 * OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF THE UNIVERSITY OF
 * CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND THE UNIVERSITY OF CALIFORNIA HAS NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
 */

#ifndef lint
static char rcsid[] = "$Header: /users/earl/Boomer/Lib/tcl7.3/RCS/tclUtil.c,v 1.84 1993/10/11 09:18:49 ouster Exp earl $ SPRITE (Berkeley)";
#endif

#include "tclInt.h"
#include "tclUnix.h"
#include <float.h>
#include <math.h>

/*
 *----------------------------------------------------------------------
 *
 * unsetenv --
 *
 *	Remove an environment variable.
 *
 * Side effects:
 *	The global environment space may change.
 *
 *----------------------------------------------------------------------
 */

void
unsetenv(name)
    CONST char *name;
{
    char        **envFind();
    char        **ppVar;
    size_t        nameLength;
    int          *pnEntries;
    WIND_TCB     *pTcb;
    extern char **ppGlobalEnviron;
    extern int    nEntries;

    nameLength = strlen(name);

    pTcb = taskTcb(0);

    pnEntries = (pTcb->ppEnviron == 0)
	      ? &nEntries
	      : &pTcb->nEnvVarEntries;

    while ((ppVar = envFind(name, nameLength)) != 0)
    {
	(*pnEntries)--;
	free(*ppVar);
	for (ppVar++; (ppVar[-1] = ppVar[0]) != 0; ppVar++)
	    continue;
    }
}

/*
 *----------------------------------------------------------------------
 *
 * waitpid --
 *
 *	Return success indicating that there are no children.
 *
 * Side effects:
 *	None.
 *
 *----------------------------------------------------------------------
 */

#undef waitpid
int
waitpid(pid, pstatus, modifier)
    int pid;
    int *pstatus;
    int modifier;
{
    return 0;
}

/*
 *----------------------------------------------------------------------
 *
 * access --
 *
 *	Check file access permissions.
 *
 * Results:
 *	Returns 0 if file can be accessed, otherwise returns -1 with
 *	problem indication in errno.
 *
 * Side effects:
 *	Opens and closes a file descriptor.
 *
 *----------------------------------------------------------------------
 */

int
access(name, mode)
    char *name;
    int mode;
{
    int fd;
    struct stat statbuf;

    switch (mode)
    {
        default:
            return -1;

	case X_OK:
	    if (stat(name, &statbuf) != 0 ||
	       (statbuf.st_mode & (S_IXUSR | S_IXGRP | S_IXOTH)) == 0)
		return -1;
	    break;

	case F_OK:
	    if (stat(name, &statbuf) != 0)
		return -1;
	    break;

        case R_OK:
            if ((fd = open(name, O_RDONLY, 0)) < 0) 
                return -1;
            (void) close(fd);
            break;

        case W_OK:
            if ((fd = open(name, O_WRONLY, 0)) < 0) 
                return -1;
            (void) close(fd);
            break;
    }

    return 0;
}

/*
 *----------------------------------------------------------------------
 *
 * hypot --
 *
 *	Compute Euclidean distance.
 *
 * Results:
 *	Returns the Euclidean distance sqrt(x*x + y*y). This code is
 *	based on the BSD 4.4 code but doesn't accommodate NaNs or INFs.
 *
 * Side effects:
 *	None.
 *
 *----------------------------------------------------------------------
 */
double
hypot(x, y)
    double x;
    double y;
{
    double ha, a, ma;
    double hb, b, mb;
    int    ea;
    int    eb;
    int    es;

    /* Determine magnitudes only */
    ha = x < 0 ? -x : x;
    hb = y < 0 ? -y : y;

    /* Larger value in a, smaller in b */
    if (ha > hb) { a = ha; b = hb; }
    else         { a = hb; b = ha; }
    
    /* Decompose to obtain exponent and mantissa */
    ma = frexp(a, &ea);
    mb = frexp(b, &eb);

    /* If the exponent difference is sufficiently large, the result
     * is simply the sum of the two.
     */
    if ((ma - mb) > DBL_MANT_DIG)
	return a+b;

    /* If the exponents are large in magnitude, scale the result back */
    if (ea >= DBL_MAX_EXP / 2)
	es = DBL_MAX_EXP / 2;
    else if (eb < - (-DBL_MIN_EXP / 2))
	es = -DBL_MIN_EXP / 2;
    else
	es = 0;

    ea -= es;
    eb -= es;

    /* Reconstitute the values and compute the distance */
    a = ldexp(ma, ea);
    b = ldexp(mb, eb) / a;

    return ldexp(a * sqrt(1 + b * b), es);
}
