'\"
'\" Copyright (c) 1990 The Regents of the University of California.
'\" All rights reserved.
'\"
'\" Permission is hereby granted, without written agreement and without
'\" license or royalty fees, to use, copy, modify, and distribute this
'\" documentation for any purpose, provided that the above copyright
'\" notice and the following two paragraphs appear in all copies.
'\"
'\" IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY
'\" FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
'\" ARISING OUT OF THE USE OF THIS DOCUMENTATION, EVEN IF THE UNIVERSITY OF
'\" CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
'\"
'\" THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
'\" INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY
'\" AND FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS
'\" ON AN "AS IS" BASIS, AND THE UNIVERSITY OF CALIFORNIA HAS NO OBLIGATION TO
'\" PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
'\" 
.\" The definitions below are for supplemental macros used in Tcl/Tk
.\" manual entries.
.\"
.\" .HS name section [date [version]]
.\"	Replacement for .TH in other man pages.  See below for valid
.\"	section names.
.\"
.\" .AP type name in/out [indent]
.\"	Start paragraph describing an argument to a library procedure.
.\"	type is type of argument (int, etc.), in/out is either "in", "out",
.\"	or "in/out" to describe whether procedure reads or modifies arg,
.\"	and indent is equivalent to second arg of .IP (shouldn't ever be
.\"	needed;  use .AS below instead)
.\"
.\" .AS [type [name]]
.\"	Give maximum sizes of arguments for setting tab stops.  Type and
.\"	name are examples of largest possible arguments that will be passed
.\"	to .AP later.  If args are omitted, default tab stops are used.
.\"
.\" .BS
.\"	Start box enclosure.  From here until next .BE, everything will be
.\"	enclosed in one large box.
.\"
.\" .BE
.\"	End of box enclosure.
.\"
.\" .VS
.\"	Begin vertical sidebar, for use in marking newly-changed parts
.\"	of man pages.
.\"
.\" .VE
.\"	End of vertical sidebar.
.\"
.\" .DS
.\"	Begin an indented unfilled display.
.\"
.\" .DE
.\"	End of indented unfilled display.
.\"
'\"	# Heading for Tcl/Tk man pages
.de HS
.ds ^3 \\0
.if !"\\$3"" .ds ^3 \\$3
.if '\\$2'cmds'       .TH \\$1 1 \\*(^3 \\$4
.if '\\$2'lib'        .TH \\$1 3 \\*(^3 \\$4
.if '\\$2'tcldp'         .TH \\$1 n \\*(^3 Tcl-DP "Tcl-DP Commands"
.if '\\$2'tcldpc'         .TH \\$1 3 \\*(^3 Tcl-DP "Tcl-DP Library Procedures"
.if '\\$2'tcldpcmds'         .TH \\$1 1 \\*(^3 Tcl-DP "Tcl-DP Applications"
.if '\\$2'tcldpintro'         .TH \\$1 n \\*(^3 Tcl-DP "Introduction to Tcl-DP"
.if t .wh -1.3i ^B
.nr ^l \\n(.l
.ad b
..
'\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ie !"\\$3"" \{\
.ta \\n()Au \\n()Bu
\&\\$1	\\fI\\$2\\fP	(\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
'\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
'\"	# BS - start boxed text
'\"	# ^y = starting y location
'\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
'\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
'\"	# VS - start vertical sidebar
'\"	# ^Y = starting y location
'\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
'\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
'\"	# Special macro to handle page bottom:  finish off current
'\"	# box/sidebar if in box/sidebar mode, then invoked standard
'\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
'\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
'\"	# DE - end display
.de DE
.fi
.RE
.sp .5
..
.HS Tcl-DP tcldpintro
.BS
.SH NAME
.LP 
Tcl-DP - distributed programming extension to Tcl/Tk
.BE
.SH DESCRIPTION
.LP

Tcl-DP is a freely distributable extension to Tcl/Tk and stands
for Tcl Distributed Programming.  Tcl-DP adds TCP and IP
connection management, remote procedure call (RPC), and
distributed object support to Tcl/Tk.  Tcl stands for Tool
Command Language, a freely distributable, embeddable scripting
language.  Tk stands for Toolkit, a freely distributable X
windows widget set extension to Tcl.

This man page provides an overview of the Tcl-DP programmer
interface.  The Tcl/Tk commands provided by Tcl-DP can be
separated into three levels:

.SH CONNECTION MANAGEMENT COMMANDS
.LP

Tcl-DP adds to Tcl/Tk several commands which manage basic TCP and
IP network connections.  Among these connection management
commands are dp_address, dp_accept, dp_connect,
shutdown, dp_sendTo,
dp_receiveFrom, and dp_filehandler.  These commands provide
basically the same level of service as the UNIX C socket(2)
related system calls.

These connection management commands return and take as arguments
identifiers called \fIsockId\fR's.  (A \fIsockId\fR represents a
UNIX file descriptor, which UNIX uses to represent
both open files and open sockets.  A socket is an endpoint of
network communication.)  These \fIsockId\fR's are identical to
the identifiers manipulated by the read, gets, puts,
and close file management commands of Tcl.

.SH REMOTE PROCEDURE CALL COMMANDS
.LP

The RPC commands of Tcl-DP are implemented on top of the
connection management commands listed above.  For speed, some of
the RPC commands are actually implemented in C instead of Tcl/Tk
scripting.  These RPC commands include dp_MakeRPCServer,
dp_MakeRPCClient, dp_RPC, and dp_CloseRPC.  The basic
dp_RPC command has the following form:

dp_RPC \fIsockId\fR ?\fIargs\fR?

Here is an example usage:

dp_RPC file4 puts stdout "hello world"

The above RPC command will send its \fIargs\fR argument (the
string {puts stdout "hello world"}) to the connected remote
process, represented by file4.  The remote process will evaluate
the received \fIargs\fR string in its Tcl interpreter.  Any
return value will be sent back to the waiting RPC caller process.
Since all data and commands in Tcl/Tk are strings, there are no
data conversion or format problems.

.SH DISTRIBUTED OBJECT SUPPORT COMMANDS 
.LP

The distributed object commands of Tcl-DP are implemented on top
of the RPC commands described above.  An object in Tcl-DP is a
procedure, just like a widget instance of Tk is a procedure.  A
procedural object must take as its first argument a method
selector.  In other words, if \fIobject\fR is the name of a
procedural object:

\fIobject\fB \fImethod\fR ?\fIargs ...\fR?

Objects can have slots.  Objects which are to be distributed
using Tcl-DP must handle two methods, \fBconfigure\fR and
\fBslot-value\fR, which access the slots of the object.

The configure method must handle three different forms of
arguments, which makes it very much like the configure
option for Tk widgets:

\fIobject\fB \fBconfigure\fR ?\fI-slot\fR?
.br
\fIobject\fB \fBconfigure\fR ?\fI-slot value ...\fR?
.br
\fIobject\fB \fBconfigure\fR

The slot-value method must take one argument:

\fIobject\fB \fBslot-value\fR ?\fIslot\fR?

Objects are usually defined in C for speed but have a Tcl access
interface.  For example, Tk widgets are defined in C but have Tcl
access interfaces.  Objects can also be defined using Tcl/Tk
scripting only, as Tcl-DP supplies several utility procedures for
creating and manipulating objects with Tcl/Tk scripting only.
(See dp_object(l).)

Once you have created an object, you may distribute that object
among several RPC connected processes.  Use the
dp_DistributeObject and dp_UndistributeObject commands.
(The graph of RPC connections among these processes must be
acyclic.)

Once an object is distributed, use the dp_setf and dp_getf
commands, not the configure and slot-value methods,
to access the slots of the distributed object.  These two
commands, dp_setf and dp_getf, replicate any slot value
changes to all processes where the object is distributed.

You may set triggers on any slot of any Tcl-DP distributed object
with the dp_SetTrigger, and associated commands.  Trigger are code
that is evaluated when the value of a slot in an object changes.

.SH C INTERFACE
.LP

A C language interface is provided for several of the commands of
Tcl-DP.  See the man pages DP_Address(3), DP_Network(3), and DP_RPC(3).

.SH SECURITY
.LP

The Tcl-DP package provides little support for access and
authentication security.  With Tcl-DP, any process can send any
Tcl/Tk command to any remote process.

A standard measure is to remove or undefine "dangerous" Tcl/Tk
commands, through the Tcl rename command.  Some of the Tcl
commands which you would probably want to remove include
open, exec, proc, dp_connect (from Tcl-DP),
and lastly rename.  

The procedure auto_load_all is supplied, which will
source all autoloading Tcl library scripts not already
source'd.  Use auto_load_all before you undefine the
Tcl proc command.

.SH AUTHOR
Brian Smith (bsmith@cs.berkeley.edu)
.br
Steve Yen (syen@cs.berkeley.edu)
.br
Stephen Tu (tus@roger-rabbit.cs.berkeley.edu)
