.TH TmCore 3 "24 July 1993"
.SH NAME
.B TmCore
- the Core widget class
.SH SYNOPSIS
No command exists to create this widget - it is for inheritance
purposes only.
.br
.SH DESCRIPTION
This is the
.I tcl
binding to the Xt Core widget.
.SH RESOURCES
The new resources are
.IP
background
.br
backgroundPixmap
.br
borderColor
.br
borderPixmap
.br
borderWidth
.br
destroyCallback
.br
height
.br
mappedWhenManaged
.br
sensitive
.br
width
.br
x
.br
y
.LP
.TP 5 5
.B background
The value for this resource is the name of a color.
.TP 5 5
.B height
The value for this resource is an integer number of pixels.
.TP 5 5
.B sensitive
The values for this resource are
.RS 10
.br
true
.br
false
.RE 10
.SH METHODS
The methods supported for this widget and all its descendants are
.RS 5
getValues
.br
setValues
.br
manageChild
.br
unmanageChild
.br
getGC
.br
callActionProc
.br
destroyWidget
.br
dragStart
.br
dropSiteRegister
.br
isComposite
.br
isConstraint
.br
isManaged
.br
isSensitive
.br
isShell
.br
mapWidget
.br
processTraversal
.br
realizeWidget
.br
resources
.br
setSensistive
.br
unmapWidget
.RE

.LP
.TP 5 5
\fBgetValues\fP \fI-resource vbl ...\fP
.B getValues
takes a list of resource/variable pairs and stores the value of each
resource in the corresponding variable.

.TP 5 5
\fBsetValues\fP \fI-resource value ...\fP
.B setValues
takes a list of resource/value pairs and sets each resource to the
corresponding value.

.TP 5 5
.B manageChild
This manages the child and brings it under the geometry management of
the parent.

.TP 5 5
.B unmanageChild
This removes the child from the geometry management of the parent.
.TP 5 5
\fBgetGC\fP -background \fIbg\fP -foreground \fIfg\fP
This method creates a graphics context with the specified foreground
and background values, and returns an XID that can be used in drawing
commands requiring a graphics context.

.TP 5 5
\fBcallActionProc\fP \fIaction\fP [options]
This calls the widget action specified.
The action must be in the form it would appear in an action table,
The event included given to the action is by default of type
ClientMessage.
Options include
.br
-type ButtonRelease | ButtonPress | KeyRelease | KeyPress
.br
.RS 10
This sets the event type.
.RE
.br
-x
.I x
.RS 10
This sets the 
.I x
value in the event.
.RE
-y
.I y
.RS 10
This sets the
.I y
value in the event.
.RE
.br
-keysysm
.I keysym
.RS 10
This sets the keysym for a KeyRelease or KeyPress event. A
.I keysym
is the Xt abstraction for keys.
.RE
For example the arrow widget has an action Activate() which requires
x and y values of the pointer:
.ti +5
callActionproc Activate() -type ButtonPress -x 0 -y 0

.TP 5 5
.B destroyWidget
The destroys the widget and the
.I tcl
command associated to it.

.TP 5 5
.B dragStart
This is used in drag and drop. See TmDrag.man.

.TP 5 5
.B dropSiteRegister
This is used in drag and drop. See TmDrag.man.

.TP 5 5
.B mapWidget
This maps the widget, causing it to become visible if unmapped.

.TP 5 5
\fB processTraversal \fP direction
This sets the widget that receives the next keyboard events. The possible
values are 
.RS 10
current
.br
down
.br
home
.br
left
.br
next
.br
next_tab_group
.br
prev
.br
prev_tab_group
.br
right
.br
up
.RE

.TP 5 5
.B realizeWidget
This realizes the widget and all its children, which creates windows
for the widget and its children. 
Generally this would only be used on `.', but may be used on other
widgets if it is neccessary that they have an X window.

.TP 5 5
.B resources
This returns a list of resources that the widget has.
Each element of the list consists of a list of five values:
the resource name as used in get/setValues,
the resource name as used in resource files,
the resource class as used in resource files,
the resource type as known to Motif
and the resource value.
in cases where the resource value makes no sense (as in
a C pointer), it is replaced by an empty string.


.TP 5 5
\fB setSensitive \fP true | false
Sets the sensitivity of the widget to input events to either
true or false.

.TP 5 5
.B unmapWidget
This unmaps the widget, removing it from the display.
It does not remove it from the geometry management of the parent.

.SH "CALLBACK SUBSTITUTIONS
No substitutions are supported for this class.
.SH BUGS
None known.
.SH AUTHOR
.LP
Jan Newmarch, University of Canberra
