/* 
 * tmTclCommands.c --
 *
 *	This file contains the loader for the commands recognised
 *	by the moat interpreter to give Motif support.
 *
 * Copyright 1993 Jan Newmarch, University of Canberra.
 * Permission to use, copy, modify, and distribute this
 * software and its documentation for any purpose and without
 * fee is hereby granted, provided that the above copyright
 * notice appear in all copies.  The author
 * makes no representations about the suitability of this
 * software for any purpose.  It is provided "as is" without
 * express or implied warranty.

 *
 * Copyright 1990-1992 Regents of the University of California.
 * Permission to use, copy, modify, and distribute this
 * software and its documentation for any purpose and without
 * fee is hereby granted, provided that the above copyright
 * notice appear in all copies.  The University of California
 * makes no representations about the suitability of this
 * software for any purpose.  It is provided "as is" without
 * express or implied warranty.
 */

#ifndef lint
static char rcsid[] = "$Header$";
#endif
#include "tm.h"
#include "tmFuncs.h"

#if XmVersion > 1001
#include <Xm/XmAll.h>

#else
#include <X11/Intrinsic.h>
#include <Xm/ArrowB.h>
#include <Xm/BulletinB.h>
#include <Xm/CascadeB.h>
#include <Xm/Command.h>
#include <Xm/DialogS.h>
#include <Xm/DrawingA.h>
#include <Xm/DrawnB.h>
#include <Xm/FileSB.h>
#include <Xm/Form.h>
#include <Xm/Frame.h>
#include <Xm/Label.h>
#include <Xm/List.h>
#include <Xm/MainW.h>
#include <Xm/MenuShell.h>
#include <Xm/MessageB.h>
#include <Xm/PanedW.h>
#include <Xm/PushB.h>
#include <Xm/RowColumn.h>
#include <Xm/Scale.h>
#include <Xm/ScrollBar.h>
#include <Xm/ScrolledW.h>
#include <Xm/SelectioB.h>
#include <Xm/Separator.h>
#include <Xm/Text.h>
#include <Xm/TextF.h>
#include <Xm/ToggleB.h>
#endif / * XmVersion */

/*
 * Commands that are part of the intrinsics:
 */

Tm_Cmd Tm_Commands[] = {
    /*
     * Widget-creation commands.
     */
    {xmArrowButton,	Tm_AnyCmd,	Tm_AnyWidgetCmd},
    {xmBulletinBoard,	Tm_AnyCmd, 	Tm_AnyWidgetCmd},
    {xmBulletinBoardDialog, Tm_DialogCmd, Tm_AnyWidgetCmd},
    {xmCascadeButton,	Tm_AnyCmd, 	Tm_AnyWidgetCmd},
    {xmCommand,		Tm_AnyCmd, 	Tm_CommandWidgetCmd},
    {xmDialogShell,	Tm_AnyCmd, 	Tm_AnyWidgetCmd},
    {xmDrawingArea,	Tm_AnyCmd, 	Tm_DrawnWidgetCmd},
    {xmDrawnButton,	Tm_AnyCmd, 	Tm_DrawnWidgetCmd},
    {xmErrorDialog,	Tm_DialogCmd, 	Tm_AnyWidgetCmd},
    {xmFileSelectionBox,Tm_HasChildrenCmd, Tm_AnyWidgetCmd},
    {xmFileSelectionDialog, Tm_DialogCmd, Tm_AnyWidgetCmd},
    {xmForm,		Tm_AnyCmd, 	Tm_AnyWidgetCmd},
    {xmFormDialog,	Tm_DialogCmd, 	Tm_AnyWidgetCmd},
    {xmFrame,		Tm_AnyCmd, 	Tm_AnyWidgetCmd},
    {xmInformationDialog, Tm_DialogCmd, Tm_AnyWidgetCmd},
    {xmLabel,		Tm_AnyCmd, 	Tm_AnyWidgetCmd},
    {xmList,		Tm_AnyCmd, 	Tm_ListWidgetCmd},
    {xmMainWindow,	Tm_AnyCmd, 	Tm_AnyWidgetCmd},
    {xmMenuBar,		Tm_RowColumnCmd, Tm_AnyWidgetCmd},
    {xmMessageBox,	Tm_HasChildrenCmd, Tm_AnyWidgetCmd},
    {xmMessageDialog,	Tm_DialogCmd, 	Tm_AnyWidgetCmd},
    {xmOptionMenu,	Tm_RowColumnCmd, Tm_AnyWidgetCmd},
    {xmPanedWindow,	Tm_AnyCmd, 	Tm_AnyWidgetCmd},
    {xmPopupMenu,	Tm_RowColumnCmd, Tm_PopupMenuWidgetCmd},
    {xmPromptDialog,	Tm_DialogCmd, 	Tm_AnyWidgetCmd},
    {xmPulldownMenu,	Tm_RowColumnCmd, Tm_AnyWidgetCmd},
    {xmPushButton,	Tm_AnyCmd, 	Tm_AnyWidgetCmd},
    {xmQuestionDialog,	Tm_DialogCmd, 	Tm_AnyWidgetCmd},
    {xmRowColumn,	Tm_RowColumnCmd, Tm_AnyWidgetCmd},
    {xmScale,		Tm_AnyCmd, 	Tm_AnyWidgetCmd},
    {xmScrollBar,	Tm_AnyCmd, 	Tm_AnyWidgetCmd},
    {xmScrolledList,	Tm_ScrolledCmd, Tm_ListWidgetCmd},
    {xmScrolledText,	Tm_ScrolledCmd, Tm_TextWidgetCmd},
    {xmScrolledWindow,	Tm_HasChildrenCmd, Tm_AnyWidgetCmd},
    {xmSelectionBox,	Tm_HasChildrenCmd, Tm_AnyWidgetCmd},
    {xmSelectionDialog,	Tm_DialogCmd, 	Tm_AnyWidgetCmd},
    {xmSeparator,	Tm_AnyCmd, 	Tm_AnyWidgetCmd},
    {xmText,		Tm_AnyCmd, 	Tm_TextWidgetCmd},
    {xmTextField,	Tm_AnyCmd, 	Tm_TextWidgetCmd},
    {xmToggleButton,	Tm_AnyCmd, 	Tm_AnyWidgetCmd},
    {xmTopLevelShell,	Tm_AnyCmd, 	Tm_ShellWidgetCmd},
    {xmWarningDialog,	Tm_DialogCmd, 	Tm_AnyWidgetCmd},
    {xmWorkingDialog,	Tm_DialogCmd, 	Tm_AnyWidgetCmd},

#if XmVERSION >= 2
    {xmContainer,	Tm_AnyCmd, 	Tm_AnyWidgetCmd},
    {xmCSText,		Tm_AnyCmd, 	Tm_CSTextWidgetCmd},
    {xmIconGadget,	Tm_AnyCmd, 	Tm_AnyWidgetCmd},
    {xmNotebook,	Tm_AnyCmd, 	Tm_NotebookWidgetCmd},
    {xmComboBox,	Tm_ComboBoxCmd, Tm_AnyWidgetCmd},
    {xmDropDownComboBox,Tm_ComboBoxCmd, Tm_AnyWidgetCmd},
    {xmDropDownList,	Tm_ComboBoxCmd, Tm_AnyWidgetCmd},
    {xmSpinBox,		Tm_AnyCmd, 	Tm_AnyWidgetCmd},
#endif /* XmVERSION */
    {(char *) NULL,	(int (*)()) NULL, (Tm_WidgetCmdProc) NULL}
};

extern Tm_Cmd Tm_ExternCommands[];

void Tm_LoadWidgetCommands (interp)
    Tcl_Interp *interp;
{
    register Tm_Cmd *cmdPtr;

    /*
     * Bind in Tm's commands.
     */

    for (cmdPtr = Tm_Commands; cmdPtr->name != NULL; cmdPtr++) {
	Tcl_CreateCommand(interp, cmdPtr->name, cmdPtr->cmdProc,
		(ClientData) cmdPtr->widgetCmdProc, (void (*)()) NULL);
    }

    /*
     * Bind in any other commands desired
     */

    for (cmdPtr = Tm_ExternCommands; cmdPtr->name != NULL; cmdPtr++) {
	Tcl_CreateCommand(interp, cmdPtr->name, cmdPtr->cmdProc,
		(ClientData) cmdPtr->widgetCmdProc, (void (*)()) NULL);
    }
}

