.TH "sender" TCL "" "TCL"
.ad b
.SH NAME
sender - TCL script-level command that creates connections to remote TCL interpreters.
.SH SYNOPSIS
.nf
.ft CW
sender new label [programhost] [portmanagerhost]
sender destroy ipchandle
.ft R
.fi
'
.PP
.SH DESCRIPTION
.PP
This command allows the TCL script-level programmer to create 
connections to other TCL interpreters that have previously registered
themselves with the command \fBreceiver\fR.  The handle
returned from the sender command can be used as an argument with the
\fBisend\fR command.  A PortManager is contacted for information relating
to the desired destination interpreter.
'
.SS sender new label [programhost] [programhost portmanagerhost]
.PP
The new option sets up a connection to another interpreter,  which has 
registered itself as "label".  An optional program host and PortManager
host can be included to allow a more precise definition of the
destination interpreter.
.PP
Parameters:
.RS 2
\fBo \fIlabel\fR - The name the target interpreter used in a 
\fBreceiver new\fR command.
.br
.PP
\fBo \fIprogramhost\fR - This optional item is the name of the
host where the interpreter that registered itself as "label" should be
executing.  If programhost is not included, the PortManager on the
local machine is contacted, and the first interpreter registered under
"label" is returned.  Label/host pairs must be unique within a PortManager so
multiple interpreters under the name "label" may be registered.
.br
.PP
\fBo \fIportmanagerhost\fR - This optional item is the name of the
host where the PortManager that should be contacted regarding this
destination interpreter is executing.
If portmanagerhost is not included, the PortManager on the
local machine is contacted.  If a PortManager host is included, a
programhost must also be included.  This is a limitation in the current
implementation.
.br
.RE
.PP
Returns:
.RS 2
Returns TCL_OK if successful and TCL_ERROR if not.  If successful, the
result is a tclIPC handle that must be used with \fBisend\fR and 
\fBsender destroy\fR.  If TCL_ERROR is returned, the result is a string
description of the problem.
.RE
'
.SS sender destroy ipchandle
.PP
This option destroys the resources associated with the connection.
.PP
Parameters:
.RS 2
\fBo \fIipchandle\fR - A valid sender handle as returned by the 
\fBsender new\fR command.
.br
.RE
.PP
Returns:
.RS 2
Returns TCL_OK if successful and TCL_ERROR if not. 
.RE
'
