/*
 * Copyright 1992 by the National Optical Astronomy Observatories(*)
 *
 * Permission to use, copy, and distribute for non-commercial purposes,
 * is hereby granted without fee, providing that the above copyright
 * notice appear in all copies and that both the copyright notice and this
 * permission notice appear in supporting documentation.
 *
 * This software is provided "as is" without any express or implied warranty.
 *
 * (*) Operated by the Association of Universities for Research in
 *     Astronomy, Inc. (AURA) under cooperative agreement with the
 *     National Science Foundation.
 */
/* File: tclipc.h
 *      This is public interface to the routines that create
 *      and destroy senders and receivers.
 *
 * Created: K. Gillies 26 June 1992
 * SCCS INFO
 *      @(#)tclipc.h	1.1 9/11/92
 *
 */
#ifndef _tclipc_h
#define _tclipc_h

/* This is here to find out if tclIPC.h is included */
#ifndef IPCHDR
#define _TCLIPC_H_RPCGEN

#if defined(__STDC__)
#include <stdarg.h>
#endif

/* Sender and Receiver are opaque */
typedef struct _Sender *Sender;
typedef struct _Receiver *Receiver;

#define PortMgrPortNumber 6601            /* Fixed socket of PortManager */
#define AnyPort 0                         /* Means any port! */

/* The contents of a Port */
typedef struct Port {
  char *hostName;                        /* machine name */
  char *appName;                         /* application label */
  int portNumber;                        /* Port number */
} Port;

/* command part of a cmdType */
typedef char *cmdText;

/* Passed from source to destination process */
typedef struct cmdType {
  int destinationPort;                   /* port for remote receiver */
  cmdText cmd;                           /* actual command */
} cmdType;

/* Returned by destination process to source */
typedef struct evalcmd_res {
  int errno;                             /* TCL_OK or TCL_ERROR */
  cmdText text;                          /* Text of result */
} evalcmd_res;

#endif

/* Some needed defines */
#define MAXHOSTNAMELEN 64
#define LOCALHOST  "localhost"
#define ANYHOST "AnyHost"

/* The name of the local host */
EXTERN char *ipcThisHostName;

/* Used by PortMgr routines.  Just a string. */
typedef char* PortMgrResult;

/* Types for user functions */
/* Type of function required to evaluate commands */
typedef evalcmd_res *(* evalfunction)_ANSI_ARGS_((Tcl_Interp*, cmdText));

/* Type of function required to check for incoming messages */
#define WAITFOREVER -1
typedef void (*listenfunction)_ANSI_ARGS_((void));

/* Type for looking at incoming connection file descriptors */
typedef void (*connectfunction)_ANSI_ARGS_((int newfd));

/* Public functions */

/* Add commands for ipc to an interpreter. Can return TCL_ERROR or TCL_OK */
EXTERN void ipcInterpInit _ANSI_ARGS_((Tcl_Interp *interp));

/* Initialize ipc library.  Call only once. */
EXTERN void ipcSendInit _ANSI_ARGS_((long timeoutsec,
				    long timeoutusec,
				    long receivesec,
				    long receiveusec,
				    evalfunction evaluator,
				    listenfunction listener,
				    connectfunction connect,
				    connectfunction destroyer));

/* Call the blocking wait for message function */
EXTERN void ipcWaitForMessages _ANSI_ARGS_((void));

/* Listen for messages on one descriptor and return */
EXTERN void ipcListenOnceOnSocket _ANSI_ARGS_((int fd));

/* Create a new Sender */
EXTERN Sender ipcNewSender _ANSI_ARGS_((Tcl_Interp *interp, 
				  char *program, char *hostname, 
				  char *portmanhost));
/* Destroy a Sender from a handle */
EXTERN int ipcDestroySenderFromHandle _ANSI_ARGS_((Tcl_Interp *interp, 
						   char *program));

/* Destroy a sender from a sender */
EXTERN int ipcDestroySender _ANSI_ARGS_((Tcl_Interp *interp, 
					 Sender sender));

/* Return socket associated with a Sender */
EXTERN int ipcGetSenderSocket _ANSI_ARGS_((Sender sender));

/* Create a new Receiver */
EXTERN Receiver ipcNewReceiver _ANSI_ARGS_((Tcl_Interp *interp, 
				       char *program, 
				       char *portmanhost));
/* Destroy a Receiver from a Handle */
EXTERN int ipcDestroyReceiverFromHandle _ANSI_ARGS_((Tcl_Interp *interp, 
						     char *handle));

/* Destroy a Receiver */
EXTERN int ipcDestroyReceiver _ANSI_ARGS_((Tcl_Interp *interp, 
					   Receiver receiver));

/* Destroy all outstanding receivers and senders */
EXTERN int ipcDestroyAll _ANSI_ARGS_((Tcl_Interp *interp));

/* Return socket associated with a Receiver */
EXTERN int ipcGetReceiverSocket _ANSI_ARGS_((Receiver receiver));

/* Two options for send.  One for ANSI C the other for plain C */
/* Send a command string to a Sender */
#if defined(__STDC__)
EXTERN int ipcRemoteSend _ANSI_ARGS_((Sender sender, 
				      const char *fmt, ...));
#else
EXTERN int ipcRemoteSend _ANSI_ARGS_(());
#endif

/* PortManager convenience routines, etc */
#define PMCONNECT_OK 0
#define PMCONNECT_FAIL 1
#define PMCONNECT_NOTUNIQUE 2

/* Register with a PortManager, returns one of above three */
EXTERN int pmConnectWithPortMgr _ANSI_ARGS_((Sender sender, 
					     Port* receivingPort));
/* Check to see if program is unique */
EXTERN int pmIsPortUnique _ANSI_ARGS_((Sender sender, Port *receivingPort));

/* Remove an entry from a PortManager */
EXTERN int pmDisconnectFromPortMgr _ANSI_ARGS_((Sender sender, 
						Port* appPort));
/* Get the list of open apps on a PortManager */
EXTERN int pmGetOpenApps _ANSI_ARGS_((Sender sender, 
				      PortMgrResult* openAppsReturn));
/* Get the port for a specified application name */
EXTERN int pmGetPortFromName _ANSI_ARGS_((Sender sender,
					  Port* appNameAndHost,
					  PortMgrResult* matchingPortsReturn));
/* Remove the data from a PortManager result */
EXTERN int pmGetPortFromResult _ANSI_ARGS_((Tcl_Interp *interp, 
					    int whichone, 
					    PortMgrResult pmresult, 
					    Port *appPortReturn));
/* Destroy a PortManager result */
EXTERN int pmDestroyResult _ANSI_ARGS_((PortMgrResult pmresult));

#endif  /* _TCLIPC_H_RPCGEN */
