/*
 * Copyright 1992 by the National Optical Astronomy Observatories(*)
 *
 * Permission to use, copy, and distribute
 * is hereby granted without fee, providing that the above copyright
 * notice appear in all copies and that both the copyright notice and this
 * permission notice appear in supporting documentation.
 *
 * This software is provided "as is" without any express or implied warranty.
 *
 * (*) Operated by the Association of Universities for Research in
 *     Astronomy, Inc. (AURA) under cooperative agreement with the
 *     National Science Foundation.
 */
/* Program: tclmain.c
 *      This file contains a test program for Tk that uses the tclipc library.
 *
 * Created: K. Gillies 26 June 1992
 *
 * SCCS INFO
 *      %W% %G%
 */
#include <stdio.h>
#include <assert.h>
#include <string.h>
#include <fcntl.h>
#include <tk.h>
#include "tcl.h"
#include "tclipc.h"

#define TRUE 1
#define FALSE 0

/* Something I use to reduce length of arg lists */
typedef struct _tclInfo {
  Tcl_Interp *interp;
  Tcl_CmdBuf buffer;
} tclinfo, *tclInfo;
static tclInfo info;

/* In file function prototypes */
static int cmdBeep _ANSI_ARGS_((ClientData *clientData, Tcl_Interp *interp,
                int argc, char *argv[]));
static int cmdQuit _ANSI_ARGS_((ClientData *clientData, Tcl_Interp *interp,
                int argc, char *argv[]));
static tclInfo tclInit _ANSI_ARGS_((Tcl_Interp *interp));
static evalcmd_res* tclTestCmdReceive _ANSI_ARGS_((Tcl_Interp *interp, 
						   cmdText cmd));
static void tkRegisterNewFD _ANSI_ARGS_((int newfd));
static void tkUnRegisterFD _ANSI_ARGS_((int dyingfd));
static void myFileProc _ANSI_ARGS_((ClientData clientData, int mask));

static char *initCmd =
 "if [file exists [info library]/init.tcl] {source [info library]/init.tcl}";

#define MYBUFSIZ        64
/* Tcp variables */
/* some in file variables */
#if defined(__STDC__)
static volatile int quitFlag = FALSE;
#else
static int quitFlag = FALSE;
#endif

int tkipcInit(interp, appName)
Tcl_Interp *interp;
char *appName;
{
  info = tclInit(interp);
  ipcSendInit(0, 0, 1, 0, tclTestCmdReceive, NULL, 
	      tkRegisterNewFD, tkUnRegisterFD);
  ipcInterpInit(info->interp);

  return TCL_OK;
}

/*
 *--------------------------------------------------------------
 *
 * tkRegisterNewFD
 *
 *      Tk function to register a new file descriptor for events.
 *
 * Results:
 *      void
 *--------------------------------------------------------------
 */
static void tkRegisterNewFD(newfd)
int newfd;
{
#ifdef DEBUG 
  fprintf(stderr, "Add: %d\n", newfd);
#endif
  Tk_CreateFileHandler(newfd, TK_READABLE, myFileProc, (ClientData)NULL);
}

/*
 *--------------------------------------------------------------
 *
 * tkUnRegister
 *
 *      Clean up a closed connection for Tk.
 *
 * Results:
 *      void
 *--------------------------------------------------------------
 */
static void tkUnRegisterFD(dyingfd)
int dyingfd;
{
#ifdef DEBUG
  fprintf(stderr, "Destroy: %d\n", dyingfd);
#endif
  Tk_DeleteFileHandler(dyingfd);
}

/*
 *--------------------------------------------------------------
 *
 * myFileProc
 *
 *      Tk ipc procedure that responds to incoming messages.
 *
 * Results:
 *      void
 *--------------------------------------------------------------
 */
static void myFileProc(ClientData clientData, int mask)
{
  ipcWaitForMessages();
}

static evalcmd_res* tclTestCmdReceive(interp, argp)
Tcl_Interp *interp;
cmdText argp;
{
  static evalcmd_res answer = { 0, NULL };

  /* Freeing result is taken care of somewhere else ! */
  /* fprintf(stderr, "%d %s\n", strlen(argp), argp); */
  answer.errno = Tcl_Eval(interp, argp, 0, NULL);
  answer.text = interp->result;

  return(&answer);
}

static tclInfo tclInit(interp)
Tcl_Interp *interp;
{
  int result;
  tclInfo info;

  info = (tclInfo)malloc(sizeof(tclinfo));
  assert(info != NULL);

  info->interp = interp;

  /* Some standard tcl built-ins */
  Tcl_CreateCommand(info->interp, "quit", (Tcl_CmdProc *)cmdQuit,
                    (ClientData) 0,
                    (Tcl_CmdDeleteProc *) NULL);
  Tcl_CreateCommand(info->interp, "beep", (Tcl_CmdProc *)cmdBeep,
                    (ClientData) 0,
                    (Tcl_CmdDeleteProc *) NULL);

  /* Source the tcl library */
  result = Tcl_Eval(info->interp, initCmd, 0, (char **) NULL);
  assert(result == TCL_OK);

  return info;
}

/* A formal quit command */
static int cmdQuit(clientData, interp, argc, argv)
ClientData *clientData;
Tcl_Interp *interp;
int argc;
char *argv[];
{
  quitFlag = 1;
  /* Ugly, but I'm use to it */
  ipcDestroyAll(info->interp);

  exit(0);
  return TCL_OK;
}

/* A beep command */
static int cmdBeep(clientData, interp, argc, argv)
ClientData *clientData;
Tcl_Interp *interp;
int argc;
char *argv[];
{
  /*  FakeButtonPress("Test"); */
  Tcl_AppendResult(interp, "OK", (char *)NULL);
  return TCL_OK;
}
