.Dd July 11, 1994
.Dt MIDIDEVICE N
.Os
.Sh NAME
.Nm mididevice
.Nd "tclmidi command to get or modify MIDI device configuration values"
.Sh SYNOPSIS
.Nm
.Op name Op value
.Op midithru Op value
.Sh DESCRIPTION
.Nm
is a
.Xr tclmidi 1
command that
gets or modifies the configurations
values for a MIDI device.
Currently, only two configuration values are support, though
more might be added in the future.
.Pp
Without arguments
.Nm
reports all configuration values.
It can also take option arguments.
All arguments should be lists consisting of the parameter
name followed by an optional value.
If a value for a parameter is not specified then the current
setting is reported.
If a value is specified then that parameter is changed.
.Pp
The different parameters are:
.Bl -tag -width division
.It name
This controls the device interface name.
The default value is
.Dq /dev/midi0 .
.It midithru
This paramter controls if data arriving at the \%MIDI IN
port is passed to the \%MIDI OUT port.
By default it is not.
The parameter is a boolean value and should be one of
.Dq yes ,
.Dq on ,
.Dq true ,
.Dq 1 ,
.Dq no ,
.Dq off ,
.Dq false
or
.Dq 0 .
.El
.Sh RETURN VALUES
If parameters are being set,
.Nm
will return nothing.
If parameters are being queried,
a list of lists will be returned.
Each sublist will contain the parameter
name and its associated value.
The parameters are returned in the order
specified or in the order
.Em name, midithru
if
.Nm
is called without arguments.
.Pp
If there is no device configured with tclmidi,
.Nm
will return 0.
.Sh SEE ALSO
.Xr tclmidi 1
.Sh AUTHOR
Mike Durian - durian@boogie.com
