/*-
 * Copyright (c) 1993, 1994 Michael B. Durian.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by Michael B. Durian.
 * 4. The name of the the Author may be used to endorse or promote 
 *    products derived from this software without specific prior written 
 *    permission.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESS OR IMPLIED 
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
#ifndef EVENTTREE_H
#define EVENTTREE_H

#include <iostream.h>
#include <strstream.h>
#include <iomanip.h>

#include "Event.h"

extern "C" {
#include "rb.h"
}

typedef struct rb_node EventTreeNode;
typedef struct rb_node EventTreeHead;

class EventTree {
	friend ostream &operator<<(ostream &os, const EventTree &t);
public:
	EventTree();
	EventTree(const EventTree &t);
	~EventTree();

	Event *GetEvents(unsigned long time);
	Event *NextEvent(void);
	Event *NextEvent(const Event *e);
	Event *NextEvents(void);
	Event *NextEvents(const Event *e);
	Event *PrevEvent(void);
	Event *PrevEvent(const Event *e);
	Event *PrevEvents(void);
	Event *PrevEvents(const Event *e);
	Event *GetFirstEvent(void);
	Event *GetFirstEvents(void);
	Event *GetLastEvent(void);
	Event *GetLastEvents(void);
	EventTreeNode *GetFirstNode(void);
	EventTreeNode *GetLastNode(void);
	EventTreeNode *NextNode(const EventTreeNode *n);
	EventTreeNode *PrevNode(const EventTreeNode *n);
	unsigned long GetStartTime(void);
	unsigned long GetEndTime(void);

	int Add(const EventTree &et, unsigned long start, double scalar = 1);
	EventTree *GetRange(unsigned long start, unsigned long end) const;
	int DeleteRange(unsigned long start, unsigned long end);

	Event *PutEvent(const Event &event);
	void RewindEvents(void);
	int DeleteEvent(const Event &event);

	EventTree &operator=(const EventTree &t);
private:
	void DeleteTree(void);
	void CopyTree(const EventTree &t);

	EventTreeHead *head;
	EventTreeNode *curr_node;
	Event *curr_event;
};
#endif
