#
# A check for memory leaks in Tk graphic widgets...
#

set Color..top black
set Color..bot white
set Counter 0

# system specific
proc memreport {} { puts stdout [exec /etc/pstat -T] }

proc make {} {
    set F graphic
    $F .top -command {paintme .top} \
    	-geometry 300x200 -bg black -doublebuffered true \
    	-relief raised -border 4
    $F .bot -command {paintme .bot} \
    	-geometry 300x150 -bg black -doublebuffered true \
    	-relief raised -border 4
    pack append . .top {top fill expand} .bot {top fill expand}
    update
    after 100 later
}

proc later {} {
    global Counter
    if { $Counter > 20 } { memreport; set Counter 0 } { incr Counter }
    .top paint; .bot paint
    after 1 later
}

proc paintme {w} {
    global Color.$w
    for {set i 0} {$i<1000} {incr i} { g_color [set Color.$w] }
    g_clear
    case [set Color.$w] black {set Color.$w white} white {set Color.$w black}
}
wm minsize .  0 0 
make
