#!/usr/local/bin/wish -f
# demo.tcl for tkSticker by Heribert Dahms (dahms@ifk20.mach.uni-karlsruhe.de)
pack [canvas .c]
wm geometry . +30+30		;# For fvwm.
set delay 2000			;# Two seconds should be enough.

# I used a 75dpi screen for testing, but others should make no difference!
# You'll see a small upright rectangle with "He" inside.
#.c create sticker 20 30 40 80 -text Hello -tags st
.c create sticker 6m 10m 13m 27m -text Hello -tags st
update; after $delay

# You'll see the whole "Hello" drawn rotated 90 degrees.
.c itemconfigure st -orient vertical
update; after $delay

# The rectangle shrinks and the text is clipped to "Hell".
#.c coords st 20 30 40 60
.c coords st 6m 10m 13m 20m
update; after $delay

# Now you'll read "ello".
.c itemconfigure st -lefttrunc yes
update; after $delay

# Enlarging the rectangle shows the complete "Hello" again.
.c scale st 0 0 3 3
update; after $delay

# This time the text is repeated: "Hello", approx. 5mm space, "Hello".
.c it st -space 5m
update; after $delay

# A vertical bar appears in the lower right region and text jumps to the left.
.c it st -anchor n -relw .3 -relh .7 -relx .6 -rely .3 -bar red
update; after $delay

# Finally an monstrous outline forces a single "Hello" and shrinks the bar.
.c it st -width 6m
update; after $delay

# In case you have sourced the script interactively and want to play around...
if !$tcl_interactive exit
