#==============================================================================
#                                 Config.mk
#------------------------------------------------------------------------------
# Configuration file for Tcl sipp.  Edit the following variables to specify
# the location of required packages and other attribbutes.   
#
# IMPORTANT NOTE:
#     All paths should either be absoulte or relative to the src & photo
# directories  below the directory containing this file (../../).
#------------------------------------------------------------------------------

#------------------------------------------------------------------------------
# Version number of tsipp (Don't change this).
#
TSIPP_VERSION  = 3.0c


#------------------------------------------------------------------------------
# C compiler, ar and lex commands to use.
#
CC  = cc
AR  = ar
LEX = lex

#------------------------------------------------------------------------------
# Compiler options (-g, -O).  Be sure and set set STRIP=touch below if
# -g is used.  Can also be specified on the make command line with
#   make CFLAGS=-O
#
CCOPT = -O

#------------------------------------------------------------------------------
# If your system requires the use or ranlib set RANLIB to "ranlib", otherwise
# set it to "touch".
#
#RANLIB = ranlib
RANLIB = touch

#------------------------------------------------------------------------------
# Stripping - Set to the command `strip' to strip, `touch' to not strip.
#
#STRIP = touch
STRIP = strip

#------------------------------------------------------------------------------
# System libraries that might be needed (-lm almost always is).  This includes
# all of the libraries required by Extended Tcl shell (tcl).  A list of these
# libraries is saved in the TclX build directory tclmaster/src/SYSLIBS.
# If you have libPW.a, it contains alloca, which is desirable to have.
#
LDLIBS = -lsocket -lm -lmalloc -lPW -lc_s

#------------------------------------------------------------------------------
# The function "alloca" is a very fast memory allocator.  If you don't have
# alloca(), specify -DHAVE_NO_ALLOCA.  If you have alloca(),  but don't have
# alloca.h, specify -DHAVE_NO_ALLOCA_H.  If you are using GCC, don't specify
# either option, you get a very fast build-in alloca for free.
# (NOTE: Sun users MUST include alloca.h!!!!)
#
#ALLOCA = -DHAVE_NO_ALLOCA
ALLOCA = -DHAVE_NO_ALLOCA_H

#------------------------------------------------------------------------------
# If you don't have memcpy() and friends in your C library, or 
# if you don't have memory.h in /usr/include, uncomment the
# following line:
#NOMEMCPY = -DNOMEMCPY

#------------------------------------------------------------------------------
# TCLINCL is the directory containing the Tcl include file (tcl.h).
# TCLLIB is the path to the Tcl library (libtcl.a).
#
TCLINCL = ../../tclX7.3a/tclmaster/include
TCLLIB  = ../../tclX7.3a/tclmaster/lib/libtcl.a

#------------------------------------------------------------------------------
# TCLXINCL is the directory containing the Extended Tcl (TclX) include file
# (tclExtend.h)
# TCLXLIB is the path to the  Extended Tcl library (libtclx.a).
#
TCLXINCL = ../../tclX7.3a/tclmaster/include
TCLXLIB  = ../../tclX7.3a/tclmaster/lib/libtclx.a

#------------------------------------------------------------------------------
# Define the URTDEF, URTINCL and URTLIB if you are building with the Utah
# Raster Toolkit (URT).  Comment these out if you don't have the URT toolkit.
#
# URTINCL is the directory containing the URT RLE file (rle.h).
# URTLIB is the path to the URT RLE library (librle.h).
#
URTDEF  = -DTSIPP_HAVE_RLE
URTINCL = /u/markd/graphics/include
URTLIB  = /u/markd/graphics/lib/librle.a

#------------------------------------------------------------------------------
# These options need to be defined if you want to build tksipp, a version of
# the Tk shell wish with the SIPP command set and the photo widget. Comment
# these out if your don't want to build tksipp.  You must have compiled
# Extended Tcl with the TK_BUILD=WISHX option set in its configuration file.
# (If you have wishx, you did).
#
# TKSRC is the directory of your Tk source, include files.  It does not have
# to be built, but this must point to the source distribution, as files
# will be patched by this build to add the colorfocus command.
# TKLIB is the path to Tk library (libtk.a)
# TKXLIB is the path to Extended Tk library (libtkx.a)
# XLIBS are the libraries to use for X11.
#
TKSIPP_BUILD = BUILD_TKSIPP
TKSRC  = ../../tk3.6
TKLIB  = ../../tk3.6/libtk.a
TKXLIB = ../../tclX7.3a/tkmaster/lib/libtkx.a
XLIBS  = -lX11_s

#------------------------------------------------------------------------------
# Install prefixes.  This are the directory which contains the bin directory
# to install files in.  One day this will have a real configure script and
# configure will set it.  Till then it can be set by hand, or the variables
# that use it can be set.
#
prefix=/usr/local
exec_prefix=${prefix}

#------------------------------------------------------------------------------
# TSIPP master diectory path.  A directory containing the tsipp version number
# is built under here.
#
MASTERDIR=${prefix}/tsipp

#------------------------------------------------------------------------------
# Arcitecture suffix to append to the bin directory under the tsipp master.
# The suffix normally starts with a "." if specified.  If you are not setting
# up multi-arcitecture servers, you probably want to ignore it.
ARCH=

#------------------------------------------------------------------------------
# Public bin and lib directories where symbolic links to the external files
# in the master directory are placed
#
BINDIR=${prefix}/bin
LIBDIR=${prefix}/lib

#------------------------------------------------------------------------------
# o TSIPP_MAN_CMD_SECTION - Section for tsipp command manual pages. Normal `1'
#   or `C'.  You might perfer TSIPP or what you specified with TclX.

TSIPP_MAN_CMD_SECTION=TSIPP
#TSIPP_MAN_CMD_SECTION=1

#------------------------------------------------------------------------------
# o MAN_DIR_SEPARATOR - The separator character used in the directory name
#   of the cat* and man* manual directories.  This is usually empty or 
#   a period. i.e "/usr/man/man1" or "/usr/man/man.1".

MAN_DIR_SEPARATOR=

#------------------------------------------------------------------------------
# Arguments to use in when generating the demo pictures when you do a
# "make demo".  The following arguments may be specified for this flag:
#
#     o -mode rmode - The rendering mode.  The value of rmode is one of PHONG,
#        GOURAUD, FLAT or LINE.  Default is PHONG.
#     o -oversample factor - The oversampling factor.  The default is 2 for
#        most images, a couple are 3.  You might want to set this to 1 to speed
#        up the rendering.
#     o -size isize - The size of the image to render.  The result will be an
#        image isize X isize pixels.  The default is 256 pixels.
#     o -ppm - Force PPM (or PBM for LINE mode) format images to be rendered.
#        The default is to render RLE images if Tcl-SIPP was built with the 
#        Utah Raster Toolkit RLE library and a PPM images if RLE is not
#        available.
#        
DEMOARGS=
