#==============================================================================
#                                  vwhd.tcl
#------------------------------------------------------------------------------
# Defines the VW hood surface.
#
# Copyright (c) Evans & Sutherland - ok to distribute if copyright appears.
#------------------------------------------------------------------------------
# $Id: vwhd.tcl,v 4.0 1993/11/27 21:25:39 markd Rel $
#==============================================================================

proc SippVWHood {side shader} {

    set pnt(1)  {16.500  -29.500   38.750}
    set pnt(2)  {10.750  -30.250   39.500}
    set pnt(3)  { 6.250  -31.000   39.750}
    set pnt(4)  { 3.500  -34.000   39.500}
    set pnt(5)  { 1.750  -38.500   39.250}
    set pnt(6)  { 1.250  -43.250   39.000}
    set pnt(7)  { 1.000  -53.750   35.750}
    set pnt(8)  { 1.000  -59.000   33.500}
    set pnt(9)  { 0.750  -65.500   28.750}
    set pnt(10) { 1.000  -68.000   26.000}
    set pnt(11) { 1.200  -70.500   21.750}
    set pnt(12) { 2.500  -72.000   18.000}
    set pnt(13) { 5.000  -71.500   19.250}
    set pnt(14) { 8.100  -68.250   24.000}
    set pnt(15) {10.250  -65.000   28.000}
    set pnt(16) {12.750  -59.000   31.750}
    set pnt(17) {14.500  -54.000   34.500}
    set pnt(18) {17.250  -43.750   36.750}
    set pnt(19) {18.500  -33.750   38.250}
    set pnt(20) {18.250  -31.000   38.500}
    set pnt(21) {16.500  -29.250   39.250}
    set pnt(22) {10.250  -30.000   40.000}
    set pnt(23) { 6.000  -31.250   40.250}
    set pnt(24) { 3.250  -34.250   40.000}
    set pnt(25) { 1.500  -38.500   39.750}
    set pnt(26) { 1.000  -43.250   39.500}
    set pnt(27) { 0.750  -53.750   36.250}
    set pnt(28) { 0.750  -59.000   34.000}
    set pnt(29) { 0.500  -65.500   29.250}
    set pnt(30) { 0.750  -68.000   26.500}
    set pnt(31) { 1.000  -70.500   22.250}
    set pnt(32) { 2.500  -72.750   18.500}
    set pnt(33) { 5.250  -71.750   19.750}
    set pnt(34) { 8.350  -68.500   24.500}
    set pnt(35) {10.500  -65.250   28.500}
    set pnt(36) {13.000  -59.000   32.250}
    set pnt(37) {14.750  -54.000   35.000}
    set pnt(38) {17.500  -43.750   37.250}
    set pnt(39) {18.750  -33.750   38.750}
    set pnt(40) {18.500  -31.000   39.000}
    set pnt(41) {19.750  -26.000   38.370}
    set pnt(42) {10.250  -27.630   39.870}
    set pnt(43) { 4.750  -28.500   40.750}
    set pnt(44) { 0.000  -29.000   40.750}
    set pnt(45) { 0.000  -34.000   40.250}
    set pnt(46) { 0.000  -43.250   39.250}
    set pnt(47) { 0.000  -54.000   36.750}
    set pnt(48) { 0.000  -59.250   34.250}
    set pnt(49) { 0.000  -65.500   29.250}
    set pnt(50) { 0.000  -68.000   26.250}
    set pnt(51) { 0.000  -70.250   22.000}
    set pnt(52) { 0.000  -72.500   15.750}
    set pnt(53) { 0.000  -72.000   13.250}
    set pnt(54) { 0.000  -71.500   12.000}
    set pnt(55) { 5.000  -71.500   12.500}
    set pnt(56) { 8.250  -71.000   15.750}
    set pnt(57) {12.250  -66.500   21.250}
    set pnt(58) {14.500  -63.250   25.750}
    set pnt(59) {16.500  -58.500   30.000}
    set pnt(60) {17.875  -53.500   31.375}
    set pnt(61) {20.250  -44.250   33.500}
    set pnt(62) {21.000  -39.250   34.000}
    set pnt(63) {22.500  -30.000   35.750}
    set pnt(64) {23.000  -28.500   36.500}
    set pnt(65) {22.250  -26.000   36.500}  ;#???? 36.5 FISHY
    set pnt(66) { 3.250  -72.000   13.750}
    set pnt(67) { 3.000  -71.500   16.500}
    set pnt(68) { 7.750  -70.750   17.000}
    set pnt(69) { 6.500  -71.000   18.250}
    set pnt(70) {11.000  -67.500   23.500}
    set pnt(71) { 9.500  -68.000   24.000}
    set pnt(72) {13.000  -64.750   26.500}
    set pnt(73) {12.000  -65.250   27.500}
    set pnt(74) {15.500  -59.000   31.000}
    set pnt(75) {14.250  -59.500   32.000}
    set pnt(76) {17.000  -53.250   33.750}
    set pnt(77) {16.000  -53.250   34.500}
    set pnt(78) {19.000  -43.750   35.750}
    set pnt(79) {18.000  -43.750   36.750}
    set pnt(80) {21.500  -34.250   37.750}
    set pnt(81) {20.500  -34.000   38.000}
    set pnt(82) {19.500  -31.000   38.750}
    set pnt(83) { 9.250  -35.750   39.750}
    set pnt(84) { 8.750  -43.500   38.750}
    set pnt(85) { 7.000  -54.000   36.000}
    set pnt(86) { 6.250  -59.500   33.500}
    set pnt(87) { 5.500  -65.000   29.250}
    set pnt(88) { 4.500  -68.250   25.500}
    set pnt(89) {22.000  -31.000   37.500}

    SippVW:DefPoly $side pnt {1  2 83 19 20}
    SippVW:DefPoly $side pnt {2  3  4 83}
    SippVW:DefPoly $side pnt {83  4  5  6 84}
    SippVW:DefPoly $side pnt {84  6  7 85}
    SippVW:DefPoly $side pnt {85  7  8 86}
    SippVW:DefPoly $side pnt {86  8  9 87}
    SippVW:DefPoly $side pnt {87  9 10 88}
    SippVW:DefPoly $side pnt {88 10 11 13 14}
    SippVW:DefPoly $side pnt {11 12 13}
    SippVW:DefPoly $side pnt {14 15 87 88}
    SippVW:DefPoly $side pnt {15 16 86 87}
    SippVW:DefPoly $side pnt {16 17 85 86}
    SippVW:DefPoly $side pnt {17 18 84 85}
    SippVW:DefPoly $side pnt {18 19 83 84}
    SippVW:DefPoly $side pnt {63 64 65 89}
    SippVW:DefPoly $side pnt {89 65 41 82}
    SippVW:DefPoly $side pnt {82 41 40}
    SippVW:DefPoly $side pnt {40 41 21}
    SippVW:DefPoly $side pnt {21 41 42 22}
    SippVW:DefPoly $side pnt {22 42 43 23}
    SippVW:DefPoly $side pnt {23 43 44 45 24}
    SippVW:DefPoly $side pnt {24 45 46 26 25}
    SippVW:DefPoly $side pnt {26 46 47 27}
    SippVW:DefPoly $side pnt {27 47 48 28}
    SippVW:DefPoly $side pnt {28 48 49 29}
    SippVW:DefPoly $side pnt {29 49 50 30}
    SippVW:DefPoly $side pnt {30 50 51 31}
    SippVW:DefPoly $side pnt {31 51 52 32}
    SippVW:DefPoly $side pnt {32 52 53 67}
    SippVW:DefPoly $side pnt {67 53 54 55 66}
    SippVW:DefPoly $side pnt {33 32 67 66}
    SippVW:DefPoly $side pnt {69 33 66}
    SippVW:DefPoly $side pnt {68 69 66}
    SippVW:DefPoly $side pnt {68 66 55 56}
    SippVW:DefPoly $side pnt {68 56 57 70}
    SippVW:DefPoly $side pnt {69 68 70 71}
    SippVW:DefPoly $side pnt {69 71 34 33}
    SippVW:DefPoly $side pnt {70 57 58 72}
    SippVW:DefPoly $side pnt {71 70 72 73}
    SippVW:DefPoly $side pnt {71 73 35 34}
    SippVW:DefPoly $side pnt {72 58 59 74}
    SippVW:DefPoly $side pnt {73 72 74 75}
    SippVW:DefPoly $side pnt {73 75 36 35}
    SippVW:DefPoly $side pnt {74 59 60 76}
    SippVW:DefPoly $side pnt {75 74 76 77}
    SippVW:DefPoly $side pnt {75 77 37 36}
    SippVW:DefPoly $side pnt {76 60 61 78}
    SippVW:DefPoly $side pnt {77 76 78 79}
    SippVW:DefPoly $side pnt {77 79 38 37}
    SippVW:DefPoly $side pnt {78 61 62 80}
    SippVW:DefPoly $side pnt {79 78 80 81}
    SippVW:DefPoly $side pnt {79 81 39 38}
    SippVW:DefPoly $side pnt {80 62 63 89}
    SippVW:DefPoly $side pnt {81 80 89 82}
    SippVW:DefPoly $side pnt {81 82 40 39}
    SippVW:DefPoly $side pnt {19 39 40 20}
    SippVW:DefPoly $side pnt {20 40 21  1}
    SippVW:DefPoly $side pnt {1 21 22  2}
    SippVW:DefPoly $side pnt {2 22 23  3}
    SippVW:DefPoly $side pnt {3 23 24  4}
    SippVW:DefPoly $side pnt {4 24 25  5}
    SippVW:DefPoly $side pnt {5 25 26  6}
    SippVW:DefPoly $side pnt {6 26 27  7}
    SippVW:DefPoly $side pnt {7 27 28  8}
    SippVW:DefPoly $side pnt {8 28 29  9}
    SippVW:DefPoly $side pnt {9 29 30 10}
    SippVW:DefPoly $side pnt {10 30 31 11}
    SippVW:DefPoly $side pnt {11 31 32 12}
    SippVW:DefPoly $side pnt {12 32 33 13}
    SippVW:DefPoly $side pnt {13 33 34 14}
    SippVW:DefPoly $side pnt {14 34 35 15}
    SippVW:DefPoly $side pnt {15 35 36 16}
    SippVW:DefPoly $side pnt {16 36 37 17}
    SippVW:DefPoly $side pnt {17 37 38 18}
    SippVW:DefPoly $side pnt {18 38 39 19}

    SippSurfaceCreate $shader
}
