#==============================================================================
#                                strauss.tcl
#------------------------------------------------------------------------------
# A port of SIPP demo program strausstest.c to Tcl-SIPP.
#------------------------------------------------------------------------------
# $Id: strauss.tcl,v 5.0 1994/09/05 01:21:39 markd Rel $
#------------------------------------------------------------------------------

if {[info commands DoRendering] == ""} {
    if [file exists ./demoutil.tlib] {
        loadlibindex ./demoutil.tlib
    } else {
        set demoutil [searchpath $auto_path demos/demoutil.tlib]
        if [lempty $demoutil] {
            error "Can't find \"demos/demoutil.tlib\" on auto_path"
        }
        loadlibindex $demoutil
    }
}
ParseDemoArgs

#
# Demo of the strauss shader. Four spheres are rendered, 
# all with the same base color, but different smoothness
# and metalness.
#/

set RESOLUTION 30

#
# Surface description of the spheres.
#/
set non_metal_dull [SippShaderStrauss 0.4 0.2 0.1 {0.6 0.33 0.27}]
 
set non_metal_shiny [SippShaderStrauss 0.4 0.7 0.1 {0.6 0.33 0.27}]

set metal_dull [SippShaderStrauss 0.4 0.2 0.9 {0.6 0.33 0.27}]

set metal_shiny [SippShaderStrauss 0.4 0.7 0.9 {0.6 0.33 0.27}]

#
# Antique white surface as background.
#
set bg_surf [SippShaderBasic 0.4 0.0 0.99 {0.9804 0.9216 0.8431}]

SippLightSourceCreate {-1.0 -1.0 1.0} {1.0 1.0 1.0} DIRECTION
SippLightSourceCreate { 0.0 -1.0 2.0} {0.6 0.6 0.6} DIRECTION

#
# Non metal, dull. Upper left.
#
set nmd [SippSphere 1.0 $RESOLUTION $non_metal_dull WORLD]
SippObjectMove $nmd {-1.1 0.0 1.1}
SippObjectAddSubobj WORLD $nmd

#
# Non metal, shiny. Upper right.
#
set nms [SippSphere 1.0 $RESOLUTION $non_metal_shiny WORLD]
SippObjectMove $nms {1.1 0.0 1.1}
SippObjectAddSubobj WORLD $nms

#
# Metal, dull. Lower left.
#
set md [SippSphere 1.0 $RESOLUTION $metal_dull WORLD]
SippObjectMove $md {-1.1 0.0 -1.1}
SippObjectAddSubobj WORLD $md

#
# Metal, shiny. Lower right.
#
set ms [SippSphere 1.0 $RESOLUTION $metal_shiny WORLD]
SippObjectMove $ms {1.1 0.0 -1.1}
SippObjectAddSubobj WORLD $ms

#
# Background.
#
set bg [SippBlock {10.0 0.5 10.0} $bg_surf WORLD]
SippObjectMove $bg {0.0 1.5 0.0}
SippObjectAddSubobj WORLD $bg

SippCameraParams STDCAMERA {0.0 -10.0 0.0} {0.0 0.0 0.0} {0.0 0.0 1.0} 0.25

DoRendering "strauss"

