#!/usr/local/bin/wish -f
# Program: chichot
# Tcl version: 7.2 (Tcl/Tk/XF)
# Tk version: 3.6
# XF version: 2.3
#

# module inclusion
global env
global xfLoadPath
global xfLoadInfo
set xfLoadInfo 0
if {[info exists env(XF_LOAD_PATH)]} {
  if {[string first $env(XF_LOAD_PATH) /usr/local/lib/] == -1} {
    set xfLoadPath $env(XF_LOAD_PATH):/usr/local/lib/
  } {
    set xfLoadPath /usr/local/lib/
  }
} {
  set xfLoadPath /usr/local/lib/
}

global argc
global argv
global tkVersion
set tmpArgv ""
for {set counter 0} {$counter < $argc} {incr counter 1} {
  case [string tolower [lindex $argv $counter]] in {
    {-xfloadpath} {
      incr counter 1
      set xfLoadPath "[lindex $argv $counter]:$xfLoadPath"
    }
    {-xfstartup} {
      incr counter 1
      source [lindex $argv $counter]
    }
    {-xfbindfile} {
      incr counter 1
      set env(XF_BIND_FILE) "[lindex $argv $counter]"
    }
    {-xfcolorfile} {
      incr counter 1
      set env(XF_COLOR_FILE) "[lindex $argv $counter]"
    }
    {-xfcursorfile} {
      incr counter 1
      set env(XF_CURSOR_FILE) "[lindex $argv $counter]"
    }
    {-xffontfile} {
      incr counter 1
      set env(XF_FONT_FILE) "[lindex $argv $counter]"
    }
    {-xfmodelmono} {
      if {$tkVersion >= 3.0} {
        tk colormodel . monochrome
      }
    }
    {-xfmodelcolor} {
      if {$tkVersion >= 3.0} {
        tk colormodel . color
      }
    }
    {-xfloading} {
      set xfLoadInfo 1
    }
    {-xfnoloading} {
      set xfLoadInfo 0
    }
    {default} {
      lappend tmpArgv [lindex $argv $counter]
    }
  }
}
set argv $tmpArgv
set argc [llength $tmpArgv]
unset counter
unset tmpArgv


# procedure to show window .top13
proc ShowWindow.top13 {args} {# xf ignore me 7

  # build widget .top13
  if {"[info procs XFEdit]" != ""} {
    catch "XFDestroy .top13"
  } {
    catch "destroy .top13"
  }
  toplevel .top13 

  # Window manager configurations
  global tkVersion
  wm positionfrom .top13 ""
  wm sizefrom .top13 ""
  update idletask
  wm iconify .top13
  wm maxsize .top13 1000 1000
  wm minsize .top13 10 10
  wm title .top13 {command}


  # build widget .top13.frame18
  frame .top13.frame18 \
    -borderwidth {2} \
    -relief {raised}

  # build widget .top13.frame18.frame11
  frame .top13.frame18.frame11 \
    -borderwidth {2} \
    -geometry {9x9} \
    -relief {raised}

  # build widget .top13.frame18.frame11.radiobutton12
  radiobutton .top13.frame18.frame11.radiobutton12 \
    -command {set chichotWord 0
set chichotLine 0} \
    -text {Char} \
    -value {1} \
    -variable {chichotCharacter}

  # build widget .top13.frame18.frame11.radiobutton13
  radiobutton .top13.frame18.frame11.radiobutton13 \
    -command {set chichotCharacter 0
set chichotLine 0} \
    -text {Word} \
    -value {1} \
    -variable {chichotWord}

  # build widget .top13.frame18.frame11.radiobutton14
  radiobutton .top13.frame18.frame11.radiobutton14 \
    -command {set chichotCharacter 0
set chichotWord 0} \
    -text {Line} \
    -value {1} \
    -variable {chichotLine}

  # pack widget .top13.frame18.frame11
  pack append .top13.frame18.frame11 \
    .top13.frame18.frame11.radiobutton12 {left frame center} \
    .top13.frame18.frame11.radiobutton13 {left frame center} \
    .top13.frame18.frame11.radiobutton14 {top frame center}

  # build widget .top13.frame18.frame16
  frame .top13.frame18.frame16 \
    -borderwidth {2} \
    -relief {raised}

  # build widget .top13.frame18.frame16.button15
  button .top13.frame18.frame16.button15 \
    -command {if { $chichotTop } {
  if { $chichotWiden } {
    if { $chichotLine } {
      send chichot set chichotCmd \"\\034k\\034\"
    } elseif { $chichotWord } {
      send chichot set chichotCmd \"\\034W\\034\"
    } else {
      send chichot set chichotCmd \"\\034h\\034\"
    }
  } else {
    if { $chichotLine } {
      send chichot set chichotCmd \"\\034K\\034\"
    } elseif { $chichotWord } {
      send chichot set chichotCmd \"\\034w\\034\"
    } else {
      send chichot set chichotCmd \"\\034H\\034\"
    }
  }
} else {
  if { $chichotWiden } {
    if { $chichotLine } {
      send chichot set chichotCmd \"\\034j\\034\"
    } elseif { $chichotWord } {
      send chichot set chichotCmd \"\\034B\\034\"
    } else {
      send chichot set chichotCmd \"\\034l\\034\"
    }
  } else {
    if { $chichotLine } {
      send chichot set chichotCmd \"\\034J\\034\"
    } elseif { $chichotWord } {
      send chichot set chichotCmd \"\\034b\\034\"
    } else {
      send chichot set chichotCmd \"\\034L\\034\"
    }
  }
}} \
    -text {OK}

  # build widget .top13.frame18.frame16.button19
  button .top13.frame18.frame16.button19 \
    -command {pack forget .top13.frame18
wm withdraw .top13
grab release .top13} \
    -text {Go back}

  # pack widget .top13.frame18.frame16
  pack append .top13.frame18.frame16 \
    .top13.frame18.frame16.button19 {left frame center expand fillx} \
    .top13.frame18.frame16.button15 {left frame center expand fillx}

  # build widget .top13.frame18.frame17
  frame .top13.frame18.frame17 \
    -borderwidth {2} \
    -relief {raised}

  # build widget .top13.frame18.frame17.frame5
  frame .top13.frame18.frame17.frame5 \
    -borderwidth {2} \
    -relief {raised}

  # build widget .top13.frame18.frame17.frame5.radiobutton6
  radiobutton .top13.frame18.frame17.frame5.radiobutton6 \
    -command {set chichotShrink 0} \
    -text {Widen} \
    -value {1} \
    -variable {chichotWiden}

  # build widget .top13.frame18.frame17.frame5.radiobutton7
  radiobutton .top13.frame18.frame17.frame5.radiobutton7 \
    -command {set chichotWiden 0} \
    -text {Shrink} \
    -value {1} \
    -variable {chichotShrink}

  # pack widget .top13.frame18.frame17.frame5
  pack append .top13.frame18.frame17.frame5 \
    .top13.frame18.frame17.frame5.radiobutton6 {top frame center expand fillx} \
    .top13.frame18.frame17.frame5.radiobutton7 {top frame center expand fillx}

  # build widget .top13.frame18.frame17.frame8
  frame .top13.frame18.frame17.frame8 \
    -borderwidth {2} \
    -relief {raised}

  # build widget .top13.frame18.frame17.frame8.radiobutton10
  radiobutton .top13.frame18.frame17.frame8.radiobutton10 \
    -command {set chichotTop 0} \
    -text {Bottom} \
    -value {1} \
    -variable {chichotBottom}

  # build widget .top13.frame18.frame17.frame8.radiobutton9
  radiobutton .top13.frame18.frame17.frame8.radiobutton9 \
    -command {set chichotBottom 0} \
    -text {Top} \
    -value {1} \
    -variable {chichotTop}

  # pack widget .top13.frame18.frame17.frame8
  pack append .top13.frame18.frame17.frame8 \
    .top13.frame18.frame17.frame8.radiobutton10 {top frame center expand fillx} \
    .top13.frame18.frame17.frame8.radiobutton9 {left frame center expand fillx}

  # pack widget .top13.frame18.frame17
  pack append .top13.frame18.frame17 \
    .top13.frame18.frame17.frame5 {left frame center expand fillx} \
    .top13.frame18.frame17.frame8 {top frame center expand fillx}

  # build widget .top13.frame18.label4
  label .top13.frame18.label4 \
    -relief {raised} \
    -text {Area select:}

  # pack widget .top13.frame18
  pack append .top13.frame18 \
    .top13.frame18.label4 {top frame center fillx} \
    .top13.frame18.frame11 {top frame center} \
    .top13.frame18.frame17 {top frame center fillx} \
    .top13.frame18.frame16 {top frame center fillx}

  # build widget .top13.frame9
  frame .top13.frame9 \
    -borderwidth {2} \
    -relief {raised}

  # build widget .top13.frame9.button6
  button .top13.frame9.button6 \
    -command {send chichot set chichotCmd \"\\034\"
pack forget .top13.frame9
wm withdraw .top13
grab release .top13
set patternHeight ""
set patternWidth ""} \
    -text {Cancel}

  # build widget .top13.frame9.button7
  button .top13.frame9.button7 \
    -command {if { [string compare $patternHeight ""] && [string compare $patternWidth ""] } {
  pack forget .top13.frame9
  pack .top13.frame11
  .top13.frame11.text11 configure -height $patternHeight -width $patternWidth
  set patternHeight ""
  set patternWidth ""
}} \
    -text {OK}

  # build widget .top13.frame9.frame8
  frame .top13.frame9.frame8 \
    -borderwidth {2} \
    -relief {raised}

  # build widget .top13.frame9.frame8.label2
  label .top13.frame9.frame8.label2 \
    -relief {raised} \
    -text {Height:}

  # build widget .top13.frame9.frame8.entry4
  entry .top13.frame9.frame8.entry4 \
    -relief {sunken} \
    -textvariable {patternHeight} \
    -width {2}

  # build widget .top13.frame9.frame8.label3
  label .top13.frame9.frame8.label3 \
    -relief {raised} \
    -text {Width:}

  # build widget .top13.frame9.frame8.entry5
  entry .top13.frame9.frame8.entry5 \
    -relief {sunken} \
    -textvariable {patternWidth} \
    -width {2}

  # pack widget .top13.frame9.frame8
  pack append .top13.frame9.frame8 \
    .top13.frame9.frame8.label2 {left frame center expand fillx} \
    .top13.frame9.frame8.entry4 {left frame center expand fill} \
    .top13.frame9.frame8.label3 {left frame center expand fillx} \
    .top13.frame9.frame8.entry5 {left frame center expand fillx}

  # build widget .top13.frame9.label5
  label .top13.frame9.label5 \
    -relief {raised} \
    -text {Pattern size:}

  # pack widget .top13.frame9
  pack append .top13.frame9 \
    .top13.frame9.label5 {top frame center fillx} \
    .top13.frame9.frame8 {top frame center fillx} \
    .top13.frame9.button6 {left frame center expand fillx} \
    .top13.frame9.button7 {left frame center expand fillx}

  # build widget .top13.frame1
  frame .top13.frame1 \
    -borderwidth {2} \
    -relief {raised}

  # build widget .top13.frame1.frame11
  frame .top13.frame1.frame11 \
    -borderwidth {2} \
    -relief {raised}

  # build widget .top13.frame1.frame11.button3
  button .top13.frame1.frame11.button3 \
    -command {send chichot set chichotCmd \"w\"} \
    -text {Word}

  # build widget .top13.frame1.frame11.button4
  button .top13.frame1.frame11.button4 \
    -command {send chichot set chichotCmd \"n\"} \
    -text {Number}

  # build widget .top13.frame1.frame11.frame6
  frame .top13.frame1.frame11.frame6 \
    -borderwidth {2} \
    -relief {raised}

  # build widget .top13.frame1.frame11.frame6.button7
  button .top13.frame1.frame11.frame6.button7 \
    -command {pack forget .top13.frame1.frame11.frame6.button7
pack .top13.frame1.frame11.frame6.button8} \
    -text {Repeat}

  # build widget .top13.frame1.frame11.frame6.button8
  button .top13.frame1.frame11.frame6.button8 \
    -command {pack forget .top13.frame1.frame11.frame6.button8
pack .top13.frame1.frame11.frame6.button7} \
    -text {End Repeat}

  # pack widget .top13.frame1.frame11.frame6
  pack append .top13.frame1.frame11.frame6 \
    .top13.frame1.frame11.frame6.button7 {top frame center}

  # pack widget .top13.frame1.frame11
  pack append .top13.frame1.frame11 \
    .top13.frame1.frame11.button3 {left frame center expand fill} \
    .top13.frame1.frame11.button4 {left frame center expand fill} \
    .top13.frame1.frame11.frame6 {top frame center expand fillx}

  # build widget .top13.frame1.frame12
  frame .top13.frame1.frame12 \
    -borderwidth {2} \
    -relief {raised}

  # build widget .top13.frame1.frame12.button5
  button .top13.frame1.frame12.button5 \
    -command {send chichot set chichotCmd \"\\034\\034\"
pack forget .top13.frame1
wm withdraw .top13
grab release .top13} \
    -text {End search}

  # build widget .top13.frame1.frame12.button9
  button .top13.frame1.frame12.button9 \
    -command {set searchString [split $chichotSearchText {}]
set searchString [join $searchString \\]
set searchString [split \\$searchString {}]
set searchString [join $searchString \\]
send chichot [list set chichotCmd "\$searchString"]
set chichotSearchText ""} \
    -text {Text:}

  # build widget .top13.frame1.frame12.entry10
  entry .top13.frame1.frame12.entry10 \
    -relief {sunken} \
    -textvariable {chichotSearchText} \
    -width {7}

  # pack widget .top13.frame1.frame12
  pack append .top13.frame1.frame12 \
    .top13.frame1.frame12.button5 {left frame center expand fillx} \
    .top13.frame1.frame12.button9 {left frame center expand fillx} \
    .top13.frame1.frame12.entry10 {left frame center expand fillx}

  # build widget .top13.frame1.frame13
  frame .top13.frame1.frame13 \
    -borderwidth {2} \
    -relief {raised}

  # build widget .top13.frame1.frame13.button14
  button .top13.frame1.frame13.button14 \
    -command {if { [string match "\[0-9\]" $chichotRegNr] } {
  send chichot [list set chichotCmd "$chichotRegNr"]
}
set chichotRegNr ""} \
    -text {Save to register:}

  # build widget .top13.frame1.frame13.entry15
  entry .top13.frame1.frame13.entry15 \
    -relief {sunken} \
    -textvariable {chichotRegNr} \
    -width {1}

  # pack widget .top13.frame1.frame13
  pack append .top13.frame1.frame13 \
    .top13.frame1.frame13.button14 {left frame center expand fillx} \
    .top13.frame1.frame13.entry15 {left frame center fill}

  # pack widget .top13.frame1
  pack append .top13.frame1 \
    .top13.frame1.frame11 {top frame center fillx} \
    .top13.frame1.frame12 {top frame center expand fillx} \
    .top13.frame1.frame13 {top frame center fillx}

  # build widget .top13.frame6
  frame .top13.frame6 \
    -borderwidth {2} \
    -relief {raised}

  # build widget .top13.frame6.label7
  label .top13.frame6.label7 \
    -relief {raised} \
    -text {Add context(s):}

  # build widget .top13.frame6.frame15
  frame .top13.frame6.frame15 \
    -borderwidth {2} \
    -relief {raised}

  # build widget .top13.frame6.frame15.label16
  label .top13.frame6.frame15.label16 \
    -relief {raised} \
    -text {Trigger:}

  # build widget .top13.frame6.frame15.entry17
  entry .top13.frame6.frame15.entry17 \
    -textvariable {chichotTrigger}

  # pack widget .top13.frame6.frame15
  pack append .top13.frame6.frame15 \
    .top13.frame6.frame15.label16 {left frame center} \
    .top13.frame6.frame15.entry17 {top frame center expand fillx}

  # build widget .top13.frame6.frame18
  frame .top13.frame6.frame18 \
    -borderwidth {2} \
    -relief {raised}

  # build widget .top13.frame6.frame18.label19
  label .top13.frame6.frame18.label19 \
    -relief {raised} \
    -text {Job:}

  # build widget .top13.frame6.frame18.entry20
  entry .top13.frame6.frame18.entry20 \
    -textvariable {chichotJob}

  # pack widget .top13.frame6.frame18
  pack append .top13.frame6.frame18 \
    .top13.frame6.frame18.label19 {left frame center} \
    .top13.frame6.frame18.entry20 {top frame center expand fillx}

  # build widget .top13.frame6.label11
  label .top13.frame6.label11 \
    -relief {raised} \
    -text {Delete context(s):}

  # build widget .top13.frame6.frame21
  frame .top13.frame6.frame21 \
    -borderwidth {2} \
    -relief {raised}

  # build widget .top13.frame6.frame21.scrollbar10
  scrollbar .top13.frame6.frame21.scrollbar10 \
    -activeforeground {#ffe4c4} \
    -command {addContextsText yview}

  # build widget .top13.frame6.frame21.text9
  text .top13.frame6.frame21.text9 \
    -height {9} \
    -width {9} \
    -yscrollcommand {.top13.frame6.frame21.scrollbar10 set}

  # build widget .top13.frame6.frame21.frame2
  frame .top13.frame6.frame21.frame2 \
    -borderwidth {2} \
    -relief {raised}

  # build widget .top13.frame6.frame21.frame2.checkbutton0
  checkbutton .top13.frame6.frame21.frame2.checkbutton0 \
    -text {linemode} \
    -variable {chichotLinemode}

  # build widget .top13.frame6.frame21.frame2.checkbutton1
  checkbutton .top13.frame6.frame21.frame2.checkbutton1 \
    -text {nolongwait} \
    -variable {chichotNolongwait}

  # pack widget .top13.frame6.frame21.frame2
  pack append .top13.frame6.frame21.frame2 \
    .top13.frame6.frame21.frame2.checkbutton0 {left frame center expand fillx} \
    .top13.frame6.frame21.frame2.checkbutton1 {left frame center expand fillx}

  # pack widget .top13.frame6.frame21
  pack append .top13.frame6.frame21 \
    .top13.frame6.frame21.frame2 {top frame center fillx} \
    .top13.frame6.frame21.text9 {left frame center expand fillx} \
    .top13.frame6.frame21.scrollbar10 {top frame center expand filly}

  # build widget .top13.frame6.frame22
  frame .top13.frame6.frame22 \
    -borderwidth {2} \
    -relief {raised}

  # build widget .top13.frame6.frame22.scrollbar14
  scrollbar .top13.frame6.frame22.scrollbar14 \
    -activeforeground {#ffe4c4} \
    -command {delContextsText yview}

  # build widget .top13.frame6.frame22.text13
  text .top13.frame6.frame22.text13 \
    -height {9} \
    -relief {raised} \
    -width {9} \
    -wrap {none} \
    -yscrollcommand {.top13.frame6.frame22.scrollbar14 set}

  # pack widget .top13.frame6.frame22
  pack append .top13.frame6.frame22 \
    .top13.frame6.frame22.text13 {left frame center expand fillx} \
    .top13.frame6.frame22.scrollbar14 {top frame center expand filly}

  # build widget .top13.frame6.frame23
  frame .top13.frame6.frame23 \
    -borderwidth {2} \
    -relief {raised}

  # build widget .top13.frame6.frame23.button24
  button .top13.frame6.frame23.button24 \
    -command {set addContexts [addContextsText get 0.0 end]
set delContexts [delContextsText get 0.0 end]
if { [string compare $addContexts ""] ||
     [string compare $delContexts ""] } {
  set currContexts [currContextsText get 0.0 end]
  set currContexts [split $currContexts \n]
  set addContexts [split $addContexts \n]
  set delContexts [split $delContexts \n]
  set currInd [lsearch $currContexts "linemode"]
  if { $currInd >= 0 } {
    set currContexts [lreplace $currContexts $currInd $currInd]
  }
  set currInd [lsearch $currContexts "nolongwait"]
  if { $currInd >= 0 } {
    set currContexts [lreplace $currContexts $currInd $currInd]
  }
  set currContexts [concat $currContexts $addContexts]
  set addContexts ""
  if { $chichotLinemode } {
    set currContexts [lappend currContexts "linemode"]
  }
  if { $chichotNolongwait } {
    set currContexts [lappend currContexts "nolongwait"]
  }
  set delInd [llength $delContexts]
  incr delInd -1
  while { $delInd >= 0 } {
    set delElem [lindex $delContexts $delInd]
    set currInd [lsearch $currContexts $delElem]
    if { $currInd >= 0 } {
      set currContexts [lreplace $currContexts $currInd $currInd]
    }
    incr delInd -1
  }
  set delContexts ""
  set currContexts [join $currContexts \n]
  if { ![string compare $currContexts ""] } {
    set currContexts " "
  }
  if { [string compare $chichotTrigger ""] } {
    regsub -all {\\\n} $chichotTrigger \n chichotTriggerNew
    send chichot [list set chichotCmd "\034o$chichotTriggerNew\034\034t$currContexts\034\034"]
  } else {
    send chichot [list set chichotCmd "\034t$currContexts\034\034"]
  }
  addContextsText delete 0.0 end
  delContextsText delete 0.0 end
  set chichotJob ""
  set chichotTrigger ""
  set chichotLinemode 1
  set chichotNolongwait 1
  pack forget .top13.frame6
  wm withdraw .top13
  grab release .top13
}} \
    -text {OK}

  # build widget .top13.frame6.frame23.button25
  button .top13.frame6.frame23.button25 \
    -command {addContextsText delete 0.0 end
delContextsText delete 0.0 end
set chichotJob ""
set chichotTrigger ""
set chichotLinemode 1
set chichotNolongwait 1
pack forget .top13.frame6
wm withdraw .top13
grab release .top13
} \
    -text {Cancel}

  # pack widget .top13.frame6.frame23
  pack append .top13.frame6.frame23 \
    .top13.frame6.frame23.button24 {left frame center expand fillx} \
    .top13.frame6.frame23.button25 {left frame center expand fillx}

  # build widget .top13.frame6.label1
  label .top13.frame6.label1 \
    -relief {raised} \
    -text {Change context:}

  # pack widget .top13.frame6
  pack append .top13.frame6 \
    .top13.frame6.label1 {top frame center fillx} \
    .top13.frame6.frame15 {top frame center fillx} \
    .top13.frame6.frame18 {top frame center fillx} \
    .top13.frame6.label7 {top frame center fillx} \
    .top13.frame6.frame21 {top frame center fillx} \
    .top13.frame6.label11 {top frame center fillx} \
    .top13.frame6.frame22 {top frame center fillx} \
    .top13.frame6.frame23 {top frame center fillx}

  # build widget .top13.frame0
  frame .top13.frame0 \
    -borderwidth {2} \
    -relief {raised}

  # build widget .top13.frame0.scrollbar19
  scrollbar .top13.frame0.scrollbar19 \
    -activeforeground {#ffe4c4} \
    -command {screenMacroList yview} \
    -relief {raised}

  # build widget .top13.frame0.frame15
  frame .top13.frame0.frame15 \
    -borderwidth {2} \
    -relief {raised}

  # build widget .top13.frame0.frame15.label16
  label .top13.frame0.frame15.label16 \
    -relief {raised} \
    -text {Screen macro list:}

  # build widget .top13.frame0.frame15.button17
  button .top13.frame0.frame15.button17 \
    -command {screenMacroList delete 0 end
pack forget .top13.frame0
wm withdraw .top13
grab release .top13} \
    -text {Dismiss}

  # pack widget .top13.frame0.frame15
  pack append .top13.frame0.frame15 \
    .top13.frame0.frame15.label16 {left frame center expand fillx} \
    .top13.frame0.frame15.button17 {left frame center expand fillx}

  # build widget .top13.frame0.listbox1
  listbox .top13.frame0.listbox1 \
    -geometry {29x9} \
    -relief {raised} \
    -yscrollcommand {.top13.frame0.scrollbar19 set}

  # pack widget .top13.frame0
  pack append .top13.frame0 \
    .top13.frame0.frame15 {top frame center fillx} \
    .top13.frame0.listbox1 {left frame center} \
    .top13.frame0.scrollbar19 {top frame center expand filly}

  # build widget .top13.frame4
  frame .top13.frame4 \
    -borderwidth {2} \
    -relief {raised}

  # build widget .top13.frame4.scrollbar14
  scrollbar .top13.frame4.scrollbar14 \
    -activeforeground {#ffe4c4} \
    -command {keywordList yview}

  # build widget .top13.frame4.frame9
  frame .top13.frame4.frame9 \
    -borderwidth {2} \
    -relief {raised}

  # build widget .top13.frame4.frame9.label11
  label .top13.frame4.frame9.label11 \
    -relief {raised} \
    -text {Keyword list:}

  # build widget .top13.frame4.frame9.button2
  button .top13.frame4.frame9.button2 \
    -command {pack forget .top13.frame4
wm withdraw .top13
} \
    -text {Dismiss}

  # pack widget .top13.frame4.frame9
  pack append .top13.frame4.frame9 \
    .top13.frame4.frame9.label11 {left frame center expand fillx} \
    .top13.frame4.frame9.button2 {top frame center}

  # build widget .top13.frame4.listbox0
  listbox .top13.frame4.listbox0 \
    -geometry {14x9} \
    -relief {raised} \
    -yscrollcommand {.top13.frame4.scrollbar14 set}

  # pack widget .top13.frame4
  pack append .top13.frame4 \
    .top13.frame4.frame9 {top frame center fillx} \
    .top13.frame4.listbox0 {left frame center expand fillx} \
    .top13.frame4.scrollbar14 {top frame center expand filly}

  # build widget .top13.frame11
  frame .top13.frame11 \
    -borderwidth {2} \
    -relief {raised}

  # build widget .top13.frame11.frame0
  frame .top13.frame11.frame0 \
    -borderwidth {2} \
    -relief {ridge}

  # build widget .top13.frame11.frame0.menubutton1
  menubutton .top13.frame11.frame0.menubutton1 \
    -menu {.top13.frame11.frame0.menubutton1.m} \
    -text {L} \
    -underline {0}

  # build widget .top13.frame11.frame0.menubutton1.m
  menu .top13.frame11.frame0.menubutton1.m
  .top13.frame11.frame0.menubutton1.m add command \
    -command {send chichot set chichotCmd \"\\034\"
patternText delete 0.0 end
pack forget .top13.frame11
wm withdraw .top13
grab release .top13} \
    -label {Cancel} \
    -underline {0}
  .top13.frame11.frame0.menubutton1.m add command \
    -command {set patternVal [patternText get 0.0 end]
set modPatt ""
set pattInd [string first \\ $patternVal]
while { -1 != $pattInd } {
  set modPatt $modPatt[string range $patternVal 0 [expr $pattInd-1] ]\\\\
  set patternVal [string range $patternVal [expr $pattInd+1] end]
  set pattInd [string first \\ $patternVal]
}
set patternVal $modPatt$patternVal
set modPatt ""
set pattInd [string first \n $patternVal]
while { -1 != $pattInd } {
  set modPatt $modPatt[string range $patternVal 0 [expr $pattInd-1]]\\n
  set patternVal [string range $patternVal [expr $pattInd+1] end]
  set pattInd [string first \n $patternVal]
}
set modPatt $modPatt$patternVal
patternText delete 0.0 end
send chichot [list set chichotCmd "r$modPatt\034\034"]
pack forget .top13.frame11
wm withdraw .top13
grab release .top13} \
    -label {Locate} \
    -underline {0}

  # pack widget .top13.frame11.frame0
  pack append .top13.frame11.frame0 \
    .top13.frame11.frame0.menubutton1 {top frame center fillx}

  # build widget .top13.frame11.text11
  text .top13.frame11.text11 \
    -height {3} \
    -relief {raised} \
    -width {1} \
    -wrap {none}

  # pack widget .top13.frame11
  pack append .top13.frame11 \
    .top13.frame11.frame0 {top frame center fillx} \
    .top13.frame11.text11 {left frame center}

  # build widget .top13.frame2
  frame .top13.frame2 \
    -borderwidth {2} \
    -relief {raised}

  # build widget .top13.frame2.button18
  button .top13.frame2.button18 \
    -command {pack forget .top13.frame2
wm withdraw .top13
grab release .top13} \
    -text {Dismiss}

  # build widget .top13.frame2.frame19
  frame .top13.frame2.frame19 \
    -borderwidth {2} \
    -relief {raised}

  # build widget .top13.frame2.frame19.scrollbar2
  scrollbar .top13.frame2.frame19.scrollbar2 \
    -activeforeground {#ffe4c4} \
    -command {debug yview}

  # build widget .top13.frame2.frame19.text0
  text .top13.frame2.frame19.text0 \
    -height {9} \
    -width {9} \
    -yscrollcommand {.top13.frame2.frame19.scrollbar2 set}

  # pack widget .top13.frame2.frame19
  pack append .top13.frame2.frame19 \
    .top13.frame2.frame19.text0 {left frame center} \
    .top13.frame2.frame19.scrollbar2 {right frame center filly}

  # pack widget .top13.frame2
  pack append .top13.frame2 \
    .top13.frame2.frame19 {top frame center fillx} \
    .top13.frame2.button18 {top frame center fillx}

  # build widget .top13.frame3
  frame .top13.frame3 \
    -borderwidth {2} \
    -relief {raised}

  # build widget .top13.frame3.message5
  message .top13.frame3.message5 \
    -aspect {1500} \
    -padx {5} \
    -pady {2} \
    -relief {raised} \
    -text {An alternative action
is being requested}

  # build widget .top13.frame3.button6
  button .top13.frame3.button6 \
    -command {pack forget .top13.frame3
wm withdraw .top13
grab release .top13
send chichot set chichotCmd \"\\034\"
actionOn} \
    -text {Confirm}

  # pack widget .top13.frame3
  pack append .top13.frame3 \
    .top13.frame3.message5 {top frame center} \
    .top13.frame3.button6 {top frame center fillx}

  # build widget .top13.frame5
  frame .top13.frame5 \
    -borderwidth {2} \
    -relief {raised}

  # build widget .top13.frame5.button7
  button .top13.frame5.button7 \
    -command {send chichot [list set chichotCmd " "]} \
    -text {View log char by char}

  # build widget .top13.frame5.button8
  button .top13.frame5.button8 \
    -command {send chichot set chichotCmd \"l\"} \
    -text {View log line by line}

  # build widget .top13.frame5.button9
  button .top13.frame5.button9 \
    -command {send chichot set chichotCmd \"c\"} \
    -text {Capture}

  # build widget .top13.frame5.button10
  button .top13.frame5.button10 \
    -command {send chichot set chichotCmd \"\\034\"
pack forget .top13.frame5
wm deiconify .top13
grab release .top13} \
    -text {End capture}

  # build widget .top13.frame5.button11
  button .top13.frame5.button11 \
    -command {send chichot set chichotCmd \"\\034\"
pack forget .top13.frame5
wm withdraw .top13
grab release .top13
} \
    -text {Dismiss}

  # pack widget .top13.frame5
  pack append .top13.frame5 \
    .top13.frame5.button7 {top frame center fillx} \
    .top13.frame5.button8 {top frame center fillx} \
    .top13.frame5.button9 {top frame center fillx} \
    .top13.frame5.button10 {top frame center fillx} \
    .top13.frame5.button11 {top frame center fillx}

  # build widget .top13.frame7
  frame .top13.frame7 \
    -borderwidth {2} \
    -relief {raised}

  # build widget .top13.frame7.button17
  button .top13.frame7.button17 \
    -command {pack forget .top13.frame7
wm withdraw .top13
grab release .top13} \
    -text {Cancel}

  # build widget .top13.frame7.button18
  button .top13.frame7.button18 \
    -command {set arrSec [arrivalSeconds get]
set arrUsec [expr 1000*[arrivalMilliseconds get]+[arrivalMicroseconds get]]
set iarrSec [interarrivalSeconds get]
set iarrUsec [expr 1000*[interarrivalMilliseconds get]+[interarrivalMicroseconds get]]
if { $timeoutStandard } {
  send chichot set chichotCmd \"\\034u$arrSec\\034$arrUsec\\034$iarrSec\\034$iarrUsec\\034\\034\"
} else {
  send chichot set chichotCmd \"\\034U$arrSec\\034$arrUsec\\034$iarrSec\\034$iarrUsec\\034\\034\"
}
pack forget .top13.frame7
wm withdraw .top13
grab release .top13} \
    -text {OK}

  # build widget .top13.frame7.frame21
  frame .top13.frame7.frame21 \
    -borderwidth {2} \
    -relief {raised}

  # build widget .top13.frame7.frame21.frame19
  frame .top13.frame7.frame21.frame19 \
    -borderwidth {2} \
    -relief {raised}

  # build widget .top13.frame7.frame21.frame19.label15
  label .top13.frame7.frame21.frame19.label15 \
    -relief {raised} \
    -text {Arrival}

  # build widget .top13.frame7.frame21.frame19.scale10
  scale .top13.frame7.frame21.frame19.scale10 \
    -activeforeground {#cdb79e} \
    -label {Milliseconda} \
    -orient {horizontal} \
    -to {999}

  # build widget .top13.frame7.frame21.frame19.scale11
  scale .top13.frame7.frame21.frame19.scale11 \
    -activeforeground {#cdb79e} \
    -label {Microseconds} \
    -orient {horizontal} \
    -to {999}

  # build widget .top13.frame7.frame21.frame19.scale9
  scale .top13.frame7.frame21.frame19.scale9 \
    -activeforeground {#cdb79e} \
    -label {Seconds} \
    -orient {horizontal} \
    -to {120}

  # pack widget .top13.frame7.frame21.frame19
  pack append .top13.frame7.frame21.frame19 \
    .top13.frame7.frame21.frame19.label15 {top frame center fillx} \
    .top13.frame7.frame21.frame19.scale9 {top frame center} \
    .top13.frame7.frame21.frame19.scale10 {top frame center} \
    .top13.frame7.frame21.frame19.scale11 {top frame center}

  # build widget .top13.frame7.frame21.frame20
  frame .top13.frame7.frame21.frame20 \
    -borderwidth {2} \
    -relief {raised}

  # build widget .top13.frame7.frame21.frame20.label16
  label .top13.frame7.frame21.frame20.label16 \
    -relief {raised} \
    -text {Interarrival}

  # build widget .top13.frame7.frame21.frame20.scale12
  scale .top13.frame7.frame21.frame20.scale12 \
    -activeforeground {#cdb79e} \
    -label {Seconds} \
    -orient {horizontal} \
    -to {120}

  # build widget .top13.frame7.frame21.frame20.scale13
  scale .top13.frame7.frame21.frame20.scale13 \
    -activeforeground {#cdb79e} \
    -label {Milliseconds} \
    -orient {horizontal} \
    -to {999}

  # build widget .top13.frame7.frame21.frame20.scale14
  scale .top13.frame7.frame21.frame20.scale14 \
    -activeforeground {#cdb79e} \
    -label {Microseconds} \
    -orient {horizontal} \
    -to {999}

  # pack widget .top13.frame7.frame21.frame20
  pack append .top13.frame7.frame21.frame20 \
    .top13.frame7.frame21.frame20.label16 {top frame center fillx} \
    .top13.frame7.frame21.frame20.scale12 {top frame center} \
    .top13.frame7.frame21.frame20.scale13 {top frame center} \
    .top13.frame7.frame21.frame20.scale14 {top frame center}

  # pack widget .top13.frame7.frame21
  pack append .top13.frame7.frame21 \
    .top13.frame7.frame21.frame19 {left frame center} \
    .top13.frame7.frame21.frame20 {top frame center}

  # build widget .top13.frame7.frame1
  frame .top13.frame7.frame1 \
    -borderwidth {2} \
    -relief {raised}

  # build widget .top13.frame7.frame1.label22
  label .top13.frame7.frame1.label22 \
    -relief {raised} \
    -text {Timeout values:}

  # build widget .top13.frame7.frame1.checkbutton0
  checkbutton .top13.frame7.frame1.checkbutton0 \
    -text {Standard} \
    -variable {timeoutStandard}

  # pack widget .top13.frame7.frame1
  pack append .top13.frame7.frame1 \
    .top13.frame7.frame1.label22 {left frame center fillx} \
    .top13.frame7.frame1.checkbutton0 {top frame center fillx}

  # pack widget .top13.frame7
  pack append .top13.frame7 \
    .top13.frame7.frame1 {top frame center fillx} \
    .top13.frame7.frame21 {top frame center} \
    .top13.frame7.button17 {left frame center expand fillx} \
    .top13.frame7.button18 {left frame center expand fillx}

  # build widget .top13.frame8
  frame .top13.frame8 \
    -borderwidth {2} \
    -relief {raised}

  # build widget .top13.frame8.frame14
  frame .top13.frame8.frame14 \
    -borderwidth {2} \
    -relief {raised}

  # build widget .top13.frame8.frame14.message10
  message .top13.frame8.frame14.message10 \
    -aspect {1500} \
    -padx {5} \
    -pady {2} \
    -relief {raised} \
    -text {Keyword threshold:}

  # build widget .top13.frame8.frame14.entry11
  entry .top13.frame8.frame14.entry11 \
    -relief {raised} \
    -textvariable {keywordThreshold} \
    -width {2}

  # pack widget .top13.frame8.frame14
  pack append .top13.frame8.frame14 \
    .top13.frame8.frame14.message10 {left frame center expand fillx} \
    .top13.frame8.frame14.entry11 {left frame center expand fill}

  # build widget .top13.frame8.frame15
  frame .top13.frame8.frame15 \
    -borderwidth {2} \
    -relief {raised}

  # build widget .top13.frame8.frame15.button12
  button .top13.frame8.frame15.button12 \
    -command {grab release .top13
pack forget .top13.frame8
wm withdraw .top13
set keywordThreshold ""} \
    -text {Cancel}

  # build widget .top13.frame8.frame15.button13
  button .top13.frame8.frame15.button13 \
    -command {grab release .top13
pack forget .top13.frame8
wm withdraw .top13
if { [string compare $keywordNumberRelation lessThan] } {
  send chichot set chichotCmd \"\\034C$keywordThreshold\\034\"
} else {
  send chichot set chichotCmd \"\\034F$keywordThreshold\\034\"
}
set keywordThreshold ""} \
    -text {OK}

  # pack widget .top13.frame8.frame15
  pack append .top13.frame8.frame15 \
    .top13.frame8.frame15.button12 {left frame center expand fillx} \
    .top13.frame8.frame15.button13 {left frame center expand fillx}

  # build widget .top13.frame8.frame2
  frame .top13.frame8.frame2 \
    -borderwidth {2} \
    -relief {raised}

  # build widget .top13.frame8.frame2.radiobutton0
  radiobutton .top13.frame8.frame2.radiobutton0 \
    -text {Less than} \
    -value {lessThan} \
    -variable {keywordNumberRelation}

  # build widget .top13.frame8.frame2.radiobutton1
  radiobutton .top13.frame8.frame2.radiobutton1 \
    -text {Greater than} \
    -value {greaterThan} \
    -variable {keywordNumberRelation}

  # pack widget .top13.frame8.frame2
  pack append .top13.frame8.frame2 \
    .top13.frame8.frame2.radiobutton0 {left frame center expand fillx} \
    .top13.frame8.frame2.radiobutton1 {left frame center expand fillx}

  # pack widget .top13.frame8
  pack append .top13.frame8 \
    .top13.frame8.frame2 {top frame center fillx} \
    .top13.frame8.frame14 {top frame center fillx} \
    .top13.frame8.frame15 {top frame center fillx}

  # build widget .top13.frame10
  frame .top13.frame10 \
    -borderwidth {2} \
    -relief {raised}

  # build widget .top13.frame10.frame12
  frame .top13.frame10.frame12 \
    -borderwidth {2} \
    -relief {raised}

  # build widget .top13.frame10.frame12.label15
  label .top13.frame10.frame12.label15 \
    -relief {raised} \
    -text {Macro/Action:}

  # build widget .top13.frame10.frame12.label16
  label .top13.frame10.frame12.label16 \
    -relief {raised} \
    -text {project} \
    -textvariable {addContextMacro}

  # pack widget .top13.frame10.frame12
  pack append .top13.frame10.frame12 \
    .top13.frame10.frame12.label15 {top frame center fillx} \
    .top13.frame10.frame12.label16 {top frame center fillx}

  # build widget .top13.frame10.frame13
  frame .top13.frame10.frame13 \
    -borderwidth {2} \
    -relief {raised}

  # build widget .top13.frame10.frame13.label17
  label .top13.frame10.frame13.label17 \
    -relief {raised} \
    -text {Context to be added:}

  # build widget .top13.frame10.frame13.entry18
  entry .top13.frame10.frame13.entry18 \
    -relief {raised} \
    -textvariable {addContextContext} \
    -width {7}

  # pack widget .top13.frame10.frame13
  pack append .top13.frame10.frame13 \
    .top13.frame10.frame13.label17 {top frame center fillx} \
    .top13.frame10.frame13.entry18 {top frame center fillx}

  # build widget .top13.frame10.frame14
  frame .top13.frame10.frame14 \
    -borderwidth {2} \
    -relief {raised}

  # build widget .top13.frame10.frame14.button19
  button .top13.frame10.frame14.button19 \
    -command {pack forget .top13.frame10
wm withdraw .top13
grab release .top13} \
    -text {Cancel}

  # build widget .top13.frame10.frame14.button20
  button .top13.frame10.frame14.button20 \
    -command {if { [string compare "" $addContextContext] &&
     [string compare "" $addContxetMacro } {
  send chichot [list set chichotCmd "\034A$contextMacro\034$addContextContext\034"]
  pack forget .top13.frame10
  wm withdraw .top13
  grab release .top13
}} \
    -text {OK}

  # pack widget .top13.frame10.frame14
  pack append .top13.frame10.frame14 \
    .top13.frame10.frame14.button19 {left frame center expand fillx} \
    .top13.frame10.frame14.button20 {left frame center expand fillx}

  # pack widget .top13.frame10
  pack append .top13.frame10 \
    .top13.frame10.frame12 {top frame center fillx} \
    .top13.frame10.frame13 {top frame center fillx} \
    .top13.frame10.frame14 {top frame center fillx}

  # build widget .top13.frame12
  frame .top13.frame12 \
    -borderwidth {2} \
    -relief {raised}

  # build widget .top13.frame12.label14
  label .top13.frame12.label14 \
    -relief {raised} \
    -text {Numeric compare:}

  # build widget .top13.frame12.frame15
  frame .top13.frame12.frame15 \
    -borderwidth {2} \
    -relief {raised}

  # build widget .top13.frame12.frame15.label18
  label .top13.frame12.frame15.label18 \
    -relief {raised} \
    -text {Threshold:}

  # build widget .top13.frame12.frame15.entry19
  entry .top13.frame12.frame15.entry19 \
    -relief {raised} \
    -textvariable {numThreshold} \
    -width {7}

  # pack widget .top13.frame12.frame15
  pack append .top13.frame12.frame15 \
    .top13.frame12.frame15.label18 {left frame center expand fillx} \
    .top13.frame12.frame15.entry19 {left frame center expand fill}

  # build widget .top13.frame12.frame16
  frame .top13.frame12.frame16 \
    -borderwidth {2} \
    -relief {raised}

  # build widget .top13.frame12.frame16.radiobutton20
  radiobutton .top13.frame12.frame16.radiobutton20 \
    -text {<} \
    -value {<} \
    -variable {numRelation}

  # build widget .top13.frame12.frame16.radiobutton21
  radiobutton .top13.frame12.frame16.radiobutton21 \
    -text {>} \
    -value {>} \
    -variable {numRelation}

  # build widget .top13.frame12.frame16.radiobutton22
  radiobutton .top13.frame12.frame16.radiobutton22 \
    -text {=} \
    -value {=} \
    -variable {numRelation}

  # pack widget .top13.frame12.frame16
  pack append .top13.frame12.frame16 \
    .top13.frame12.frame16.radiobutton20 {left frame center expand fillx} \
    .top13.frame12.frame16.radiobutton21 {left frame center expand fillx} \
    .top13.frame12.frame16.radiobutton22 {left frame center expand fillx}

  # build widget .top13.frame12.frame17
  frame .top13.frame12.frame17 \
    -borderwidth {2} \
    -relief {raised}

  # build widget .top13.frame12.frame17.button23
  button .top13.frame12.frame17.button23 \
    -command {set numThreshold ""
pack forget .top13.frame12
wm withdraw .top13
grab release .top13} \
    -text {Cancel}

  # build widget .top13.frame12.frame17.button24
  button .top13.frame12.frame17.button24 \
    -command {if { [string compare "" $numThreshold] } {
  send chichot set chichotCmd \"\\034$numRelation$numThreshold\\034\"
  pack forget .top13.frame12
  wm withdraw .top13
  grab release .top13
}} \
    -text {OK}

  # pack widget .top13.frame12.frame17
  pack append .top13.frame12.frame17 \
    .top13.frame12.frame17.button23 {left frame center expand fillx} \
    .top13.frame12.frame17.button24 {left frame center expand fillx}

  # pack widget .top13.frame12
  pack append .top13.frame12 \
    .top13.frame12.label14 {top frame center fillx} \
    .top13.frame12.frame16 {top frame center fillx} \
    .top13.frame12.frame15 {top frame center fillx} \
    .top13.frame12.frame17 {top frame center fillx}

  global tkVersion
  if {$tkVersion >= 3.0} {
    tk_menuBar .top13.frame11.frame0 .top13.frame11.frame0.menubutton1
  } {
    tk_menus .top13 .top13.frame11.frame0.menubutton1
  }

  .top13.frame6.frame21.text9 insert end {}
  .top13.frame6.frame22.text13 insert end {}
  .top13.frame11.text11 insert end {}
  .top13.frame2.frame19.text0 insert end {}



  if {"[info procs XFEdit]" != ""} {
    catch "XFMiscBindWidgetTree .top13"
    after 2 "catch {XFEditSetShowWindows}"
  }
}

proc DestroyWindow.top13 {} {# xf ignore me 7
  if {"[info procs XFEdit]" != ""} {
    if {"[info commands .top13]" != ""} {
      global xfShowWindow.top13
      set xfShowWindow.top13 0
      XFEditSetPath .
      after 2 "XFSaveAsProc .top13; XFEditSetShowWindows"
    }
  } {
    catch "destroy .top13"
    update
  }
}


# procedure to show window .
proc ShowWindow. {args} {# xf ignore me 7

  # Window manager configurations
  global tkVersion
  wm positionfrom . user
  wm sizefrom . ""
  wm maxsize . 800 600
  wm title . {assist}

  # bindings
  bind . <Button-3> {MenuPopupPost .frame8.menubutton15.m.menu3 %X %Y}
  bind . <ButtonRelease-3> {MenuPopupRelease .frame8.menubutton15.m.menu3 %W}

  # build widget .frame8
  frame .frame8 \
    -borderwidth {2} \
    -relief {raised}

  # build widget .frame8.menubutton3
  menubutton .frame8.menubutton3 \
    -menu {.frame8.menubutton3.m} \
    -text {Macro} \
    -underline {0}

  # build widget .frame8.menubutton3.m
  menu .frame8.menubutton3.m
  .frame8.menubutton3.m add cascade \
    -label {Record} \
    -menu {.frame8.menubutton3.m.menu6} \
    -state {active} \
    -underline {0}
  .frame8.menubutton3.m add command \
    -command {if { [string compare "" $chichotName] } {
  send chichot [list set chichotCmd "\034x$chichotName\034"]
} else {
  set sel [inputMacroList curselection]
  if { 1 == [llength $sel] } {
    send chichot [list set chichotCmd "\034x[inputMacroList get $sel]\034"]
  }
}} \
    -label {Replay} \
    -underline {2}
  .frame8.menubutton3.m add separator
  .frame8.menubutton3.m add cascade \
    -label {Keyword} \
    -menu {.frame8.menubutton3.m.menu5} \
    -underline {0}
  .frame8.menubutton3.m add command \
    -command {send chichot set chichotCmd \"\\034S\\034\"
pack .top13.frame0
wm deiconify .top13
grab set .top13} \
    -label {Termcap} \
    -underline {0}
  .frame8.menubutton3.m add separator
  .frame8.menubutton3.m add cascade \
    -label {Delete} \
    -menu {.frame8.menubutton3.m.menu9} \
    -underline {0}
  .frame8.menubutton3.m add command \
    -command {send chichot set chichotCmd \"\\034w\\034\"} \
    -label {Save} \
    -underline {0}
  .frame8.menubutton3.m add command \
    -command {set sel [inputMacroList curselection]
if { 1 == [llength $sel] } {
  set addContextMacro [inputMacroList get $sel]
  wm deiconify .top13
  pack .top13.frame10
  grab set .top13
}
} \
    -label {Add context} \
    -underline {0}

  # build widget .frame8.menubutton3.m.menu6
  menu .frame8.menubutton3.m.menu6
  .frame8.menubutton3.m.menu6 add cascade \
    -label {Input} \
    -menu {.frame8.menubutton3.m.menu6.m} \
    -underline {0}
  .frame8.menubutton3.m.menu6 add cascade \
    -label {Output} \
    -menu {.frame8.menubutton3.m.menu6.menu1} \
    -underline {0}
  # bindings
  bind .frame8.menubutton3.m.menu6 <B3-Motion> {MenuPopupMotion .frame8.menubutton3.m.menu6 %W %X %Y}
  bind .frame8.menubutton3.m.menu6 <ButtonRelease-3> {MenuPopupRelease .frame8.menubutton3.m.menu6 %W}

  # build widget .frame8.menubutton3.m.menu6.m
  menu .frame8.menubutton3.m.menu6.m
  .frame8.menubutton3.m.menu6.m add command \
    -command {send chichot [list set chichotCmd "\034i$chichotName\034\034"]
set chichotStatus "Recording ..."} \
    -label {Start} \
    -underline {0}
  .frame8.menubutton3.m.menu6.m add command \
    -command {send chichot set chichotCmd \"\\034\"
set chichotStatus "                 "} \
    -label {End} \
    -underline {0}

  # build widget .frame8.menubutton3.m.menu6.menu1
  menu .frame8.menubutton3.m.menu6.menu1
  .frame8.menubutton3.m.menu6.menu1 add command \
    -command {send chichot [list set chichotCmd "\034o$chichotName\034"]
set chichotStatus "Recording ..."} \
    -label {Start} \
    -underline {0}
  .frame8.menubutton3.m.menu6.menu1 add command \
    -command {send chichot set chichotCmd \"\\034\"
set chichotStatus "                   "
} \
    -label {End} \
    -underline {0}
  # bindings
  bind .frame8.menubutton3.m.menu6.menu1 <B3-Motion> {MenuPopupMotion .frame8.menubutton3.m.menu6.menu1 %W %X %Y}
  bind .frame8.menubutton3.m.menu6.menu1 <ButtonRelease-3> {MenuPopupRelease .frame8.menubutton3.m.menu6.menu1 %W}

  # build widget .frame8.menubutton3.m.menu9
  menu .frame8.menubutton3.m.menu9
  .frame8.menubutton3.m.menu9 add command \
    -command {if { [string compare "" $chichotName] } {
  send chichot [list set chichotCmd "\034e$chichotName\034"]
}} \
    -label {Named} \
    -underline {0}
  .frame8.menubutton3.m.menu9 add command \
    -command {send chichot set chichotCmd \"\\034d\\034\"
} \
    -label {Last defined} \
    -underline {0}
  .frame8.menubutton3.m.menu9 add command \
    -command {set sel [inputMacroList curselection]
if { [string compare "" $sel] } {
  foreach i $sel {
    send chichot [list set chichotCmd "\034e[inputMacroList get $i]\034"]
    inputMacroList delete $i
  }
}
set sel [triggerList curselection]
if { [string compare "" $sel] } {
  foreach i $sel {
    send chichot [list set chichotCmd "\034e[triggerList get $i]\034"]
    triggerList delete $i
  }
}
set sel [actionList curselection]
if { [string compare "" $sel] } {
  foreach i $sel {
    send chichot [list set chichotCmd "\034e[actionList get $i]\034"]
    actionList delete $i
  }
}
set sel [keywordList curselection]
if { [string compare "" $sel] } {
  foreach i $sel {
    send chichot [list set chichotCmd "\034e[keywordList get $i]\034"]
    keywordList delete $i
  }
}
set sel [screenMacroList curselection]
if { [string compare "" $sel] } {
  foreach i $sel {
    send chichot [list set chichotCmd "\034e[screenMacroList get $i]\034"]
    screenMacroList delete $i
  }
}
} \
    -label {Selected} \
    -underline {0}
  # bindings
  bind .frame8.menubutton3.m.menu9 <B3-Motion> {MenuPopupMotion .frame8.menubutton3.m.menu9 %W %X %Y}
  bind .frame8.menubutton3.m.menu9 <ButtonRelease-3> {MenuPopupRelease .frame8.menubutton3.m.menu9 %W}

  # build widget .frame8.menubutton3.m.menu5
  menu .frame8.menubutton3.m.menu5
  .frame8.menubutton3.m.menu5 add command \
    -command {send chichot [list set chichotCmd "\034k$chichotName\034"]} \
    -label {Define} \
    -underline {0}
  .frame8.menubutton3.m.menu5 add command \
    -command {wm deiconify .top13
pack .top13.frame4
send chichot set chichotCmd \"\\034y\\034\"
} \
    -label {List} \
    -underline {0}
  # bindings
  bind .frame8.menubutton3.m.menu5 <B3-Motion> {MenuPopupMotion .frame8.menubutton3.m.menu5 %W %X %Y}
  bind .frame8.menubutton3.m.menu5 <ButtonRelease-3> {MenuPopupRelease .frame8.menubutton3.m.menu5 %W}

  # build widget .frame8.menubutton5
  menubutton .frame8.menubutton5 \
    -menu {.frame8.menubutton5.m} \
    -text {Quit} \
    -underline {0}

  # build widget .frame8.menubutton5.m
  menu .frame8.menubutton5.m
  .frame8.menubutton5.m add command \
    -label {No, don't quit} \
    -underline {0}
  .frame8.menubutton5.m add command \
    -command {destroy .} \
    -label {Quit} \
    -underline {0}

  # build widget .frame8.menubutton10
  menubutton .frame8.menubutton10 \
    -menu {.frame8.menubutton10.m} \
    -text {Context} \
    -underline {3}

  # build widget .frame8.menubutton10.m
  menu .frame8.menubutton10.m
  .frame8.menubutton10.m add command \
    -command {wm deiconify .top13
pack .top13.frame6
grab set .top13} \
    -label {Change} \
    -state {active} \
    -underline {0}

  # build widget .frame8.menubutton15
  menubutton .frame8.menubutton15 \
    -foreground {black} \
    -menu {.frame8.menubutton15.m} \
    -text {Command} \
    -underline {0}

  # build widget .frame8.menubutton15.m
  menu .frame8.menubutton15.m
  .frame8.menubutton15.m add command \
    -command {send chichot set chichotCmd \"\\034\"
wm deiconify .top13
pack .top13.frame5
grab set .top13} \
    -label {View log/Capture} \
    -state {active} \
    -underline {0}
  .frame8.menubutton15.m add command \
    -command {send chichot set chichotCmd \"\\034h\\034\"} \
    -label {Help} \
    -underline {0}
  .frame8.menubutton15.m add command \
    -command {send chichot set chichotCmd \"\\034s\\034\"} \
    -label {Screen img} \
    -underline {0}
  .frame8.menubutton15.m add separator
  .frame8.menubutton15.m add command \
    -command {wm deiconify .top13
pack .top13.frame18
grab set .top13} \
    -label {Area} \
    -state {disabled} \
    -underline {0}
  .frame8.menubutton15.m add cascade \
    -label {Retrieve} \
    -menu {.frame8.menubutton15.m.menu1} \
    -state {disabled} \
    -underline {0}
  .frame8.menubutton15.m add cascade \
    -label {Row} \
    -menu {.frame8.menubutton15.m.menu2} \
    -state {disabled} \
    -underline {0}
  .frame8.menubutton15.m add command \
    -command {send chichot set chichotCmd \"\\034T\\034\"} \
    -label {Compare} \
    -state {disabled} \
    -underline {0}
  .frame8.menubutton15.m add command \
    -command {send chichot set chichotCmd \"\\034\"
wm deiconify .top13
pack .top13.frame9
grab set .top13} \
    -label {Pattern} \
    -state {disabled} \
    -underline {0}
  .frame8.menubutton15.m add cascade \
    -label {Dump} \
    -menu {.frame8.menubutton15.m.menu0} \
    -state {disabled}
  .frame8.menubutton15.m add command \
    -command {send chichot set chichotCmd \"\\034/\"
wm deiconify .top13
pack .top13.frame1
grab set .top13
} \
    -label {Search} \
    -state {disabled}
  .frame8.menubutton15.m add command \
    -command {wm deiconify .top13
pack .top13.frame7
grab set .top13} \
    -label {Timeout} \
    -state {disabled}
  .frame8.menubutton15.m add cascade \
    -label {Numeric} \
    -menu {.frame8.menubutton15.m.m} \
    -state {disabled} \
    -underline {0}
  .frame8.menubutton15.m add cascade \
    -label {Keyword #} \
    -menu {.frame8.menubutton15.m.menu3} \
    -state {disabled} \
    -underline {0}

  # build widget .frame8.menubutton15.m.menu1
  menu .frame8.menubutton15.m.menu1
  .frame8.menubutton15.m.menu1 add command \
    -command {send chichot set chichotCmd \"\\0340\\034\"
} \
    -label {Reg 0} \
    -underline {0}
  .frame8.menubutton15.m.menu1 add command \
    -command {send chichot set chichotCmd \"\\0341\\034\"
} \
    -label {Reg 1} \
    -underline {0}
  .frame8.menubutton15.m.menu1 add command \
    -command {send chichot set chichotCmd \"\\0342\\034\"
} \
    -label {Reg 2} \
    -underline {0}
  .frame8.menubutton15.m.menu1 add command \
    -command {send chichot set chichotCmd \"\\0343\\034\"
} \
    -label {Reg 3} \
    -underline {0}
  .frame8.menubutton15.m.menu1 add command \
    -command {send chichot set chichotCmd \"\\0344\\034\"
} \
    -label {Reg 4} \
    -underline {0}
  .frame8.menubutton15.m.menu1 add command \
    -command {send chichot set chichotCmd \"\\0345\\034\"
} \
    -label {Reg 5} \
    -underline {0}
  .frame8.menubutton15.m.menu1 add command \
    -command {send chichot set chichotCmd \"\\0346\\034\"
} \
    -label {Reg 6} \
    -underline {0}
  .frame8.menubutton15.m.menu1 add command \
    -command {send chichot set chichotCmd \"\\0347\\034\"
} \
    -label {Reg 7} \
    -underline {0}
  .frame8.menubutton15.m.menu1 add command \
    -command {send chichot set chichotCmd \"\\0348\\034\"
} \
    -label {Reg 8} \
    -underline {0}
  .frame8.menubutton15.m.menu1 add command \
    -command {send chichot set chichotCmd \"\\0349\\034\"
} \
    -label {Reg 9} \
    -underline {0}
  # bindings
  bind .frame8.menubutton15.m.menu1 <B3-Motion> {MenuPopupMotion .frame8.menubutton15.m.menu1 %W %X %Y}
  bind .frame8.menubutton15.m.menu1 <ButtonRelease-3> {MenuPopupRelease .frame8.menubutton15.m.menu1 %W}

  # build widget .frame8.menubutton15.m.menu2
  menu .frame8.menubutton15.m.menu2
  .frame8.menubutton15.m.menu2 add command \
    -command {send chichot set chichotCmd \"\\034n\\034\"} \
    -label {Down} \
    -underline {0}
  .frame8.menubutton15.m.menu2 add command \
    -command {send chichot set chichotCmd \"\\034p\\034\"} \
    -label {Up} \
    -underline {0}
  .frame8.menubutton15.m.menu2 add command \
    -command {send chichot set chichotCmd \"\\034f\\034\"} \
    -label {Reset}
  # bindings
  bind .frame8.menubutton15.m.menu2 <B3-Motion> {MenuPopupMotion .frame8.menubutton15.m.menu2 %W %X %Y}
  bind .frame8.menubutton15.m.menu2 <ButtonRelease-3> {MenuPopupRelease .frame8.menubutton15.m.menu2 %W}

  # build widget .frame8.menubutton15.m.menu0
  menu .frame8.menubutton15.m.menu0
  .frame8.menubutton15.m.menu0 add command \
    -command {send chichot set chichotCmd \"\\034D\\034\"} \
    -label {Save}
  .frame8.menubutton15.m.menu0 add command \
    -command {send chichot set chichotCmd \"\\034E\\034\"} \
    -label {Retrieve}
  # bindings
  bind .frame8.menubutton15.m.menu0 <B3-Motion> {MenuPopupMotion .frame8.menubutton15.m.menu0 %W %X %Y}
  bind .frame8.menubutton15.m.menu0 <ButtonRelease-3> {MenuPopupRelease .frame8.menubutton15.m.menu0 %W}

  # build widget .frame8.menubutton15.m.m
  menu .frame8.menubutton15.m.m
  .frame8.menubutton15.m.m add command \
    -command {send chichot set chichotCmd \"\\034N\\034\"} \
    -label {Assert} \
    -underline {0}
  .frame8.menubutton15.m.m add command \
    -command {wm deiconify .top13
pack .top13.frame12
grab set .top13
} \
    -label {Compare} \
    -underline {0}

  # build widget .frame8.menubutton15.m.menu3
  menu .frame8.menubutton15.m.menu3
  .frame8.menubutton15.m.menu3 add command \
    -command {wm deiconify .top13
pack .top13.frame8
grab set .top13
} \
    -label {Threshold} \
    -underline {0}
  .frame8.menubutton15.m.menu3 add command \
    -command {send chichot set chichotCmd \"g\"} \
    -label {Clear}
  # bindings
  bind .frame8.menubutton15.m.menu3 <B3-Motion> {MenuPopupMotion .frame8.menubutton15.m.menu3 %W %X %Y}
  bind .frame8.menubutton15.m.menu3 <ButtonRelease-3> {MenuPopupRelease .frame8.menubutton15.m.menu3 %W}

  # build widget .frame8.menubutton6
  menubutton .frame8.menubutton6 \
    -foreground {black} \
    -menu {.frame8.menubutton6.m} \
    -text {Action} \
    -underline {0}

  # build widget .frame8.menubutton6.m
  menu .frame8.menubutton6.m
  .frame8.menubutton6.m add cascade \
    -label {Record} \
    -menu {.frame8.menubutton6.m.menu9} \
    -underline {0}
  .frame8.menubutton6.m add cascade \
    -label {Replay} \
    -menu {.frame8.menubutton6.m.menu0} \
    -underline {0}
  .frame8.menubutton6.m add separator
  .frame8.menubutton6.m add command \
    -command {set sel [inputMacroList curselection]
if { 1 == [llength $sel] } {
  set addContextMacro [inputMacroList get $sel]
  wm deiconify .top13
  pack .top13.frame10
  grab set .top13
}
} \
    -label {Add context}

  # build widget .frame8.menubutton6.m.menu9
  menu .frame8.menubutton6.m.menu9
  .frame8.menubutton6.m.menu9 add command \
    -command {send chichot [list set chichotCmd "\034a$chichotName\034"]
actionOn
} \
    -label {Start} \
    -underline {0}
  .frame8.menubutton6.m.menu9 add command \
    -command {actionOff
} \
    -label {End} \
    -state {disabled} \
    -underline {0}
  # bindings
  bind .frame8.menubutton6.m.menu9 <B3-Motion> {MenuPopupMotion .frame8.menubutton6.m.menu9 %W %X %Y}
  bind .frame8.menubutton6.m.menu9 <ButtonRelease-3> {MenuPopupRelease .frame8.menubutton6.m.menu9 %W}

  # build widget .frame8.menubutton6.m.menu0
  menu .frame8.menubutton6.m.menu0
  .frame8.menubutton6.m.menu0 add command \
    -command {if { [string compare "" $chichotName] } {
  send chichot [list set chichotCmd "\034x$chichotName\034"]
  actionMenubutton configure -fg red
} else {
  set sel [actionList curselection]
  if { 1 == [llength $sel] } {
    send chichot [list set chichotCmd "\034x[actionList get $sel]\034"]
    actionMenubutton configure -fg red
  }
}
} \
    -label {Once}
  .frame8.menubutton6.m.menu0 add cascade \
    -label {Cycle} \
    -menu {.frame8.menubutton6.m.menu0.m}
  # bindings
  bind .frame8.menubutton6.m.menu0 <B3-Motion> {MenuPopupMotion .frame8.menubutton6.m.menu0 %W %X %Y}
  bind .frame8.menubutton6.m.menu0 <ButtonRelease-3> {MenuPopupRelease .frame8.menubutton6.m.menu0 %W}

  # build widget .frame8.menubutton6.m.menu0.m
  menu .frame8.menubutton6.m.menu0.m
  .frame8.menubutton6.m.menu0.m add command \
    -command {if { [string compare "" $chichotName] } {
  send chichot [list set chichotCmd "\034X$chichotName\034"]
  actionMenubutton configure -fg red
  cycleMenu disable 0
  cycleMenu enable 1
} else {
  set sel [actionList curselection]
  if { 1 == [llength $sel] } {
    send chichot [list set chichotCmd "\034X[actionList get $sel]\034"]
    actionMenubutton configure -fg red
    cycleMenu disable 0
    cycleMenu enable 1
  }
}
} \
    -label {Start} \
    -underline {0}
  .frame8.menubutton6.m.menu0.m add command \
    -command {send chichot set chichotEndCycle \"1\"
cycleMenu enable 0
cycleMenu disable 1} \
    -label {End} \
    -state {disabled} \
    -underline {0}

  # pack widget .frame8
  pack append .frame8 \
    .frame8.menubutton6 {left frame center} \
    .frame8.menubutton15 {left frame center} \
    .frame8.menubutton10 {left frame center} \
    .frame8.menubutton3 {left frame center} \
    .frame8.menubutton5 {right frame center}

  # build widget .frame2
  frame .frame2 \
    -borderwidth {2} \
    -relief {raised}

  # build widget .frame2.entry4
  entry .frame2.entry4 \
    -relief {sunken} \
    -textvariable {chichotName} \
    -width {18}

  # build widget .frame2.label3
  label .frame2.label3 \
    -relief {raised} \
    -text {Name/Description:}

  # build widget .frame2.label4
  label .frame2.label4 \
    -foreground {#ff0000} \
    -relief {raised} \
    -text {                 } \
    -textvariable {chichotStatus}

  # pack widget .frame2
  pack append .frame2 \
    .frame2.label4 {left frame center expand fillx} \
    .frame2.label3 {left frame center expand fillx} \
    .frame2.entry4 {left frame center expand fillx}

  # build widget .frame15
  frame .frame15 \
    -borderwidth {2} \
    -relief {raised}

  # build widget .frame15.frame7
  frame .frame15.frame7 \
    -borderwidth {2} \
    -relief {raised}

  # build widget .frame15.frame7.scrollbar10
  scrollbar .frame15.frame7.scrollbar10 \
    -activeforeground {#ffe4c4} \
    -command {triggerList yview}

  # build widget .frame15.frame7.listbox9
  listbox .frame15.frame7.listbox9 \
    -geometry {14x9} \
    -relief {raised} \
    -yscrollcommand {.frame15.frame7.scrollbar10 set}

  # build widget .frame15.frame7.label8
  label .frame15.frame7.label8 \
    -relief {raised} \
    -text {Triggers:}

  # pack widget .frame15.frame7
  pack append .frame15.frame7 \
    .frame15.frame7.label8 {top frame center expand fillx} \
    .frame15.frame7.listbox9 {left frame center expand fillx} \
    .frame15.frame7.scrollbar10 {top frame center expand filly}

  # build widget .frame15.frame0
  frame .frame15.frame0 \
    -borderwidth {2} \
    -relief {raised}

  # build widget .frame15.frame0.scrollbar3
  scrollbar .frame15.frame0.scrollbar3 \
    -activeforeground {#ffe4c4} \
    -command {currContextsText yview} \
    -relief {raised}

  # build widget .frame15.frame0.text2
  text .frame15.frame0.text2 \
    -height {9} \
    -relief {raised} \
    -width {19} \
    -wrap {none} \
    -yscrollcommand {.frame15.frame0.scrollbar3 set}

  # build widget .frame15.frame0.label1
  label .frame15.frame0.label1 \
    -relief {raised} \
    -text {Contexts:}

  # pack widget .frame15.frame0
  pack append .frame15.frame0 \
    .frame15.frame0.label1 {top frame center fillx} \
    .frame15.frame0.text2 {left frame center expand fill} \
    .frame15.frame0.scrollbar3 {top frame center expand filly}

  # pack widget .frame15
  pack append .frame15 \
    .frame15.frame7 {left frame center expand fillx} \
    .frame15.frame0 {left frame center filly}

  # build widget .frame3
  frame .frame3 \
    -borderwidth {2} \
    -relief {raised}

  # build widget .frame3.scrollbar5
  scrollbar .frame3.scrollbar5 \
    -activeforeground {#ffe4c4} \
    -command {inputMacroList yview}

  # build widget .frame3.listbox4
  listbox .frame3.listbox4 \
    -geometry {19x9} \
    -relief {raised} \
    -yscrollcommand {.frame3.scrollbar5 set}

  # build widget .frame3.label6
  label .frame3.label6 \
    -relief {raised} \
    -text {Active macros:}

  # pack widget .frame3
  pack append .frame3 \
    .frame3.label6 {top frame center expand fillx} \
    .frame3.listbox4 {left frame center expand fillx} \
    .frame3.scrollbar5 {top frame center expand filly}

  # build widget .frame7
  frame .frame7 \
    -borderwidth {2} \
    -relief {raised}

  # build widget .frame7.scrollbar10
  scrollbar .frame7.scrollbar10 \
    -activeforeground {#ffe4c4} \
    -command {actionList yview}

  # build widget .frame7.label8
  label .frame7.label8 \
    -relief {raised} \
    -text {Active actions:}

  # build widget .frame7.listbox0
  listbox .frame7.listbox0 \
    -geometry {19x9} \
    -relief {raised}

  # pack widget .frame7
  pack append .frame7 \
    .frame7.label8 {top frame center fillx} \
    .frame7.listbox0 {left frame center expand fillx} \
    .frame7.scrollbar10 {top frame center expand filly}

  # pack widget .
  pack append . \
    .frame8 {top frame center expand fillx} \
    .frame2 {top frame center expand fillx} \
    .frame15 {top frame center fillx} \
    .frame3 {top frame center expand fillx} \
    .frame7 {top frame center expand fillx}

  global tkVersion
  if {$tkVersion >= 3.0} {
    tk_menuBar .frame8 .frame8.menubutton3 .frame8.menubutton5 .frame8.menubutton10 .frame8.menubutton15 .frame8.menubutton6
  } {
    tk_menus . .frame8.menubutton3 .frame8.menubutton5 .frame8.menubutton10 .frame8.menubutton15 .frame8.menubutton6
  }

  .frame15.frame0.text2 insert end { }



  if {"[info procs XFEdit]" != ""} {
    catch "XFMiscBindWidgetTree ."
    after 2 "catch {XFEditSetShowWindows}"
  }
}


# User defined procedures


# Procedure: actionList
proc actionList { args} {
#xf ignore me 4
return [eval ".frame7.listbox0 $args"]
}


# Procedure: actionMenubutton
proc actionMenubutton { args} {
#xf ignore me 4
return [eval ".frame8.menubutton6 $args"]
}


# Procedure: actionOff
proc actionOff {} {
global chichotStatus
send chichot set chichotCmd \"\\034a\\034\"
set chichotStatus "                   "
.frame8.menubutton6.m.menu9 enable 0
.frame8.menubutton6.m.menu9 disable 1
.frame8.menubutton15.m disable 4
.frame8.menubutton15.m disable 5
.frame8.menubutton15.m disable 6
.frame8.menubutton15.m disable 7
.frame8.menubutton15.m disable 8
.frame8.menubutton15.m disable 9
.frame8.menubutton15.m disable 10
.frame8.menubutton15.m disable 11
.frame8.menubutton15.m disable 12
.frame8.menubutton15.m disable 13
}


# Procedure: actionOn
proc actionOn {} {
global chichotStatus
set chichotStatus "Recording ..."
.frame8.menubutton6.m.menu9 disable 0
.frame8.menubutton6.m.menu9 enable 1
.frame8.menubutton15.m enable 4
.frame8.menubutton15.m enable 5
.frame8.menubutton15.m enable 6
.frame8.menubutton15.m enable 7
.frame8.menubutton15.m enable 8
.frame8.menubutton15.m enable 9
.frame8.menubutton15.m enable 10
.frame8.menubutton15.m enable 11
.frame8.menubutton15.m enable 12
.frame8.menubutton15.m enable 13
}


# Procedure: addContextsText
proc addContextsText { args} {
#xf ignore me 4
return [eval ".top13.frame6.frame21.text9 $args"]
}


# Procedure: arrivalMicroseconds
proc arrivalMicroseconds { args} {
#xf ignore me 4
return [eval ".top13.frame7.frame21.frame19.scale11 $args"]
}


# Procedure: arrivalMilliseconds
proc arrivalMilliseconds { args} {
#xf ignore me 4
return [eval ".top13.frame7.frame21.frame19.scale10 $args"]
}


# Procedure: arrivalSeconds
proc arrivalSeconds { args} {
#xf ignore me 4
return [eval ".top13.frame7.frame21.frame19.scale9 $args"]
}


# Procedure: currContextsText
proc currContextsText { args} {
#xf ignore me 4
return [eval ".frame15.frame0.text2 $args"]
}


# Procedure: cycleMenu
proc cycleMenu { args} {
#xf ignore me 4
return [eval ".frame8.menubutton6.m.menu0.m $args"]
}


# Procedure: delContextsText
proc delContextsText { args} {
#xf ignore me 4
return [eval ".top13.frame6.frame22.text13 $args"]
}


# Procedure: feedback
proc feedback { args} {
#xf ignore me 4
return [eval ".top13.frame1.frame19.text0 $args"]
}


# Procedure: inputMacroList
proc inputMacroList { args} {
#xf ignore me 4
return [eval ".frame3.listbox4 $args"]
}


# Procedure: interarrivalMicroseconds
proc interarrivalMicroseconds { args} {
#xf ignore me 4
return [eval ".top13.frame7.frame21.frame20.scale14 $args"]
}


# Procedure: interarrivalMilliseconds
proc interarrivalMilliseconds { args} {
#xf ignore me 4
return [eval ".top13.frame7.frame21.frame20.scale13 $args"]
}


# Procedure: interarrivalSeconds
proc interarrivalSeconds { args} {
#xf ignore me 4
return [eval ".top13.frame7.frame21.frame20.scale12 $args"]
}


# Procedure: keywordList
proc keywordList { args} {
#xf ignore me 4
return [eval ".top13.frame4.listbox0 $args"]
}


# Procedure: patternText
proc patternText { args} {
#xf ignore me 4
return [eval ".top13.frame11.text11 $args"]
}


# Procedure: preSave
proc preSave {} {
global chichotName
triggerList delete 0 end
inputMacroList delete 0 end
currContextsText delete 0.0 end
currContextsText insert 0.0 " "
keywordList delete 0 end
screenMacroList delete 0 end
actionList delete 0 end
set chichotName ""
}


# Procedure: reqAltAction
proc reqAltAction { args} {
#xf ignore me 4
return [eval ".top13.frame3 $args"]
}


# Procedure: screenMacroList
proc screenMacroList { args} {
#xf ignore me 4
return [eval ".top13.frame0.listbox1 $args"]
}


# Procedure: termcapList
proc termcapList { args} {
#xf ignore me 4
return [eval ".top13.frame0.listbox1 $args"]
}


# Procedure: triggerList
proc triggerList { args} {
#xf ignore me 4
return [eval ".frame15.frame7.listbox9 $args"]
}


# Internal procedures


# Procedure: Alias
if {"[info procs Alias]" == ""} {
proc Alias { args} {
# xf ignore me 7
##########
# Procedure: Alias
# Description: establish an alias for a procedure
# Arguments: args - no argument means that a list of all aliases
#                   is returned. Otherwise the first parameter is
#                   the alias name, and the second parameter is
#                   the procedure that is aliased.
# Returns: nothing, the command that is bound to the alias or a
#          list of all aliases - command pairs. 
# Sideeffects: internalAliasList is updated, and the alias
#              proc is inserted
##########
  global internalAliasList

  if {[llength $args] == 0} {
    return $internalAliasList
  } {
    if {[llength $args] == 1} {
      set xfTmpIndex [lsearch $internalAliasList "[lindex $args 0] *"]
      if {$xfTmpIndex != -1} {
        return [lindex [lindex $internalAliasList $xfTmpIndex] 1]
      }
    } {
      if {[llength $args] == 2} {
        eval "proc [lindex $args 0] {args} {#xf ignore me 4
return \[eval \"[lindex $args 1] \$args\"\]}"
        set xfTmpIndex [lsearch $internalAliasList "[lindex $args 0] *"]
        if {$xfTmpIndex != -1} {
          set internalAliasList [lreplace $internalAliasList $xfTmpIndex $xfTmpIndex "[lindex $args 0] [lindex $args 1]"]
        } {
          lappend internalAliasList "[lindex $args 0] [lindex $args 1]"
        }
      } {
        error "Alias: wrong number or args: $args"
      }
    }
  }
}
}


# Procedure: GetSelection
if {"[info procs GetSelection]" == ""} {
proc GetSelection {} {
# xf ignore me 7
##########
# Procedure: GetSelection
# Description: get current selection
# Arguments: none
# Returns: none
# Sideeffects: none
##########

  # the save way
  set xfSelection ""
  catch "selection get" xfSelection
  if {"$xfSelection" == "selection doesn't exist or form \"STRING\" not defined"} {
    return ""
  } {
    return $xfSelection
  }
}
}


# Procedure: MenuPopupAdd
if {"[info procs MenuPopupAdd]" == ""} {
proc MenuPopupAdd { xfW xfButton xfMenu {xfModifier ""} {xfCanvasTag ""}} {
# xf ignore me 7
# the popup menu handling is from (I already gave up with popup handling :-):
#
# Copyright 1991,1992 by James Noble.
# Everyone is granted permission to copy, modify and redistribute.
# This notice must be preserved on all copies or derivates.
#
##########
# Procedure: MenuPopupAdd
# Description: attach a popup menu to widget
# Arguments: xfW - the widget
#            xfButton - the button we use
#            xfMenu - the menu to attach
#            {xfModifier} - a optional modifier
#            {xfCanvasTag} - a canvas tagOrId
# Returns: none
# Sideeffects: none
##########
  global tk_popupPriv

  set tk_popupPriv($xfMenu,focus) ""
  set tk_popupPriv($xfMenu,grab) ""
  if {"$xfModifier" != ""} {
    set press "$xfModifier-"
    set motion "$xfModifier-"
    set release "Any-"
  } {
    set press ""
    set motion ""
    set release ""
  }

  bind $xfMenu "<${motion}B${xfButton}-Motion>"  "MenuPopupMotion $xfMenu %W %X %Y"
  bind $xfMenu "<${release}ButtonRelease-${xfButton}>"  "MenuPopupRelease $xfMenu %W"
  if {"$xfCanvasTag" == ""} {
    bind $xfW "<${press}ButtonPress-${xfButton}>"  "MenuPopupPost $xfMenu %X %Y"
    bind $xfW "<${release}ButtonRelease-${xfButton}>"  "MenuPopupRelease $xfMenu %W"
  } {
    $xfW bind $xfCanvasTag "<${press}ButtonPress-${xfButton}>"  "MenuPopupPost $xfMenu %X %Y"
    $xfW bind $xfCanvasTag "<${release}ButtonRelease-${xfButton}>"  "MenuPopupRelease $xfMenu %W"
  }
}
}


# Procedure: MenuPopupMotion
if {"[info procs MenuPopupMotion]" == ""} {
proc MenuPopupMotion { xfMenu xfW xfX xfY} {
# xf ignore me 7
##########
# Procedure: MenuPopupMotion
# Description: handle the popup menu motion
# Arguments: xfMenu - the topmost menu
#            xfW - the menu
#            xfX - the root x coordinate
#            xfY - the root x coordinate
# Returns: none
# Sideeffects: none
##########
  global tk_popupPriv

  if {"[info commands $xfW]" != "" && [winfo ismapped $xfW] &&
      "[winfo class $xfW]" == "Menu" &&
      [info exists tk_popupPriv($xfMenu,focus)] &&
      "$tk_popupPriv($xfMenu,focus)" != "" &&
      [info exists tk_popupPriv($xfMenu,grab)] &&
      "$tk_popupPriv($xfMenu,grab)" != ""} {
    set xfPopMinX [winfo rootx $xfW]
    set xfPopMaxX [expr $xfPopMinX+[winfo width $xfW]]
    if {$xfX >= $xfPopMinX && $xfX <= $xfPopMaxX} {
      $xfW activate @[expr $xfY-[winfo rooty $xfW]]
      if {![catch "$xfW entryconfig @[expr $xfY-[winfo rooty $xfW]] -menu" result]} {
        if {"[lindex $result 4]" != ""} {
          foreach binding [bind $xfMenu] {
            bind [lindex $result 4] $binding [bind $xfMenu $binding]
          }
        }
      }
    } {
      $xfW activate none
    }
  }
}
}


# Procedure: MenuPopupPost
if {"[info procs MenuPopupPost]" == ""} {
proc MenuPopupPost { xfMenu xfX xfY} {
# xf ignore me 7
##########
# Procedure: MenuPopupPost
# Description: post the popup menu
# Arguments: xfMenu - the menu
#            xfX - the root x coordinate
#            xfY - the root x coordinate
# Returns: none
# Sideeffects: none
##########
  global tk_popupPriv

  if {"[info commands $xfMenu]" != ""} {
    if {![info exists tk_popupPriv($xfMenu,focus)]} {
      set tk_popupPriv($xfMenu,focus) [focus]
    } {
      if {"$tk_popupPriv($xfMenu,focus)" == ""} {
        set tk_popupPriv($xfMenu,focus) [focus]
      }
    }
    set tk_popupPriv($xfMenu,grab) $xfMenu

    catch "$xfMenu activate none"
    catch "$xfMenu post $xfX $xfY"
    catch "focus $xfMenu"
    catch "grab -global $xfMenu"
  }
}
}


# Procedure: MenuPopupRelease
if {"[info procs MenuPopupRelease]" == ""} {
proc MenuPopupRelease { xfMenu xfW} {
# xf ignore me 7
##########
# Procedure: MenuPopupRelease
# Description: remove the popup menu
# Arguments: xfMenu - the topmost menu widget
#            xfW - the menu widget
# Returns: none
# Sideeffects: none
##########
  global tk_popupPriv
  global tkVersion

  if {"[info commands $xfW]" != "" && [winfo ismapped $xfW] &&
      "[winfo class $xfW]" == "Menu" &&
      [info exists tk_popupPriv($xfMenu,focus)] &&
      "$tk_popupPriv($xfMenu,focus)" != "" &&
      [info exists tk_popupPriv($xfMenu,grab)] &&
      "$tk_popupPriv($xfMenu,grab)" != ""} {
    if {$tkVersion >= 3.0} {
      catch "grab release $tk_popupPriv($xfMenu,grab)"
    } {
      catch "grab none"
    }
    catch "focus $tk_popupPriv($xfMenu,focus)"
    set tk_popupPriv($xfMenu,focus) ""
    set tk_popupPriv($xfMenu,grab) ""
    if {"[$xfW index active]" != "none"} {
      $xfW invoke active; catch "$xfMenu unpost"
    }
  }
  catch "$xfMenu unpost"
}
}


# Procedure: NoFunction
if {"[info procs NoFunction]" == ""} {
proc NoFunction { args} {
# xf ignore me 7
##########
# Procedure: NoFunction
# Description: do nothing (especially with scales and scrollbars)
# Arguments: args - a number of ignored parameters
# Returns: none
# Sideeffects: none
##########
}
}


# Procedure: SN
if {"[info procs SN]" == ""} {
proc SN { {xfName ""}} {
# xf ignore me 7
##########
# Procedure: SN
# Description: map a symbolic name to the widget path
# Arguments: xfName
# Returns: the symbolic name
# Sideeffects: none
##########

  SymbolicName $xfName
}
}


# Procedure: SymbolicName
if {"[info procs SymbolicName]" == ""} {
proc SymbolicName { {xfName ""}} {
# xf ignore me 7
##########
# Procedure: SymbolicName
# Description: map a symbolic name to the widget path
# Arguments: xfName
# Returns: the symbolic name
# Sideeffects: none
##########

  global symbolicName

  if {"$xfName" != ""} {
    set xfArrayName ""
    append xfArrayName symbolicName ( $xfName )
    if {![catch "set \"$xfArrayName\"" xfValue]} {
      return $xfValue
    } {
      if {"[info commands XFProcError]" != ""} {
        XFProcError "Unknown symbolic name:\n$xfName"
      } {
        puts stderr "XF error: unknown symbolic name:\n$xfName"
      }
    }
  }
  return ""
}
}


# Procedure: Unalias
if {"[info procs Unalias]" == ""} {
proc Unalias { aliasName} {
# xf ignore me 7
##########
# Procedure: Unalias
# Description: remove an alias for a procedure
# Arguments: aliasName - the alias name to remove
# Returns: none
# Sideeffects: internalAliasList is updated, and the alias
#              proc is removed
##########
  global internalAliasList

  set xfIndex [lsearch $internalAliasList "$aliasName *"]
  if {$xfIndex != -1} {
    rename $aliasName ""
    set internalAliasList [lreplace $internalAliasList $xfIndex $xfIndex]
  }
}
}



# application parsing procedure
proc XFLocalParseAppDefs {xfAppDefFile} {
  global xfAppDefaults

  # basically from: Michael Moore
  if {[file exists $xfAppDefFile] &&
      [file readable $xfAppDefFile] &&
      "[file type $xfAppDefFile]" == "link"} {
    catch "file type $xfAppDefFile" xfType
    while {"$xfType" == "link"} {
      if {[catch "file readlink $xfAppDefFile" xfAppDefFile]} {
        return
      }
      catch "file type $xfAppDefFile" xfType
    }
  }
  if {!("$xfAppDefFile" != "" &&
        [file exists $xfAppDefFile] &&
        [file readable $xfAppDefFile] &&
        "[file type $xfAppDefFile]" == "file")} {
    return
  }
  if {![catch "open $xfAppDefFile r" xfResult]} {
    set xfAppFileContents [read $xfResult]
    close $xfResult
    foreach line [split $xfAppFileContents "\n"] {
      # backup indicates how far to backup.  It applies to the
      # situation where a resource name ends in . and when it
      # ends in *.  In the second case you want to keep the *
      # in the widget name for pattern matching, but you want
      # to get rid of the . if it is the end of the name. 
      set backup -2  
      set line [string trim $line]
      if {[string index $line 0] == "#" || "$line" == ""} {
        # skip comments and empty lines
        continue
      }
      set list [split $line ":"]
      set resource [string trim [lindex $list 0]]
      set i [string last "." $resource]
      set j [string last "*" $resource]
      if {$j > $i} { 
        set i $j
        set backup -1
      }
      incr i
      set name [string range $resource $i end]
      incr i $backup
      set widname [string range $resource 0 $i]
      set value [string trim [lindex $list 1]]
      if {"$widname" != "" && "$widname" != "*"} {
        # insert the widget and resourcename to the application
        # defaults list.
        if {![info exists xfAppDefaults]} {
          set xfAppDefaults ""
        }
        lappend xfAppDefaults [list $widname [string tolower $name] $value]
      }
    }
  }
}

# application loading procedure
proc XFLocalLoadAppDefs {{xfClasses ""} {xfPriority "startupFile"} {xfAppDefFile ""}} {
  global env

  if {"$xfAppDefFile" == ""} {
    set xfFileList ""
    if {[info exists env(XUSERFILESEARCHPATH)]} {
      append xfFileList [split $env(XUSERFILESEARCHPATH) :]
    }
    if {[info exists env(XAPPLRESDIR)]} {
      append xfFileList [split $env(XAPPLRESDIR) :]
    }
    if {[info exists env(XFILESEARCHPATH)]} {
      append xfFileList [split $env(XFILESEARCHPATH) :]
    }
    append xfFileList " /usr/lib/X11/app-defaults"
    append xfFileList " /usr/X11/lib/X11/app-defaults"

    foreach xfCounter1 $xfClasses {
      foreach xfCounter2 $xfFileList {
        set xfPathName $xfCounter2
        if {[regsub -all "%N" "$xfPathName" "$xfCounter1" xfResult]} {
          set xfPathName $xfResult
        }
        if {[regsub -all "%T" "$xfPathName" "app-defaults" xfResult]} {
          set xfPathName $xfResult
        }
        if {[regsub -all "%S" "$xfPathName" "" xfResult]} {
          set xfPathName $xfResult
        }
        if {[regsub -all "%C" "$xfPathName" "" xfResult]} {
          set xfPathName $xfResult
        }
        if {[file exists $xfPathName] &&
            [file readable $xfPathName] &&
            ("[file type $xfPathName]" == "file" ||
             "[file type $xfPathName]" == "link")} {
          catch "option readfile $xfPathName $xfPriority"
          if {"[info commands XFParseAppDefs]" != ""} {
            XFParseAppDefs $xfPathName
          } {
            if {"[info commands XFLocalParseAppDefs]" != ""} {
              XFLocalParseAppDefs $xfPathName
            }
          }
        } {
          if {[file exists $xfCounter2/$xfCounter1] &&
              [file readable $xfCounter2/$xfCounter1] &&
              ("[file type $xfCounter2/$xfCounter1]" == "file" ||
               "[file type $xfCounter2/$xfCounter1]" == "link")} {
            catch "option readfile $xfCounter2/$xfCounter1 $xfPriority"
            if {"[info commands XFParseAppDefs]" != ""} {
              XFParseAppDefs $xfCounter2/$xfCounter1
            } {
              if {"[info commands XFLocalParseAppDefs]" != ""} {
                XFLocalParseAppDefs $xfCounter2/$xfCounter1
              }
            }
          }
        }
      }
    }
  } {
    # load a specific application defaults file
    if {[file exists $xfAppDefFile] &&
        [file readable $xfAppDefFile] &&
        ("[file type $xfAppDefFile]" == "file" ||
         "[file type $xfAppDefFile]" == "link")} {
      catch "option readfile $xfAppDefFile $xfPriority"
      if {"[info commands XFParseAppDefs]" != ""} {
        XFParseAppDefs $xfAppDefFile
      } {
        if {"[info commands XFLocalParseAppDefs]" != ""} {
          XFLocalParseAppDefs $xfAppDefFile
        }
      }
    }
  }
}

# application setting procedure
proc XFLocalSetAppDefs {{xfWidgetPath "."}} {
  global xfAppDefaults

  if {![info exists xfAppDefaults]} {
    return
  }
  foreach xfCounter $xfAppDefaults {
    if {"$xfCounter" == ""} {
      break
    }
    set widname [lindex $xfCounter 0]
    if {[string match $widname ${xfWidgetPath}] ||
        [string match "${xfWidgetPath}*" $widname]} {
      set name [string tolower [lindex $xfCounter 1]]
      set value [lindex $xfCounter 2]
      # Now lets see how many tcl commands match the name
      # pattern specified.
      set widlist [info command $widname]
      if {"$widlist" != ""} {
        foreach widget $widlist {
          # make sure this command is a widget.
          if {![catch "winfo id $widget"] &&
              [string match "${xfWidgetPath}*" $widget]} {
            catch "$widget configure -$name $value" 
          }
        }
      }
    }
  }
}



# startup source
proc StartupSrc {args} {
pack forget .frame20
}

# prepare auto loading
global auto_path
global tk_library
global xfLoadPath
foreach xfElement [eval list [split $xfLoadPath :] $auto_path] {
  if {[file exists $xfElement/tclIndex]} {
    lappend auto_path $xfElement
  }
}
catch "unset auto_index"

catch "unset auto_oldpath"

catch "unset auto_execs"


# startup source
StartupSrc

# initialize global variables
proc InitGlobals {} {
  global {addContextContext}
  set {addContextContext} {}
  global {addContextMacro}
  set {addContextMacro} {project}
  global {addContexts}
  set {addContexts} {}
  global {agentName}
  set {agentName} {LINUX}
  global {checkbutton0}
  set {checkbutton0} {0}
  global {checkbutton1}
  set {checkbutton1} {0}
  global {chichotBottom}
  set {chichotBottom} {0}
  global {chichotCharacter}
  set {chichotCharacter} {1}
  global {chichotCompareEntry}
  set {chichotCompareEntry} {}
  global {chichotDefAction}
  set {chichotDefAction} {0}
  global {chichotDefAgent}
  set {chichotDefAgent} {0}
  global {chichotJob}
  set {chichotJob} {}
  global {chichotLine}
  set {chichotLine} {0}
  global {chichotLinemode}
  set {chichotLinemode} {1}
  global {chichotName}
  set {chichotName} {}
  global {chichotNolongwait}
  set {chichotNolongwait} {1}
  global {chichotRegNr}
  set {chichotRegNr} {}
  global {chichotSearchText}
  set {chichotSearchText} {}
  global {chichotShrink}
  set {chichotShrink} {1}
  global {chichotStatus}
  set {chichotStatus} {                 }
  global {chichotTop}
  set {chichotTop} {1}
  global {chichotTrigger}
  set {chichotTrigger} {}
  global {chichotWiden}
  set {chichotWiden} {0}
  global {chichotWord}
  set {chichotWord} {0}
  global {currContexts}
  set {currContexts} { \nrobots}
  global {currInd}
  set {currInd} {1}
  global {delContexts}
  set {delContexts} {}
  global {delElem}
  set {delElem} {shell}
  global {delInd}
  set {delInd} {-1}
  global {i}
  set {i} {0}
  global {keywordNumberRelation}
  set {keywordNumberRelation} {greaterThan}
  global {keywordThreshold}
  set {keywordThreshold} {}
  global {modPatt}
  set {modPatt} {+\n@\n+}
  global {numRelation}
  set {numRelation} {<}
  global {numThreshold}
  set {numThreshold} {}
  global {numrelation}
  set {numrelation} {<}
  global {pattInd}
  set {pattInd} {-1}
  global {patternHeight}
  set {patternHeight} {}
  global {patternVal}
  set {patternVal} {+}
  global {patternWidth}
  set {patternWidth} {}
  global {recordStatus}
  set {recordStatus} {}
  global {result}
  set {result} {}
  global {searchString}
  set {searchString} {\\/}
  global {sel}
  set {sel} {}
  global {timeoutStandard}
  set {timeoutStandard} {0}
  global {tmplt}
  set {tmplt} {0}

  # please don't modify the following
  # variables. They are needed by xf.
  global {autoLoadList}
  set {autoLoadList(chichot.tcl)} {0}
  global {internalAliasList}
  set {internalAliasList} {{currContextsText .frame15.frame0.text2} {addContextsText .top13.frame6.frame21.text9} {delContextsText .top13.frame6.frame22.text13} {inputMacroList .frame3.listbox4} {keywordList .top13.frame4.listbox0} {screenMacroList .top13.frame0.listbox1} {triggerList .frame15.frame7.listbox9} {feedback .top13.frame1.frame19.text0} {termcapList .top13.frame0.listbox1} {actionList .frame7.listbox0} {reqAltAction .top13.frame3} {actionMenubutton .frame8.menubutton6} {patternText .top13.frame11.text11} {arrivalSeconds .top13.frame7.frame21.frame19.scale9} {arrivalMilliseconds .top13.frame7.frame21.frame19.scale10} {arrivalMicroseconds .top13.frame7.frame21.frame19.scale11} {interarrivalMicroseconds .top13.frame7.frame21.frame20.scale14} {interarrivalMilliseconds .top13.frame7.frame21.frame20.scale13} {interarrivalSeconds .top13.frame7.frame21.frame20.scale12} {cycleMenu .frame8.menubutton6.m.menu0.m}}
  global {moduleList}
  set {moduleList(chichot.tcl)} {}
  global {preloadList}
  set {preloadList(xfInternal)} {}
  global {symbolicName}
  set {symbolicName(root)} {.}
  global {xfWmSetPosition}
  set {xfWmSetPosition} {}
  global {xfWmSetSize}
  set {xfWmSetSize} {.top4}
  global {xfAppDefToplevels}
  set {xfAppDefToplevels} {}
}

# initialize global variables
InitGlobals

# display/remove toplevel windows.
ShowWindow.

global xfShowWindow.top13
set xfShowWindow.top13 1
ShowWindow.top13

# load default bindings.
if {[info exists env(XF_BIND_FILE)] &&
    "[info procs XFShowHelp]" == ""} {
  source $env(XF_BIND_FILE)
}

# parse and apply application defaults.
XFLocalLoadAppDefs Chichot
XFLocalSetAppDefs

# eof
#

