
/* Copyright (c) 1994
 *      Zbigniew Wieckowski (wieckows@cs.umn.edu)
 *
 * Permission is granted to freely use, copy, modify, and redistribute
 * this software under the terms of the GPL licence agreement.
 */

//	1	2	3	4	5	6	7	8	9
//34567890123456789012345678901234567890123456789012345678901234567890123
#include <unistd.h>
#include <sys/types.h>
#include <sys/time.h>
#include "chichotConfig.h"
#include "line_link.h"
#include "myScreen.h"

const TABPOS1 = 9;
const TABPOS2 = 17;
const TABPOS3 = 25;
const TABPOS4 = 33;
const TABPOS5 = 41;
const TABPOS6 = 49;
const TABPOS7 = 57;
const TABPOS8 = 65;
const TABPOS9 = 73;

macro_link::macro_link()
{
   macro = new string();
   macroName = new string();
   for (short i = 0; i < MAX_CONTEXTS; i++)
      context[i] = 0;
   macro_md = undef;
   next = 0;
}

void
macro_link::empty()
{
   if (macroName) {
      macroName->empty();
      delete macroName;
   }
   if (macro) {
      macro->empty();
      delete macro;
   }
   for (short cn = 0; 0 != context[cn] && cn < MAX_CONTEXTS; cn++) {
      context[cn]->empty();
      delete context[cn];
   }
}

match_link::match_link()
{
   match = 0;
   count = 0;
   next = 0;
}


inline
void
screen::init_lines()
{
     lines = new line_link;
     lines->line_md = undef;
     lines->next = 0;
     lines->line = 0;
}

void
screen::init_macros()
{
   in_macros = new macro_link;
   in_macros->lexptr = 0;
   in_macros->next = 0;
   in_macros->macroName = 0;
   in_macros->macro = 0;
   out_macros = new macro_link;
   out_macros->lexptr = 0;
   out_macros->next = 0;
   out_macros->macroName = 0;
   out_macros->macro = 0;
   ifstream f_in(macroFile, ios::in);
   if (!f_in) {
      cerr << "cannot open " << macroFile;
      exit(1);
   }
   char name[MAX_NAME];
   char def[MAX_DEF];
   macro_link* p;
   while (f_in.get(name, MAX_NAME, '\0')) {
      char ch;
      f_in.get(ch);
      if (f_in.get(def, MAX_DEF, '\0')) {
	 p = new macro_link;
	 p->macroName->assign(name, strlen(name));
	 p->macro->assign(def, strlen(def)); // macro length
	 f_in.get(ch);
	 short cn = 0;
	 short done = 0;
	 char field[MAX_NAME];
	 while (!done && f_in.get(field, MAX_NAME, '\0')) {
	    if (!strcmp(field, "i") || !strcmp(field, "o")) {
	       done = 1;
	       ch = field[0];
	       switch (ch) {
		  case 'i':
		  p->lexptr = ilexicon[name[0]];
		  ilexicon[name[0]] = p;
		  p->macro_md = in;
		  p->valid = 1;
		  p->next = in_macros;
		  break;
		  case 'o' :
		  p->lexptr = olexicon[name[0]];
		  olexicon[name[0]] = p;
		  p->macro_md = out;
		  p->valid = 1;
		  p->next = out_macros;
		  break;
		  default:
		  cerr << "error reading " << macroFile << " -> " << name;
		  exit(1);
	       }
	    }
	    else if (cn < MAX_CONTEXTS) {
	       p->context[cn++] = new string(field, strlen(field));
	       f_in.get(ch);
	    }
	    else {
	       cerr << "error reading " << macroFile << " : too many contexts";
	    }
	 }
	 if (!done) {
	    cerr << "error reading " << macroFile << " -> " << name;
	    exit(1);
	 }
	 if (!f_in.get(ch) || ch != '\0') {
	    cerr << "error reading " << macroFile;
	    exit(1);
	 }
         if (in == p->macro_md)
	    in_macros = p;
	 else
	    out_macros = p;
      }
      else {
	 cerr << "no definition for " << name;
	 exit(1);
      }
   }

   f_in.close();
   p = new macro_link;
   p->macroName->assign("|null", 5);
   p->macro->assign("", 1);
   p->macro_md = out;
   p->lexptr = olexicon['|'];
   olexicon['|'] = p;
   p->next = out_macros;
   out_macros = p;
}

void screen::insert_macro()
{
   if (new_macro_defined)
      save_macros();
   new_macro_defined = 1;
   if (in == new_macro->macro_md) {
      new_macro->lexptr = ilexicon[new_macro->macroName->realstr()[0]];
      ilexicon[new_macro->macroName->realstr()[0]] = new_macro;
      new_macro->next = in_macros;
      in_macros = new_macro;
   }
   else {
      short quote = 0;
      string *newcontexts = new string();
      for (int m = 0; m < new_macro->macroName->length(); m++)
	 if (quote) {
	    if ('n' == new_macro->macroName->realstr()[m]) {
	       *newcontexts += '\n';
	    } else {
	       *newcontexts += '\\';
	       *newcontexts += new_macro->macroName->realstr()[m];
	    }
	    quote = 0;
	 } else {
	    if ('\\' == new_macro->macroName->realstr()[m]) {
	       quote = 1;
	    } else {
	       *newcontexts += new_macro->macroName->realstr()[m];
	    }
	 }
      new_macro->macroName->empty();
      *new_macro->macroName = *newcontexts;
      newcontexts->empty();
      delete newcontexts;
      quote = 0;
      newcontexts = new string();
      for (m = 0; m < new_macro->macro->length(); m++)
	 if (quote) {
	    if ('n' == new_macro->macro->realstr()[m]) {
	       *newcontexts += '\n';
	    } else {
	       *newcontexts += '\\';
	       *newcontexts += new_macro->macro->realstr()[m];
	    }
	    quote = 0;
	 } else {
	    if ('\\' == new_macro->macro->realstr()[m]) {
	       quote = 1;
	    } else {
	       *newcontexts += new_macro->macro->realstr()[m];
	    }
	 }
      new_macro->macro->empty();
      *new_macro->macro = *newcontexts;
      newcontexts->empty();
      delete newcontexts;
      new_macro->lexptr = olexicon[new_macro->macroName->realstr()[0]];
      olexicon[new_macro->macroName->realstr()[0]] = new_macro;
      new_macro->next = out_macros;
      out_macros = new_macro;
   }
}

inline
void
screen::init_matches()
{
     matches = new match_link;
     matches->count = -1;
     matches->next = 0;
     matches->match = 0;
}

void
screen::set_disp_width(int width)
{
   disp_width = width;
}

void
screen::set_disp_height(int height)
{
   disp_height = height;
}

void
screen::init_disp()
{
     for (int i = 0; i < disp_height; i++)
       for (int j = 0; j < disp_width; j++)
	 disp[i][j] = ' ';
}

screen::screen()
{
     last_line = 0;
     inv_mode = 0;
     curr_x = 1;
     curr_y = 1;
     cd_mode = 1;
     def_in = 0;
     def_out = 0;
     call_in = 0;
     curr_md = undef;
     def_agent = 0;
     def_branch = 0;
     alt_branch = 0;
     pick_alt_branch = 0;
     capture = 0;
     new_macro_defined = 0;
     macro_removed = 0;
     sel_line = 0;
     search = 0;
     scr_clear = 0;
     next_char_lit = 0;
     pattern_in = 0;
     patt_val = 0;
     init_lines();
     for (int i = 0; i < 128; i++) {
	ilexicon[i] = 0;
	olexicon[i] = 0;
     }
     context_change = 0;
     context[0] = new string(" ", 1);
     for (i = 1; i < MAX_CONTEXTS; i++)
	context[i] = 0;
     allcontexts = 0;
     prevcontexts = 0;
     init_macros();
     init_matches();
     select_parent = 0;
     cycle = 0;
     numCycles = 0;
     total_keywords = 0;
     for (i = 0; i < MAX_DISP_HEIGHT; i++)
	kwrd_line_cnt[i] = 0;
     add_context_in = 0;
     context_in = 0;
     add_context_macro = 0;
     num_threshold_in = 0;
}

void
screen::del_lines()
{
     line_link* t;
     string* d = lines->line;
     while (d != 0) {
	  t = lines->next;
	  if (d->realstr())
	     d->empty();
	  delete d;
	  if (lines->sample) {
	     if (lines->sample->realstr())
		lines->sample->empty();
	     delete lines->sample;
	     lines->sample = 0;
	  }
	  delete lines;
	  lines = t;
	  d = lines->line;
     }
     delete lines;
   t = 0;
}

void
screen::save_macros()
{
   if (new_macro_defined || macro_removed) {
      ofstream f_out(macroFile, ios::out);
      if (!f_out) {
	 cerr << "cannot open " << macroFile;
	 exit(1);
      }
      macro_link* tmp = in_macros;
      string* n = tmp->macroName;
      while (n != 0) {
	if (tmp->valid) {
	  f_out.write(n->realstr(), n->length() + 1);
	  string* d = tmp->macro;
	  if (0 == d) {
	    cerr << "no macro definition ";
	    exit(1);
	  }
	  f_out.write(d->realstr(), d->length() + 1);
	  for (short cn = 0; tmp->context[cn] != 0; cn++)
	     f_out.write(tmp->context[cn]->realstr(),
			 tmp->context[cn]->length() + 1);
	  f_out.put('i');
	  f_out.put('\0');
	  f_out.flush();
	}
	tmp = tmp->next;
	n = tmp->macroName;
      }
      tmp = out_macros;
      n = tmp->macroName;
      while (n != 0) {
	if (tmp->valid && strcmp(n->realstr(), "|null")) {
	  f_out.write(n->realstr(), n->length() + 1);
	  string* d = tmp->macro;
	  if (0 == d) {
	    cerr << "no macro definition ";
	    exit(1);
	  }
	  f_out.write(d->realstr(), d->length() + 1);
	  for (short cn = 0; tmp->context[cn] != 0; cn++)
	     f_out.write(tmp->context[cn]->realstr(),
			 tmp->context[cn]->length() + 1);
	  f_out.put('o');
	  f_out.put('\0');
	  f_out.flush();
	}
	tmp = tmp->next;
	n = tmp->macroName;
      }
      f_out.close();
      new_macro_defined = 0;
      macro_removed = 0;
   }
}

void
screen::destroy_macros()
{
   macro_link* t;
   string* n = in_macros->macroName;
   while (n != 0) {
      n->empty();
      string* d = in_macros->macro;
      if (0 == d) {
	 cerr << "no macro definition ";
	 exit(1);
      }
      d->empty();
      for (short cn = 0; in_macros->context[cn] != 0; cn++)
	 in_macros->context[cn]->empty();
      t = in_macros->next;
      delete in_macros;
      in_macros = t;
      n = in_macros->macroName;
   }
   delete in_macros;
   n = out_macros->macroName;
   while (n != 0) {
      n->empty();
      string* d = out_macros->macro;
      if (0 == d) {
	 cerr << "no macro definition ";
	 exit(1);
      }
      d->empty();
      for (short cn = 0; out_macros->context[cn] != 0; cn++)
	 out_macros->context[cn]->empty();
      t = out_macros->next;
      delete out_macros;
      out_macros = t;
      n = out_macros->macroName;
   }
   delete out_macros;
}

screen::~screen() {
   save_macros();
   destroy_macros();
   del_lines();
}

void screen::bdcpy(char* pos, const char* bd, int* plen)
{
   for (macro_link* b = out_macros; b->macroName != 0; b = b->next)
      if (!isprint(b->macro->realstr()[0]) &&
	  !memcmp(bd, b->macroName->realstr(),
		   b->macroName->length()))
	 break;
   if (0 == b->macroName) {
      cerr << "Macro not found" << endl;
      exit(1);
   }
   strcpy(pos, b->macro->realstr());
   *plen += strlen(b->macro->realstr());
}

void screen::show_sel_line(char*& line, int* plen)
{
   int hghlt = !disp_inv[(sel_line_nr + last_line + 1) % disp_height][0];
   line[0] = META_CHAR;
   *plen = 1;
   bdcpy(&line[*plen], "|esc[1", plen);
   (*plen)--;
   if (sel_line_nr < 9)
     line[(*plen)++] = '1' + sel_line_nr;
   else {
     line[(*plen)++] = '0' + (sel_line_nr + 1) / 10;
     line[(*plen)++] = '0' + (sel_line_nr + 1) % 10;
   }
   line[(*plen)++] = ';';
   line[(*plen)++] = '0';
   line[(*plen)++] = 'H';
   for (int x = 0; x < disp_width; x++)
     if (!(hghlt != disp_inv[(sel_line_nr + last_line + 1) %
			     disp_height][x]))
       line[(*plen)++] = disp[(sel_line_nr + last_line + 1) %
			      disp_height][x];
     else {
       if (hghlt) {
	 bdcpy(&line[*plen], "|hb", plen);
	 hghlt = 0;
       }
       else {
	 bdcpy(&line[*plen], "|he", plen);
	 hghlt = 1;
       }
       line[(*plen)++] = disp[(sel_line_nr + last_line + 1) %
			      disp_height][x];
     }
   if (sel_old_line) {
      hghlt = !disp_inv[(sel_old_line_nr + last_line + 1) % disp_height][0];
      bdcpy(&line[*plen], "|esc[1", plen);
      (*plen)--;
      if (sel_old_line_nr < 9)
	line[(*plen)++] = '1' + sel_old_line_nr;
      else {
	line[(*plen)++] = '0' + (sel_old_line_nr + 1) / 10;
	line[(*plen)++] = '0' + (sel_old_line_nr + 1) % 10;
      }
      line[(*plen)++] = ';';
      line[(*plen)++] = '0';
      line[(*plen)++] = 'H';
      for (int x = 0; x < disp_width; x++)
	if (!(hghlt != disp_inv[(sel_old_line_nr + last_line + 1) %
				disp_height][x]))
	  line[(*plen)++] = disp[(sel_old_line_nr + last_line + 1) %
				 disp_height][x];
	else {
	  if (hghlt) {
	    bdcpy(&line[*plen], "|he", plen);
	    hghlt = 0;
	  }
	  else {
	    bdcpy(&line[*plen], "|hb", plen);
	    hghlt = 1;
	  }
	  line[(*plen)++] = disp[(sel_old_line_nr + last_line + 1) %
				 disp_height][x];
	}
   }
   bdcpy(&line[*plen], "|esc[1", plen);
   (*plen)--;
   if (curr_y < 10)
     line[(*plen)++] = '0' + curr_y;
   else {
     line[(*plen)++] = '0' + curr_y / 10;
     line[(*plen)++] = '0' + curr_y % 10;
   }
   line[(*plen)++] = ';';
   if (curr_x < 10)
      line[(*plen)++] = '0' + curr_x;
   else {
      line[(*plen)++] = '0' + curr_x / 10;
      line[(*plen)++] = '0' + curr_x % 10;
   }
   line[(*plen)++] = 'H';
   line[*plen] = '\0';
}

void screen::show_sel_area(char*& line, int* plen)
{
   static int last_wrapped = 0;
   int hghlt = disp_inv[(top_line + last_line) % disp_height][0];
   int imar = (bottom_line - top_line -
	       (!(bottom_line != top_line) &&
		(last_wrapped || top_pos > bottom_pos))
	       + disp_height) % disp_height + 3;
   int imax = imar - 2 * (!(bottom_line != top_line) &&
			  (last_wrapped || top_pos > bottom_pos)) -
      !(top_line != (bottom_line + 1) % disp_height);
   for (int i = 0; i < imax; i++) {
      bdcpy(&line[*plen], "|esc[1", plen);
      (*plen)--;
      if (0 == (top_line + i) % disp_height) {
	strcpy(&line[*plen], "24");
	*plen += 2;
      }
      else if ((top_line + i + disp_height - 1) % disp_height < 9)
	line[(*plen)++] =
	  '0' + (top_line + i + disp_height - 1) % disp_height + 1;
      else {
	line[(*plen)++] =
	  '0' + (top_line + i + disp_height) % disp_height / 10;
	line[(*plen)++] =
	  '0' + (top_line + i + disp_height) % disp_height % 10;
      }
      line[(*plen)++] = ';';
      line[(*plen)++] = '0';
      line[(*plen)++] = 'H';
      if (hghlt)
	 bdcpy(&line[*plen], "|hb", plen);
      else
	 bdcpy(&line[*plen], "|he", plen);
      for (int x = 0; x < disp_width; x++)
	if (!(hghlt != disp_inv[(top_line + i + last_line) %
				disp_height][x]) &&
	    (scr_clear || 0 == i && (top_line < bottom_line ||
				     !(top_line != bottom_line) &&
				     top_pos <= bottom_pos ||
				     top_line > bottom_line + 1) || 1 == i && 
	     (x < top_pos && (top_line < bottom_line ||
			      !(top_line != bottom_line) &&
			      top_pos <= bottom_pos ||
			      top_line > bottom_line) ||
	      !(top_line != bottom_line) && top_pos <= bottom_pos &&
	      x > bottom_pos ||
	      !(top_line != bottom_line) && x > bottom_pos &&
	      x < top_pos) ||
	     !(top_line != bottom_line) && top_line <= bottom_line &&
	     last_wrapped && 1 < i && i < imar -2 ||
	     top_line < bottom_line &&
	     (!(i != imar - 1) || !(i != imar - 2) && x > bottom_pos) ||
	     !(top_line != bottom_line) && !(i != imar - 1) ||
	     top_line > bottom_line &&
	     top_line != bottom_line && !(i != imar - 2) &&
	     x > bottom_pos ||
	     !(i != imar - 1) && top_line > bottom_line + 1) ||
	    hghlt != disp_inv[(top_line + i + last_line) %
			      disp_height][x] && !scr_clear &&
	    (0 == i && (top_line > bottom_line ||
			!(top_line != bottom_line) &&
			top_pos > bottom_pos) ||
	     (top_line != bottom_line || top_pos > bottom_pos) &&
	     i > 1 && i < imar - 2 || 1 == i &&
	     (x >= top_pos && (top_line > bottom_line ||
			       !(top_line != bottom_line) &&
			       top_pos > bottom_pos) ||
	      !(top_line != bottom_line) && x <= bottom_pos &&
	      bottom_pos < top_pos ||
	      top_line < bottom_line && x >= top_pos ||
	      !(top_line != bottom_line) && x >= top_pos &&
	      x <= bottom_pos) ||
	     top_line != bottom_line && !(i != imar - 2) &&
	     x <= bottom_pos))
	  line[(*plen)++] = disp[(top_line + i + last_line) %
				 disp_height][x];
	else {
	  if (hghlt) {
	    bdcpy(&line[*plen], "|he", plen);
	    hghlt = 0;
	  }
	  else {
	    bdcpy(&line[*plen], "|hb", plen);
	    hghlt = 1;
	  }
	  line[(*plen)++] = disp[(top_line + i + last_line) %
				 disp_height][x];
	}
   }
   bdcpy(&line[*plen], "|esc[1", plen);
   (*plen)--;
   if (curr_y < 10)
     line[(*plen)++] = '0' + curr_y;
   else {
     line[(*plen)++] = '0' + curr_y / 10;
     line[(*plen)++] = '0' + curr_y % 10;
   }
   line[(*plen)++] = ';';
   if (curr_x < 10)
      line[(*plen)++] = '0' + curr_x;
   else {
      line[(*plen)++] = '0' + curr_x / 10;
      line[(*plen)++] = '0' + curr_x % 10;
   }
   line[(*plen)++] = 'H';
   line[*plen] = '\0';
   last_wrapped = top_line > bottom_line ||
      !(top_line != bottom_line) && top_pos > bottom_pos;
}

int
screen::search_next_match(char*& line, int* plen)
{
   int found = 0;
   int next_lit = 0;
   scr_clear = 1;
   show_sel_area(line, plen);
   scr_clear = 0;
   while (!found) {
      bottom_line = top_line;
      bottom_pos = top_pos;
      top_pos++;
      if (disp_width == top_pos) {
	 top_pos = 0;
	 top_line++;
	 if (disp_height == top_line)
	    return 0;
      }
      int p = 0;
      while (p < search_pattern.length()) {
	 if (!next_lit && isalpha(search_pattern.realstr()[p])) {
	    if ('w' == search_pattern.realstr()[p]) {
	       bottom_pos++;
	       if (disp_width == bottom_pos) {
		  bottom_pos = 0;
		  bottom_line++;
		  if (disp_height == bottom_line)
		     break;
	       }
	       if (!isalpha(disp[(bottom_line + last_line + 1) %
				 disp_height][bottom_pos]))
		  break;
	       else
		  do {
		     bottom_pos++;
		     if (disp_width == bottom_pos) {
			bottom_pos = 0;
			bottom_line++;
			if (disp_height == bottom_line)
			   break;
		     }
		  } while (isalpha(disp[(bottom_line + last_line + 1) %
					disp_height][bottom_pos]) ||
			   isdigit(disp[(bottom_line + last_line + 1) %
					disp_height][bottom_pos]));
	       bottom_pos--;
	       if (0 == bottom_pos) {
		  bottom_pos = disp_width - 1;
		  bottom_line += disp_height - 1;
		  bottom_line %= disp_height;
	       }
	    }
	    else if ('n' == search_pattern.realstr()[p]) {
	       bottom_pos++;
	       if (disp_width == bottom_pos) {
		  bottom_pos = 0;
		  bottom_line++;
		  if (disp_height == bottom_pos)
		     break;
	       }
	       if (!isdigit(disp[(bottom_line + last_line + 1) %
				 disp_height][bottom_pos]))
		  break;
	       else
		  do {
		     bottom_pos++;
		     if (disp_width == bottom_pos) {
			bottom_pos = 0;
			bottom_line++;
			if (disp_height == bottom_pos)
			   break;
		     }
		  } while (isdigit(disp[(bottom_line + last_line + 1) %
					disp_height][bottom_pos]));
	       bottom_pos--;
	       if (0 == bottom_pos) {
		  bottom_pos = disp_width - 1;
		  bottom_line += disp_height - 1;
		  bottom_line %= disp_height;
	       }
	    }
	    else if ('r' == search_pattern.realstr()[p]) {
	       int reg_start = p;
	       int reg_end = ++reg_start;
	       do
		  while (reg_end != search_pattern.length() &&
			 'e' != search_pattern.realstr()[reg_end++]);
	       while (reg_end != search_pattern.length() &&
		      '\\' == search_pattern.realstr()[reg_end - 1]);
	       int done = !(reg_end != search_pattern.length());
	       int test_bot_line = bottom_line;
	       int test_bot_pos = bottom_pos;
	       while (!done) {
		  int test_ch_lit = 0;
		  for (int n = reg_start; n < reg_end && !done; n++) {
		     test_bot_pos++;
		     if (disp_width == test_bot_pos) {
			test_bot_pos = 0;
			test_bot_line++;
			if (disp_height == test_bot_line)
			   break;
		     }
		     if (!test_ch_lit &&
			 isalpha(search_pattern.realstr()[n]))
			switch(search_pattern.realstr()[n]) {
			   case 'e':
			   if (test_bot_pos)
			      test_bot_pos--;
			   else {
			      test_bot_pos = 0;
			      test_bot_line--;
			   }
			   break;
			   case 'n':
			   if (!isdigit(disp[(test_bot_line + last_line + 1) %
					     disp_height][test_bot_pos])) {
			      done = 1;
			      break;		      
			   }
			   else {
			      do {
				 test_bot_pos++;
				 if (disp_width == test_bot_pos) {
				    test_bot_pos = 0;
				    test_bot_line++;
				    if (disp_height == test_bot_line) {
				       done = 1;
				       break;
				    }
				 }
			      } while (isdigit(disp[(test_bot_line +
						     last_line + 1) %
						    disp_height]
					       [test_bot_pos]));
			      if (0 == test_bot_pos) {
				 test_bot_pos = disp_width - 1;
				 test_bot_line += disp_height - 1;
				 test_bot_line %= disp_height;
			      }
			      else
				 test_bot_pos--;
			   }
			   break;
			   case 'w':
			   if (!isalpha(disp[(test_bot_line + last_line + 1) %
					     disp_height][test_bot_pos])) {
			      done = 1;
			      break;		      
			   }
			   else {
			      do {
				 test_bot_pos++;
				 if (disp_width == test_bot_pos) {
				    test_bot_pos = 0;
				    test_bot_line++;
				    if (disp_height == test_bot_line) {
				       done = 1;
				       break;
				    }
				 }
			      } while (isalpha(disp[(test_bot_line +
						     last_line + 1) %
						    disp_height]
					       [test_bot_pos]) ||
				       isdigit(disp[(test_bot_line +
						     last_line + 1) %
						    disp_height]
					       [test_bot_pos]));
			      if (0 == test_bot_pos) {
				 test_bot_pos = disp_width - 1;
				 test_bot_line += disp_height - 1;
				 test_bot_line %= disp_height;
			      }
			      else
				 test_bot_pos--;
			   }
			   break;
			   default:
			   cerr << "Invalid search command inside repeat"
			      << endl;
			   exit(1);
			}
		     else if (!test_ch_lit &&
			      '\\' == search_pattern.realstr()[n])
			test_ch_lit = 1;
		     else {
			test_ch_lit = 0;
			if (search_pattern.realstr()[n] !=
			    disp[(last_line + test_bot_line + 1) %
				 disp_height][test_bot_pos]) {
			   done = 1;
			   break;
			}
		     }
		  }
		  if (!done) {
		     bottom_pos = test_bot_pos;
		     bottom_line = test_bot_line;
		  }
	       }
	       if (reg_end != search_pattern.length())
		  p = reg_end;
	    }
	 }
	 else if (!next_lit && '\\' == search_pattern.realstr()[p])
	    next_lit = 1;
	 else {
	    next_lit = 0;
	    bottom_pos++;
	    if (disp_width == bottom_pos) {
	       bottom_pos = 0;
	       bottom_line++;
	       if (disp_width == bottom_line)
		  break;
	    }
	    if (search_pattern.realstr()[p] != 
		disp[(last_line + bottom_line + 1) %
		     disp_height][bottom_pos])
	       break;
	 }
	 p++;
      }
      found = !(p != search_pattern.length());
   }
   return 1;
}

void screen::show_blueprint(char*& line, int* plen)
{
   strcpy(&line[0], "\033[;H");
   *plen = strlen("\033[;H");
   bdcpy(&line[*plen], "|he", plen);
   int hghlt = !disp_inv[(last_line + 1) % disp_height][0];
   for (int y = 0; y < disp_height; y++) {
      for (int x = 0; x < disp_width; x++)
	if (!(hghlt != disp_inv[(y + last_line + 1) % disp_height][x]))
	  line[(*plen)++] = disp[(y + last_line + 1) % disp_height][x];
	else {
	  if (hghlt) {
	    bdcpy(&line[*plen], "|he", plen);
	    hghlt = 0;
	  }
	  else {
	    bdcpy(&line[*plen], "|hb", plen);
	    hghlt = 1;
	  }
	  line[(*plen)++] = disp[(y + last_line + 1) % disp_height][x];
	}
      if (disp_height - 1 != y) {
	 strcpy(&line[*plen], "\r\r\n");
	 *plen += 3;
      }
      else {
	 bdcpy(&line[*plen], "|esc[1", plen);
	 (*plen)--;
	 if (curr_y < 10)
	   line[(*plen)++] = '0' + curr_y;
	 else {
	   line[(*plen)++] = '0' + curr_y / 10;
	   line[(*plen)++] = '0' + curr_y % 10;
	 }
	 line[(*plen)++] = ';';
	    if (curr_x < 10)
	       line[(*plen)++] = '0' + curr_x;
	    else {
	       line[(*plen)++] = '0' + curr_x / 10;
	       line[(*plen)++] = '0' + curr_x % 10;
	    }
	 line[(*plen)++] = 'H';
      }
   }
   line[*plen] = '\0';
}

void screen::log_line(const mode proc_mode,
		      const char*& const line_toappl, const int* toappllen,
		      const char*& const line_touser, const int* touserlen,
		      char*& tmpline, int* tlen)
{
   static line_link* back_ptr = NULL;
   static int lines_cnt = 0;
   int old_curr_y = curr_y;
   if (name_in || name_agent || pattern_in || num_threshold_in ||
       kwrd_threshold_in ||
       in == proc_mode && META_CHAR == line_toappl[0] && !def_agent &&
       !def_branch)
      return;
   if (!(proc_mode != curr_md))
      if (in == proc_mode)
	 lines->line->add(line_toappl, *toappllen);
      else
	 lines->line->add(line_touser, *touserlen);
   else {
      if (cmd != curr_md)
	 curr_md = proc_mode;
      line_link* p = new line_link();
      /*p->test = none;*/
      if (in == proc_mode)
	 p->line->assign(line_toappl, *toappllen);
      else
	 p->line->assign(line_touser, *touserlen);
      if (100 == lines_cnt)
	 back_ptr = lines;
      else if (200 == lines_cnt) {
	 line_link* t = lines;
	 lines = back_ptr->next;
	 del_lines();
	 back_ptr->line->empty();
	 delete back_ptr->line;
	 if (back_ptr->sample) {
	    back_ptr->sample->empty();
	    delete back_ptr->sample;
	    back_ptr->sample = 0;
	 }
	 back_ptr->next = 0;
	 back_ptr->line = 0;
	 back_ptr = lines = t;
	 lines_cnt -= 100;
      }
      p->next = lines;
      p->line_md = proc_mode;
      lines = p;
      if (!def_agent && !def_branch)
	 lines_cnt++;
   }
   if (out == proc_mode) {
      *tlen = 0;
      int i = 0;
      while (i < *touserlen) {
         if (isprint(line_touser[i])) {
	    tmpline[(*tlen)++] = line_touser[i];
	    if (curr_x <= disp_width) {
	       disp[(last_line + curr_y) % disp_height][curr_x - 1] =
		  line_touser[i];
	       disp_inv[(last_line + curr_y) % disp_height][curr_x - 1] =
		  inv_mode;
	       disp_und[(last_line + curr_y) % disp_height][curr_x - 1] =
		  und_mode;
	       curr_x++;
	    }
	    i++;
         } else {
            for (macro_link* b = out_macros; b->macroName != 0; b = b->next)
               if (!memcmp(&line_touser[i], b->macro->realstr(),
			   b->macro->length()))
                  break;
            if (0 == b->macroName) {
	       if (inv_mode)
		  memcpy(&tmpline[*tlen], "|ihe |ihb", 9);
	       else
		  memcpy(&tmpline[*tlen], "|ihb |ihe", 9);
               *tlen += 9;
	       i++;
            }
            else if (!strcmp("|hb", b->macroName->realstr()) ||
		     !strcmp("|hb2", b->macroName->realstr())) {
	       memcpy(&tmpline[*tlen], &line_touser[i], b->macro->length());
	       *tlen += b->macro->length();
               i += b->macro->length();
               inv_mode = 1;
            }
            else if (!strcmp("|he", b->macroName->realstr()) ||
		     !strcmp("|he2", b->macroName->realstr()) ||
                     !strcmp("|esc[27m", b->macroName->realstr())) {
	       memcpy(&tmpline[*tlen], &line_touser[i], b->macro->length());
	       *tlen += b->macro->length();
               i += b->macro->length();
               inv_mode = 0;
            }
            else if (!strcmp("|cr", b->macroName->realstr())) {
	       memcpy(&tmpline[*tlen], &line_touser[i], b->macro->length());
	       *tlen += b->macro->length();
               i += b->macro->length();
               curr_x = 1;
            }
            else if (!strcmp("|lf", b->macroName->realstr())) {
	       memcpy(&tmpline[*tlen], &line_touser[i], b->macro->length());
	       *tlen += b->macro->length();
               i += b->macro->length();
               if (!(curr_y != disp_height)) {
                  last_line++;
                  last_line %= disp_height;
                  for (int j = 0; j < disp_width; j++) {
                     disp[last_line][j] = ' ';
                     disp_inv[last_line][j] = 0;
                  }
               }
	       else
		  curr_y++;
            }
            else if (!strcmp("|cl", b->macroName->realstr()) ||
		     !strcmp("|cl2", b->macroName->realstr())) {
	       memcpy(&tmpline[*tlen], &line_touser[i], b->macro->length());
	       *tlen += b->macro->length();
               i += b->macro->length();
               for (int j = 0; j < disp_height; j++) {
                  for (int k = 0; k < disp_width; k++) {
                     disp[j][k] = ' ';
                     disp_inv[j][k] = 0;
                  }
               }
            }
            else if (!strcmp("|del", b->macroName->realstr())) {
	       memcpy(&tmpline[*tlen], &line_touser[i], b->macro->length());
	       *tlen += b->macro->length();
               i += b->macro->length();
               if (curr_x) {
                  curr_x -= 1;
                  curr_x %= disp_width;
               }
            }
            else if (!strcmp("|bell", b->macroName->realstr())) {
	       memcpy(&tmpline[*tlen], &line_touser[i], b->macro->length());
	       *tlen += b->macro->length();
               i += b->macro->length();
            }
            else if (!strcmp("|keol", b->macroName->realstr())) {
	       memcpy(&tmpline[*tlen], &line_touser[i], b->macro->length());
	       *tlen += b->macro->length();
               i += b->macro->length();
               for (int k = curr_x - 1; k < disp_width; k++) {
                     disp[(last_line + curr_y) % disp_height][k] = ' ';
                     disp_inv[(last_line + curr_y) % disp_height][k] = 0;
               }
            }
            else if (!strcmp("|tab", b->macroName->realstr())) {
	       memcpy(&tmpline[*tlen], &line_touser[i], b->macro->length());
	       *tlen += b->macro->length();
               i += b->macro->length();
	       if (curr_x < TABPOS1)
		  curr_x = TABPOS1;
	       else if (curr_x < TABPOS2)
		  curr_x = TABPOS2;
	       else if (curr_x < TABPOS3)
		  curr_x = TABPOS3;
	       else if (curr_x < TABPOS4)
		  curr_x = TABPOS4;
	       else if (curr_x < TABPOS5)
		  curr_x = TABPOS5;
	       else if (curr_x < TABPOS6)
		  curr_x = TABPOS6;
	       else if (curr_x < TABPOS7)
		  curr_x = TABPOS7;
	       else if (curr_x < TABPOS8)
		  curr_x = TABPOS8;
	       else if (curr_x < TABPOS9)
		  curr_x = TABPOS9;
            }
            else if (!strcmp("|esc[1", b->macroName->realstr())) {
	       int first, second;
               if (';' == line_touser[i + 3]) {
                  first = 1;
		  memcpy(&tmpline[*tlen], &line_touser[i], 4);
		  *tlen += 4;
                  i += 4;
               }
	       else if ('@' == line_touser[i + 3]) {
		  for (int j = disp_width - 1; j >= curr_x; j--)
		     disp[(curr_y + last_line) % disp_height][j] =
			disp[(curr_y + last_line) % disp_height][j - 1];
		  memcpy(&tmpline[*tlen], &line_touser[i], 4);
		  *tlen += 4;
		  i += 4;
		  break;
	       }
               else {
                  first = 10 + line_touser[i + 3] - '0';
		  memcpy(&tmpline[*tlen], &line_touser[i], 5);
		  *tlen += 5;
                  i += 5;
               }
	       tmpline[(*tlen)++] = line_touser[i];
               second = line_touser[i++] - '0';
               if (line_touser[i] != 'H' && line_touser[i] != 'r') {
		  tmpline[(*tlen)++] = line_touser[i];
                  second = 10 * second + line_touser[i++] - '0';
	       }
	       tmpline[(*tlen)++] = line_touser[i];
	       if ('H' == line_touser[i]) {
		  curr_y = first;
		  curr_x = second;
	       }
	       else if ('r' == line_touser[i]) {
		  scrollBegin = first;
		  scrollEnd = second;
	       }
	       else {
		  strcpy(&tmpline[(*tlen)], "Unknown ANSI control sequence");
		  *tlen += strlen("Unknown ANSI control sequence");
	       }
               i++;
            }
            else if (!strcmp("|esc[2;", b->macroName->realstr())) {
               curr_y = 2;
	       memcpy(&tmpline[*tlen], &line_touser[i], 4);
	       *tlen += 4;
               i += 4;
	       tmpline[(*tlen)++] = line_touser[i];
               curr_x = line_touser[i++] - '0';
               if (line_touser[i] != 'H') {
		  tmpline[(*tlen)++] = line_touser[i];
                  curr_x = 10 * curr_x + line_touser[i++] - '0';
	       }
	       tmpline[(*tlen)++] = line_touser[i];
               i++;
            }
            else if (!strcmp("|esc[20;", b->macroName->realstr())) {
	       curr_y = 20;
	       memcpy(&tmpline[*tlen], &line_touser[i], 5);
	       *tlen += 5;
	       i += 5;
	       tmpline[(*tlen)++] = line_touser[i];
               curr_x = line_touser[i++] - '0';
               if (line_touser[i] != 'H') {
		  tmpline[(*tlen)++] = line_touser[i];
                  curr_x = 10 * curr_x + line_touser[i++] - '0';
	       }
	       tmpline[(*tlen)++] = line_touser[i++];
            }
            else if (!strcmp("|esc[21;", b->macroName->realstr())) {
	       curr_y = 21;
	       memcpy(&tmpline[*tlen], &line_touser[i], 5);
	       *tlen += 5;
	       i += 5;
	       tmpline[(*tlen)++] = line_touser[i];
               curr_x = line_touser[i++] - '0';
               if (line_touser[i] != 'H') {
		  tmpline[(*tlen)++] = line_touser[i];
                  curr_x = 10 * curr_x + line_touser[i++] - '0';
	       }
	       tmpline[(*tlen)++] = line_touser[i];
               i++;
            }
            else if (!strcmp("|esc[22;", b->macroName->realstr())) {
	       curr_y = 22;
	       memcpy(&tmpline[*tlen], &line_touser[i], 5);
	       *tlen += 5;
	       i += 5;
	       tmpline[(*tlen)++] = line_touser[i];
               curr_x = line_touser[i++] - '0';
               if (line_touser[i] != 'H') {
		  tmpline[(*tlen)++] = line_touser[i];
                  curr_x = 10 * curr_x + line_touser[i++] - '0';
	       }
	       tmpline[(*tlen)++] = line_touser[i];
               i++;
            }
            else if (!strcmp("|esc[23;", b->macroName->realstr())) {
	       curr_y = 23;
	       memcpy(&tmpline[*tlen], &line_touser[i], 5);
	       *tlen += 5;
	       i += 5;
	       tmpline[(*tlen)++] = line_touser[i];
               curr_x = line_touser[i++] - '0';
               if (line_touser[i] != 'H') {
		  tmpline[(*tlen)++] = line_touser[i];
                  curr_x = 10 * curr_x + line_touser[i++] - '0';
	       }
	       tmpline[(*tlen)++] = line_touser[i];
               i++;
            }
            else if (!strcmp("|esc[24;", b->macroName->realstr())) {
	       curr_y = 24;
	       memcpy(&tmpline[*tlen], &line_touser[i], 5);
	       *tlen += 5;
	       i += 5;
	       tmpline[(*tlen)++] = line_touser[i];
               curr_x = line_touser[i++] - '0';
               if (line_touser[i] != 'H') {
		  tmpline[(*tlen)++] = line_touser[i];
                  curr_x = 10 * curr_x + line_touser[i++] - '0';
	       }
	       tmpline[(*tlen)++] = line_touser[i];
               i++;
            }
            else if (!strcmp("|esc[25;", b->macroName->realstr())) {
	       curr_y = 25;
	       memcpy(&tmpline[*tlen], &line_touser[i], 5);
	       *tlen += 5;
	       i += 5;
	       tmpline[(*tlen)++] = line_touser[i];
               curr_x = line_touser[i++] - '0';
               if (line_touser[i] != 'H') {
		  tmpline[(*tlen)++] = line_touser[i];
                  curr_x = 10 * curr_x + line_touser[i++] - '0';
	       }
	       tmpline[(*tlen)++] = line_touser[i];
               i++;
            }
            else if (!strcmp("|esc[26;", b->macroName->realstr())) {
	       curr_y = 26;
	       memcpy(&tmpline[*tlen], &line_touser[i], 5);
	       *tlen += 5;
	       i += 5;
	       tmpline[(*tlen)++] = line_touser[i];
               curr_x = line_touser[i++] - '0';
               if (line_touser[i] != 'H') {
		  tmpline[(*tlen)++] = line_touser[i];
                  curr_x = 10 * curr_x + line_touser[i++] - '0';
	       }
	       tmpline[(*tlen)++] = line_touser[i];
               i++;
            }
            else if (!strcmp("|esc[27;", b->macroName->realstr())) {
	       curr_y = 27;
	       memcpy(&tmpline[*tlen], &line_touser[i], 5);
	       *tlen += 5;
	       i += 5;
	       tmpline[(*tlen)++] = line_touser[i];
               curr_x = line_touser[i++] - '0';
               if (line_touser[i] != 'H') {
		  tmpline[(*tlen)++] = line_touser[i];
                  curr_x = 10 * curr_x + line_touser[i++] - '0';
	       }
	       tmpline[(*tlen)++] = line_touser[i];
               i++;
            }
            else if (!strcmp("|esc[28;", b->macroName->realstr())) {
	       curr_y = 28;
	       memcpy(&tmpline[*tlen], &line_touser[i], 5);
	       *tlen += 5;
	       i += 5;
	       tmpline[(*tlen)++] = line_touser[i];
               curr_x = line_touser[i++] - '0';
               if (line_touser[i] != 'H') {
		  tmpline[(*tlen)++] = line_touser[i];
                  curr_x = 10 * curr_x + line_touser[i++] - '0';
	       }
	       tmpline[(*tlen)++] = line_touser[i];
               i++;
            }
            else if (!strcmp("|esc[29;", b->macroName->realstr())) {
	       curr_y = 29;
	       memcpy(&tmpline[*tlen], &line_touser[i], 5);
	       *tlen += 5;
	       i += 5;
	       tmpline[(*tlen)++] = line_touser[i];
               curr_x = line_touser[i++] - '0';
               if (line_touser[i] != 'H') {
		  tmpline[(*tlen)++] = line_touser[i];
                  curr_x = 10 * curr_x + line_touser[i++] - '0';
	       }
	       tmpline[(*tlen)++] = line_touser[i];
               i++;
            }
            else if (!strcmp("|esc[3;", b->macroName->realstr())) {
               curr_y = 3;
	       memcpy(&tmpline[*tlen], &line_touser[i], 4);
	       *tlen += 4;
               i += 4;
	       tmpline[(*tlen)++] = line_touser[i];
               curr_x = line_touser[i++] - '0';
               if (line_touser[i] != 'H') {
		  tmpline[(*tlen)++] = line_touser[i];
                  curr_x = 10 * curr_x + line_touser[i++] - '0';
	       }
	       tmpline[(*tlen)++] = line_touser[i];
               i++;
            }
            else if (!strcmp("|esc[30;", b->macroName->realstr())) {
	       curr_y = 30;
	       memcpy(&tmpline[*tlen], &line_touser[i], 5);
	       *tlen += 5;
	       i += 5;
	       tmpline[(*tlen)++] = line_touser[i];
               curr_x = line_touser[i++] - '0';
               if (line_touser[i] != 'H') {
		  tmpline[(*tlen)++] = line_touser[i];
                  curr_x = 10 * curr_x + line_touser[i++] - '0';
	       }
	       tmpline[(*tlen)++] = line_touser[i];
               i++;
            }
            else if (!strcmp("|esc[31;", b->macroName->realstr())) {
	       curr_y = 31;
	       memcpy(&tmpline[*tlen], &line_touser[i], 5);
	       *tlen += 5;
	       i += 5;
	       tmpline[(*tlen)++] = line_touser[i];
               curr_x = line_touser[i++] - '0';
               if (line_touser[i] != 'H') {
		  tmpline[(*tlen)++] = line_touser[i];
                  curr_x = 10 * curr_x + line_touser[i++] - '0';
	       }
	       tmpline[(*tlen)++] = line_touser[i];
               i++;
            }
            else if (!strcmp("|esc[32;", b->macroName->realstr())) {
	       curr_y = 32;
	       memcpy(&tmpline[*tlen], &line_touser[i], 5);
	       *tlen += 5;
	       i += 5;
	       tmpline[(*tlen)++] = line_touser[i];
               curr_x = line_touser[i++] - '0';
               if (line_touser[i] != 'H') {
		  tmpline[(*tlen)++] = line_touser[i];
                  curr_x = 10 * curr_x + line_touser[i++] - '0';
	       }
	       tmpline[(*tlen)++] = line_touser[i];
               i++;
            }
            else if (!strcmp("|esc[33;", b->macroName->realstr())) {
	       curr_y = 33;
	       memcpy(&tmpline[*tlen], &line_touser[i], 5);
	       *tlen += 5;
	       i += 5;
	       tmpline[(*tlen)++] = line_touser[i];
               curr_x = line_touser[i++] - '0';
               if (line_touser[i] != 'H') {
		  tmpline[(*tlen)++] = line_touser[i];
                  curr_x = 10 * curr_x + line_touser[i++] - '0';
	       }
	       tmpline[(*tlen)++] = line_touser[i];
               i++;
            }
            else if (!strcmp("|esc[34;", b->macroName->realstr())) {
	       curr_y = 34;
	       memcpy(&tmpline[*tlen], &line_touser[i], 5);
	       *tlen += 5;
	       i += 5;
	       tmpline[(*tlen)++] = line_touser[i];
               curr_x = line_touser[i++] - '0';
               if (line_touser[i] != 'H') {
		  tmpline[(*tlen)++] = line_touser[i];
                  curr_x = 10 * curr_x + line_touser[i++] - '0';
	       }
	       tmpline[(*tlen)++] = line_touser[i];
               i++;
            }
            else if (!strcmp("|esc[35;", b->macroName->realstr())) {
	       curr_y = 35;
	       memcpy(&tmpline[*tlen], &line_touser[i], 5);
	       *tlen += 5;
	       i += 5;
	       tmpline[(*tlen)++] = line_touser[i];
               curr_x = line_touser[i++] - '0';
               if (line_touser[i] != 'H') {
		  tmpline[(*tlen)++] = line_touser[i];
                  curr_x = 10 * curr_x + line_touser[i++] - '0';
	       }
	       tmpline[(*tlen)++] = line_touser[i];
               i++;
            }
            else if (!strcmp("|esc[36;", b->macroName->realstr())) {
	       curr_y = 36;
	       memcpy(&tmpline[*tlen], &line_touser[i], 5);
	       *tlen += 5;
	       i += 5;
	       tmpline[(*tlen)++] = line_touser[i];
               curr_x = line_touser[i++] - '0';
               if (line_touser[i] != 'H') {
		  tmpline[(*tlen)++] = line_touser[i];
                  curr_x = 10 * curr_x + line_touser[i++] - '0';
	       }
	       tmpline[(*tlen)++] = line_touser[i];
               i++;
            }
            else if (!strcmp("|esc[37;", b->macroName->realstr())) {
	       curr_y = 37;
	       memcpy(&tmpline[*tlen], &line_touser[i], 5);
	       *tlen += 5;
	       i += 5;
	       tmpline[(*tlen)++] = line_touser[i];
               curr_x = line_touser[i++] - '0';
               if (line_touser[i] != 'H') {
		  tmpline[(*tlen)++] = line_touser[i];
                  curr_x = 10 * curr_x + line_touser[i++] - '0';
	       }
	       tmpline[(*tlen)++] = line_touser[i];
               i++;
            }
            else if (!strcmp("|esc[38;", b->macroName->realstr())) {
	       curr_y = 38;
	       memcpy(&tmpline[*tlen], &line_touser[i], 5);
	       *tlen += 5;
	       i += 5;
	       tmpline[(*tlen)++] = line_touser[i];
               curr_x = line_touser[i++] - '0';
               if (line_touser[i] != 'H') {
		  tmpline[(*tlen)++] = line_touser[i];
                  curr_x = 10 * curr_x + line_touser[i++] - '0';
	       }
	       tmpline[(*tlen)++] = line_touser[i];
               i++;
            }
            else if (!strcmp("|esc[39;", b->macroName->realstr())) {
	       curr_y = 39;
	       memcpy(&tmpline[*tlen], &line_touser[i], 5);
	       *tlen += 5;
	       i += 5;
	       tmpline[(*tlen)++] = line_touser[i];
               curr_x = line_touser[i++] - '0';
               if (line_touser[i] != 'H') {
		  tmpline[(*tlen)++] = line_touser[i];
                  curr_x = 10 * curr_x + line_touser[i++] - '0';
	       }
	       tmpline[(*tlen)++] = line_touser[i];
               i++;
            }
            else if (!strcmp("|esc[4;", b->macroName->realstr())) {
	       curr_y = 4;
	       memcpy(&tmpline[*tlen], &line_touser[i], 4);
	       *tlen += 4;
	       i += 4;
	       tmpline[(*tlen)++] = line_touser[i];
               curr_x = line_touser[i++] - '0';
               if (line_touser[i] != 'H') {
		  tmpline[(*tlen)++] = line_touser[i];
                  curr_x = 10 * curr_x + line_touser[i++] - '0';
	       }
	       tmpline[(*tlen)++] = line_touser[i];
               i++;
            }
            else if (!strcmp("|esc[40;", b->macroName->realstr())) {
	       curr_y = 40;
	       memcpy(&tmpline[*tlen], &line_touser[i], 5);
	       *tlen += 5;
	       i += 5;
	       tmpline[(*tlen)++] = line_touser[i];
               curr_x = line_touser[i++] - '0';
               if (line_touser[i] != 'H') {
		  tmpline[(*tlen)++] = line_touser[i];
                  curr_x = 10 * curr_x + line_touser[i++] - '0';
	       }
	       tmpline[(*tlen)++] = line_touser[i];
               i++;
            }
            else if (!strcmp("|esc[41;", b->macroName->realstr())) {
	       curr_y = 41;
	       memcpy(&tmpline[*tlen], &line_touser[i], 5);
	       *tlen += 5;
	       i += 5;
	       tmpline[(*tlen)++] = line_touser[i];
               curr_x = line_touser[i++] - '0';
               if (line_touser[i] != 'H') {
		  tmpline[(*tlen)++] = line_touser[i];
                  curr_x = 10 * curr_x + line_touser[i++] - '0';
	       }
	       tmpline[(*tlen)++] = line_touser[i];
               i++;
            }
            else if (!strcmp("|esc[42;", b->macroName->realstr())) {
	       curr_y = 42;
	       memcpy(&tmpline[*tlen], &line_touser[i], 5);
	       *tlen += 5;
	       i += 5;
	       tmpline[(*tlen)++] = line_touser[i];
               curr_x = line_touser[i++] - '0';
               if (line_touser[i] != 'H') {
		  tmpline[(*tlen)++] = line_touser[i];
                  curr_x = 10 * curr_x + line_touser[i++] - '0';
	       }
	       tmpline[(*tlen)++] = line_touser[i];
               i++;
            }
            else if (!strcmp("|esc[43;", b->macroName->realstr())) {
	       curr_y = 43;
	       memcpy(&tmpline[*tlen], &line_touser[i], 5);
	       *tlen += 5;
	       i += 5;
	       tmpline[(*tlen)++] = line_touser[i];
               curr_x = line_touser[i++] - '0';
               if (line_touser[i] != 'H') {
		  tmpline[(*tlen)++] = line_touser[i];
                  curr_x = 10 * curr_x + line_touser[i++] - '0';
	       }
	       tmpline[(*tlen)++] = line_touser[i];
               i++;
            }
            else if (!strcmp("|esc[44;", b->macroName->realstr())) {
	       curr_y = 44;
	       memcpy(&tmpline[*tlen], &line_touser[i], 5);
	       *tlen += 5;
	       i += 5;
	       tmpline[(*tlen)++] = line_touser[i];
               curr_x = line_touser[i++] - '0';
               if (line_touser[i] != 'H') {
		  tmpline[(*tlen)++] = line_touser[i];
                  curr_x = 10 * curr_x + line_touser[i++] - '0';
	       }
	       tmpline[(*tlen)++] = line_touser[i];
               i++;
            }
            else if (!strcmp("|esc[46;", b->macroName->realstr())) {
	       curr_y = 46;
	       memcpy(&tmpline[*tlen], &line_touser[i], 5);
	       *tlen += 5;
	       i += 5;
	       tmpline[(*tlen)++] = line_touser[i];
               curr_x = line_touser[i++] - '0';
               if (line_touser[i] != 'H') {
		  tmpline[(*tlen)++] = line_touser[i];
                  curr_x = 10 * curr_x + line_touser[i++] - '0';
	       }
	       tmpline[(*tlen)++] = line_touser[i];
               i++;
            }
            else if (!strcmp("|esc[47;", b->macroName->realstr())) {
	       curr_y = 47;
	       memcpy(&tmpline[*tlen], &line_touser[i], 5);
	       *tlen += 5;
	       i += 5;
	       tmpline[(*tlen)++] = line_touser[i];
               curr_x = line_touser[i++] - '0';
               if (line_touser[i] != 'H') {
		  tmpline[(*tlen)++] = line_touser[i];
                  curr_x = 10 * curr_x + line_touser[i++] - '0';
	       }
	       tmpline[(*tlen)++] = line_touser[i];
               i++;
            }
            else if (!strcmp("|esc[48;", b->macroName->realstr())) {
	       curr_y = 48;
	       memcpy(&tmpline[*tlen], &line_touser[i], 5);
	       *tlen += 5;
	       i += 5;
	       tmpline[(*tlen)++] = line_touser[i];
               curr_x = line_touser[i++] - '0';
               if (line_touser[i] != 'H') {
		  tmpline[(*tlen)++] = line_touser[i];
                  curr_x = 10 * curr_x + line_touser[i++] - '0';
	       }
	       tmpline[(*tlen)++] = line_touser[i];
               i++;
            }
            else if (!strcmp("|esc[49;", b->macroName->realstr())) {
	       curr_y = 49;
	       memcpy(&tmpline[*tlen], &line_touser[i], 5);
	       *tlen += 5;
	       i += 5;
	       tmpline[(*tlen)++] = line_touser[i];
               curr_x = line_touser[i++] - '0';
               if (line_touser[i] != 'H') {
		  tmpline[(*tlen)++] = line_touser[i];
                  curr_x = 10 * curr_x + line_touser[i++] - '0';
	       }
	       tmpline[(*tlen)++] = line_touser[i];
               i++;
            }
            else if (!strcmp("|esc[5;", b->macroName->realstr())) {
	       curr_y = 5;
	       memcpy(&tmpline[*tlen], &line_touser[i], 4);
	       *tlen += 4;
	       i += 4;
	       tmpline[(*tlen)++] = line_touser[i];
               curr_x = line_touser[i++] - '0';
               if (line_touser[i] != 'H') {
		  tmpline[(*tlen)++] = line_touser[i];
                  curr_x = 10 * curr_x + line_touser[i++] - '0';
	       }
	       tmpline[(*tlen)++] = line_touser[i];
               i++;
            }
            else if (!strcmp("|esc[50;", b->macroName->realstr())) {
	       curr_y = 50;
	       memcpy(&tmpline[*tlen], &line_touser[i], 5);
	       *tlen += 5;
	       i += 5;
	       tmpline[(*tlen)++] = line_touser[i];
               curr_x = line_touser[i++] - '0';
               if (line_touser[i] != 'H') {
		  tmpline[(*tlen)++] = line_touser[i];
                  curr_x = 10 * curr_x + line_touser[i++] - '0';
	       }
	       tmpline[(*tlen)++] = line_touser[i];
               i++;
            }
            else if (!strcmp("|esc[51;", b->macroName->realstr())) {
	       curr_y = 51;
	       memcpy(&tmpline[*tlen], &line_touser[i], 5);
	       *tlen += 5;
	       i += 5;
	       tmpline[(*tlen)++] = line_touser[i];
               curr_x = line_touser[i++] - '0';
               if (line_touser[i] != 'H') {
		  tmpline[(*tlen)++] = line_touser[i];
                  curr_x = 10 * curr_x + line_touser[i++] - '0';
	       }
	       tmpline[(*tlen)++] = line_touser[i];
               i++;
            }
            else if (!strcmp("|esc[52;", b->macroName->realstr())) {
	       curr_y = 52;
	       memcpy(&tmpline[*tlen], &line_touser[i], 5);
	       *tlen += 5;
	       i += 5;
	       tmpline[(*tlen)++] = line_touser[i];
               curr_x = line_touser[i++] - '0';
               if (line_touser[i] != 'H') {
		  tmpline[(*tlen)++] = line_touser[i];
                  curr_x = 10 * curr_x + line_touser[i++] - '0';
	       }
	       tmpline[(*tlen)++] = line_touser[i];
               i++;
            }
            else if (!strcmp("|esc[53;", b->macroName->realstr())) {
	       curr_y = 53;
	       memcpy(&tmpline[*tlen], &line_touser[i], 5);
	       *tlen += 5;
	       i += 5;
	       tmpline[(*tlen)++] = line_touser[i];
               curr_x = line_touser[i++] - '0';
               if (line_touser[i] != 'H') {
		  tmpline[(*tlen)++] = line_touser[i];
                  curr_x = 10 * curr_x + line_touser[i++] - '0';
	       }
	       tmpline[(*tlen)++] = line_touser[i];
               i++;
            }
            else if (!strcmp("|esc[54;", b->macroName->realstr())) {
	       curr_y = 54;
	       memcpy(&tmpline[*tlen], &line_touser[i], 5);
	       *tlen += 5;
	       i += 5;
	       tmpline[(*tlen)++] = line_touser[i];
               curr_x = line_touser[i++] - '0';
               if (line_touser[i] != 'H') {
		  tmpline[(*tlen)++] = line_touser[i];
                  curr_x = 10 * curr_x + line_touser[i++] - '0';
	       }
	       tmpline[(*tlen)++] = line_touser[i];
               i++;
            }
            else if (!strcmp("|esc[56;", b->macroName->realstr())) {
	       curr_y = 56;
	       memcpy(&tmpline[*tlen], &line_touser[i], 5);
	       *tlen += 5;
	       i += 5;
	       tmpline[(*tlen)++] = line_touser[i];
               curr_x = line_touser[i++] - '0';
               if (line_touser[i] != 'H') {
		  tmpline[(*tlen)++] = line_touser[i];
                  curr_x = 10 * curr_x + line_touser[i++] - '0';
	       }
	       tmpline[(*tlen)++] = line_touser[i];
               i++;
            }
            else if (!strcmp("|esc[57;", b->macroName->realstr())) {
	       curr_y = 57;
	       memcpy(&tmpline[*tlen], &line_touser[i], 5);
	       *tlen += 5;
	       i += 5;
	       tmpline[(*tlen)++] = line_touser[i];
               curr_x = line_touser[i++] - '0';
               if (line_touser[i] != 'H') {
		  tmpline[(*tlen)++] = line_touser[i];
                  curr_x = 10 * curr_x + line_touser[i++] - '0';
	       }
	       tmpline[(*tlen)++] = line_touser[i];
               i++;
            }
            else if (!strcmp("|esc[58;", b->macroName->realstr())) {
	       curr_y = 58;
	       memcpy(&tmpline[*tlen], &line_touser[i], 5);
	       *tlen += 5;
	       i += 5;
	       tmpline[(*tlen)++] = line_touser[i];
               curr_x = line_touser[i++] - '0';
               if (line_touser[i] != 'H') {
		  tmpline[(*tlen)++] = line_touser[i];
                  curr_x = 10 * curr_x + line_touser[i++] - '0';
	       }
	       tmpline[(*tlen)++] = line_touser[i];
               i++;
            }
            else if (!strcmp("|esc[59;", b->macroName->realstr())) {
	       curr_y = 59;
	       memcpy(&tmpline[*tlen], &line_touser[i], 5);
	       *tlen += 5;
	       i += 5;
	       tmpline[(*tlen)++] = line_touser[i];
               curr_x = line_touser[i++] - '0';
               if (line_touser[i] != 'H') {
		  tmpline[(*tlen)++] = line_touser[i];
                  curr_x = 10 * curr_x + line_touser[i++] - '0';
	       }
	       tmpline[(*tlen)++] = line_touser[i];
               i++;
	    }
            else if (!strcmp("|esc[6;", b->macroName->realstr())) {
               curr_y = 6;
	       memcpy(&tmpline[*tlen], &line_touser[i], 4);
	       *tlen += 4;
               i += 4;
	       tmpline[(*tlen)++] = line_touser[i];
               curr_x = line_touser[i++] - '0';
               if (line_touser[i] != 'H') {
		  tmpline[(*tlen)++] = line_touser[i];
                  curr_x = 10 * curr_x + line_touser[i++] - '0';
	       }
	       tmpline[(*tlen)++] = line_touser[i];
               i++;
            }
            else if (!strcmp("|esc[60;", b->macroName->realstr())) {
	       curr_y = 60;
	       memcpy(&tmpline[*tlen], &line_touser[i], 5);
	       *tlen += 5;
	       i += 5;
	       tmpline[(*tlen)++] = line_touser[i];
               curr_x = line_touser[i++] - '0';
               if (line_touser[i] != 'H') {
		  tmpline[(*tlen)++] = line_touser[i];
                  curr_x = 10 * curr_x + line_touser[i++] - '0';
	       }
	       tmpline[(*tlen)++] = line_touser[i];
               i++;
            }
            else if (!strcmp("|esc[61;", b->macroName->realstr())) {
	       curr_y = 61;
	       memcpy(&tmpline[*tlen], &line_touser[i], 5);
	       *tlen += 5;
	       i += 5;
	       tmpline[(*tlen)++] = line_touser[i];
               curr_x = line_touser[i++] - '0';
               if (line_touser[i] != 'H') {
		  tmpline[(*tlen)++] = line_touser[i];
                  curr_x = 10 * curr_x + line_touser[i++] - '0';
	       }
	       tmpline[(*tlen)++] = line_touser[i];
               i++;
            }
            else if (!strcmp("|esc[62;", b->macroName->realstr())) {
	       curr_y = 62;
	       memcpy(&tmpline[*tlen], &line_touser[i], 5);
	       *tlen += 5;
	       i += 5;
	       tmpline[(*tlen)++] = line_touser[i];
               curr_x = line_touser[i++] - '0';
               if (line_touser[i] != 'H') {
		  tmpline[(*tlen)++] = line_touser[i];
                  curr_x = 10 * curr_x + line_touser[i++] - '0';
	       }
	       tmpline[(*tlen)++] = line_touser[i];
               i++;
            }
            else if (!strcmp("|esc[63;", b->macroName->realstr())) {
	       curr_y = 63;
	       memcpy(&tmpline[*tlen], &line_touser[i], 5);
	       *tlen += 5;
	       i += 5;
	       tmpline[(*tlen)++] = line_touser[i];
               curr_x = line_touser[i++] - '0';
               if (line_touser[i] != 'H') {
		  tmpline[(*tlen)++] = line_touser[i];
                  curr_x = 10 * curr_x + line_touser[i++] - '0';
	       }
	       tmpline[(*tlen)++] = line_touser[i];
               i++;
            }
            else if (!strcmp("|esc[64;", b->macroName->realstr())) {
	       curr_y = 64;
	       memcpy(&tmpline[*tlen], &line_touser[i], 5);
	       *tlen += 5;
	       i += 5;
	       tmpline[(*tlen)++] = line_touser[i];
               curr_x = line_touser[i++] - '0';
               if (line_touser[i] != 'H') {
		  tmpline[(*tlen)++] = line_touser[i];
                  curr_x = 10 * curr_x + line_touser[i++] - '0';
	       }
	       tmpline[(*tlen)++] = line_touser[i];
               i++;
            }
            else if (!strcmp("|esc[66;", b->macroName->realstr())) {
	       curr_y = 66;
	       memcpy(&tmpline[*tlen], &line_touser[i], 5);
	       *tlen += 5;
	       i += 5;
	       tmpline[(*tlen)++] = line_touser[i];
               curr_x = line_touser[i++] - '0';
               if (line_touser[i] != 'H') {
		  tmpline[(*tlen)++] = line_touser[i];
                  curr_x = 10 * curr_x + line_touser[i++] - '0';
	       }
	       tmpline[(*tlen)++] = line_touser[i];
               i++;
            }
            else if (!strcmp("|esc[67;", b->macroName->realstr())) {
	       curr_y = 67;
	       memcpy(&tmpline[*tlen], &line_touser[i], 5);
	       *tlen += 5;
	       i += 5;
	       tmpline[(*tlen)++] = line_touser[i];
               curr_x = line_touser[i++] - '0';
               if (line_touser[i] != 'H') {
		  tmpline[(*tlen)++] = line_touser[i];
                  curr_x = 10 * curr_x + line_touser[i++] - '0';
	       }
	       tmpline[(*tlen)++] = line_touser[i];
               i++;
            }
            else if (!strcmp("|esc[68;", b->macroName->realstr())) {
	       curr_y = 68;
	       memcpy(&tmpline[*tlen], &line_touser[i], 5);
	       *tlen += 5;
	       i += 5;
	       tmpline[(*tlen)++] = line_touser[i];
               curr_x = line_touser[i++] - '0';
               if (line_touser[i] != 'H') {
		  tmpline[(*tlen)++] = line_touser[i];
                  curr_x = 10 * curr_x + line_touser[i++] - '0';
	       }
	       tmpline[(*tlen)++] = line_touser[i];
               i++;
            }
            else if (!strcmp("|esc[69;", b->macroName->realstr())) {
	       curr_y = 69;
	       memcpy(&tmpline[*tlen], &line_touser[i], 5);
	       *tlen += 5;
	       i += 5;
	       tmpline[(*tlen)++] = line_touser[i];
               curr_x = line_touser[i++] - '0';
               if (line_touser[i] != 'H') {
		  tmpline[(*tlen)++] = line_touser[i];
                  curr_x = 10 * curr_x + line_touser[i++] - '0';
	       }
	       tmpline[(*tlen)++] = line_touser[i];
               i++;
	    }
            else if (!strcmp("|esc[7;", b->macroName->realstr())) {
               curr_y = 7;
	       memcpy(&tmpline[*tlen], &line_touser[i], 4);
	       *tlen += 4;
               i += 4;
	       tmpline[(*tlen)++] = line_touser[i];
               curr_x = line_touser[i++] - '0';
               if (line_touser[i] != 'H') {
		  tmpline[(*tlen)++] = line_touser[i];
                  curr_x = 10 * curr_x + line_touser[i++] - '0';
	       }
	       tmpline[(*tlen)++] = line_touser[i];
               i++;
            }
            else if (!strcmp("|esc[8;", b->macroName->realstr())) {
               curr_y = 8;
	       memcpy(&tmpline[*tlen], &line_touser[i], 4);
	       *tlen += 4;
               i += 4;
	       tmpline[(*tlen)++] = line_touser[i];
               curr_x = line_touser[i++] - '0';
               if (line_touser[i] != 'H') {
		  tmpline[(*tlen)++] = line_touser[i];
                  curr_x = 10 * curr_x + line_touser[i++] - '0';
	       }
	       tmpline[(*tlen)++] = line_touser[i];
               i++;
            }
            else if (!strcmp("|esc[9;", b->macroName->realstr())) {
               curr_y = 9;
	       memcpy(&tmpline[*tlen], &line_touser[i], 4);
	       *tlen += 4;
               i += 4;
	       tmpline[(*tlen)++] = line_touser[i];
               curr_x = line_touser[i++] - '0';
               if (line_touser[i] != 'H') {
		  tmpline[(*tlen)++] = line_touser[i];
                  curr_x = 10 * curr_x + line_touser[i++] - '0';
	       }
	       tmpline[(*tlen)++] = line_touser[i];
               i++;
            }
            else if (!strcmp("|top", b->macroName->realstr()) ||
		     !strcmp("|top;", b->macroName->realstr())) {
	       curr_x = 1;
	       curr_y = 1;
	       memcpy(&tmpline[*tlen], &line_touser[i], b->macro->length());
	       *tlen += b->macro->length();
	       i += b->macro->length();
            }
            else if (!strcmp("|esc[3@", b->macroName->realstr())) {
	       curr_x = 3;
	       for (int i = 4; i <= disp_width; i++) // ?
		  disp[(last_line + curr_y) % disp_height][i - 1] = ' ';
	       memcpy(&tmpline[*tlen], &line_touser[i], 4);
	       *tlen += 4;
	       i += 4;
            }
            else if (!strcmp("|esc[C", b->macroName->realstr())) {
	       curr_x += 1;
	       memcpy(&tmpline[*tlen], &line_touser[i], 3);
	       *tlen += 3;
	       i += 3;
            }
            else if (!strcmp("|esc[3C", b->macroName->realstr())) {
	       curr_x += 3;
	       memcpy(&tmpline[*tlen], &line_touser[i], 4);
	       *tlen += 4;
	       i += 4;
            }
            else if (!strcmp("|esc[4C", b->macroName->realstr())) {
	       curr_x += 4;
	       memcpy(&tmpline[*tlen], &line_touser[i], 4);
	       *tlen += 4;
	       i += 4;
            }
            else if (!strcmp("|esc[5C", b->macroName->realstr())) {
	       curr_x += 5;
	       memcpy(&tmpline[*tlen], &line_touser[i], 4);
	       *tlen += 4;
	       i += 4;
            }
            else if (!strcmp("|esc[6C", b->macroName->realstr())) {
	       curr_x += 6;
	       memcpy(&tmpline[*tlen], &line_touser[i], 4);
	       *tlen += 4;
	       i += 4;
            }
            else if (!strcmp("|esc[7C", b->macroName->realstr())) {
	       curr_x += 7;
	       memcpy(&tmpline[*tlen], &line_touser[i], 4);
	       *tlen += 4;
	       i += 4;
            }
            else if (!strcmp("|esc[8C", b->macroName->realstr())) {
	       curr_x += 8;
	       memcpy(&tmpline[*tlen], &line_touser[i], 4);
	       *tlen += 4;
	       i += 4;
            }
            else if (!strcmp("|esc[9C", b->macroName->realstr())) {
	       curr_x += 9;
	       memcpy(&tmpline[*tlen], &line_touser[i], 4);
	       *tlen += 4;
	       i += 4;
            }
            else if (!strcmp("|esc[3D", b->macroName->realstr())) {
	       curr_x -= 3;
	       memcpy(&tmpline[*tlen], &line_touser[i], 4);
	       *tlen += 4;
	       i += 4;
            }
            else if (!strcmp("|esc[4D", b->macroName->realstr())) {
	       curr_x -= 4;
	       memcpy(&tmpline[*tlen], &line_touser[i], 4);
	       *tlen += 4;
	       i += 4;
            }
            else if (!strcmp("|esc[5D", b->macroName->realstr())) {
	       curr_x -= 5;
	       memcpy(&tmpline[*tlen], &line_touser[i], 4);
	       *tlen += 4;
	       i += 4;
            }
            else if (!strcmp("|esc[6D", b->macroName->realstr())) {
	       curr_x -= 6;
	       memcpy(&tmpline[*tlen], &line_touser[i], 4);
	       *tlen += 4;
	       i += 4;
            }
            else if (!strcmp("|esc[7D", b->macroName->realstr())) {
	       curr_x -= 7;
	       memcpy(&tmpline[*tlen], &line_touser[i], 4);
	       *tlen += 4;
	       i += 4;
            }
            else if (!strcmp("|esc[8D", b->macroName->realstr())) {
	       curr_x -= 8;
	       memcpy(&tmpline[*tlen], &line_touser[i], 4);
	       *tlen += 4;
	       i += 4;
            }
            else if (!strcmp("|esc[9D", b->macroName->realstr())) {
	       curr_x -= 9;
	       memcpy(&tmpline[*tlen], &line_touser[i], 4);
	       *tlen += 4;
	       i += 4;
            }
            else if (!strcmp("|esc[10D", b->macroName->realstr())) {
	       curr_x -= 10;
	       memcpy(&tmpline[*tlen], &line_touser[i], 5);
	       *tlen += 5;
	       i += 5;
            }
            else if (!strcmp("|esc[11D", b->macroName->realstr())) {
	       curr_x -= 11;
	       memcpy(&tmpline[*tlen], &line_touser[i], 5);
	       *tlen += 5;
	       i += 5;
            }
            else if (!strcmp("|esc[12D", b->macroName->realstr())) {
	       curr_x -= 12;
	       memcpy(&tmpline[*tlen], &line_touser[i], 5);
	       *tlen += 5;
	       i += 5;
            }
            else if (!strcmp("|esc[13D", b->macroName->realstr())) {
	       curr_x -= 13;
	       memcpy(&tmpline[*tlen], &line_touser[i], 5);
	       *tlen += 5;
	       i += 5;
            }
            else if (!strcmp("|esc[14D", b->macroName->realstr())) {
	       curr_x -= 14;
	       memcpy(&tmpline[*tlen], &line_touser[i], 5);
	       *tlen += 5;
	       i += 5;
            }
            else if (!strcmp("|esc[15D", b->macroName->realstr())) {
	       curr_x -= 15;
	       memcpy(&tmpline[*tlen], &line_touser[i], 5);
	       *tlen += 5;
	       i += 5;
            }
            else if (!strcmp("|esc[16D", b->macroName->realstr())) {
	       curr_x -= 16;
	       memcpy(&tmpline[*tlen], &line_touser[i], 5);
	       *tlen += 5;
	       i += 5;
            }
            else if (!strcmp("|esc[17D", b->macroName->realstr())) {
	       curr_x -= 17;
	       memcpy(&tmpline[*tlen], &line_touser[i], 5);
	       *tlen += 5;
	       i += 5;
            }
            else if (!strcmp("|esc[18D", b->macroName->realstr())) {
	       curr_x -= 18;
	       memcpy(&tmpline[*tlen], &line_touser[i], 5);
	       *tlen += 5;
	       i += 5;
            }
            else if (!strcmp("|esc[19D", b->macroName->realstr())) {
	       curr_x -= 19;
	       memcpy(&tmpline[*tlen], &line_touser[i], 5);
	       *tlen += 5;
	       i += 5;
            }
            else if (!strcmp("|esc[20D", b->macroName->realstr())) {
	       curr_x -= 20;
	       memcpy(&tmpline[*tlen], &line_touser[i], 5);
	       *tlen += 5;
	       i += 5;
            }
            else if (!strcmp("|esc[21D", b->macroName->realstr())) {
	       curr_x -= 21;
	       memcpy(&tmpline[*tlen], &line_touser[i], 5);
	       *tlen += 5;
	       i += 5;
            }
            else if (!strcmp("|esc[22D", b->macroName->realstr())) {
	       curr_x -= 22;
	       memcpy(&tmpline[*tlen], &line_touser[i], 5);
	       *tlen += 5;
	       i += 5;
            }
            else if (!strcmp("|esc[23D", b->macroName->realstr())) {
	       curr_x -= 23;
	       memcpy(&tmpline[*tlen], &line_touser[i], 5);
	       *tlen += 5;
	       i += 5;
            }
            else if (!strcmp("|esc[24D", b->macroName->realstr())) {
	       curr_x -= 24;
	       memcpy(&tmpline[*tlen], &line_touser[i], 5);
	       *tlen += 5;
	       i += 5;
            }
            else if (!strcmp("|esc[25D", b->macroName->realstr())) {
	       curr_x -= 25;
	       memcpy(&tmpline[*tlen], &line_touser[i], 5);
	       *tlen += 5;
	       i += 5;
            }
            else if (!strcmp("|esc[26D", b->macroName->realstr())) {
	       curr_x -= 26;
	       memcpy(&tmpline[*tlen], &line_touser[i], 5);
	       *tlen += 5;
	       i += 5;
            }
            else if (!strcmp("|esc[27D", b->macroName->realstr())) {
	       curr_x -= 27;
	       memcpy(&tmpline[*tlen], &line_touser[i], 5);
	       *tlen += 5;
	       i += 5;
            }
            else if (!strcmp("|esc[28D", b->macroName->realstr())) {
	       curr_x -= 28;
	       memcpy(&tmpline[*tlen], &line_touser[i], 5);
	       *tlen += 5;
	       i += 5;
            }
            else if (!strcmp("|esc[29D", b->macroName->realstr())) {
	       curr_x -= 29;
	       memcpy(&tmpline[*tlen], &line_touser[i], 5);
	       *tlen += 5;
	       i += 5;
            }
            else if (!strcmp("|esc[2P", b->macroName->realstr())) {
	       for (int j = 0; j < 2; j++)
		  disp[(curr_y +last_line) % disp_height][curr_x - 2 - j] =' ';
	       curr_x -= 2;
	    }
            else if (!strcmp("|esc[3P", b->macroName->realstr())) {
	       for (int j = 0; j < 3; j++)
		  disp[(curr_y +last_line) % disp_height][curr_x - 2 - j] =' ';
	       curr_x -= 3;
	    }
            else if (!strcmp("|esc[4P", b->macroName->realstr())) {
	       for (int j = 0; j < 4; j++)
		  disp[(curr_y +last_line) % disp_height][curr_x - 2 - j] =' ';
	       curr_x -= 4;
	    }
            else if (!strcmp("|esc[5P", b->macroName->realstr())) {
	       for (int j = 0; j < 5; j++)
		  disp[(curr_y +last_line) % disp_height][curr_x - 2 - j] =' ';
	       curr_x -= 5;
	    }
            else if (!strcmp("|esc[6P", b->macroName->realstr())) {
	       for (int j = 0; j < 6; j++)
		  disp[(curr_y +last_line) % disp_height][curr_x - 2 - j] =' ';
	       curr_x -= 6;
	    }
            else if (!strcmp("|esc[7P", b->macroName->realstr())) {
	       for (int j = 0; j < 7; j++)
		  disp[(curr_y +last_line) % disp_height][curr_x - 2 - j] =' ';
	       curr_x -= 7;
	    }
            else if (!strcmp("|esc[8P", b->macroName->realstr())) {
	       for (int j = 0; j < 8; j++)
		  disp[(curr_y +last_line) % disp_height][curr_x - 2 - j] =' ';
	       curr_x -= 8;
	    }
            else if (!strcmp("|esc[9P", b->macroName->realstr())) {
	       for (int j = 0; j < 9; j++)
		  disp[(curr_y +last_line) % disp_height][curr_x - 2 - j] =' ';
	       curr_x -= 9;
	    }
            else if (!strcmp("|esc[2L", b->macroName->realstr())) {
	       for (int j = scrollEnd - 2; j >= curr_y; j--)
		  for (int k = 0; k < disp_width; k++)
		     disp[(j + disp_height + 2) % disp_height][k] =
			disp[(j + disp_height) % disp_height][k];
	       for (j = 0; j < 2; j++)
		  for (int k = 0; k < disp_width; k++)
		     disp[(curr_y + j + last_line) % disp_height][k] = ' ';
	       memcpy(&tmpline[*tlen], &line_touser[i], 4);
	       *tlen += 4;
	       i += 4;
            }
            else if (!strcmp("|esc[3L", b->macroName->realstr())) {
	       for (int j = scrollEnd - 3; j >= curr_y; j--)
		  for (int k = 0; k < disp_width; k++)
		     disp[(j + disp_height + 3) % disp_height][k] =
			disp[(j + disp_height) % disp_height][k];
	       for (j = 0; j < 3; j++)
		  for (int k = 0; k < disp_width; k++)
		     disp[(curr_y + j + last_line) % disp_height][k] = ' ';
	       memcpy(&tmpline[*tlen], &line_touser[i], 4);
	       *tlen += 4;
	       i += 4;
            }
            else if (!strcmp("|esc[4L", b->macroName->realstr())) {
	       for (int j = scrollEnd - 4; j >= curr_y; j--)
		  for (int k = 0; k < disp_width; k++)
		     disp[(j + disp_height + 4) % disp_height][k] =
			disp[(j + disp_height) % disp_height][k];
	       for (j = 0; j < 4; j++)
		  for (int k = 0; k < disp_width; k++)
		     disp[(curr_y + j + last_line) % disp_height][k] = ' ';
	       memcpy(&tmpline[*tlen], &line_touser[i], 4);
	       *tlen += 4;
	       i += 4;
            }
            else if (!strcmp("|esc[5L", b->macroName->realstr())) {
	       for (int j = scrollEnd - 5; j >= curr_y; j--)
		  for (int k = 0; k < disp_width; k++)
		     disp[(j + disp_height + 5) % disp_height][k] =
			disp[(j + disp_height) % disp_height][k];
	       for (j = 0; j < 5; j++)
		  for (int k = 0; k < disp_width; k++)
		     disp[(curr_y + j + last_line) % disp_height][k] = ' ';
	       memcpy(&tmpline[*tlen], &line_touser[i], 4);
	       *tlen += 4;
	       i += 4;
            }
            else if (!strcmp("|esc[6L", b->macroName->realstr())) {
	       for (int j = scrollEnd - 6; j >= curr_y; j--)
		  for (int k = 0; k < disp_width; k++)
		     disp[(j + disp_height + 6) % disp_height][k] =
			disp[(j + disp_height) % disp_height][k];
	       for (j = 0; j < 6; j++)
		  for (int k = 0; k < disp_width; k++)
		     disp[(curr_y + j + last_line) % disp_height][k] = ' ';
	       memcpy(&tmpline[*tlen], &line_touser[i], 4);
	       *tlen += 4;
	       i += 4;
            }
            else if (!strcmp("|esc[7L", b->macroName->realstr())) {
	       for (int j = scrollEnd - 7; j >= curr_y; j--)
		  for (int k = 0; k < disp_width; k++)
		     disp[(j + disp_height + 7) % disp_height][k] =
			disp[(j + disp_height) % disp_height][k];
	       for (j = 0; j < 7; j++)
		  for (int k = 0; k < disp_width; k++)
		     disp[(curr_y + j + last_line) % disp_height][k] = ' ';
	       memcpy(&tmpline[*tlen], &line_touser[i], 4);
	       *tlen += 4;
	       i += 4;
            }
            else if (!strcmp("|esc[8L", b->macroName->realstr())) {
	       for (int j = scrollEnd - 8; j >= curr_y; j--)
		  for (int k = 0; k < disp_width; k++)
		     disp[(j + disp_height + 8) % disp_height][k] =
			disp[(j + disp_height) % disp_height][k];
	       for (j = 0; j < 8; j++)
		  for (int k = 0; k < disp_width; k++)
		     disp[(curr_y + j + last_line) % disp_height][k] = ' ';
	       memcpy(&tmpline[*tlen], &line_touser[i], 4);
	       *tlen += 4;
	       i += 4;
            }
            else if (!strcmp("|esc[9L", b->macroName->realstr())) {
	       for (int j = scrollEnd - 9; j >= curr_y; j--)
		  for (int k = 0; k < disp_width; k++)
		     disp[(j + disp_height + 9) % disp_height][k] =
			disp[(j + disp_height) % disp_height][k];
	       for (j = 0; j < 9; j++)
		  for (int k = 0; k < disp_width; k++)
		     disp[(curr_y + j + last_line) % disp_height][k] = ' ';
	       memcpy(&tmpline[*tlen], &line_touser[i], 4);
	       *tlen += 4;
	       i += 4;
            }
            else if (!strcmp("|null", b->macroName->realstr()))
	       memcpy(&tmpline[(*tlen)++], &line_touser[i++], 1);
            else if (!strcmp("|esc[24m", b->macroName->realstr())) {
	       memcpy(&tmpline[*tlen], &line_touser[i], 5);
	       *tlen += 5;
	       i += 5;
	       und_mode = 0;
	    }
            else if (!strcmp("|esc[4m", b->macroName->realstr())) {
	       memcpy(&tmpline[*tlen], &line_touser[i], 4);
	       *tlen += 4;
	       i += 4;
	       und_mode = 1;
	    }
            else if (!strcmp("|esc[A", b->macroName->realstr())) {
	       memcpy(&tmpline[*tlen], &line_touser[i], 3);
	       if (curr_y > 1)
		 curr_y--;
	       *tlen += 3;
	       i += 3;
	    }
            else if (!strcmp("|escM", b->macroName->realstr())) {
	       if (curr_y > 1)
		 curr_y--;
	       memcpy(&tmpline[*tlen], &line_touser[i], 2);
	       *tlen += 2;
	       i += 2;
            }
            else if (!strcmp("|esc[23B", b->macroName->realstr())) {
	      curr_y += 23;
	      memcpy(&tmpline[*tlen], &line_touser[i], 4);
	      *tlen += 4;
	      i += 4;
            }
            else if (!strcmp("|esc[22B", b->macroName->realstr())) {
	      curr_y += 22;
	      memcpy(&tmpline[*tlen], &line_touser[i], 4);
	      *tlen += 4;
	      i += 4;
            }
            else if (!strcmp("|esc[21B", b->macroName->realstr())) {
	      curr_y += 21;
	      memcpy(&tmpline[*tlen], &line_touser[i], 4);
	      *tlen += 4;
	      i += 4;
            }
            else if (!strcmp("|esc[20B", b->macroName->realstr())) {
	      curr_y += 20;
	      memcpy(&tmpline[*tlen], &line_touser[i], 4);
	      *tlen += 4;
	      i += 4;
            }
            else if (!strcmp("|esc[9B", b->macroName->realstr())) {
	      curr_y += 9;
	      memcpy(&tmpline[*tlen], &line_touser[i], 3);
	      *tlen += 3;
	      i += 3;
            }
            else if (!strcmp("|esc[8B", b->macroName->realstr())) {
	      curr_y += 8;
	      memcpy(&tmpline[*tlen], &line_touser[i], 3);
	      *tlen += 3;
	      i += 3;
            }
            else if (!strcmp("|esc[7B", b->macroName->realstr())) {
	      curr_y += 7;
	      memcpy(&tmpline[*tlen], &line_touser[i], 3);
	      *tlen += 3;
	      i += 3;
            }
            else if (!strcmp("|esc[6B", b->macroName->realstr())) {
	      curr_y += 6;
	      memcpy(&tmpline[*tlen], &line_touser[i], 3);
	      *tlen += 3;
	      i += 3;
            }
            else if (!strcmp("|esc[5B", b->macroName->realstr())) {
	      curr_y += 5;
	      memcpy(&tmpline[*tlen], &line_touser[i], 3);
	      *tlen += 3;
	      i += 3;
            }
            else if (!strcmp("|esc[4B", b->macroName->realstr())) {
	      curr_y += 4;
	      memcpy(&tmpline[*tlen], &line_touser[i], 3);
	      *tlen += 3;
	      i += 3;
            }
            else if (!strcmp("|esc7", b->macroName->realstr())) {
	       memcpy(&tmpline[*tlen], &line_touser[i], 2);
	       save_x = curr_x;
	       save_y = curr_y;
	       *tlen += 2;
	       i += 2;
            }
            else if (!strcmp("|esc8", b->macroName->realstr())) {
	       memcpy(&tmpline[*tlen], &line_touser[i], 2);
	       curr_x = save_x;
	       curr_y = save_y;
	       *tlen += 2;
	       i += 2;
            }
            else if (!strcmp("|esc[?47h", b->macroName->realstr())) {
	       memcpy(&tmpline[*tlen], &line_touser[i], 6);
	       *tlen += 6;
	       i += 6;
            }
            else if (!strcmp("|esc[?47l", b->macroName->realstr())) {
	      memcpy(&tmpline[*tlen], "|cl", 3);
	      memcpy(&tmpline[*tlen], &line_touser[i], 6);
	      *tlen += 6;
	      i += 6;
            }
            else if (!strcmp("|escc", b->macroName->realstr())) {
	       memcpy(&tmpline[*tlen], &line_touser[i], 2);
	       *tlen += 2;
	       i += 2;
            }
            else if (!strcmp("|cancel", b->macroName->realstr())) {
	       memcpy(&tmpline[*tlen], &line_touser[i], 1);
	       *tlen += 1;
	       i += 1;
            }
	    else {
	       if (inv_mode)
		  memcpy(&tmpline[*tlen], "|ihe?|ihb", 9);
	       else
		  memcpy(&tmpline[*tlen], "|ihb?|ihe", 9);
	       curr_x++;
	       *tlen += 9;
               i += b->macro->length();
            }
         }
	 if (curr_y != old_curr_y) {
	    total_keywords -= kwrd_line_cnt[curr_y];
	    kwrd_line_cnt[curr_y] = 0;
	 }
      }
   }
}

void
screen::save_to_reg(int r)
{
   int line = top_line;
   int pos = top_pos;
   reg[r].empty();
   do {
      reg[r] += disp[(line + last_line + 1) % disp_height][pos++];
      if (disp_width == pos) {
	 pos = 0;
	 line++;
      }
   } while (line != bottom_line || pos != bottom_pos);
   reg[r] += disp[(line + last_line + 1) % disp_height][pos];
}
