#!/usr/local/bin/perl

# sample_application shows how to embed evaluate_parameters into your application.

require "src/evap.pl";

sub setup_for_evap { 

    # Simply read the PDT and MM files and initialize the evap variables for the specified package.

    local( $pkg, $command ) = @_;

    open( IN, "<pdt/${command}_pdt" );
    eval "@${pkg}'PDT = <IN>;";                        # initialize Parameter Description Table
    close( IN );
    open( IN, "<mm/${command}.mm" );
    eval "@${pkg}'MM = grep( \$@ = s/\n\$//, <IN> );"; # initialize Message Module
    close( IN );

} # end setup_for_evap

# sample_application command processors follow, in alphabetical order.
 
sub exi_proc {

    package exi_pkg;		# qualify %Options

    &main'setup_for_evap( "exi_pkg", "exi" );
    if ( &main'evap( *PDT, *MM ) != 1 ) { return; }

    print STDOUT "Have a nice day!\n";
    exit( 0 );

} # end exi_proc

sub samc_proc {

    package samc_pkg;		# qualify %Options

    &main'setup_for_evap( "samc_pkg", "samc" );
    $evap'evap_Help_Hooks{'P_HHUOFL'} = " [Color_List]\n";
    $evap'evap_Help_Hooks{'P_HHBOFL'} = "\nA Color_List is optionally required by this command.\n\n";
    if ( &main'evap( *PDT, *MM ) != 1 ) { return; }

    print STDOUT "In sub samc_proc, value of option `id' = `$Options{'id'}'.\n";
    foreach $color (@ARGV) {
        print STDOUT "  color = $color\n";
    }

} # end samc_proc

# Main.

%commands =  ("exit|exi", "exi_proc", "sample_command|samc", "samc_proc");

&setup_for_evap( "main", "sama" );
&evap( *PDT, *MM );		# evaluate_parameters for sample_application

# Let evaluate_parameters process all user input for the application, and then call the actual command processor.

$I = 'sama_input_handle';
open( $I, "$Options{'input'}" );

&evap_pac( "sama>", $I, %commands ); # process application commands

close( $I );
exit( 0 );
