/************************************************************************
 *  Copyright (c) 1993 by Charles A. Measday                            *
 *                                                                      *
 *  Permission to use, copy, modify, and distribute this software       *
 *  and its documentation for any purpose and without fee is hereby     *
 *  granted, provided that the above copyright notice appear in all     *
 *  copies.  The author makes no representations about the suitability  *
 *  of this software for any purpose.  It is provided "as is" without   *
 *  express or implied warranty.                                        *
 ************************************************************************/

/*
@(#)  FILE: nix_util.h  RELEASE: 1.1  DATE: 5/20/94, 12:06:45
*/
/*******************************************************************************

    nix_util.h

    Network I/O Handler Definitions.

*******************************************************************************/

#ifndef  NIX_UTIL_H			/* Has the file been INCLUDE'd already? */
#define  NIX_UTIL_H  yes


#ifndef P_
#    if __STDC__ || defined(__cplusplus) || defined(vaxc)
#        define  P_(s)  s
#    else
#        define  P_(s)  ()
#        define  const
#    endif
#endif


/*******************************************************************************
    Network I/O Handler Structures (Client View) and Definitions.
*******************************************************************************/

typedef  struct  _NxAppContext  *NxAppContext ;		/* Application context. */
typedef  struct  _NxIOSource  *NxInputId ;		/* I/O source. */
typedef  struct  _NxTimer  *NxIntervalId ;		/* Timeout timer. */
typedef  struct  _NxBackgroundTask  *NxWorkProcId ;	/* Work procedure. */

typedef  long  NxInputMask ;				/* SELECT(2) masks. */
#define  NxInputNoneMask	0L
#define  NxInputReadMask	(1L << 0)
#define  NxInputWriteMask	(1L << 1)
#define  NxInputExceptMask	(1L << 2)

					/* Callback function prototypes. */
typedef  int  (*NxInputCallback) P_((NxAppContext, NxInputId, int, void *)) ;
typedef  int  (*NxTimerCallback) P_((NxAppContext, NxIntervalId, void *)) ;
typedef  int  (*NxWorkProc) P_((NxAppContext, NxWorkProcId, void *)) ;


/*******************************************************************************
    Miscellaneous declarations.
*******************************************************************************/

extern  int  nix_util_debug ;		/* Global debug switch (1/0 = yes/no). */


/*******************************************************************************
    Public functions.
*******************************************************************************/

extern  NxInputId  NxAddInput P_((NxAppContext *context,
                                  int source,
                                  NxInputMask condition,
                                  NxInputCallback callbackF,
                                  void *client_data)) ;

extern  NxIntervalId  NxAddTimeOut P_((NxAppContext *context,
                                       double interval,
                                       NxTimerCallback callbackF,
                                       void *client_data)) ;

extern  NxWorkProcId  NxAddWorkProc P_((NxAppContext *context,
                                        NxWorkProc workprocF,
                                        void *client_data)) ;

extern  int  NxCreateContext P_((NxAppContext *context)) ;

extern  int  NxMainLoop P_((NxAppContext *context)) ;

#ifdef VMS
    extern  int  NxMainLoopEF P_((NxAppContext *context, int timer_ef)) ;
#endif

extern  int  NxRemoveInput P_((NxAppContext *context,
                               NxInputId source_ID)) ;

extern  int  NxRemoveTimeOut P_((NxAppContext *context,
                                 NxIntervalId timer_ID)) ;

extern  int  NxRemoveWorkProc P_((NxAppContext *context,
                                  NxWorkProcId workproc_ID)) ;

extern  int  NxSetDebug P_((NxAppContext *context, int enable)) ;


#endif				/* If this file was not INCLUDE'd previously. */
