#
# Tcl/Tk based news reader - install program
#
# Copyright 1995 - Koert Zeilstra
#
# No warranty - use at your own risk
#

wm title . "Install NewsFlash"

proc install {} \
{
  set bindir [.bindir.entry get]
  set libdir [.libdir.entry get]

  set result [catch \
  { set fp [open "$bindir/newsflash" w]
    puts $fp "#!/bin/sh"
    puts $fp "NF_WISH=nfwish"
    puts $fp "NF_BINDIR=$bindir"
    puts $fp "NF_LIBDIR=$libdir/newsflash"
    puts $fp "PATH=\$NF_BINDIR:\$PATH"
    puts $fp "export NF_WISH NF_LIBDIR PATH"
    puts $fp "exec \$NF_WISH \$NF_LIBDIR/nftcl/nf.tcl \$*"
    close $fp

    exec chmod 755 $bindir/newsflash
    exec cp nfwish $bindir
    exec mkdir -p $libdir/newsflash
    exec cp -pr nftcl $libdir/newsflash
  } msg]
  if {$result} \
  { tk_dialog .error_message "Install error" $msg error 0 "OK" }
}

proc uninstall {} \
{
  set bindir [.bindir.entry get]
  set libdir [.libdir.entry get]
  set result [catch \
  {
    exec rm -f $bindir/newsflash
    exec rm -f $bindir/nfwish
    exec rm -rf $libdir/newsflash
  } msg]
  if {$result} \
  { tk_dialog .error_message "Install error" $msg error 0 "OK" }
}

frame .bindir
label .bindir.label -text "Binary Directory" -width 20 -anchor w
entry .bindir.entry -width 25
pack .bindir.label .bindir.entry -side left
pack .bindir -side top -fill x

frame .libdir
label .libdir.label -text "Library Directory" -width 20 -anchor w
entry .libdir.entry -width 25
pack .libdir.label .libdir.entry -side left
pack .libdir -side top -fill x

.bindir.entry insert 0 "/usr/local/bin"
.libdir.entry insert 0 "/usr/local/lib"

frame .buttons -relief sunken -bd 1
button .buttons.exit -text "Exit" -width 8 -command "exit"
button .buttons.install -text "Install" -width 8 -command "install"
button .buttons.uninstall -text "Uninstall" -width 8 \
	-command "uninstall"
pack .buttons.exit .buttons.install .buttons.uninstall -side right -padx 3 -pady 3
pack .buttons -side top -fill x



