#
# labelentry.tcl
#
# Copyright 1995 - Koert Zeilstra
#
#
# LabelEntry
#
# Public attributes:
#   -labeltext		label text
#   -labelwidth		label width
#   -entrywidth		entry width
#
# Methods:
#

itcl_class LabelEntry \
{
  constructor {config} \
  {

    #
    #  Create a window with the same name as this object
    #
    set class [$this info class]
    ::rename $this $this-tmp-
    ::frame $this -class $class
    ::rename $this $this-win-
    ::rename $this-tmp- $this

    label $this.label -text $labeltext -anchor e
    if {$labelwidth != ""} \
    { $this.label config -width $labelwidth }
    entry $this.entry
    if {$entrywidth != ""} \
    { $this.entry config -width $entrywidth }
    pack $this.label $this.entry -side left
  }

  destructor {
    ::rename $this-win- {}
  }

  method setEntry {text} \
  {
    $this.entry delete 0 end
    $this.entry insert 0 $text
  }

  method getEntry {} \
  { return [$this.entry get] }

  public labeltext ""
  public labelwidth ""
  public entrywidth ""
}





