#
# Tcl/Tk based news reader
#
# Copyright 1995 - Koert Zeilstra
#
# No warranty - use at your own risk
#

lappend auto_path $env(NF_LIBDIR)/nftcl
wm title . "NewsFlash"

option add *font "-adobe-helvetica-medium-r-normal-*-14-*-*-*-*-*-*-*" widgetDefault
option add *MenuBar*font "-adobe-helvetica-bold-r-normal-*-14-*-*-*-*-*-*-*" widgetDefault
option add *background DarkSeaGreen widgetDefault
option add *activeBackground DarkSeaGreen widgetDefault
option add *MenuBar*activeForeground Blue widgetDefault
option add *highlightBackground DarkSeaGreen widgetDefault
option add *Text.background Gray80 widgetDefault
option add *Text.selectBackground White widgetDefault
option add *Button.background Gray80 widgetDefault
option add *Button.activeBackground Gray90 widgetDefault
option add *Scrollbar.foreground DarkSeaGreen widgetDefault
option add *Scrollbar.activeBackground 	Gray90 widgetDefault
option add *Scrollbar.background DarkSeaGreen widgetDefault
option add *Entry.background White widgetDefault
loadAppDefaults {NewsFlash NEWSFLASH} userDefault

InstallStandardBindings

if 0 \
{ proc tkerror {message} \
  { tk_dialog .error_dialog "NewsFlash Error" $message error 0 "OK" }
}


#
# GroupWindow
#
# Public attributes:
#   -quit_command	command when quit is selected
#
# Methods:
#   clearAllColumns {}
#   addRow {item_list}
#   getRow {row_no}
#
itcl_class GroupWindow \
{
  constructor {config} \
  {
    global ${this}_font ${this}_fontsize
    #
    #  Create a window with the same name as this object
    #
    set class [$this info class]
    ::rename $this $this-tmp-
    ::toplevel $this -class $class
    ::rename $this $this-win-
    ::rename $this-tmp- $this

    wm title $this $appname

    frame $this.menu -relief raised -borderwidth 2 -class MenuBar
    pack $this.menu -side top -fill x

    menubutton $this.menu.file -text "File" -menu $this.menu.file.m\
		-underline 0
    menu $this.menu.file.m
    $this.menu.file.m add command -label "Open.."\
		-command "$this fileOpen" -underline 0
    $this.menu.file.m add command -label "Open .newsrc"\
		-command "$this fileOpenNewsRc" -underline 0
    $this.menu.file.m add command -label "Save"\
		-command "$this fileSave" -underline 0
    $this.menu.file.m add command -label "Save As.."\
		-command "$this fileSave" -underline 0
    $this.menu.file.m add separator
    $this.menu.file.m add command -label "Setup.."\
		-command "$this fileSetup" -underline 0
    $this.menu.file.m add command -label "About.."\
		-command "$this fileAbout" -underline 0
    $this.menu.file.m add separator
    $this.menu.file.m add command -label "Quit"\
		-command "$this fileQuit" -underline 0\
		-accelerator "Ctrl Q"

    menubutton $this.menu.group -text "Group" \
		-menu $this.menu.group.m -underline 0
    menu $this.menu.group.m
    $this.menu.group.m add command -label "Get Article Count"\
		-command "$this fileUpdateGrouplist" -underline 0
    $this.menu.group.m add separator
    $this.menu.group.m add command -label "Open.." \
		-command "$this groupOpen" -underline 0
    $this.menu.group.m add command -label "Open Unthreaded.." \
		-command "$this groupOpenNoThreads" -underline 5
    $this.menu.group.m add separator
    $this.menu.group.m add command -label "Delete" \
		-command "$this groupDelete" -underline 0
    $this.menu.group.m add separator
    $this.menu.group.m add command -label "All Groups.." \
		-command "$this groupSelection" -underline 0

    menubutton $this.menu.option -text "Option" \
		-menu $this.menu.option.m -underline 0
    menu $this.menu.option.m
    $this.menu.option.m add cascade -label "Font" -underline 0 \
	-menu $this.menu.option.m.font
    $this.menu.option.m add cascade -label "Font Size" -underline 0 \
	-menu $this.menu.option.m.fontsize

    set ${this}_font $current_font
    set ${this}_fontsize $current_fontsize

    menu $this.menu.option.m.font
    foreach font $fonts \
    { set name [lindex $font 0]
      set id [lindex $font 1]
      $this.menu.option.m.font add radiobutton -label "$name"\
	-command "$this optionChangeFont $name" -variable ${this}_font
    }
    menu $this.menu.option.m.fontsize
    foreach size $fontsizes \
    { $this.menu.option.m.fontsize add radiobutton -label "$size"\
	-command "$this optionChangeFontSize $size" \
	-variable ${this}_fontsize
    }

    menubutton $this.menu.help -text "Help"\
		-menu $this.menu.help.m -underline 0
    menu $this.menu.help.m
    $this.menu.help.m add command -label "NewsFlash..."\
		-command "$this helpHelp newsflash" -underline 0

    pack $this.menu.file $this.menu.group \
		-ipadx 5 -side left
#    pack $this.menu.help -ipadx 5 -side right
    tk_menuBar $this.menu $this.menu.file $this.menu.group \
		$this.menu.help

    set group_list [MultiColumnList $this.groups 2 \
		{Art Group} -size 5x10 -selectmode single \
		-select_command "$this clickGroup" \
		-doubleclick "$this doubleClickGroup"]
    $group_list setWidth 0 5
    $group_list setWidth 1 35

    pack $group_list -expand yes -fill both

    entry $this.status -state disabled -background Gray
    pack $this.status -side top -fill x

    wm protocol . WM_DELETE_WINDOW "$this fileQuit"

    set group_stat [GroupStat $this.group_stat]
    set app_config [ApplicationConfig $this.app_config]
  }

  destructor \
  { ::rename $this-win- {} }

  method config {config} {}

  method fileOpen {} \
  {
    if {$file_dialog == ""} \
    { set file_dialog [FileSelect $this.file_dialog \
		-title "$appname - Open File"]
    } \
    else \
    { wm deiconify $file_dialog }

    if {[$this.file_dialog activate]} \
    { set current_file [$this.file_dialog get]
      loadNewsRc $current_file
    }

    wm withdraw $file_dialog
  }

  method fileOpenNewsRc {} \
  { global env
    set current_file "$env(HOME)/.newsrc"
    loadNewsRc $current_file
  }

  method fileUpdateGrouplist {} \
  { global env
    updateNewsRc
  }

  method fileSave {} \
  { $group_stat save $current_file }

  method fileSaveAs {} \
  { if {$file_dialog == ""} \
    { set file_dialog [FileSelect $this.file_dialog \
		-title "$appname - Save File"]
    } \
    else \
    { wm deiconify $file_dialog }

    if {[$this.file_dialog activate]} \
    { set current_file [$this.file_dialog get]
      $group_stat save $current_file
    }

    wm withdraw $file_dialog
  }

  method fileAbout {} \
  { tk_dialog $this.about "NewsFlash About" \
	"NewsFlash newsreader\nKoert Zeilstra\nVersion 0.1 - September 1995" info 0 "OK"
  }

  method fileSetup {} \
  { if {$setup_dialog == ""} \
    { set setup_dialog [SetupDialog $this.setup_dialog -main $this \
		-appconfig $app_config \
		-close_command "wm withdraw $this.setup_dialog" \
		-ok_command "$this saveRcFile" -title "Setup"]
    } \
    else \
    { wm deiconify $setup_dialog }
    $setup_dialog readConfig
  }

  method fileQuit {} \
  { set do_quit 1
    if [$group_stat isChanged] \
    { set choice [tk_dialog $this.save_changes "Confirm Quit"\
		"Save article status to file?"\
		question 0 "Yes" "No" "Cancel"]
      switch -exact -- $choice \
      { 0 { fileSave }
        1 { set do_quit 1 }
        2 { set do_quit 0 }
      }
    }
    if $do_quit \
    { if {$nntp_socket != ""} \
      { close $nntp_socket }
      foreach child $child_apps \
      { catch {send $child quitApplication} }
      eval $quit_command
    }
  }

  method groupOpenNoThreads {} \
  { if {$selected_group != ""} \
    { openGroupNoThreads $selected_group }
  }

  method groupOpen {} \
  { if {$selected_group != ""} \
    { openGroup $selected_group }
  }

  method groupDelete {} \
  { if {$selected_group != ""} \
    { $group_stat deleteGroup $selected_group
      $group_list deleteRow $selected_row
    }
  }

  method groupSelection {} \
  { global env
    if {$group_dialog != "" && $group_dialog != "busy"} \
    { if [catch {send $group_dialog raiseWindow}] \
      { set group_dialog "" }
    }
    if {$group_dialog == ""} \
    { set nntp_server [$app_config get nntp_server]
      set nntp_port [$app_config get nntp_port]
      exec $env(NF_WISH) $env(NF_LIBDIR)/nftcl/allgroups.tcl \
		-parent [winfo name .] -nntpserver $nntp_server \
		-nntpport $nntp_port &
      set group_dialog "busy"
    }
  }

  method optionChangeFont {font} \
  {
    set current_font $font
    changeTextFont
  }

  method optionChangeFontSize {size} \
  {
    set current_fontsize $size
    changeTextFont
  }

  method addGroup {group} \
  { $group_list addRow [list "" $group]
    $group_stat addGroup $group
  }

  method openGroup {group} \
  { if {$thread_dialog == ""} \
    { set thread_dialog [ThreadedArticleListDialog $this.thread_dialog \
		-main $this -title "Group Threads" -group_stat $group_stat \
		-closecommand "wm withdraw $this.thread_dialog"]
    } \
    else \
    { wm deiconify $thread_dialog }
    $thread_dialog showGroupArticles $group
  }

  method openGroupNoThreads {group} \
  { if {$articles_dialog == ""} \
    { set articles_dialog [ArticleListDialog $this.articles_dialog \
		-main $this -title "Group" -group_stat $group_stat \
		-closecommand "wm withdraw $this.articles_dialog"]
    } \
    else \
    { wm deiconify $articles_dialog }
    $articles_dialog showGroupArticles $group
  }

  method loadNewsRc {filename} \
  { set no_of_rows 0
    set fp [open $filename r]
    $group_list clearAllColumns
    set line ""
    set max_name 0
    while {[gets $fp line] >= 0} \
    { set name ""
      if [regexp "\.+:" $line] \
      {
        if [regexp "(\[0-9,a-z,A-Z,\.\]+): *(.*)" $line m name art] \
        { $group_list addRow [list "" $name]
          $group_stat setGroupReadArticles $name $art
          set name_length [string length $name]
          if {$name_length > $max_name} \
          { set max_name $name_length }
          incr no_of_rows
        }
      }
    }
    close $fp
    if {$max_name > 0} {$group_list setWidth 1 [expr $max_name*4/5]}
    set selected_group ""
  }

  method updateNewsRc {} \
  { openNntpSocket
    blt_busy hold $this
    update
    set selected_group ""
    $group_list clearSelection
    for {set i 0} {$i<$no_of_rows} {incr i} \
    { set items [$group_list getRow $i]
      set group_name [lindex $items 1]
      dp_send $nntp_socket "group $group_name"
      gets $nntp_socket stat
      set stat [split [string trim $stat] " "]
      set articles [lindex $stat 1]
      $group_list replaceRow $i [list $articles $group_name]
    }
    blt_busy release $this
  }

  method loadRcFile {} \
  { $app_config load $rcfile }

  method saveRcFile {} \
  { $app_config save $rcfile }

  method getConfig {item} \
  { return [$app_config get $item] }

  method clickGroup {row} \
  { set row_items [$group_list getRow $row]
    set selected_group [lindex $row_items 1]
    set selected_row $row
  }

  method doubleClickGroup {row} \
  { set row_items [$group_list getRow $row]
    set selected_group [lindex $row_items 1]
    groupOpen
  }

  method openNntpSocket {} \
  { if {$nntp_socket == ""} \
    { set nntp_socket [lindex [dp_connect \
	[$app_config get nntp_server] [$app_config get nntp_port]] 0]
      gets $nntp_socket line
    }
  }

  method getNntpSocket {} \
  { if {$nntp_socket == ""} \
    { openNntpSocket }
    return $nntp_socket
  }

  method getSignature {} \
  { set filename [$app_config get signature]
    if {$filename == ""} \
    { set signature "" } \
    else \
    { if [catch {set fp [open "$filename" r]} msg] \
      { set signature "Error: $msg" } \
      else \
      { set signature [::read $fp]
        ::close $fp
      }
    }
    return $signature
  }

  method changeTextFont {} \
  {
    set font_id ""
    foreach font $fonts \
    {
      if {[lindex $font 0] == $current_font} \
      { set font_id [lindex $font 1]
      }
    }
    if {$font_id != ""} \
    { set font "-*-${font_id}-*-*-${current_fontsize}-*-*-*-*-*-*-*"
      $this.text config -font $font
    }
  }

  method helpHelp {topic} \
  {
    global env

    set apps [winfo interps]
    set found 0
    foreach app $apps \
    { puts "app: $app"
      if {$app == "help.tcl" } \
      {
        set result [catch [list send $app HelpSetTopic $topic] msg]
        if {$result == 0} \
        {
          set found 1
        }
      }
    }

    if {$found == 0} \
    {
      exec kzwish $env(TKEDIT_DIR)/help.tcl $topic &
    }
  }

  method registerChildApplication {name window_name} \
  {
    lappend child_apps $window_name
    if {$name == "allgroups.tcl"} \
    { set group_dialog $window_name }
  }

  method getAppVersion {} \
  { return "$appname $version" }

  method takeFocus {} \
  {
  }

  public rcfile ""
  public menu_font "-*-helvetica-bold-r-*-14-*"
  public text_font "-*-lucidatypewriter-medium-r-*-*-12-*-*-*-*-*-*-*"
  public quit_command ""
  public fonts {{Helvetica helvetica-medium-r} {Times times-medium-r} {LucidaTypewriter lucidatypewriter-medium-r}}
  public fontsizes {8 10 12 14 18 24 36}
  public appname "NewsFlash"
  public version "0.1"

  protected file_dialog ""
  protected group_list ""
  protected no_of_rows 0
  protected child_apps {}
  protected group_dialog ""
  protected thread_dialog ""
  protected setup_dialog ""
  protected articles_dialog ""
  protected current_font "LucidaTypewriter"
  protected current_fontsize 12
  protected nntp_socket ""
  protected selected_group ""
  protected selected_row ""
  protected group_stat ""
  protected app_config ""
  protected current_file ""
}

proc registerChildApplication {name window_name} \
{ global main
  $main registerChildApplication $name $window_name
}

proc quitApplication {} \
{ global main
  $main fileQuit
}

proc openGroup {group} \
{ global main
  $main openGroup $group
}

proc addGroup {group} \
{ global main
  $main addGroup $group
}

if {[file isdirectory $env(HOME)/.flashrc] == 0} \
{ if [catch {exec mkdir $env(HOME)/.flashrc}] \
  { puts "Could not create directory $env(HOME)/.flashrc"
    exit 1
  }
}

wm withdraw .

set main [GroupWindow .main -quit_command "exit" \
	-rcfile "$env(HOME)/.flashrc/rc"]
$main loadRcFile
# $main loadNewsRc "$env(HOME)/.newsrc"
# pack $main -expand yes -fill both
$main takeFocus






