# $Id: picgroup.tcl,v 1.9 94/02/14 14:54:50 mangin Exp $
set nextGroupId 0

################################################################
####    Bug workaround: the following command allows to     ####
####    reinitialize group tags, ungrouping all objects     ####
################################################################

proc UngroupAll {} {

  [cv] delete sFr

  foreach id [[cv] find withtag all] {
    set tags [[cv] gettags $id]
    lvarrm tags Gr*
    lvarrm tags tGr*
    [cv] itemconfigure $id \
      -tags "$tags Gr.$id tGr.$id"
  }
}

################################################################
####  groups selected items, i.e. update the groupList tag  ####
################################################################

proc Group {} {
  global nextGroupId

  set toptags [getTopGroupTags s]
  if {[lempty $toptags]} {
    warn "No items selected" 2500
    return
  }
  
  set toptags [lrmdups $toptags]
  
  if {[llength $toptags] == 1} {
    warn "Can't group a single item" 2500
    return
  }
  
  ##  add the new group id on head of groupList tag  ##
  ##  for each selected item  ##
  
  set newgid "g[incr nextGroupId]"

  foreach toptag $toptags {
    foreach it [[cv] find withtag $toptag] {
      set tags [[cv] gettags $it]
      set glist [ctail "." [lvarrm tags "Gr*"]]
      lvarrm tags tGr*
      [cv] itemconfigure $it \
	-tags "$tags Gr.$newgid.$glist tGr.$newgid"
    }
  }

  ##  Update selectFrames  ##
  [cv] delete sFr
  putFrame "tGr.$newgid"
  
  #### UNDO DISABLED ####
#  histAdd
}

##################################################################
####  ungroups selected items, i.e. update the groupList tag  ####
##################################################################

proc Ungroup {} {

  set items [[cv] find withtag s]
  if {[lempty $items]} {
    warn "No items selected" 2500
    return
  }

  ##  delete topgroup from groupList tag,  ##
  ##  update topGroup tag,  ##
  ##  and store new top groups  ##
  set newgids {}
  foreach it $items {
    set tags [[cv] gettags $it]
    set gid [lfind $tags Gr*]
    set gid [split [ctail . $gid] "."]
    if {[llength $gid] > 1} {
      lvarrm tags Gr*
      lvarrm tags tGr*
      lvarpop gid
      [cv] itemconfigure $it \
	-tags "$tags Gr.[join $gid "."] tGr.[lindex $gid 0]"
    }
    lappend newgids [lindex $gid 0]
  }

  ##  put a frame around new top groups  ##
  [cv] delete sFr
  foreach gid [lrmdups $newgids] {
    putFrame "tGr.$gid"
  }

  #### UNDO DISABLED ####
#  histAdd
}
	
##
##  Update group tags, i.e. reset the base gtag to item id, 
##    and generate unique group numbers using nextGroupId   
##  Take care of bound objects (e.g. latex text and frame)

proc updateGroupTags {tagOrId} {
  global nextGroupId

  set gidLookup {}
  set idLookup  {}

  foreach id [[cv] find withtag $tagOrId] {
    set tags [[cv] gettags $id]
    lvarrm tags tGr*
    set glist [lvarrm tags Gr*]
    set glist [split [ctail . $glist] "."]
    set lastgid [lvartail glist]

    #  First deal with group ids  #
    set newGlist {}
    foreach gid $glist {
      if {![keylget gidLookup $gid newGid]} {
	set newGid "g[incr nextGroupId]"
	keylset gidLookup $gid $newGid
      }
      lappend newGlist $newGid
    }

    #  Treat the last id  #
    if {![keylget idLookup $lastgid newGid]} {
      set newGid $id
      keylset idLookup $lastgid $newGid
    }

    lappend newGlist $newGid

    [cv] itemconfigure $id \
      -tags "tGr.[lindex $newGlist 0] Gr.[join $newGlist .] $tags"
  }
}

################################################################
####	 Return various group tag infos                     ####
################################################################

proc getGroupListTag {item} {
  return [lfind [[cv] gettags $item] Gr*]
}

proc getTopGroupTags {tagOrId} {
  set gtags {}
  foreach it [[cv] find withtag $tagOrId] {
    set tags [[cv] gettags $it]
    lappend gtags [lfind $tags "tGr*"]
  }
  return [lrmdups $gtags]
}

proc setTopGroup {item gid} {
  set tags [[cv] gettags $item]
  set gtag [lfind $tags "tGr*"]
  [cv] dtag $item $gtag
  [cv] addtag "tGr.$gid" withtag $item
}

