# Animate a grandfather clock

wm withdraw .
set win [applet embedwindow]

proc strip_lead_zeroes {x} {
    regsub {^0+} $x {} x
    if {$x == {}} {return 0} else {return $x}
}

# Get the current time
if {[catch {fmtclock [getclock] {%I %M %S}} currTime]} {
    # Don't have TclX installed, so can't display current time
    set currTime {01 01 01}
}
set hour [strip_lead_zeroes [lindex $currTime 0]]
set mins [strip_lead_zeroes [lindex $currTime 1]]
set sec  [strip_lead_zeroes [lindex $currTime 2]]

set g [canvas $win.grandfather -width 50 -height 200]

# Draw the clock background
$g create polygon 0 0 50 0 50 3 47 3 47 \
	100 50 100 50 200 0 200 0 100 3 100 3 3 0 3 0 0 \
	-fill brown
$g create polygon 10 5 40 5 40 190 10 190 10 5 \
	-fill white
$win window create [applet embedindex] -window $g -align center

# Setup a function to animate the pendulum
set pendtheta 0
proc swing_pendulum {} {
    global g pendtheta pendid

    # Remove the previous pendulum
    $g delete pendrod
    $g delete pendwgt
    # Calculate the pendulum's next position.
    set pendx [expr 25 + 5 * cos($pendtheta)]
    set pendy [expr 180 + abs(sin($pendtheta))]
    # Draw the pendulum
    $g create line 25 50 $pendx $pendy \
	-tag pendrod -fill yellow2
    $g create oval \
	[expr $pendx - 5] [expr $pendy - 5] \
	[expr $pendx + 5] [expr $pendy + 5] \
	-tag pendwgt -fill yellow2
    set pendtheta [expr $pendtheta + 0.1]
    set pendid [after 50 swing_pendulum]
}
# Start the pendulum function
set pendid [after 50 swing_pendulum]

# Remove all functions when another page is loaded
proc terminate {} {
    global pendid
    after cancel $pendid
}

