# ChoiceDialog.tcl - class for displaying a Dialog with message and a number
#                    of choices.
#
# Author: Allan Brighton

itcl_class ChoiceDialog {
    inherit Dialog


    # create the dialog

    constructor {config} {
	Dialog::constructor
	
	pack [Choice $this.choice \
		  -choice $choice \
		  -value $value \
		  -text $label \
		  -layout $layout \
		  -rows $rows \
		  -cols $cols \
		  -anchor $anchor] \
		-in $this.top.ext -side left -fill x -expand 1 \
		-padx 2m -pady 2m -ipady 1m
    }


    # this method is redefined here to change the value
    # that is returned in activate to be the contents of the Choice widget

    method set_result {} {
	global $this.choice
	if {[set $this.choice] == $default} {
	    return [$this.choice get]
	}
	return {}
    }    


    # -- public member variables --

    # list of choices to display
    public choice {}
    
    # default choice
    public value {}

    # label for the choices 
    public label {}

    # set horizontal or vertical layout for choice
    public layout {horizontal}

    # max number of rows to display (0 for unlimited) 
    # note: specify either -rows OR -cols, but not both
    public rows 0

    # max number of columns to display (0 for unlimited)
    # note: specify either -rows OR -cols, but not both
    public cols 0

    # set the label anchor
    public anchor {w}

}

