###############################################################################
# This is a test suite designed to exercise every line of code in two.tcl,
# version 1.  Since I have no code coverage tools for TCL (are there
# any?), I don't know if I've succeeded. 
# 
# One thing the suite doesn't do yet is test for all the error conditions
# with catch. 
#
#		     COPYRIGHT & WARRANTEE DISCLAIMER
#		     --------------------------------
# 	I hereby relinquish all copyrights to this software and place it
# into the public domain. 
# 	IN NO EVENT SHALL THE AUTHORS OR DISTRIBUTORS BE LIABLE TO ANY
# PARTY FOR ERRORS CONTAINED HEREIN OR DIRECT, INDIRECT, SPECIAL,
# INCIDENTAL, OR CONSEQUENTIAL DAMAGES IN CONNECTION WITH THE FURNISHING,
# PERFORMANCE, OR USE OF THIS SOFTWARE, ITS DOCUMENTATION, OR ANY
# DERIVATIVES THEREOF, EVEN IF THE AUTHORS HAVE BEEN ADVISED OF THE
# POSSIBILITY OF SUCH DAMAGE. 
# 	THE AUTHORS AND DISTRIBUTORS SPECIFICALLY DISCLAIM ANY
# WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
# MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, AND NON-INFRINGEMENT. 
# THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, AND THE AUTHORS AND
# DISTRIBUTORS HAVE NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
# UPDATES, ENHANCEMENTS, OR MODIFICATIONS. 
# 
# Andrew Ginter			aginter@cuug.ab.ca
###############################################################################
source two.tcl

# 3 classes with overlapping instance variables
class A {} {a1 # a comment
	    a2 a3}
class B A {b1 b2 a1}
class C B {c1 b1 a1}

# A method so's I can reach inside & look at stuff
method A::eval stuff {eval $stuff}
method B::eval stuff {eval $stuff}
method C::eval stuff {eval $stuff}

# Check constructors & prologues
C obj
delete obj
method C::C {} {set c1 c1 ; set b1 C::b1 ; set a1 C::a1}
method A::A {} {set a1 a1 ; set a2 a2 ; set a3 a3}
C obj
if {[obj A::eval {set a1}] != {a1}} {puts "test 1 failed"}
if {[obj B::eval {set a2}] != {a2}} {puts "test 2 failed"}
if {[obj eval {set a1}] != {C::a1}} {puts "test 3 failed"}

# Check constructor order
set order {}
method C::C {} {
    global order ; lappend order C
    set c1 c1 ; set b1 C::b1 ; set a1 C::a1
}
method B::B {} {
    global order ; lappend order B
    set b1 b1 ; set b2 b2 ; set a1 B::a1
}
method A::A {} {
    global order ; lappend order A
    set a1 a1 ; set a2 a2 ; set a3 a3
}
C obj2
if {$order != {A B C}} {puts "test 4 failed"}

# Check explicit constructor call
method B::B {} {
    $this A::A
    global order ; lappend order B
    set b1 b1 ; set b2 b2 ; set a1 B::a1
}    
set order {}
C obj3
if {$order != {A B C}} {puts "test 5 failed"}

# Check explicit & implicit destructors
method A::~A {} {global order ; lappend order ~A}
method C::~C {} {global order ; lappend order ~C}
set order {}
delete obj3
if {$order != {~C ~A}} {puts "test 6 failed"}

# Check method inheritance
method A::X {} {return X}
if {[obj3 X] != {X}} {puts "test 7 failed"}

# Make sure classes without instance variables work
class D {} {}
method D::boo {} {return booble}
D obj4
if {[obj4 boo] != {booble}} {puts "test 8 failed"}

# Make sure instance variables are being erased
class E {} {e1}
class F E {f1}
method F::eval stuff {eval $stuff}
F obj5
obj5 eval {set e1 e1 ; set f1 f1}
delete obj5
F obj5
if {! [catch {obj5 eval {set e1}}]} {puts "test 9 failed"}
if {! [catch {obj5 eval {set f1}}]} {puts "test 10 failed"}

# Make sure instance var prologues do not clobber method args
method F::foo {e1 f1} {
    if {${E::e1} != {e1} || ${F::f1} != {f1}} {puts "test 11 failed"}
    if {$e1 != {x} || $f1 != {y}} {puts "test 12 failed"}
}
obj5 eval {set e1 e1 ; set f1 f1}
obj5 foo x y
