#
# Procedure for rendering a process 'busy'
#


set TH(Busy) 0


# Renders process busy while doing command carried in args.
# W is a widget to display the busy cursor in.
proc th_busy {w args} {
  global TH

  if {!$TH(Busy)} {
    set TH(Busy) 1
    set parent [winfo toplevel $w]
    set cursor [$w cget -cursor]
    set title [wm title $parent]
    if {[set iconname [wm iconname $parent]] == ""} {
      set iconname $title}
  
    # Indicate process is busy
    $w configure -cursor watch
    wm title $parent "*BUSY $title"
    wm iconname $parent "* $iconname"
    update

    set error [catch {uplevel #0 $args} result]
  
    # Free up program now.
    $w configure -cursor $cursor
    wm title $parent $title
    wm iconname $parent $iconname
    update
  
    set TH(Busy) 0
  } else {
    set error [catch {uplevel #0 $args} result]
  }
  if $error {  error $result} else {  return $result
}}
