# button.tcl --
#
# This demonstration script creates a toplevel window containing
# several button widgets.
#
# @(#) button.tcl 1.1 95/05/26 15:56:26

set w .button
catch {destroy $w}
toplevel $w
wm title $w "Button Demonstration"
wm iconname $w "button"
positionWindow $w

label $w.msg -font $font -wraplength 4i -justify left \
    -text {{^NbNƁA{^̔wiF̃{^ɏĂFɂȂ܂B{^{^ւ̈ړ̓^uƂł\łB܂Xy[XŎs邱Ƃł܂B}
pack $w.msg -side top

frame $w.buttons
pack  $w.buttons -side bottom -expand y -fill x -pady 2m
button $w.buttons.dismiss -text  -command "destroy $w"
button $w.buttons.code -text "R[hQ" -command "showCode $w"
pack $w.buttons.dismiss $w.buttons.code -side left -expand 1

button $w.b1 -text "Peach Puff" -width 10 \
	-command "$w config -bg PeachPuff1"
button $w.b2 -text "Light Blue" -width 10 \
	-command "$w config -bg LightBlue1"
button $w.b3 -text "Sea Green" -width 10 \
	-command "$w config -bg SeaGreen2"
button $w.b4 -text "Yellow" -width 10 \
	-command "$w config -bg Yellow1"
pack $w.b1 $w.b2 $w.b3 $w.b4 -side top -expand yes -pady 2
