# style.tcl --
#
# This demonstration script creates a text widget that illustrates the
# various display styles that may be set for tags.
#
# @(#) style.tcl 1.2 95/06/15 13:17:04

set w .style
catch {destroy $w}
toplevel $w
wm title $w "Text Demonstration - Display Styles"
wm iconname $w "style"
positionWindow $w

frame $w.buttons
pack  $w.buttons -side bottom -expand y -fill x -pady 2m
button $w.buttons.dismiss -text  -command "destroy $w"
button $w.buttons.code -text "R[hQ" -command "showCode $w"
pack $w.buttons.dismiss $w.buttons.code -side left -expand 1

text $w.text -yscrollcommand "$w.scroll set" -setgrid true \
	-width 70 -height 32 -wrap word
scrollbar $w.scroll -command "$w.text yview"
pack $w.scroll -side right -fill y
pack $w.text -expand yes -fill both

# Set up display styles

global msg_kanji_font
$w.text tag configure bold -font -*-Courier-Bold-O-Normal--*-120-*-*-*-*-*-*
$w.text tag configure big -font -*-Courier-Bold-R-Normal--*-140-*-*-*-*-*-* \
	-kanjifont $msg_kanji_font
$w.text tag configure verybig -font \
	-*-Helvetica-Bold-R-Normal--*-240-*-*-*-*-*-*
$w.text tag configure small -font -Adobe-Helvetica-Bold-R-Normal-*-100-* \
	-kanjifont $kanji_font
if {[winfo depth $w] > 1} {
    $w.text tag configure color1 -background #a0b7ce
    $w.text tag configure color2 -foreground red
    $w.text tag configure raised -relief raised -borderwidth 1
    $w.text tag configure sunken -relief sunken -borderwidth 1
} else {
    $w.text tag configure color1 -background black -foreground white
    $w.text tag configure color2 -background black -foreground white
    $w.text tag configure raised -background white -relief raised \
	    -borderwidth 1
    $w.text tag configure sunken -background white -relief sunken \
	    -borderwidth 1
}
$w.text tag configure bgstipple -background black -borderwidth 0 \
	-bgstipple gray25
$w.text tag configure fgstipple -fgstipple gray50
$w.text tag configure underline -underline on
$w.text tag configure overstrike -overstrike on
$w.text tag configure right -justify right
$w.text tag configure center -justify center
$w.text tag configure super -offset 4p \
	-font -Adobe-Courier-Medium-R-Normal--*-100-*-*-*-*-*-*
$w.text tag configure sub -offset -2p \
	-font -Adobe-Courier-Medium-R-Normal--*-100-*-*-*-*-*-*
$w.text tag configure margins -lmargin1 12m -lmargin2 6m -rmargin 10m
$w.text tag configure spacing -spacing1 10p -spacing2 2p \
	-lmargin1 12m -lmargin2 6m -rmargin 10m

$w.text insert end {̂悤ɃeLXg widget ͏lXȃX^Cŕ\邱
ł܂B}
$w.text insert end ^O big
$w.text insert end {ƂJjYŃRg[܂B
^OƂ̓eLXg widget ̂镶 (͈̔)ɑ΂ēKpł
PȂ閼ÔƂłB^O͗lXȕ\X^Cɐݒł܂B
ݒ肷ƁÃ^Ô͎w肵X^Cŕ\
悤ɂȂ܂Bgpł\X^C͎̒ʂłB
}
$w.text insert end {
1. tHg} big
$w.text insert end {    ǂ X ̃tHgłg܂B}
$w.text insert end large verybig
$w.text insert end {
Ƃ}
$w.text insert end {} small
$w.text insert end {ƂB
}
$w.text insert end {
2. F} big
$w.text insert end {  }
$w.text insert end {wiF} color1
$w.text insert end {}
$w.text insert end {OiF} color2
$w.text insert end {}
$w.text insert end {} {color1 color2}
$w.text insert end {Ƃς邱Ƃł܂B
}
$w.text insert end {
3. Ԃ} big
$w.text insert end {  ̂悤ɕ`̍ۂ}
$w.text insert end {wi} bgstipple
$w.text insert end {} fgstipple
$w.text insert end {PȂhԂ
łȂAԂgƂł܂B
}
$w.text insert end {
4. } big
$w.text insert end {  ̂悤}
$w.text insert end {ɉ} underline
$w.text insert end {Ƃł܂B
}
$w.text insert end {
5. ł} big
$w.text insert end {  ̂悤}
$w.text insert end {ɏd˂Đ} overstrike
$w.text insert end {Ƃł܂B
}
$w.text insert end {
6. 3D } big
$w.text insert end {  wiɘgāA}
$w.text insert end {яo} raised
$w.text insert end {悤ɂ}
$w.text insert end {} sunken
$w.text insert end {
悤ɂł܂B
}
$w.text insert end {
7. s} big
$w.text insert end { ̂悤ɍs
}
$w.text insert end {ɑ
}
$w.text insert end {Eɑ, 
} right
$w.text insert end {^ɑł܂B
} center
$w.text insert end {
8. tƓY}  big
$w.text insert end {  10}
$w.text insert end {n} super
$w.text insert end { ̂悤ɌťʂA}
$w.text insert end {
X}
$w.text insert end {i} sub
$w.text insert end {̂悤ɓY̌ʂoƂł܂B
}
$w.text insert end {
9. }[W} big
$w.text insert end {eLXg̍ɗ]ȋ󔒂}
$w.text insert end {uƂł܂:
}
$w.text insert end {̒i̓}[W̎gpłBXN[} margins
$w.text insert end {Ő܂Ԃĕ\Ă1s̃eLXgłB} margins
$w.text insert end {ɂ2ނ̃}[W܂B} margins
$w.text insert end {1sڂɑ΂̂ƁA} margins
$w.text insert end {2sڈȍ~̘A}[W} margins
$w.text insert end {łB܂Eɂ}[W܂B} margins
$w.text insert end {s̐܂Ԃʒu߂邽߂Ɏgp邱Ƃł܂B
} margins
$w.text insert end {
10. Xy[VO} big
$w.text insert end {3̃p[^ōs̃Xy[VO}
$w.text insert end {䂷
邱Ƃł܂BSpacing1ŁAs}
$w.text insert end {ɂǂ̂炢̋ԂuA
spacing3}
$w.text insert end {ōs̉ɂǂ̂炢̋ԂuA}
$w.text insert end {s܂ԂĂȂ
΁Aspacing2ŁA}
$w.text insert end {eLXgs𐶐Ăs̊Ԃɂǂ̂炢}
$w.text insert end {̋Ԃu
܂B
}
$w.text insert end {̃Cfgꂽi͂ǂ̂悤} spacing
$w.text insert end {Xy[VOŝ܂B} spacing
$w.text insert end {ei͎ۂ̓eLXgwidget} spacing
$w.text insert end {1sŁAwidgetɂĐ܂܂Ă܂B
} spacing
$w.text insert end {Spacing1͂̃eLXgł10point} spacing
$w.text insert end {ݒ肳Ă܂B} spacing
$w.text insert end {ɂAi̊Ԃɑ傫ȊԊu} spacing
$w.text insert end {݂Ă܂B} spacing
$w.text insert end {Spacing22pointɐݒ肳Ă܂B} spacing
$w.text insert end {Œi̒ɂق̏Ԋu݂Ă܂B} spacing
$w.text insert end {Spacing3̗͂ł͎gpĂ܂B
} spacing
$w.text insert end {Ԋuǂɂ邩΁A̒i} spacing
$w.text insert end {ȂŃeLXgIĂBI} spacing
$w.text insert end {]ɂ͗]ɂƂꂽԊu} spacing
$w.text insert end {܂܂Ă܂B
} spacing
