# Voreinstellungsmen fr Drucker
#
# Copyright (C) 1994  G. Lamprecht, W. Lotz, R. Weibezahn; LRW c/o Uni Bremen


proc prt_select {s1 s2} {# get options after selection according to 
                         # s1 (== prtselstr) and s2 (!= "" if landsc./portrait)
                         # return 1 if selection successfull, 0 otherwise
  global  vv drselmax dvsep lpcmd lpopt prtformat prtfmtli prmtext prmsel olsep
  global  printer prtdriver prtoptions prtsuf prtpresel prtselstr opsep

  if {![info exists drselmax]} {
    set foid [open_vst printing.vst]
    # read first line, get number of criteris from it
    getscl $foid ein;  set dvsep [string index [string trim $ein] 0]
    set drselmax 2
    while {[getvalue $ein [expr $drselmax+9] $dvsep] != ""} {incr drselmax}
    close $foid
  }

  set k [string trim [string range $s1 1 [expr [string length $s1]-2]]]
  for {set n $drselmax} {$n>=0} {incr n -1} {
    set p [string last "," $k]
    set kl($n) [string trim [string range $k [expr $p+1] end]]
    set k [string trim [string range $k 0 [expr $p-1]]]
  }
  set oldfmt $prtformat
  set foid [open_vst printing.vst]
  getscl $foid ein; # skip first line
  while {[getscl $foid ein] > 0} {
    set selected 0
    set z [split $ein $dvsep]
    if {[string trim [lindex $z 1]]==$kl(1)} {# printer name O.K.
      set prnt $kl(1);     incr selected   
      if {"[string trim [lindex $z 2]]:[string trim [lindex $z 3]]"==$kl(2)} {
        incr selected;     # emulation and driver O.K.
        set pttext   [string trim [lindex $z 1]]
        set pdriver  [string trim [lindex $z 3]]
        set psuf     [string trim [lindex $z 4]]
        set poptions [string trim [lindex $z 5]]
        set lcmd     [string trim [lindex $z 6]]
        set lopt     [string trim [lindex $z 7]]
        set plp "";   set pprt ""
        if {[string trim [lindex $z 0]]==$kl(0)} {# printer text O.K.
          set ptext "$kl(0), $kl(1), $kl(2)";     incr selected   
          for {set n 3} {$n<=$drselmax} {incr n} {# check next criterium
            set sn [split [string trim [lindex $z [expr $n+8]]] ","]
	    if {$n == 3} {# set list of all possible formats for this printer
              set prtfmtli ""
              foreach i $sn {# set list of all possible formats for this printer
                regsub -all "\{" $i " \{" lien
                set prtfmtli "$prtfmtli [lindex $lien 0]"
              }
	    }
	    if {($n == 3) && ($s2 != "")} {# format change is demanded
              foreach i $sn {# look for old format hit and new format hit
                if {[string first "$kl(3)" $i]==0} {# old format hit
                  foreach j $sn {# look for new format hit
                    if {[string first "$s2" $j]==0} {# new format hit
                      regsub -all "\{" $j " \{" ss
                      set pprt [string trim [lindex $ss 1]]
                      set plp  [string trim [lindex $ss 2]]
                      set ptext "$ptext, [lindex $ss 0]"
                      incr selected; break
                    }
                  }
                }
	      }
	    } else {# no format change or other criterium than format
              foreach i $sn {
                if {[string first "$kl($n)" $i]==0} {
                  regsub -all "\{" $i " \{" ss
		  if {$n == 3} {
                    set pprt [string trim [lindex $ss 1]]
                    set plp  [string trim [lindex $ss 2]]
                  } else {
                    set poptions [string trim "$poptions [lindex $ss 1]"]
                    set lopt     [string trim "$lopt [lindex $ss 2]"]
                  }
                  set ptext "$ptext, [string trim [lindex $ss 0]]"
                  incr selected; break
                }
	      }
	    }
          }
        }
        if {![info exists prtmftli]} \
            {set prtfmtli \n$vv(dvns1)\n$vv(dvns2)\n$vv(xt32)\n$vv(xt33)\n}
      }
    }
    if {![info exists prtmftli]} \
            {set prtfmtli \n$vv(dvns1)\n$vv(dvns3)\n$vv(xt32)\n$vv(xt33)\n}
    if {$selected == [expr $drselmax+1]} break
  }
  close $foid
  if {$selected == [expr $drselmax+1]} {
    set prtselstr  $ptext
    update_prtformat
    set printer    $prnt
    set prtdriver  $pdriver
    set prtsuf     $psuf
    set lpcmd      $lcmd
    if {$s2 == ""} {
      set prtoptions "$opsep $poptions $opsep $pprt"
      set lpopt      "$olsep $lopt $olsep $plp"
    } else {
      set prtoptions "$opsep [lindex [split $prtoptions $opsep] 1] $opsep $pprt"
      set lpopt      "$olsep [lindex [split $lpopt $olsep] 1] $olsep $plp"
    }
    set prmtext "";  set prmsel ""
    if {[winfo exists .dv]} {
      .dv.cb delete 0 end
      .dv.cb insert end "$prtoptions"
      .dv.cd delete 0 end
      .dv.cd insert end "$lpopt"
      dvanzeige;   dvanzeigen "$vv(aus0)"
    }
    if {($oldfmt != $prtformat) && ($s2 == "")} {
      format_switch  .dv.d.tt $prtformat  1
    }
  }
  if {$selected == [expr $drselmax+1]} {return 1} else {return 0}
}


proc dv  {} {

global  vv hlp_dir  drselmax prmtext prmsel prtformat lpcmd lpopt sizeds
global  printer prtdriver prtpresel prtselstr prtoptions prtfilperm


toplevel .dv
wm title .dv "$vv(dvvor)"
wm minsize .dv 0 0


set tyh 20


proc dvanzeige {} {
  global vv printer prtselstr
  if {$printer==""} {set t "$vv(dvbad1)"} else {set t "$vv(dvbad2) $prtselstr"}
 .dv.b.ad configure -text "$t" 
}

proc dvanzeigen {s1} {
  global  vv prtselstr printer prtdriver prtoptions prtsuf lpcmd lpopt prtpresel
  global  prtformat
  writescr0 .dv.d.tt "$s1\n\n" \
                     "$prtselstr\n\n" \
                     " $vv(dv2)  $printer\n" \
                     " $vv(dv4)  $prtdriver\n" \
                     " $vv(dv6)  $prtformat\n" \
                     " $vv(dv7)  $prtoptions\n" \
                     " $vv(dv10) $prtsuf\n" \
                     " $vv(dv3)  $lpcmd\n" \
                     " $vv(dv8)  $lpopt\n" \
                     " $vv(dv5)  $prtpresel\n\n"
}

proc drlistfill {} {# fills the "printer list" in the "printer settings" menu
                     # by reading file printing.vst, respecting criteria setting
  global  vv printer prtdriver prtpresel prtselstr prtoptions
  global  drselmax drsel drseltit drseln dvsep prtsuf vd drselnm lpcmd lpopt

  if {[winfo exists .ds]} {
    .ds.b.n configure -text "$vv(dsb1)"
    for {set n 0} {$n<$drselmax} {incr n} {.ds.c.$n.d configure -text $drsel($n)}
    update idletasks
  }

  set foid [open_vst printing.vst]
  # read first line, get separator and titles for selection criteria from it
  getscl $foid ein;  set dvsep [string index [string trim $ein] 0]
  set drseltit(0) [getvalue $ein 1 $dvsep]
  set drseltit(1) "[getvalue $ein 2 $dvsep]:[getvalue $ein 3 $dvsep]"
  set drselmax 2
  while {[getvalue $ein [expr $drselmax+9] $dvsep] != ""} {incr drselmax}
  for {set n 0} {$n < $drselmax} {incr n} {set drsel($n) [lindex $prtpresel $n]}
  for {set n 2} {$n <= $drselmax} {incr n} {
    set drseltit($n) [getvalue $ein [expr $n+9] $dvsep]
  }
  # read 2. and following lines
  .dv.c.2.fr.li delete 0 end; set drseln 0
  while {[getscl $foid ein] > 0} {
    set z [split $ein $dvsep]
    if {[drlistfill1 $z]} {
      foreach k [array names vd] {
        .dv.c.2.fr.li insert end $vd($k)
        unset vd($k)
      }
    }
  }
  close $foid
  if {[winfo exists .ds]} {
    .ds.b.n configure -text "$vv(dsb1)  $drseln  $vv(dsb2)  $drselnm  $vv(dsb3)"
  }
}

proc drlistfill1 {z} {# tests, if a line of file "printing.vst" fits actual
                      # criteria and sets global variable vd to the line(s)
                      # to be added to the printer list
  global drsel drselmax vd dvsep drseln

  set hs [string trim [lindex $z 1]]
  if {("$drsel(0)" != "*") && ("$drsel(0)" != "$hs")} {
    return 0
  } else {
    set vd(0) "[lindex $z 0], $hs"
  }
  set hs "[string trim [lindex $z 2]]:[string trim [lindex $z 3]]"
  if {("$drsel(1)" != "*") && ("$drsel(1)" != "$hs")} {
    return 0
  } else {
    set vd(0) "$vd(0), $hs"
  }
  for {set n 2} {$n<$drselmax} {incr n} {
    set sn [split [string trim [lindex $z [expr $n+9]]] ","]
    foreach k [array names vd] {
      foreach i $sn {
        regsub -all "\{" $i " \{" lien
        set crit [lindex $lien 0]
        if {("$crit"=="$drsel($n)") || ("$drsel($n)"=="*")} {
          set vd($k,"$crit") "$vd($k), $crit"
        }
      }
      unset vd($k)
    }
  }
  set anz [array size vd]
  if {$anz == 0} {unset vd}
  incr drseln $anz
  return $anz
}

proc drfmtwahl {fmtneu} {
  global  vv prtformat

  writescr0 .dv.d.tt ""
  set fmtalt $prtformat
  format_switch  .dv.d.tt  "$fmtneu"  3
  if {"$fmtneu" != "$fmtalt"} {
    set prtformat $fmtneu
    if {[winfo exists .pv]} {prvlistfill}
  }
}



# Bereich a fuer erste Buttons

frame .dv.a
pack configure .dv.a -in .dv -pady 10 -anchor w -fill x

frame .dv.a.1 -relief raised -borderwidth 1
frame .dv.a.2 -relief raised -borderwidth 1
pack configure .dv.a.1 -in .dv.a -side left -anchor w -pady 3
pack configure .dv.a.2 -in .dv.a -side right -padx 3
 
button .dv.a.1.e -text "$vv(ae)"
bind   .dv.a.1.e <Button-3> {+ cat_file0 "${hlp_dir}z_vstquit.hlp" .dv.d.tt}
button .dv.a.1.h -text "$vv(ah)" 
bind   .dv.a.1.h <Any-Button> {+ cat_file0 "${hlp_dir}dv_h.hlp" .dv.d.tt}
button .dv.a.1.l -text "$vv(al)" -command {clearscr .dv.d.tt}
bind   .dv.a.1.l <Button-3> {+ cat_file0 "${hlp_dir}z_loeschetf.hlp" .dv.d.tt}
button .dv.a.1.g -text "$vv(ag)" -command {
  set foid [open_vst default.vst]
    while {[getscl $foid ein] > 0} {
    mtest $ein 19 printer
    mtest $ein 19 lpcmd
    mtest $ein 19 lpopt
    mtest $ein 19 prtdriver
    mtest $ein 19 prtpresel
    mtest $ein 19 prtselstr
    mtest $ein 19 prtoptions
    mtest $ein 19 prtsuf
    mtest $ein 19 prtfilperm
 }
  update_prtformat
  close $foid
  .dv.cb delete 0 end
  .dv.cb insert end "$prtoptions"
  .dv.cd delete 0 end
  .dv.cd insert end "$lpopt"
  dvanzeige;   dvanzeigen "$vv(ausg1)"
  drlistfill
}
bind   .dv.a.1.g <Button-3> {+ cat_file0 "${hlp_dir}dv_grund.hlp" .dv.d.tt}
pack configure .dv.a.1.e .dv.a.1.h .dv.a.1.l .dv.a.1.g -in .dv.a.1 -side left -padx 3 -pady 3

button .dv.a.2.s -text "$vv(dvas)" -command {
  if {$drselmax == "0"} {
    writescr0 .dv.d.tt "\n$vv(dsex)\n"; bell
  } else {
    ds
    bind .ds.a.1.e <ButtonRelease-1> {+
      destroy .ds; .dv.a.2.s configure -state normal; update idletasks
    }
  }
} 
bind   .dv.a.2.s <Button-3> {+ cat_file0 "${hlp_dir}dv_drvsel.hlp" .dv.d.tt}
pack configure .dv.a.2.s -in .dv.a.2


# Bereich bv fuer eigene Einstellungen

frame .dv.bv
pack configure .dv.bv -in .dv -pady 13 -anchor w

label  .dv.bv.dv -text "$vv(bvdv)"  -width 23 -anchor w
bind   .dv.bv.dv <Button-3> {+ cat_file0 "${hlp_dir}z_voreinst1.hlp" .dv.d.tt}
button .dv.bv.va -text "$vv(bvva)" -command {dvanzeigen "$vv(aus0)"}
bind   .dv.bv.va <Button-3> {+ cat_file0 "${hlp_dir}z_voreinst1.hlp" .dv.d.tt}
pack configure .dv.bv.dv .dv.bv.va -in .dv.bv -side left


# Bereich b fuer Anzeigen   

frame .dv.b
pack configure .dv.b -in .dv -anchor w

label .dv.b.ad -width 100 -anchor w
bind  .dv.b.ad <Button-3> {+ cat_file0 "${hlp_dir}dv_anzeig.hlp" .dv.d.tt}
pack configure .dv.b.ad -in .dv.b -anchor w
dvanzeige


# Bereich c fuer Wechsel   

frame .dv.c
pack configure .dv.c -in .dv -anchor w

# Bereich c1 fuer Druckerauswahl
    
frame .dv.c.1
frame .dv.c.2
  
pack configure .dv.c.1 -in .dv.c -anchor w
pack configure .dv.c.2 -in .dv.c 

label .dv.c.1.dl -text "$vv(dvc1dl)" -anchor w
bind  .dv.c.1.dl <Button-3> {+ cat_file0 "${hlp_dir}dv_drusel.hlp" .dv.d.tt}
pack configure .dv.c.1.dl -in .dv.c.1 -anchor w -pady 3

frame .dv.c.2.fr -relief raised -borderwidth 2 
pack configure .dv.c.2.fr -in .dv.c.2 -anchor w

scrollbar .dv.c.2.fr.sb -command ".dv.c.2.fr.li yview"
bind      .dv.c.2.fr.sb <Button-3> {+ cat_file0 "${hlp_dir}dv_drusel.hlp" .dv.d.tt}
listbox   .dv.c.2.fr.li -yscroll ".dv.c.2.fr.sb set" -geometry $sizeds
bind      .dv.c.2.fr.li <Button-3> {+ cat_file0 "${hlp_dir}dv_drusel.hlp" .dv.d.tt}
bind      .dv.c.2.fr.li <Triple-Button-1> {}
bind      .dv.c.2.fr.li <Double-Button-1> {
  set ii [catch {selection get} k]
  if {!$ii} {prt_select "$k" ""} else {writescr0 .dv.d.tt "\n $vv(el)\n\n";bell}
  selection clear .dv.c.2.fr.li
}
pack configure .dv.c.2.fr.sb .dv.c.2.fr.li -in .dv.c.2.fr -side right -fill y

drlistfill


# Ausgabe und Veraendern der Optionen-Strings

label .dv.ca -text "$vv(dvca)" 
bind  .dv.ca <Button-3> {+ cat_file0 "${hlp_dir}dv_optedi.hlp" .dv.d.tt}
pack configure .dv.ca -in .dv -anchor sw

entry .dv.cb -width 100 -relief sunken
      .dv.cb delete 0 end 
      .dv.cb insert end "$prtoptions"
bind  .dv.cb <Button-3> {+ cat_file0 "${hlp_dir}dv_optedi.hlp" .dv.d.tt}
bind  .dv.cb <Return> {
  set prtoptions  [string trim [.dv.cb get]]
  writescr0 .dv.d.tt "$vv(aus4) $prtoptions\n"
  focus none
}
pack configure .dv.cb -in .dv -anchor nw
focus none

label .dv.cc -text "$vv(dvcc)" 
bind  .dv.cc <Button-3> {+ cat_file0 "${hlp_dir}dv_droptedi.hlp" .dv.d.tt}
pack configure .dv.cc -in .dv -anchor sw

entry .dv.cd -width 100 -relief sunken
      .dv.cd delete 0 end 
      .dv.cd insert end "$lpopt"
bind  .dv.cd <Button-3> {+ cat_file0 "${hlp_dir}dv_droptedi.hlp" .dv.d.tt}
bind  .dv.cd <Return> {
  set lpopt  [string trim [.dv.cd get]]
  writescr0 .dv.d.tt "$vv(aus4) $lpopt\n"
  focus none
}
pack configure .dv.cd -in .dv -anchor nw
focus none


# Bereich d fuer Hilfe-Ausgaben

frame .dv.d -relief raised -borderwidth 2
pack configure .dv.d -in .dv -anchor sw -pady 6

scrollbar .dv.d.sb -command ".dv.d.tt yview"
bind      .dv.d.sb <Button-3> {+ cat_file0 "${hlp_dir}z_textfeld.hlp" .dv.d.tt}
text      .dv.d.tt -yscroll ".dv.d.sb set" -height $tyh -width 90
bind      .dv.d.tt <Button-3> {+ cat_file0 "${hlp_dir}z_textfeld.hlp" .dv.d.tt}
pack configure .dv.d.sb .dv.d.tt -in .dv.d -side right -fill y
.dv.d.tt configure -state disabled

}
