# execute additional programs:  $utcmd $utoptions  with file  $ut_file
#                                 in background if  $utback = "&"  
#                                 with backup-file if  $utbackup = "1"  
#
# Copyright (C) 1994  G. Lamprecht, W. Lotz, R. Weibezahn; LRW c/o Uni Bremen

proc utility {f austext} {

  upvar 1 $austext a

  global  vv utcmd utoptions ut_file utback utbackup

  set a ""

  writescr0 $f "[datime] $vv(so6) $utcmd$utback $utoptions $ut_file"

  if { $utoptions == "-analyse" } { # file analysis only
    set zwischendateiname ""
  } else {                           # file converting
    set zwischendateiname ".tmp"
    unlink -nocomplain $zwischendateiname
  } 


  eval mkCmd_wait $f $utcmd [list "$utoptions $ut_file $zwischendateiname"]
  
  if { $utoptions != "-analyse" } {

# return value of conversion = 0, thus tempfile -> original file:
    if { $utbackup == "1" } {
      set dateiliste [lsort [glob -nocomplain -- *]]
      set i 1
      while { [string match "*$ut_file-$i.bak*" "$dateiliste"]!=0 } {incr i}
      set backupdateiname "$ut_file-$i.bak"
    } else {
      set backupdateiname "/tmp/$ut_file"
    }

    if { [file exists "$zwischendateiname"] } {
      set a "${a}\nursprngliche Datei ---> $backupdateiname"
      exec mv $ut_file $backupdateiname
      exec mv $zwischendateiname $ut_file
      set a "${a}\numcodierte Datei    ---> $ut_file"
    }
  }

  writescr $f "\n[datime] fertig!\n "

}
