# Text chapter
proc ScrolledText { f width height } {
	frame $f
	# The setgrid setting allows the window to be resized.
	text $f.text -width $width -height $height \
		-setgrid true -wrap none \
		-xscrollcommand [list $f.xscroll set] \
		-yscrollcommand [list $f.yscroll set]
	scrollbar $f.xscroll -orient horizontal \
		-command [list $f.text xview]
	scrollbar $f.yscroll -orient vertical \
		-command [list $f.text yview]
	pack $f.xscroll -side bottom -fill x
	pack $f.yscroll -side right -fill y
	# The fill and expand are needed when resizing.
	pack $f.text -side left -fill both -expand true
	pack $f -side top -fill both -expand true
	return $f.text
}
proc ScrolledTextTest {} {
    catch {destroy .f}
    set t [ScrolledText .f 40 8]
    set in [open /etc/passwd]
    $t insert end [read $in]
    close $in
}
