#!/home/bwelch/bin/wish -f
# Canvas chapter

source random.tcl

randomInit [pid]

set W 50
set dW [expr $W/2]
set H 50
canvas .c -width $W -height $H -scrollregion "0 0 $W $H"
pack .c

set T 0
set Tleft $T
set Tright [expr $T + $W]
set L 0

set tag "left-$T"	;# Cannot just be a number.  No spaces, either.
set lasttag {}

proc Xload {cmd} {
    global T L lastL H W dW tag lasttag Tright Tleft
    set L [eval $cmd]
    if {$T > 0} {
	.c create line [expr $T-1-$Tleft] $lastL [expr $T-$Tleft] $L -tag $tag
    }
    set lastL $L
    incr T
    if {($T % $dW) == 0} {
	# Change tag every half screen
	if [string length $lasttag] {
	    .c delete $lasttag
	}
	set lasttag $tag
	set tag "left-$T"
    }
    if {$T >= $Tright} {
	.c move $lasttag -$dW 0
	incr Tright $dW
	incr Tleft $dW
    }
    after 1000 [list Xload $cmd]

}

# Xload {random 100}
#Xload {expr ($L + 1) % $H}
Xload {expr $H * [string trim [lindex [exec uptime] 9] ,]}
