'\"
'\" Copyright (c) 2001 by Jean-Luc Fontaine <jfontain@free.fr>.
'\" This code may be distributed under the same terms as Tcl.
'\"
'\" $Id: stooop.n,v 1.2 2001/12/10 09:07:31 jfontain Exp $
'\" The definitions below are for supplemental macros used in Tcl/Tk
'\" manual entries.
'\"
'\" .AP type name in/out ?indent?
'\"	Start paragraph describing an argument to a library procedure.
'\"	type is type of argument (int, etc.), in/out is either "in", "out",
'\"	or "in/out" to describe whether procedure reads or modifies arg,
'\"	and indent is equivalent to second arg of .IP (shouldn't ever be
'\"	needed;  use .AS below instead)
'\"
'\" .AS ?type? ?name?
'\"	Give maximum sizes of arguments for setting tab stops.  Type and
'\"	name are examples of largest possible arguments that will be passed
'\"	to .AP later.  If args are omitted, default tab stops are used.
'\"
'\" .BS
'\"	Start box enclosure.  From here until next .BE, everything will be
'\"	enclosed in one large box.
'\"
'\" .BE
'\"	End of box enclosure.
'\"
'\" .CS
'\"	Begin code excerpt.
'\"
'\" .CE
'\"	End code excerpt.
'\"
'\" .VS ?version? ?br?
'\"	Begin vertical sidebar, for use in marking newly-changed parts
'\"	of man pages.  The first argument is ignored and used for recording
'\"	the version when the .VS was added, so that the sidebars can be
'\"	found and removed when they reach a certain age.  If another argument
'\"	is present, then a line break is forced before starting the sidebar.
'\"
'\" .VE
'\"	End of vertical sidebar.
'\"
'\" .DS
'\"	Begin an indented unfilled display.
'\"
'\" .DE
'\"	End of indented unfilled display.
'\"
'\" .SO
'\"	Start of list of standard options for a Tk widget.  The
'\"	options follow on successive lines, in four columns separated
'\"	by tabs.
'\"
'\" .SE
'\"	End of list of standard options for a Tk widget.
'\"
'\" .OP cmdName dbName dbClass
'\"	Start of description of a specific option.  cmdName gives the
'\"	option's name as specified in the class command, dbName gives
'\"	the option's name in the option database, and dbClass gives
'\"	the option's class in the option database.
'\"
'\" .UL arg1 arg2
'\"	Print arg1 underlined, then print arg2 normally.
'\"
'\" RCS: @(#) $Id: man.macros,v 1.1 2000/03/06 21:34:53 ericm Exp $
'\"
'\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
'\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1	\\fI\\$2\\fP	(\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
'\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
'\"	# BS - start boxed text
'\"	# ^y = starting y location
'\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
'\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
'\"	# VS - start vertical sidebar
'\"	# ^Y = starting y location
'\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
'\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
'\"	# Special macro to handle page bottom:  finish off current
'\"	# box/sidebar if in box/sidebar mode, then invoked standard
'\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
'\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
'\"	# DE - end display
.de DE
.fi
.RE
.sp
..
'\"	# SO - start of list of standard options
.de SO
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 4c 8c 12c
.ft B
..
'\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\fBoptions\\fR manual entry for details on the standard options.
..
'\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
'\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
'\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.de UL
\\$1\l'|0\(ul'\\$2
..
.TH stooop n 1.0 Stooop "Simple Tcl Only Object Oriented Programming"
.BS
'\" Note: do not modify the .SH NAME line immediately below!
.SH NAME
::stooop \- Object oriented extension.
.SH SYNOPSIS
\fBpackage require Tcl 8.3\fR
.sp
\fBpackage require stooop 4.2\fR
.br
\fBnamespace import stooop::*\fR
.sp
\fBclass\fR \fIname body\fR
.sp
\fBnew\fR \fIclass ?arg arg ...?\fR
.sp
\fBdelete\fR \fIobject ?object ...?\fR
.sp
\fBvirtual\fR \fIproc name {\fR\fBthis\fR \fI?arg arg ...?} ?body?\fR
.sp
\fBclassof\fR \fIobject\fR
.sp
\fBnew\fR \fIobject\fR
.BE
.SH DESCRIPTION
.PP
This package provides commands to extend Tcl in an object oriented manner, using a familiar C++ like syntax and behaviour. Stooop only introduces a few new commands: \fBclass\fR, \fBnew\fR, \fBdelete\fR, \fBvirtual\fR and \fBclassof\fR. Along with a few coding conventions, that is basically all you need to know to use stooop. Stooop is meant to be as simple to use as possible. 
.sp
This manual is very succinct and is to be used as a quick reminder for the programmer, who should have read the thorough \fIstooop.html\fR HTML documentation at this point.
.TP
\fBclass\fR \fIname body\fR
This command creates a class. The body, similar in contents to a Tcl namespace (which a class actually also is), contains member procedure definitions. Member procedures can also be defined outside the class body, by prefixing their name with \fIclass::\fR, as you would proceed with namespace procedures.
.RS
.TP
\fIproc class {\fR\fBthis\fR \fI?arg arg ...?} ?base {?arg arg ...?} ...? body\fR
This is the constructor procedure for the class. It is invoked following a \fInew\fR invocation on the class. It must have the same name as the class and a first argument named \fIthis\fR. Any number of base classes specifications, including arguments to be passed to their constructor, are allowed before the actual body of the procedure.
.TP
\fIproc ~class {\fR\fBthis\fR\fI} body\fR
This is the destructor procedure for the class. It is invoked following a \fIdelete\fR invocation. Its name must be the concatenation of a single \fI~\fR character followed by the class name (as in C++). It must have a single argument named \fIthis\fR.
.TP
\fIproc name {\fR\fBthis\fR \fI?arg arg ...?} body\fR
This is a member procedure of the class, as its first argument is named \fIthis\fR. It allows a simple access of member data for the object referenced by \fIthis\fR inside the procedure. For example: \fIset ($this,data) 0\fR.
.TP
\fIproc name {?arg arg ...?} body\fR
This is a static (as in C++) member procedure of the class, as its first argument is not named \fIthis\fR. Static (global) class data can be accessed as in: \fIset (data) 0\fR.
.TP
\fIproc class {\fR\fBthis copy\fI} body\fR
This is the optional copy procedure for the class. It must have the same name as the class and exactly 2 arguments named \fIthis\fR and \fIcopy\fR. It is invoked following a \fInew\fR invocation on an existing object of the class.
.RE
.TP
\fBnew\fR \fIclass ?arg arg ...?\fR
This command is used to create an object. The first argument is the class name and is followed by the arguments needed by the corresponding class constructor. A unique identifier for the object just created is returned.
.TP
\fBdelete\fR \fIobject ?object ...?\fR
This command is used to delete one or several objects. It takes one or more object identifiers as argument(s).
.TP
\fBvirtual\fR \fIproc name {\fR\fBthis\fR \fI?arg arg ...?} ?body?\fR
The \fIvirtual\fR specifier may be used on member procedures to achieve dynamic binding. A procedure in a base class can then be redefined (overloaded) in the derived class(es). If the base class procedure is invoked on an object, it is actually the derived class procedure which is invoked, if it exists. If the base class procedure has no body, then it is considered to be a pure virtual and the derived class procedure is always invoked. 
.TP
\fBclassof\fR \fIobject\fR
This command returns the class of the existing object passed as single parameter.
.TP
\fBnew\fR \fIobject\fR
This command is used to create an object by copying an existing object. The copy constructor of the corresponding class is invoked if it exists, otherwise a simple copy of the copied object data members is performed.
.SH DEBUGGING
.TP
Environment variables
.RS
.TP
STOOOPCHECKDATA
Setting this variable to any true value will cause stooop to check for invalid member or class data access.
.TP
STOOOPCHECKPROCEDURES
Setting this variable to any true value will cause stooop to check for invalid member procedure arguments and pure interface classes instanciation.
.TP
STOOOPCHECKALL
Setting this variable to any true value will cause stooop to activate both procedure and data member checking.
.TP
STOOOPCHECKOBJECTS
Setting this variable to any true value will cause stooop to activate object checking. The following stooop namespace procedures then become available for debugging: \fIprintObjects\fR, \fIrecord\fR and \fIreport\fR.
.TP
STOOOPTRACEPROCEDURES
Setting this environment variable to either \fIstdout\fR, \fIstderr\fR or a file name, activates procedure tracing. The stooop library will then output to the specified channel 1 line of informational text for each member procedure invocation.
.TP
STOOOPTRACEPROCEDURESFORMAT
Defines the trace procedures output format. Defaults to \fI"class: %C, procedure: %p, object: %O, arguments: %a"\fR.
.TP
STOOOPTRACEDATA
Setting this environment variable to either \fIstdout\fR, \fIstderr\fR or a file name, activates data tracing. The stooop library will then output to the specified channel 1 line of informational text for each member data access.
.TP
STOOOPTRACEDATAFORMAT
Defines the trace data output format. Defaults to \fI"class: %C, procedure: %p, array: %A, object: %O, member: %m, operation: %o, value: %v"\fR.
.TP
STOOOPTRACEDATAOPERATIONS
When tracing data output, by default, all read, write and unsetting accesses are reported, but the user can set this variable to any combination of the \fIr\fR, \fIw\fR and \fIu\fR letters for more specific tracing (please refer to the \fItrace\fR Tcl manual page for more information).
.TP
STOOOPTRACEALL
Setting this environment variable to either \fIstdout\fR, \fIstderr\fR or a file name, enables both procedure and data tracing.
.RE
.TP
\fB::stooop::printObjects\fR \fI?pattern?\fR
Prints an ordered list of existing objects, in creation order, oldest first. Each output line contains the class name, object identifier and the procedure within which the creation occured. The optional pattern argument (as in the Tcl \fIstring match\fR command) can be used to limit the output to matching class names.
.TP
\fB::stooop::record\fR
When invoked, a snapshot of all existing stooop objects is taken. Reporting can then be used at a later time to see which objects were created or deleted in the interval.
.TP
\fB::stooop::report\fR \fI?pattern?\fR
Prints the created and deleted objects since the \fIstooop::record\fR procedure was invoked last. If present, the pattern argument limits the output to matching class names.
.SH EXAMPLES
Please see the \fIstooop.html\fR HTML documentation.
.SH KEYWORDS
class object oriented C++
