'\" -*- tcl -*- doctools manpage
'\"
'\" Generated from ../tcllib/modules/nntp/nntp.man by mpexpand with fmt.nroff
'\"
.so man.macros
.TH "nntp" n 1.5.1 nntp "Tcl NNTP Client Library"
.BS
.SH NAME
nntp \- Tcl client for the NNTP protocol
.SH "SYNOPSIS"
package require \fBTcl 8.2\fR
.sp
package require \fBnntp ?0.2?\fR
.sp
\fB::nntp::nntp\fR ?\fIhost\fR? ?\fIport\fR? ?\fInntpName\fR?\fR
.sp
\fInntpName\fR \fBmethod\fR ?\fIarg arg ...\fR?\fR
.sp
\fInntpName\fR \fBarticle\fR ?\fImsgid\fR?\fR
.sp
\fInntpName\fR \fBauthinfo\fR ?\fIuser\fR? ?\fIpass\fR?\fR
.sp
\fInntpName\fR \fBbody\fR ?\fImsgid\fR?\fR
.sp
\fInntpName\fR \fBdate\fR\fR
.sp
\fInntpName\fR \fBgroup\fR ?\fIgroup\fR?\fR
.sp
\fInntpName\fR \fBhead\fR ?\fImsgid\fR?\fR
.sp
\fInntpName\fR \fBhelp\fR\fR
.sp
\fInntpName\fR \fBlast\fR\fR
.sp
\fInntpName\fR \fBlist\fR\fR
.sp
\fInntpName\fR \fBlistgroup\fR ?\fIgroup\fR?\fR
.sp
\fInntpName\fR \fBmode_reader\fR\fR
.sp
\fInntpName\fR \fBnewgroups\fR \fIsince\fR\fR
.sp
\fInntpName\fR \fBnewnews\fR\fR
.sp
\fInntpName\fR \fBnewnews\fR \fIsince\fR\fR
.sp
\fInntpName\fR \fBnewnews\fR \fIgroup\fR ?\fIsince\fR?\fR
.sp
\fInntpName\fR \fBnext\fR\fR
.sp
\fInntpName\fR \fBpost\fR \fIarticle\fR\fR
.sp
\fInntpName\fR \fBslave\fR\fR
.sp
\fInntpName\fR \fBstat\fR ?\fImsgid\fR?\fR
.sp
\fInntpName\fR \fBquit\fR\fR
.sp
\fInntpName\fR \fBxgtitle\fR ?\fIgroup_pattern\fR?\fR
.sp
\fInntpName\fR \fBxhdr\fR \fIfield\fR ?\fIrange\fR?\fR
.sp
\fInntpName\fR \fBxover\fR ?\fIrange\fR?\fR
.sp
\fInntpName\fR \fBxpat\fR \fIfield\fR \fIrange\fR ?\fIpattern_list\fR?\fR
.sp
.BE
.SH "DESCRIPTION"
The package \fBnntp\fR provides a simple Tcl-only client library
for the NNTP protocol.  It works by opening the standard NNTP socket
on the server, and then providing a Tcl API to access the NNTP
protocol commands.  All server errors are returned as Tcl errors
(thrown) which must be caught with the Tcl \fBcatch\fR command.
.SH "COMMANDS"
.TP
\fB::nntp::nntp\fR ?\fIhost\fR? ?\fIport\fR? ?\fInntpName\fR?\fR
The command opens a socket connection to the specified NNTP server and
creates a new nntp object with an associated global Tcl command whose
name is \fInntpName\fR. This command may be used to access the various
NNTP protocol commands for the new connection. The default \fIport\fR
number is "119" and the default \fIhost\fR is "news". These defaults
can be overridden with the environment variables \fBNNTPPORT\fR and
\fBNNTPHOST\fR respectively.
.sp
Some of the commands supported by this package are not part of the
nntp rfc (rfc 977) and will not be available (or implemented) on all
nntp servers.
.sp
The access command \fInntpName\fR has the following general form:
.RS
.TP
\fInntpName\fR \fBmethod\fR ?\fIarg arg ...\fR?\fR
\fIOption\fR and the \fIarg\fRs determine the exact behavior of the
command.
.RE
.TP
\fInntpName\fR \fBarticle\fR ?\fImsgid\fR?\fR
Query the server for article \fImsgid\fR from the current group.  The article
is returned as a valid tcl list which contains the headers, followed by
a blank line, and then followed by the body of the article. Each element
in the list is one line of the article.
.TP
\fInntpName\fR \fBauthinfo\fR ?\fIuser\fR? ?\fIpass\fR?\fR
Send authentication information (username and password) to the server.
.TP
\fInntpName\fR \fBbody\fR ?\fImsgid\fR?\fR
Query the server for the body of the article \fImsgid\fR from the current
group.  The body of the article is returned as a valid tcl list. Each element
in the list is one line of the body of the article.
.TP
\fInntpName\fR \fBdate\fR\fR
Query the server for the servers current date.  The date is returned in the
format \fBYYYYMMDDHHMMSS\fR.
.TP
\fInntpName\fR \fBgroup\fR ?\fIgroup\fR?\fR
Optionally set the current group, and retrieve information about the
currently selected group.  Returns the estimated number of articles in
the group followed by the number of the first article in the group, followed
by the last article in the group, followed by the name of the group.
.TP
\fInntpName\fR \fBhead\fR ?\fImsgid\fR?\fR
Query the server for the headers of the article \fImsgid\fR from the current
group.  The headers of the article are returned as a valid tcl list. Each element
in the list is one line of the headers of the article.
.TP
\fInntpName\fR \fBhelp\fR\fR
Retrieves a list of the commands that are supported by the news server that
is currently attached to.
.TP
\fInntpName\fR \fBlast\fR\fR
Sets the current article pointer to point to the previous message (if there is
one) and returns the msgid of that message.
.TP
\fInntpName\fR \fBlist\fR\fR
Returns a tcl list of valid newsgroups and associated information.  Each
newsgroup is returned as an element in the tcl list with the following format:
.sp
group last first p
.sp
where <group> is the name of the newsgroup, <last> is the number of
the last known article currently in that newsgroup, <first> is the
number of the first article currently in the newsgroup, and <p> is
either 'y' or 'n' indicating whether posting to this newsgroup is
allowed ('y') or prohibited ('n').
.sp
The <first> and <last> fields will always be numeric.  They may have
leading zeros.  If the <last> field evaluates to less than the
<first> field, there are no articles currently on file in the
newsgroup.
.TP
\fInntpName\fR \fBlistgroup\fR ?\fIgroup\fR?\fR
Query the server for a list of all the messages (message numbers) in the
group specified by the argument \fIgroup\fR or by the current group if
the \fIgroup\fR argument was not passed.
.TP
\fInntpName\fR \fBmode_reader\fR\fR
Query the server for its nntp 'MODE READER' response string.
.TP
\fInntpName\fR \fBnewgroups\fR \fIsince\fR\fR
Query the server for a list of all the new newsgroups created since the time
specified by the argument \fIsince\fR.  The argument \fIsince\fR can be any
time string that is understood by \fBclock scan\fR. The tcl list of newsgroups
is returned in a similar form to the list of groups returned by the
\fBBnntpName list\fR command.  Each element of the list has the form:
.sp
group last first p
.sp
where <group> is the name of the newsgroup, <last> is the number of
the last known article currently in that newsgroup, <first> is the
number of the first article currently in the newsgroup, and <p> is
either 'y' or 'n' indicating whether posting to this newsgroup is
allowed ('y') or prohibited ('n').
.TP
\fInntpName\fR \fBnewnews\fR\fR
Query the server for a list of new articles posted to the current group in the
last day.
.TP
\fInntpName\fR \fBnewnews\fR \fIsince\fR\fR
Query the server for a list of new articles posted to the current group since
the time specified by the argument \fIsince\fR.  The argument \fIsince\fR can
be any time string that is understood by \fBclock scan\fR.
.TP
\fInntpName\fR \fBnewnews\fR \fIgroup\fR ?\fIsince\fR?\fR
Query the server for a list of new articles posted to the group specified by
the argument \fIgroup\fR since the time specified by the argument \fIsince\fR
(or in the past day if no \fIsince\fR argument is passed.  The argument
\fIsince\fR can be any time string that is understood by \fBclock scan\fR.
.TP
\fInntpName\fR \fBnext\fR\fR
Sets the current article pointer to point to the next message (if there is
one) and returns the msgid of that message.
.TP
\fInntpName\fR \fBpost\fR \fIarticle\fR\fR
Posts an article of the form specified in RFC 850 to the current news group.
.TP
\fInntpName\fR \fBslave\fR\fR
Identifies a connection as being made from a slave nntp server. This might
be used to indicate that the connection is serving multiple people and should
be given priority.  Actual use is entirely implementation dependent and may
vary from server to server.
.TP
\fInntpName\fR \fBstat\fR ?\fImsgid\fR?\fR
The stat command is similar to the article command except that no
text is returned.  When selecting by message number within a group,
the stat command serves to set the current article pointer without
sending text. The returned acknowledgment response will contain the
message-id, which may be of some value.  Using the stat command to
select by message-id is valid but of questionable value, since a
selection by message-id does NOT alter the "current article pointer"
.TP
\fInntpName\fR \fBquit\fR\fR
Gracefully close the connection after sending a NNTP QUIT command down
the socket.
.TP
\fInntpName\fR \fBxgtitle\fR ?\fIgroup_pattern\fR?\fR
Returns a tcl list where each element is of the form:
.sp
newsgroup description
.sp
If a \fIgroup_pattern\fR is specified then only newsgroups that match
the pattern will have their name and description returned.
.TP
\fInntpName\fR \fBxhdr\fR \fIfield\fR ?\fIrange\fR?\fR
Returns the specified header field value for the current message or for a
list of messages from the current group.  \fIfield\fR is the title of a
field in the header such as from, subject, date, etc.  If \fIrange\fR is
not specified or is "" then the current message is queried.  The command
returns a list of elements where each element has the form of:
.sp
msgid value
.sp
Where msgid is the number of the message and value is the value set for the
queried field.  The \fIrange\fR argument can be in any of the following forms:
.RS
.TP
\fB""\fR
The current message is queried.
.TP
\fBmsgid1-msgid2\fR
All messages between msgid1 and msgid2 (including msgid1 and msgid2) are queried.
.TP
\fBmsgid1 msgid2\fR
All messages between msgid1 and msgid2 (including msgid1 and msgid2) are queried.
.RE
.TP
\fInntpName\fR \fBxover\fR ?\fIrange\fR?\fR
Returns header information for the current message or for a range of messages
from the current group.  The information is returned in a tcl list
where each element is of the form:
.sp
msgid subject from date idstring bodysize headersize xref
.sp
If \fIrange\fR is not specified or is "" then the current message is queried.
The \fIrange\fR argument can be in any of the following forms:
.RS
.TP
\fB""\fR
The current message is queried.
.TP
\fBmsgid1-msgid2\fR
All messages between msgid1 and msgid2 (including msgid1 and msgid2) are queried.
.TP
\fBmsgid1 msgid2\fR
All messages between msgid1 and msgid2 (including msgid1 and msgid2) are queried.
.RE
.TP
\fInntpName\fR \fBxpat\fR \fIfield\fR \fIrange\fR ?\fIpattern_list\fR?\fR
Returns the specified header field value for a specified message or for a
list of messages from the current group where the messages match the
pattern(s) given in the pattern_list.  \fIfield\fR is the title of a
field in the header such as from, subject, date, etc.  The information is
returned in a tcl list where each element is of the form:
.sp
msgid value
.sp
Where msgid is the number of the message and value is the value set for the
queried field.  The \fIrange\fR argument can be in any of the following forms:
.RS
.TP
\fBmsgid\fR
The message specified by msgid is queried.
.TP
\fBmsgid1-msgid2\fR
All messages between msgid1 and msgid2 (including msgid1 and msgid2) are queried.
.TP
\fBmsgid1 msgid2\fR
All messages between msgid1 and msgid2 (including msgid1 and msgid2) are queried.
.RE
.SH "KEYWORDS"
news, nntp, nntpclient
