[comment {-*- tcl -*- doctools manpage}]
[manpage_begin fileutil n 1.4]
[moddesc   {file utilities}]
[titledesc {Procedures implementing some file utilities}]
[require Tcl 8]
[require fileutil [opt 1.4]]
[description]
[para]

This package provides implementations of standard unix utilities.

[list_begin definitions]


[call [cmd ::fileutil::cat] [arg filename]]

A tcl implementation of the UNIX [syscmd cat] command.  Returns the
contents of the specified file. The first argument is the name of the
file to read.


[call [cmd ::fileutil::fileType] [arg filename]]

An implementation of the UNIX [syscmd file] command, which uses
various heuristics to guess the type of a file.  Returns a list
specifying as much type information as can be determined about the
file, from most general (eg, "binary" or "text") to most specific (eg,
"gif").  For example, the return value for a GIF file would be "binary
graphic gif".  The command will detect the following types of files:
directory, empty, binary, text, script (with interpreter), executable
elf, graphic gif, graphic jpeg, html, xml (with doctype if available),
message pgp, and link.


[call [cmd ::fileutil::find] [opt "[arg basedir] [opt [arg filtercmd]]"]]

An implementation of the unix command [syscmd find]. Adapted from the
Tcler's Wiki. Takes at most two arguments, the path to the directory
to start searching from and a command to use to evaluate interest in
each file. The path defaults to [file .], i.e. the current
directory. The command defaults to the empty string, which means that
all files are of interest. The command takes care [strong not] to
loose itself in infinite loops upon encountering circular link
structures.  The result of the command is a list containing the paths
to the interesting files.


[call [cmd ::fileutil::findByPattern] [arg basedir] [opt [option -regexp]|[option -glob]] [opt [option --]] [arg patterns]]

This command is based upon the [package TclX] command

[cmd recursive_glob], except that it doesn't allow recursion over more
than one directory at a time. It uses [cmd ::fileutil::find]
internally and is thus able to and does follow symbolic links,
something the [package TclX] command does not do. First argument is
the directory to start the search in, second argument is a list of
[arg patterns]. The command returns a list of all files reachable
through [arg basedir] whose names match at least one of the
patterns. The options before the pattern-list determine the style of
matching, either regexp or glob. glob-style matching is the default if
no options are given. Usage of the option [option --] stops option
processing. This allows the use of a leading '-' in the patterns.


[call [cmd ::fileutil::foreachLine] [arg {var filename cmd}]]

The command reads the file [arg filename] and executes the script

[arg cmd] for every line in the file. During the execution of the
script the variable [arg var] is set to the contents of the current
line. The return value of this command is the result of the last
invocation of the script [arg cmd] or the empty string if the file was
empty.


[call [cmd ::fileutil::grep] [arg pattern] [opt [arg files]]]

Implementation of [syscmd grep]. Adapted from the Tcler's Wiki. The
first argument defines the [arg pattern] to search for. This is
followed by a list of [arg files] to search through. The list is
optional and [strong stdin] will be used if it is missing. The result
of the procedures is a list containing the matches. Each match is a
single element of the list and contains filename, number and contents
of the matching line, separated by a colons.



[call [cmd ::fileutil::stripN] [arg path] [arg n]]

Removes the first [arg n] elements from the specified [arg path] and
returns the modified path. If [arg n] is greater than the number of
components in [arg path] an empty string is returned.

[call [cmd ::fileutil::stripPwd] [arg path]]

If the [arg path] is inside of the directory returned by

[lb][cmd pwd][rb] it is made relative to that directory. In other
words, the current working directory is stripped from the [arg path].
The possibly modified path is returned as the result of the command.


[call [cmd ::fileutil::touch] [opt [option -a]] [opt [option -c]] [opt [option -m]] [opt "[option -r] [arg ref_file]"] [opt "[option -t] [arg time]"] [arg filename] [opt [arg ...]]]

Implementation of [syscmd touch]. Alter the atime and mtime of the
specified files. If [option -c], do not create files if they do not
already exist. If [option -r], use the atime and mtime from

[arg ref_file]. If [option -t], use the integer clock value

[arg time]. It is illegal to specify both [option -r] and

[option -t]. If [option -a], only change the atime. If [option -m],
only change the mtime.

[list_end]


[keywords {file utilities}]
[manpage_end]
