[manpage_begin stack n 1.2.1]
[moddesc   {Tcl Data Structures}]
[titledesc {Create and manipulate stack objects}]
[require Tcl 8.2]
[require struct [opt 1.2.1]]
[description]

The [cmd ::struct::stack] command creates a new stack object with an
associated global Tcl command whose name is [emph stackName].  This
command may be used to invoke various operations on the stack.  It has
the following general form:

[list_begin definitions]

[call [arg stackName] [cmd option] [opt [arg "arg arg ..."]]]

[arg Option] and the [arg arg]s determine the exact behavior of the
command.  The following commands are possible for stack objects:


[call [arg stackName] [cmd clear]]

Remove all items from the stack.


[call [arg stackName] [cmd destroy]]

Destroy the stack, including its storage space and associated command.


[call [arg stackName] [cmd peek] [opt "[arg count]"]]

Return the top [arg count] items of the stack, without removing them from
the stack.  If [arg count] is not specified, it defaults to 1.  If
[arg count] is 1, the result is a simple string; otherwise, it is a
list.  If specified, [arg count] must be greater than or equal to 1.
If there are no items on the stack, this command will return

[arg count] empty strings.


[call [arg stackName] [cmd pop] [opt "[arg count]"]]

Return the top [arg count] items of the stack, and remove them
from the stack.  If [arg count] is not specified, it defaults to 1.
If [arg count] is 1, the result is a simple string; otherwise, it is a
list.  If specified, [arg count] must be greater than or equal to 1.
If there are no items on the stack, this command will return

[arg count] empty strings.


[call [arg stackName] [cmd push] [arg item] [opt "[arg "item ..."]"]]

Push the [arg item] or items specified onto the stack.  If more than
one [arg item] is given, they will be pushed in the order they are
listed.


[call [arg stackName] [cmd size]]

Return the number of items on the stack.


[list_end]

[keywords queue matrix tree graph]
[manpage_end]
