#!/home/kcorey/hack/tk4.1b2/unix/wish
#
# Copyright (c) 1994-1996 Sun Microsystems, Inc.
#
# See the file "license.txt" for information on usage and redistribution
# of this file, and for a DISCLAIMER OF ALL WARRANTIES.
#
# main program for the menu editor (kac 4/22/96)

# Global Array
set tk_strictMotif 1
set menued_parms(width) 0
set menued_parms(height) 0
set menued_parms(highidx) 0
set menued_parms(version) {0.1}
set menued_parms(postedMb) {}
set menued_parms(cursor) {}
set menued_parms(relief) {}
set menued_parms(focus) {}
set menued_parms(inMenubutton) {}
set menued_parms(rootx) 0
set menued_parms(rooty) 0
set menued_parms(lastConfig) {}
set menued_parms(itemtext) {}
set menued_parms(lrsplit) 900
set menued_parms(configlist) {}
set menued_parms(cascademenu) {}
set menued_parms(cascademenuitem) {}
set menued_parms(autocreatecascade) 1
set menued_parms(autotearoff) 0
set menued_parms(autofill) 0
set menued_parms(autospare) 1
set menued_parms(menufilename) "untitled.mui"
set menued_parms(optionMenuExists) 0
set menued_parms(lastbackground) {}
set menued_parms(html_progress) 0
set menued_parms(lastargs) {}
set menued_parms(menuButtons) -1
set menued_parms(bmconfig) 0
set menued_parms(balloontext) ""
set menued_parms(balloondelay) 100
set menued_parms(balloonlength) 4000
set menued_parms(balloonpending) 0
set menued_parms(balloonerasepending) 0
set menued_parms(balloonhelpforget) 1
set menued_parms(windowcx) 0
set menued_parms(windowcy) 0
set menued_parms(windowcw) 0
set menued_parms(windowch) 0
set menued_parms(windowex) 0
set menued_parms(windowey) 0
set menued_parms(windowew) 0
set menued_parms(windoweh) 0
set menued_parms(help_current) -1
set menued_parms(highidx) 0
set menued_parms(originalsplitterx) 0
set menued_parms(showhelp) 1
menu .junktrashmenu999
set menued_parms(menudefbackground) [.junktrashmenu999 cget -background]
destroy .junktrashmenu999
set menued_parms(menudefhighlightbackground) "#a937fe76fced"

# configure the background so that the highlightframes are the same color
# as the background.
if {[option get . background {}] != ""} {
  option add *highlightBackground [option get . background {}] widgetDefault
}

# An array used to represent the modifiers currently selected
set menued_mods(0) {}

# A structure containing undo information
set undoq(0) {}
set qhead 0
set qhigh 0
set qtail 0

# Debugging output.  *very* copious
set Debug 0
set Debugprefix {}

if {$Debug != 0} {
#    set of [open ".log" "w"]
    set of stdout
    rename focus focus_orig
    proc focus {args} {
	global of
	puts $of "focus on $args"
	eval "focus_orig $args"
    }
    if {[info comm proc_real] != {}} {
        rename proc {}
        rename proc_real proc
    }
    rename proc proc_real
    proc_real proc {command args} {
	global of
	puts $of "Creating $command."
	proc_real $command {args} {
	    global Debugprefix of
	    set command [lindex [info level [info level]] 0]
	    puts $of "${Debugprefix}$command - $args"
	    append Debugprefix "  "
	    set result [uplevel 1 [list ${command}_real] $args]
	    set Debugprefix [string range $Debugprefix 2 900]
	    return $result
	}
	eval [list proc_real ${command}_real] $args
    }
}

# load all support functions.
# menu.tcl  -  Custom versions of the menuing code.
# file.tcl  -  The file support routines, including compilation.
# menu_help.ui.tcl  -  A SpecTcl generated interface to contain the
#              help page.
# help.tcl  -  Support code for version 0.3 of the html library
# html_library.tcl - Version 0.3 of the html library
# filecomp.tcl - A simple file selector.
set menued_parms(basedir) [file dir [info script]]
source [file join $menued_parms(basedir) menu.tcl]
source [file join $menued_parms(basedir) file.tcl]
source [file join $menued_parms(basedir) menuhelp.tcl]
source [file join $menued_parms(basedir) html_lib.tcl]
source [file join $menued_parms(basedir) help.tcl]
source [file join $menued_parms(basedir) filecomp.tcl]

#set up defaults for menubuttons and menus.
foreach q {menubutton menu} {
    $q .def
    set menued_parms(default[winfo class .def]) [.def config]
    destroy .def
}

# Try to figure out the name of our config file...
proc figureoutname {} {
    global env
    set opfile {}
    if {[array names env HOME] != {}} {
	set opfile [file join $env(HOME) .menuedrc]
    } elseif {[file exists {c:\windows}]} {
	set opfile [file join {c:\windows} ".menued.ini"]
    } else {
	# this is a particularly poor choice, because it's a group
	# directory.  Ah well.
	set opfile [file join [file dir [info script]] ".menued.ini"]
    }
    return $opfile
}

# Load all options 
proc loadoptions {} {
    global menued_parms
    set result ""
    set opfile [figureoutname]
    if {[file exists $opfile]} {
	if {[file readable $opfile]} {
	    set file [open $opfile "r"]
	    if {$file != {}} {
		while {![eof $file]} {
		    foreach {x y} [gets $file] {
			set menued_parms($x) $y
		    }
		}
		menued_ballooninsert "Options read from '$opfile'"
		close $file
	    } else {
		tk_dialog .menuediterror "Error" \
		    "I can't open '$opfile' to save the options." \
		    error 0 "Rats!"	
	    }
	} else {
	    tk_dialog .menuediterror "Error" \
		"The file '$opfile' is not readable." \
		error 0 "Rats!"
	}
    }
}

# Save all options	
proc saveoptions {} {
    global menued_parms
    set result ""

	regexp {([0-9]*)x([0-9]*)\+([0-9]*)\+([0-9]*)} [wm geometry $menued_parms(base)] match w h x y
	set menued_parms(windowex) $x
	set menued_parms(windowey) $y
	set menued_parms(windowew) $w
	set menued_parms(windoweh) $h
	regexp {([0-9]*)x([0-9]*)\+([0-9]*)\+([0-9]*)} [wm geometry $menued_parms(base).menus] match w h x y
	set menued_parms(windowcx) $x
	set menued_parms(windowcy) $y
	set menued_parms(windowcw) $w
	set menued_parms(windowch) $h

    foreach i [lsort "[array names menued_parms auto*] [array names menued_parms ball*] [array names menued_parms window*]"] {
	append result "[list $i] [list $menued_parms($i)]\n"
    }
    set opfile [figureoutname]
    set file [open $opfile "w"]
    if {$file != {}} {
	puts $file $result	
	menued_ballooninsert "Options saved in '$opfile'"
	close $file
    } else {
	tk_dialog .menuediterror "Error" \
           "I can't open '$opfile' to save the options." \
	   error 0 "Rats!"	
    }
}
					
# Get the next in a sequential order.  Used to generate unique
# identifiers for menu buttons.
proc nextidx {} {
    global menued_parms
    
    incr menued_parms(highidx)
    return $menued_parms(highidx)
}

# Used to make an option menu.
proc menued_optionMenu {w varName firstValue args} {
    upvar #0 $varName var

    if ![info exists var] {
	set var $firstValue
    }
    if {![winfo exists $w]} {
	set cmd "menubutton $w"
    } else {
	set cmd "$w config"
    }
    eval $cmd {-textvariable $varName -indicatoron 1 -menu $w.menu \
               -relief raised -bd 2 -highlightthickness 2 -anchor c}
    menu $w.menu -tearoff 0
    $w.menu add command -label $firstValue \
	    -command [list set $varName $firstValue]
    foreach i $args {
	$w.menu add command -label $i -command [list set $varName $i]
    }
    return $w.menu
}

# Set this menu to be tear off or not.
proc menued_ToggleTearoff {} {
    global menued_tearoff menued_parms
    
    set a "$menued_parms(base).f"
    set cm [lindex $menued_parms(curMenuItem) 0]
    set cmb $menued_parms(curMenuButton)
    set cmbn $menued_parms(mb$cmb)

    if {$menued_parms(cascademenu) != {}} {
	set curmenu [lindex $menued_parms(cascademenu) 0]
    } else {
	set curmenu "$a.$cmbn.m"
    }
    
    $curmenu config -tearoff $menued_tearoff
}

# Set the modifier keys
proc toggleModKey {m} {
    global menued_mods menued_parms
    set uibase "$menued_parms(base).menus.controls"
    set a "$menued_parms(base).f"
    set cm [lindex $menued_parms(curMenuItem) 0]
    set cmb $menued_parms(curMenuButton)
    set nmb $menued_parms(menuButtons)
    set cmbn $menued_parms(mb$cmb)
    set key {}

    if {$menued_parms(cascademenu) != {}} {
	set curmenu [lindex $menued_parms(cascademenu) 0]
    } else {
	set curmenu "$a.$cmbn.m"
    }

    if {[$curmenu type 0] == "tearoff"} {
	set noTearoff 0
    } else {
	set noTearoff 1
    }
    
    if {$cm > 0} {
	set temp [$curmenu entrycget [expr $cm-$noTearoff] -accel]
	if {![regexp {<.*\-([^\-]*)>} $temp match key]} {
	    regexp {<(.)>} $temp match key 
	}
	set result {}
	foreach i [array names menued_mods] {
	    if {$menued_mods($i) > 0} {
		set result "$i-$result"
	    }
	}
	set result "<$result$key>"
	$uibase.shortcut delete 0 end
	$uibase.shortcut insert 0 "$result"
	$curmenu entryconfig [expr $cm-$noTearoff] -accel $result
    }
}

# Set the alignment of the menu to one side or the other.
proc toggleMenuSide {} {
    global menuside menued_parms
    
    if {$menuside == "right"} {
	set offset 0
    } else {
	set offset 1
    }
    
    if {$offset} {
	#we want to move to the left
	if {$menued_parms(curMenuButton) >= $menued_parms(lrsplit)} {
	    #The current button *will* be affected
	    if {$menued_parms(curMenuButton) == $menued_parms(menuButtons)} {
		#It's the last one, so move *all* to the left
		set menued_parms(lrsplit) 900
	    } else {
		#set the lrsplit to be to the right of this button.
		set menued_parms(lrsplit) [expr $menued_parms(curMenuButton)+$offset]
	    }
	}
    } else {
	if {$menued_parms(curMenuButton) <= $menued_parms(lrsplit)} {
	    #The current button *will* be affected
            #set the lrsplit to be to the left of this button.
	    set menued_parms(lrsplit) [expr $menued_parms(curMenuButton)+$offset]
	}
    }
    repackmenu
}

# Used to create the string that will go in to the menu.  The string
# can be manually changed from the advanced button.
proc menued_filterEntry {k s} {
    global menued_mods menued_parms
    set uibase "$menued_parms(base).menus.controls"
    set a "$menued_parms(base).f"
    set cm [lindex $menued_parms(curMenuItem) 0]
    set cmb $menued_parms(curMenuButton)
    set nmb $menued_parms(menuButtons)
    set cmbn $menued_parms(mb$cmb)

    if {$k == "Up" || $k == "Down" || $k == "Tab" || $k == "Return"} {
#	focus $menued_parms(base).menus.controls.label
	return
    }
    if {$menued_parms(cascademenu) != {}} {
	set curmenu [lindex $menued_parms(cascademenu) 0]
    } else {
	set curmenu "$a.$cmbn.m"
    }

    if {[$curmenu type 0] == "tearoff"} {
	set noTearoff 0
    } else {
	set noTearoff 1
    }
    
    set result {}
    set key {}
    if {$cm > 0 && $k != "Control_L" && $k != "Shift_L" && $k != "Shift_R" && $k != "Meta_L" \
         && $k != "Meta_R" && $k != "Alt_L" && $k != "Caps_Lock" && $k != "Multi_Key" \
         && $k != "Mode_switch"} {
	     set result "$k>"
	     if {$s & 1} {
		 set result "S-$result"
		 set menued_mods(S) 1
	     } else {
		 set menued_mods(S) 0
	     }
	     if {$s & 2} {
		 set result "CLck-$result"
		 set menued_mods(CLck) 1
	     } else {
		 set menued_mods(CLck) 0
	     }
	     if {$s & 4} {
		 set result "^-$result"
		 set menued_mods(^) 1
	     } else {
		 set menued_mods(^) 0
	     }
	     if {$s & 8} {
		 set result "M-$result"
		 set menued_mods(M) 1
	     } else {
		 set menued_mods(M) 0
	     }
	     if {$s & 16} {
		 set result "AltG-$result"
		 set menued_mods(AltG) 1
	     } else {
		 set menued_mods(AltG) 0
	     }
	     if {$s & 32} {
		 set result "NumL-$result"
		 set menued_mods(NumL) 1
	     } else {
		 set menued_mods(NumL) 0
	     }
	     if {$s & 64} {
		 set result "A-$result"
		 set menued_mods(A) 1
	     } else {
		 set menued_mods(A) 0
	     }
	 }
    if {$result != {}} {
	$curmenu entryconfig [expr $cm-$noTearoff] -accel "<$result"
	set menued_parms(configlist) [stripconfig [$curmenu entryconfig [expr $cm-$noTearoff]]]
	$uibase.shortcut delete 0 end
	$uibase.shortcut insert 0 "<$result"
    }
}

# Gets rid of all the currently existing menus, and associated state.
proc menued_eraseMenus {} {
    global menued_parms
    
    set a "$menued_parms(base).f"
    
    for {set i 0} {$i <= $menued_parms(menuButtons)} {incr i} {
	if {[winfo exists $a.$menued_parms(mb$i)]} {
	    destroy $a.$menued_parms(mb$i)
	}
    }

    set menued_parms(mb0) {}
    set menued_parms(curMenuItem) 0
    set menued_parms(curMenuButton) 0
    set menued_parms(menuButtons) -1
    set menued_parms(lrsplit) 900
    $menued_parms(base).menus.controls.label delete 0 end
    set menued_parms(cascademenu) {}
}

# Puts a blank menu structure in.
proc menued_newMenus {} {
    global menued_parms
    
    set a "$menued_parms(base).f"
    menued_eraseMenus
    set menued_parms(mb0) "menubutton#[nextidx]"
    if {$menued_parms(autofill)} {
 	menubutton $a.$menued_parms(mb0) -text "$menued_parms(mb0)" -menu $a.$menued_parms(mb0).m
    } else {
 	menubutton $a.$menued_parms(mb0) -text "" -menu $a.$menued_parms(mb0).m
    }
    bindtags $a.$menued_parms(mb0) [concat meMbResponder meMenubutton [bindtags $a.$menued_parms(mb0)]]
    menu $a.$menued_parms(mb0).m -tearoff $menued_parms(autotearoff)
    bindtags $a.$menued_parms(mb0).m [concat meMenu [bindtags $a.$menued_parms(mb0).m]]
    pack $a.$menued_parms(mb0) -side left
    set menued_parms(curMenuItem) 0
    set menued_parms(curMenuButton) 0
    set menued_parms(menuButtons) 0
    $menued_parms(base).menus.controls.label delete 0 end
    set menued_parms(cascademenu) {}
}

# This handles the nitty-gritty of setting up a widget's balloon help,
# taking the delay into account.
proc menued_ballooninsert {t} {
    global menued_parms
    
    if {$menued_parms(showhelp)} {
	set menued_parms(balloontext) $t
	if {$menued_parms(balloonpending) != {}} {
	    after cancel $menued_parms(balloonpending)
	}
	set menued_parms(balloonpending) [after $menued_parms(balloondelay) "menued_showballoon \[list $t\]"]
    }
}

# Actually show the text of the balloon message, and set the status line
# up to be cleared.
proc menued_showballoon {t} {
    global menued_parms
    
    set menued_parms(balloonpending) {}
    $menued_parms(base).menus.controls.status config -text $t
    if {$menued_parms(balloonerasepending) != {}} {
	after cancel $menued_parms(balloonerasepending)
    }
    if {$menued_parms(balloonhelpforget) == 0} {
	after $menued_parms(balloonlength) menued_hideballoon
    }
}

# Finally clear the status line.
proc menued_hideballoon {} {
    global menued_parms
    
    $menued_parms(base).menus.controls.status config -text {}
}

# Configure a widget to also have some balloon help.
# currently this help is editted via the 'edit code' option of
# SpecTcl.
proc menued_balloontext {w txt} {
    global menued_parms
    
    bind $w <Enter> "+menued_ballooninsert [list $txt]"
    if {$menued_parms(balloonhelpforget)>0} {
	bind $w <Leave> "+menued_hideballoon"
    } else {
	bind $w <Leave> "+menued_ballooninsert {}"
    }
}

# A silly little addition that I put in because it was so simple.
proc menued_clock {} {
    global menued_parms
    
    $menued_parms(base).menus.controls.mode config -text [clock format [clock seconds] -format "%I:%M %p"]
    set menued_parms(clockid) [after 30000 menued_clock]
}

# The main startup routine...draws all windows, and sets up all tags.
proc menued_start {{root .f}} {
    global menued_parms menued_titles menued_mods menued_bhelp
    if {$root == "."} {
	set base ""
    } else {
	set base $root
    }
    if {![winfo exists $base]} {
	toplevel $base
	wm title $base "Menuedit: untitled.mui"
	set temp 1
    } else {
	set temp 0
    }
    
    set menued_parms(base) $base
    
# Set up the "control" window.
    toplevel ${base}.menus
    wm title ${base}.menus "Menuedit: untitled.mui"

    wm resizable [winfo toplevel ${base}.menus] 0 0
    frame ${base}.menus.f -relief raised -bd 2
    set a ${base}.menus.f
    menubutton $a.file -text "File" -menu $a.file.m
    menubutton $a.edit -text "Edit" -menu $a.edit.m
    menubutton $a.options -text "Options" -menu $a.options.m
    menubutton $a.help -text "Help" -menu $a.help.m
    
    menu $a.file.m -tearoff 0
    $a.file.m add command -label {New} -command {menued_eraseMenus;menued_newMenus}
    $a.file.m add separator
    $a.file.m add command -label {Open} -command {menued_doOpen {}}
    $a.file.m add command -label {Save} -command {menued_doSave}
    $a.file.m add command -label {Save as...} -command {menued_doSave {}}
    $a.file.m add command -label {Close} -command {doClose}
    $a.file.m add command -label {Compile to Tcl} -command {menued_compile_tcl}
    $a.file.m add command -label {Compile to Java} -command {menued_compile_java}
    $a.file.m add separator
    $a.file.m add command -label {Quit} -command "menued_exit $root"
    bindtags $a.file.m [concat balloonmenu [bindtags $a.file.m]]

    set menued_bhelp(New) "Create a new menu"
    set menued_bhelp(Open) "Open a menu interface"
    set menued_bhelp(Save) "Save the current interface"
    set menued_bhelp([list "Save as..."]) "Save this interface as a new file"
    set menued_bhelp(Close) "Close this interface"
    set menued_bhelp([list "Compile to Tcl"]) "Compile this interface to Tcl code"
    set menued_bhelp([list "Compile to Java"]) "Compile this interface to Java code"
    set menued_bhelp(Quit) "Exit the menu editor"

    menu $a.edit.m -tearoff 0
    $a.edit.m add command -label {Undo}
    $a.edit.m add separator
    $a.edit.m add command -label {Cut}
    $a.edit.m add command -label {Copy}
    $a.edit.m add command -label {Paste}
    $a.edit.m add command -label {Clear}
    $a.edit.m add separator
    $a.edit.m add command -label {Globals...} -command {menued_editParms}
    bindtags $a.edit.m [concat balloonmenu [bindtags $a.edit.m]]

    set menued_bhelp(Undo) "Undo the last action (Not implemented)"
    set menued_bhelp(Cut) "Cut the current item (Not implemented)"
    set menued_bhelp(Copy) "Copy the current item (Not implemented)"
    set menued_bhelp(Paste) "Paste the current item (Not implemented)"
    set menued_bhelp(Clear) "Clear the current item (Not implemented)"
    set menued_bhelp(Options...) "Modify the applications options"
    
    menu $a.options.m -tearoff 0
    $a.options.m add checkbutton -label {Create Bindings on Compile} -variable menued_parms(createBindings) \
	-command {saveoptions}
    $a.options.m add checkbutton -label {Show Help} -variable menued_parms(showhelp) \
	-command {saveoptions}
    $a.options.m add checkbutton -label {Default name in created item} -variable menued_parms(autofill) \
	-command {saveoptions}
    $a.options.m add checkbutton -label {Add spare items when moving} -variable menued_parms(autospare) \
	-command {saveoptions}
    $a.options.m add checkbutton -label {Automatically create cascades} -variable menued_parms(autocreatecascade) \
	-command {saveoptions}
    $a.options.m add checkbutton -label {Automatically create tearoffs} -variable menued_parms(autotearoff) \
	-command {saveoptions}
    bindtags $a.options.m [concat balloonmenu [bindtags $a.options.m]]

    set menued_bhelp([list "Create Bindings on Compile"]) "Generate bindings for the menus when compiled"
    set menued_bhelp([list "Show Help"]) "Show contextual help in status line"
    set menued_bhelp([list "Default creation text"]) "Put a default name in created items upon creation"
    set menued_bhelp([list "Add spare items"]) "Add a spare item on the end of the menu when moving"
    set menued_bhelp([list "Automatically create cascades"]) "Automatically turn a menu item into a cascade type item"
    set menued_bhelp([list "Automatically create tearoffs"]) "Create tearoff items for each menu when created"
    set menued_parms(createBindings) 1
    set menued_parms(showhelp) 1

    menu $a.help.m -tearoff 0
    $a.help.m add command -label {Help...} -command displayHelp
    
    pack $a.file -side left
    pack $a.edit -side left
    pack $a.options -side left
    pack $a.help -side right
    pack $a -side top -fill x
    
    frame ${base}.menus.controls
    source [file join $menued_parms(basedir) menuctrl.tcl]
    menuctrl_ui ${base}.menus.controls
    pack ${base}.menus.controls -side top -fill both -expand 1

    menued_clock
# Set up the "slave" window     
    frame ${base}.f -relief raised -bd 2
    set a ${base}.f
    
    pack ${base}.f -side top -fill x
    
    menued_eraseMenus
    menued_newMenus
    loadoptions
    
    label ${base}.disclaimer -text "This is the working menu!" -fg blue
    pack ${base}.disclaimer -side top
    bind ${base}.disclaimer <Enter> "focus ${base}.menus.controls.label"
    bind ${base} <Enter> "focus ${base}.menus.controls.label"
    bind ${base}.f <Enter> "focus ${base}.menus.controls.label"

    # This is the splitter bar
    frame ${base}.splitter -width 5 -height 40 -bg black -cursor sb_h_double_arrow
    bind ${base}.splitter <1> {set menued_parms(tsh) $menued_parms(showhelp);set menued_parms(showhelp) 0;bind blockExpose <Expose> {break}}
    bind ${base}.splitter <ButtonRelease-1> {endSplitter %X;set menued_parms(showhelp) $menued_parms(tsh)}
    bind ${base}.splitter <B1-Motion> {moveSplitter %X %Y}
    bind ${base} <Map> "place ${base}.splitter -x \[expr \[winfo width ${base}\] - 5\] -y 0;bind ${base} <Map> {}"
    menued_balloontext ${base}.splitter "Split the menus left and right on this bar"
    set menued_mods(^) {}
    set menued_mods(S) {}
    set menued_mods(AltG) {}
    set menued_mods(A) {}
    set menued_mods(M) {}
    set menued_mods(CLck) {}
    set menued_mods(NumL) {}
    
    bind entryModifier <Any-Key> {+menued_passToWidget %K}
    bind entryLimit <Any-Key> {menued_filterEntry %K %s}
    bind ${base}.menus.controls.shortcut <1> "focus ${base}.menus.controls.sc;break"
    ${base}.menus.controls.sc config -takefocus 1
#    bind entryFocus <Tab> {menued_nextMenu 1;break}
#    bind entryFocus <Shift-Tab> {menued_nextMenu -1;break}
    bind entryFocus <Right> {menued_nextMenu 1;break}
    bind entryFocus <Left> {menued_nextMenu -1;break}
    bind entryFocus <Up> {menued_nextMenuItem -1}
    bind entryFocus <Shift-Down> {menued_nextMenuItem -1}
    bind entryFocus <Shift-Up> {menued_nextMenuItem 1}
    bind entryFocus <Down> {menued_nextMenuItem 1}
    bind entryFocus <Return> {menued_nextMenuItem 1}
    bind entryFocus <d> {if {%s & 4} {menued_DeleteItem}}
    bind balloonmenu <Enter> {+menued_menuMove %W %y %s}
    bind balloonmenu <Motion> {+menued_menuMove %W %y %s}
    bind balloonmenu <Key-Return> {+set menued_parms(help_current) -1}
    bind balloonmenu <Leave> {+set menued_parms(help_current) -1}
    bind balloonmenu <Key-space> {+set menued_parms(help_current) -1}
    bind balloonmenu <ButtonRelease> {+set menued_parms(help_current) -1}
    bind entryFocus <Delete> {menued_DeleteItem;break}
    bind entryFocus <i> {if {%s & 4} {menued_InsertItem;break}}
    bind entryFocus <Insert> {menued_InsertItem;break}
    bind entrycommit <Return> {menued_CommitEntry %W;break}
    bind optionEntry <Return> {menued_optionEntryCommit %W;break}
    bind parmEntry   <Return> {menued_parmEntryCommit %W;break}
    bind meMenu <ButtonRelease-1> {menued_thisMenuItem %W %y;break}
    bind meMbResponder <1> {menued_thisMenuButton %W}
    bindtags ${base}.menus.controls.label [concat entryFocus [bindtags ${base}.menus.controls.label] entryModifier]
    bindtags ${base}.menus.controls.command [concat entrycommit [bindtags ${base}.menus.controls.command]]
    bindtags ${base}.menus.controls.value [concat entrycommit [bindtags ${base}.menus.controls.value]]
    bindtags ${base}.menus.controls.underline [concat entrycommit [bindtags ${base}.menus.controls.underline]]
    bindtags ${base}.menus.controls.variable [concat entrycommit [bindtags ${base}.menus.controls.variable]]
    bindtags ${base}.menus.controls.shortcut [concat entryLimit [bindtags ${base}.menus.controls.shortcut]]
    bindtags ${base}.menus.controls.sc [concat entryLimit [bindtags ${base}.menus.controls.sc]]
    focus ${base}.menus.controls.label
    if {($menued_parms(windowex) != 0 
	 || $menued_parms(windowey)) != 0
	&& $menued_parms(windowew) != 0
	&& $menued_parms(windoweh) != 0} {
	wm geometry ${base} "+$menued_parms(windowex)+$menued_parms(windowey)"
    } else {
	bind ${base}.menus <Map> "\
	    regexp {(\[0-9\]*)x(\[0-9\]*)\[\+\-\](\[0-9\]*)\[\+\-\](\[0-9\]*)} \[wm geometry ${base}.menus\] match w h x y;\
	    wm geometry ${base} \"+\[expr \$x + \$w + 15]+\${y}\";\
            bind ${base}.menus <Map> {}\
        "
    }
    if {($menued_parms(windowcx) != 0 
	 || $menued_parms(windowcy)) != 0
	&& $menued_parms(windowcw) != 0
	&& $menued_parms(windowch) != 0} {
	wm geometry ${base}.menus "+$menued_parms(windowcx)+$menued_parms(windowcy)"
    }

    update idletasks
#    bind ${base} <Configure> "puts \$of \"Config $base-Win(%W),x(%x),y(%y),w(%w),h(%h),b(%B),a(%a),o(%o)\""
#    bind ${base}.menus <Configure> "puts \$of \"Config $base.menus-Win(%W),x(%x),y(%y),w(%w),h(%h),b(%B),a(%a),o(%o)\""
    bind ${base} <Configure> {+baseconfig %W }
    bind ${base}.menus <Configure> {+basemenusconfig %W "Config $menued_parms(base).menus-Win(%W),x(%x),y(%y),w(%w),h(%h),b(%B),a(%a),o(%o)"}
    bind blockExpose <Expose> {\
        menuedMenuUnpost "$menued_parms(base).f.$menued_parms(mb$menued_parms(curMenuButton))"; \
        menuedMbPost "$menued_parms(base).f.$menued_parms(mb$menued_parms(curMenuButton))" \
    }
    bindtags ${base} [concat blockExpose [bindtags ${base}]]
} 

# This routine moves the splitter bar back and forth, following the lrsplit
proc moveSplitter {x y} {
    global menued_parms
    set xllim [winfo rootx [winfo toplevel $menued_parms(base)]]
    set ns [expr $x-$xllim]
    if {$ns >= [winfo width [winfo toplevel $menued_parms(base)]]-5} {
	set ns [expr [winfo width [winfo toplevel $menued_parms(base)]]-5]
    } elseif {$ns < 0} {
	set ns 0
    }
    place $menued_parms(base).splitter -x $ns
}

proc endSplitter {x} {
    global menued_parms
    set nmb $menued_parms(menuButtons)
    set xllim [winfo rootx [winfo toplevel $menued_parms(base)]]
    set ns [expr $x-$xllim]

    set menued_parms(lrsplit) 900
    for {set i 0} {$i <= $nmb} {incr i} {
	set x1 [winfo rootx $menued_parms(base).f.$menued_parms(mb$i)]
	if {$x < $x1} {
	    set menued_parms(lrsplit) $i
	    break
	}
    }
    bind blockExpose <Expose> {}
    repackmenu
}

proc basemenusconfig {w str} {
    global menued_parms of
    if {$menued_parms(bmconfig) != 1 && $w == "$menued_parms(base).menus" && $menued_parms(lastargs) != $str} {
	set menued_parms(bmconfig) 1
	set vw [winfo vrootwidth [winfo toplevel $w]]
	set vh [winfo vrootheight [winfo toplevel $w]]
	set rx [winfo rootx [winfo toplevel $w]]
	set ry [winfo rooty [winfo toplevel $w]]
	set menued_parms(rootx) $rx; set menued_parms(rooty) $ry
	update idletasks
	menuedMenuUnpost "$menued_parms(base).f.$menued_parms(mb$menued_parms(curMenuButton))"
	update idletasks
	menuedMbPost "$menued_parms(base).f.$menued_parms(mb$menued_parms(curMenuButton))"
	set menued_parms(windowcx) $rx
	set menued_parms(windowcy) $ry
	set menued_parms(windowcw) [winfo width $menued_parms(base).f]
	set menued_parms(windowch) [winfo height $menued_parms(base).f]
	saveoptions
	set menued_parms(lastargs) $str
	set menued_parms(bmconfig) 0
	place $menued_parms(base).splitter -x [expr [winfo width $menued_parms(base)]-5]
    }
}

proc baseconfig {w} {
    global menued_parms of
    if {$w == "$menued_parms(base)"} {
	set vw [winfo vrootwidth [winfo toplevel $w]]
	set vh [winfo vrootheight [winfo toplevel $w]]
	set rx [winfo rootx [winfo toplevel $w]]
	set ry [winfo rooty [winfo toplevel $w]]
	if {0 <= $rx && $rx < $vw && 0 <= $ry && $ry < $vh} {
	    if {$rx != $menued_parms(rootx) || $ry != $menued_parms(rooty)} {
		set menued_parms(rootx) $rx; set menued_parms(rooty) $ry
		update idletasks
		menuedMenuUnpost {}
		menued_recurPost "$menued_parms(base).f.$menued_parms(mb$menued_parms(curMenuButton))" [lrange $menued_parms(cascademenu) 1 900] [lrange $menued_parms(curMenuItem) 1 900]
	    }
	} else {
	    set menued_parms(rootx) $rx; set menued_parms(rooty) $ry
	    menuedMenuUnpost "$menued_parms(base).f.$menued_parms(mb$menued_parms(curMenuButton))"
	}
	set menued_parms(windowex) $rx
	set menued_parms(windowey) $ry
	set menued_parms(windowew) [winfo width $menued_parms(base)]
	set menued_parms(windoweh) [winfo height $menued_parms(base)]
	saveoptions
    }
}

# Used when exiting the application.
proc menued_exit {root} {
    global menued_parms
    destroy $root
    after cancel $menued_parms(clockid)
    if {[info comm .helpDlg] != ""} {
	destroy .helpDlg
    }
    if {[info comm .options*] != ""} {
	destroy .options
    }
    if {[info comm .bgerrorTrace*] != ""} {
	destroy .bgerrorTrace
    }
    if {[info comm .*] == "."} {destroy .} else {puts "Windows that still exist:\n[info comm .*]"}
}

# Clear the current shortcut shown.
proc menued_eraseMod {} {
    global menued_parms
    set uibase "$menued_parms(base).menus.controls"
    set a "$menued_parms(base).f"
    set cm [lindex $menued_parms(curMenuItem) 0]
    set cmb $menued_parms(curMenuButton)
    set nmb $menued_parms(menuButtons)
    set cmbn $menued_parms(mb$cmb)
    set result {}

    if {$menued_parms(cascademenu) != {}} {
	set curmenu [lindex $menued_parms(cascademenu) 0]
    } else {
	set curmenu "$a.$cmbn.m"
    }
    if {[$curmenu type 0] == "tearoff"} {
	set noTearoff 0
	set rcm $cm
    } else {
	set noTearoff 1
	set rcm [expr $cm-1]
    }

    $uibase.shortcut delete 0 end
    if {$cm > 0} {
	$curmenu entryconfig $rcm -accel {}
    }
    # If $cm == 0, we're pointing to a menu button, and it shouldn't
    # have an accelerator anyway.
}

# Used to implement balloon menus.  Tracks the current item.
proc menued_menuMove {w y s} {
    set oldy -1
    set idx [$w index last]
    set newy [$w yposition $idx]
    while {$oldy != $newy} {
        if {$y >= $newy} {
            menued_handleEntry $w $idx
            return
        }
        set oldy $newy
        set idx [expr $idx-1]
	if {$idx > -1} {
	    set newy [$w yposition $idx]
	}
    }
}

# Put the appropriate string in the help text area.
proc menued_handleEntry {w i} {
   global menued_parms menued_bhelp
   
   if {$i > -1 && $menued_parms(help_current) != $i} {
       set menued_parms(help_current) $i
       set type [$w type $i]
       if {$type != "tearoff" && $type != "separator"} {
           set name [$w entrycget $i -label]
	   if {$name != {} && [array names menued_bhelp [list $name]] != {}} {
	       menued_ballooninsert $menued_bhelp([list $name])
	   }    
       } else {
	   menued_ballooninsert {}
       }
   }
}

# Recursively post all cascades until we get to the 'end'.
proc menued_recurPost {m cml cmi} {
    if {[llength $cml]} {
	menued_recurPost $m [lrange $cml 1 900] [lrange $cmi 1 900]
	set cmenu [lindex $cml 0]
	if {[$cmenu type 0] == "tearoff"} {
	    $cmenu postcascade [lindex $cmi 0]
	} else {
	    $cmenu postcascade [expr [lindex $cmi 0]-1]
	}
    } else {
	if {$cmi > 0} {
	    menuedMbPost $m
	    if {[${m}.m type 0] == "tearoff"} {
		${m}.m postcascade $cmi
	    } else {
		${m}.m postcascade [expr $cmi-1]
	    }
	} else {
	    menuedMbPost $m
	}
    }
}

# When <Return> is pressed on an entry, this causes the change to be
# felt immediately.
proc menued_CommitEntry {w} {
    global menued_parms
    set a "$menued_parms(base).f"
    set cm [lindex $menued_parms(curMenuItem) 0]
    set cmb $menued_parms(curMenuButton)
    set nmb $menued_parms(menuButtons)
    set cmbn $menued_parms(mb$cmb)
    set result {}

    if {$menued_parms(cascademenu) != {}} {
	set curmenu [lindex $menued_parms(cascademenu) 0]
    } else {
	set curmenu "$a.$cmbn.m"
    }
    if {[$curmenu type 0] == "tearoff"} {
	set noTearoff 0
	set rcm $cm
    } else {
	set noTearoff 1
	set rcm [expr $cm-1]
    }
    $menued_parms(base).menus.controls.label delete 0 end
    if {[regexp {.*\.([^.]*)} $w match field] != 0} {
	if {$cm == 0} {
	    $a.$cmbn config -$field [$w get]
	    $menued_parms(base).menus.controls.label insert 0 [menued_underlineEscape [$a.$cmbn cget -text] [$a.$cmbn cget -underline]]
	} else {
	    $curmenu entryconfig $rcm -$field [$w get]
	    $menued_parms(base).menus.controls.label insert 0 [menued_underlineEscape [$curmenu entrycget $rcm -label] [$curmenu entrycget $rcm -underline]]
	}
    } else {
	tk_dialog .menuediterror "Error" \
           "I can't figure out the field for the widget '$w', in menued_CommitEntry." \
	   error 0 "Rats!"
    }
}

# This causes the change to be felt for a change in the option sheet.
proc menued_optionEntryCommit {w} {
    global menued_parms
    set a "$menued_parms(base).f"
    set cm [lindex $menued_parms(curMenuItem) 0]
    set cmb $menued_parms(curMenuButton)
    set nmb $menued_parms(menuButtons)
    set cmbn $menued_parms(mb$cmb)
    set result {}
    
    if {$menued_parms(cascademenu) != {}} {
	set curmenu [lindex $menued_parms(cascademenu) 0]
    } else {
	set curmenu "$a.$cmbn.m"
    }
    if {[$curmenu type 0] == "tearoff"} {
	set noTearoff 0
	set rcm $cm
    } else {
	set noTearoff 1
	set rcm [expr $cm-1]
    }
    if {[regexp {.*\.e([^\.]*)} $w match idx]} {
	if {$cm > 0} {
	    $curmenu entryconfig $rcm [.options.f.c.f.l$idx cget -text] [$w get]
	} else {
	    $a.$cmbn config [.options.f.c.f.l$idx cget -text] [$w get]
	}
	if {"[.options.f.c.f.l$idx cget -text]" == "-background"} {
	    set menued_parms(lastbackground) [$w get]
	}
    } else {
	puts "Can't find the index for $w."
    }
}

# Change a global parameter.
proc menued_parmEntryCommit {w} {
    global menued_parms
    if {[regexp {.*\.e([^\.]*)} $w match idx]} {
	set t [.options.f.c.f.l$idx cget -text]
	if {$t != {}} {
	    set menued_parms([.options.f.c.f.l$idx cget -text]) [$w get]
	} else {
	    puts "Can't find the array index '$t'"
	}
    } else {
	puts "Can't find the index for $w."
    }
    
}

# Edit the options of the current item.
proc menued_editOptions {} {
    global menued_parms
    set a "$menued_parms(base).f"
    set cm [lindex $menued_parms(curMenuItem) 0]
    set cmb $menued_parms(curMenuButton)
    set nmb $menued_parms(menuButtons)
    set cmbn $menued_parms(mb$cmb)
    set idx 0

    set menued_parms(optionMenuExists) 1
    
    if {$menued_parms(cascademenu) != {}} {
	set curmenu [lindex $menued_parms(cascademenu) 0]
    } else {
	set curmenu "$a.$cmbn.m"
    }
    if {[$curmenu type 0] == "tearoff"} {
	set noTearoff 0
	set rcm $cm
    } else {
	set noTearoff 1
	set rcm [expr $cm-1]
    }
    if {$cm > 0} {
	set options [$curmenu entryconfig $rcm]
    } else {
	set options [$a.$cmbn config]
    }
    menued_editOptions_actual $options
}

# Edit the current parameters in the global array.
proc menued_editParms {} {
    global menued_parms
    
    set options {}
    
    foreach i [array names menued_parms] {
	lappend options [list $i {} {} {} $menued_parms($i)]
    }
    set options [lsort $options]
    menued_editOptions_actual $options 1
}

# Where the editting of the options or parameters is really done.
proc menued_editOptions_actual {options {listflag 0}} {
    global menued_parms
    set a "$menued_parms(base).f"
    set cm [lindex $menued_parms(curMenuItem) 0]
    set cmb $menued_parms(curMenuButton)
    set nmb $menued_parms(menuButtons)
    set cmbn $menued_parms(mb$cmb)
    set idx 0

    set a ".options"
    if {[winfo exists .options]} {
	foreach i [winfo children $a.f.c.f] {
	    destroy $i
	}
    } else {
	toplevel .options
	frame $a.b
	pack $a.b -side bottom -fill x
	button $a.b.b -text "Dismiss" -command "destroy $a;set menued_parms(optionMenuExists) 0"
	pack $a.b.b
	scrollbar $a.sb -command "$a.f.c yview"
	pack $a.sb -side right -fill y
	frame $a.f -relief sunken -bd 2
	pack $a.f -fill both -expand 1
	canvas $a.f.c -yscrollc "$a.sb set" -bd 0 -highlightthickness 0 -yscrollinc 26
	pack $a.f.c -fill both -expand 1
	frame $a.f.c.f
	$a.f.c create window 0 0 -window $a.f.c.f -anchor nw
    }
    
    frame $a.f.c.f.vertbar -background Blue
    grid $a.f.c.f.vertbar -column 2 -row 1 -sticky ns
    
    frame $a.f.c.f.horizbar -background Blue
    grid $a.f.c.f.horizbar -column 1 -row 1 -columnspan 3 -sticky new
    foreach i $options {
	if {$i == "-background"} {
	    set i $menued_parms(lastbackground)
	}
	incr idx
	label $a.f.c.f.l$idx -text [lindex $i 0]
	entry $a.f.c.f.e$idx 
	if {$listflag == 0} {
	    bindtags $a.f.c.f.e$idx [concat optionEntry [bindtags $a.f.c.f.e$idx]]
	} else {
	    bindtags $a.f.c.f.e$idx [concat parmEntry [bindtags $a.f.c.f.e$idx]]
	}
	# This next binding forces the canvas to follow the focused entry option.
        # This is still crude.  Scrolling going down is by page, going up it's by
	# item.  This looks bad, but it's functional for now.
	# TODO: Fix the downward scrolling to be per line as well.
	bind $a.f.c.f.e$idx <FocusIn> "\
            set cy \[$a.f.c canvasy 0\];\
	    set fy \[winfo height $a.f\];\
	    set gy [expr ($idx-1)*26];\
	    if \{\$cy > \$gy || (\$gy + 26) >= (\$cy + \$fy)\} \{\
	        $a.f.c yview moveto \[expr (($idx-1)*1.0)/\$menued_parms(numoptions)\]\
            \}\
        "
	
	if {[lindex $i 4] == {} && [lindex $i 3] != {}} {
	    $a.f.c.f.e$idx insert 0 [lindex $i 3]
	} else {
	    $a.f.c.f.e$idx insert 0 [lindex $i 4]
	}
	frame $a.f.c.f.horizbar#$idx -background Blue
	grid $a.f.c.f.vertbar -rowspan [expr ($idx)*2]
	grid $a.f.c.f.l$idx -column 1 -row [expr $idx*2] -sticky e
	grid $a.f.c.f.e$idx -column 3 -row [expr $idx*2] -sticky ew
	grid $a.f.c.f.horizbar#$idx -column 1 -row [expr ($idx)*2+1] -columnspan 3 -sticky new
    }
    set menued_parms(numoptions) $idx
    grid columnconfigure $a.f.c.f 3 -weight 1.0
    bind $a.f <Configure> "$a.f.c itemconfig 1 -width \[expr %w-4\]"
    update idletasks
    eval "$a.f.c config -scrollregion \[$a.f.c bbox all\]"
}

# Change the type of the menu to a new type.
proc menued_changetype {t} {
    global menued_parms menutype
    set a "$menued_parms(base).f"
    set cm [lindex $menued_parms(curMenuItem) 0]
    set cmb $menued_parms(curMenuButton)
    set nmb $menued_parms(menuButtons)
    set cmbn $menued_parms(mb$cmb)
    set result {}

    if {$menued_parms(cascademenu) != {}} {
	set curmenu [lindex $menued_parms(cascademenu) 0]
    } else {
	set curmenu "$a.$cmbn.m"
    }

    menued_unhighlight
    if {[$curmenu type 0] == "tearoff"} {
	set noTearoff 0
	set rcm $cm
    } else {
	set noTearoff 1
	set rcm [expr $cm-1]
    }
    
    if {$cm > 0} {
	set i 0
	set j 0
	set temp [stripconfig [$curmenu entryconfig $rcm]]
	set result {}
	while { $i < [llength $menued_parms(configlist)] && $j < [llength $temp] && [lindex $menued_parms(configlist) [expr $i*2]] != {} && [lindex $temp [expr $j*2]] != {}} {
	    set r [string compare [lindex $menued_parms(configlist) [expr $i*2]] [lindex $temp [expr $j*2]]]
	    if {$r <= 0} {
		lappend result [lindex $menued_parms(configlist) [expr $i*2]]
		lappend result [lindex $menued_parms(configlist) [expr $i*2+1]]
		incr i
		if {$r == 0} {
		    incr j
		}
	    } else {
		lappend result [lindex $temp [expr $j*2]]
		lappend result [lindex $temp [expr $j*2+1]]
		incr j
	    }
	}
	if {[expr $j*2+1] < [llength $temp]} {
	    append result \ [lrange $temp [expr $j*2] 900]
	}
	if {[expr $i*2+1] < [llength $menued_parms(configlist)]} {
	    append result \ [lrange $menued_parms(configlist) [expr $i*2] 900]
	}
    } else {
	puts "Ouch! Can't config a menubutton!"
    }
    set menued_parms(configlist) $result
    $curmenu delete $rcm
    $curmenu insert $rcm $menutype
    foreach {i j} $result {
	catch {$curmenu entryconfig $rcm $i $j}
    }
    if {$menued_parms(optionMenuExists) != "0"} {
	menued_editOptions
    }
    menued_highlight
}

# Highlight the 'current' menu item.
proc menued_highlight {} {
    global menued_parms menued_tearoff menutype menuside menued_mods
    
    set a "$menued_parms(base).f"
    set cm [lindex $menued_parms(curMenuItem) 0]
    set cmb $menued_parms(curMenuButton)
    set cmbn $menued_parms(mb$cmb)
    set uibase "$menued_parms(base).menus.controls"
    set type [$a.$cmbn.m type $cm]
    
    if {$menued_parms(cascademenu) != {}} {
	set curmenu [lindex $menued_parms(cascademenu) 0]
    } else {
	set curmenu "$a.$cmbn.m"
    }

    if {[$curmenu type 0] == "tearoff"} {
	set noTearOff 0
	set menued_tearoff 1
    } else {
	set noTearOff 1
	set menued_tearoff 0
    }
    $uibase.command delete 0 end
	$uibase.command config -state disabled
	$uibase.lcommand config -foreground "#a3a3a3"
    $uibase.shortcut delete 0 end
	$uibase.shortcut config -state disabled
	$uibase.lshortcut config -foreground "#a3a3a3"
    $uibase.label delete 0 end
    $uibase.value delete 0 end
	$uibase.value config -state disabled
	$uibase.lvalue config -foreground "#a3a3a3"
    $uibase.variable delete 0 end
	$uibase.variable config -state disabled
	$uibase.lvariable config -foreground "#a3a3a3"
    $uibase.underline delete 0 end
	$uibase.underline config -state disabled
	$uibase.lunderline config -foreground "#a3a3a3"
    
    if {$cm == 0} {
	set menued_parms(lastbackground) [$a.$cmbn cget -background]
	$a.$cmbn config -background $menued_parms(menudefhighlightbackground)
	$uibase.menutypelabel config -fg grey
	$uibase.mt_command config -state disabled
	$uibase.mt_checkbutton config -state disabled
	$uibase.mt_radiobutton config -state disabled
	$uibase.mt_cascade config -state disabled
	$uibase.mt_separator config -state disabled
	$uibase.mods config -state disabled
	$uibase.sc_erase config -state disabled
	$uibase.sc config -takefocus 0
	if {$cmb < $menued_parms(lrsplit)} {
	    set menuside "left"
	} else {
	    set menuside "right"
	}
	set menutype "none"
	$uibase.label insert 0 [menued_underlineEscape [$a.$cmbn cget -text] [$a.$cmbn cget -underline]]
	$uibase.underline config -state normal
	$uibase.lunderline config -foreground Black
	$uibase.underline insert 0 [$a.$cmbn cget -underline]
    } else {
	set menued_parms(lastbackground) [$curmenu entrycget [expr $cm-$noTearOff] -background]
	$curmenu entryconfig [expr $cm-$noTearOff] -background $menued_parms(menudefhighlightbackground)
	$uibase.menutypelabel config -fg black
	$uibase.mt_command config -state normal
	$uibase.mt_checkbutton config -state normal
	$uibase.mt_radiobutton config -state normal
	$uibase.mt_cascade config -state normal
	$uibase.mt_separator config -state normal
	$uibase.sc config -takefocus 0
	set type [$curmenu type [expr $cm-$noTearOff]]
	if {$type != "separator" && $type != "tearoff" && $type != "cascade"} {
	    $uibase.mods config -state normal
	    $uibase.sc_erase config -state normal
	} else {
	    $uibase.mods config -state disabled
	    $uibase.sc_erase config -state disabled
	}
	set menuside "none"
	set menutype [$curmenu type [expr $cm-$noTearOff]]
	set temp [$curmenu entryconfig [expr $cm-$noTearOff]]
	if {[regexp {\-command} $temp]} {
	    $uibase.command config -state normal
	    $uibase.lcommand config -foreground Black
	    $uibase.command insert 0 [$curmenu entrycget [expr $cm-$noTearOff] -command]
	}
	if {[regexp {\-accelerator} $temp] && $type != "cascade"} {
	    $uibase.sc config -takefocus 1
	    $uibase.shortcut config -state normal
	    $uibase.lshortcut config -foreground Black
	    set dummy [$curmenu entrycget [expr $cm-$noTearOff] -accelerator]
	    $uibase.shortcut insert 0 $dummy
	    foreach i [array names menued_mods] {
		set menued_mods($i) 0
	    }
	    regexp {<(.*)>} $dummy match dummy
	    foreach i [split $dummy '-'] {
		if {[array names menued_mods $i] != {}} {
		    set menued_mods($i) 1
		}
	    }
	}
	if {[regexp {\-label} $temp]} {
	    $uibase.label insert 0 [menued_underlineEscape [$curmenu entrycget [expr $cm-$noTearOff] -label] [$curmenu entrycget [expr $cm-$noTearOff] -underline]]
	}
	if {[regexp {\-value} $temp]} {
	    $uibase.value config -state normal
	    $uibase.lvalue config -foreground Black
	    $uibase.value insert 0 [$curmenu entrycget [expr $cm-$noTearOff] -value]
	}
	if {[regexp {\-variable} $temp]} {
	    $uibase.variable config -state normal
	    $uibase.lvariable config -foreground Black
	    $uibase.variable insert 0 [$curmenu entrycget [expr $cm-$noTearOff] -variable]
	}
	if {[regexp {\-underline} $temp]} {
	    $uibase.underline config -state normal
	    $uibase.lunderline config -foreground Black
	    $uibase.underline insert 0 [$curmenu entrycget [expr $cm-$noTearOff] -underline]
	}
    }
    update idletasks
    $menued_parms(base).menus.controls.label selection range 0 end
}

# Escape a menu item so that 'This & That' & and Underline of 7 turns
# into: 'This && &That."
proc menued_underlineEscape {s u} {
    if {$u > -1} {
	set newstring "[string range $s 0 [expr $u-1]]\001[string range $s $u 900]"
    } else {
	set newstring $s
    }
    regsub -all "&" $newstring "&&" newstring
    regsub -all "\001" $newstring {\&} newstring
    return $newstring
}

# Deal with updating the display when a keypress has happened in the
# options widgets.
proc menued_passToWidget {k} {
    global menued_parms
    set a "$menued_parms(base).f"
    set cm [lindex $menued_parms(curMenuItem) 0]
    set cmb $menued_parms(curMenuButton)
    set cmbn $menued_parms(mb$cmb)    
    
    if {$menued_parms(cascademenu) != {}} {
	set curmenu [lindex $menued_parms(cascademenu) 0]
	set isCascade 1
    } else {
	set curmenu "$a.$cmbn.m"
	set isCascade 0
    }

    set result $menued_parms(itemtext)
    regsub -all {&&} $result "\001" result
    set underline [string first "&" $result]
    regsub -all {\&} $result {} result
    regsub -all "\001" $result {\&} result
    
    $menued_parms(base).menus.controls.underline delete 0 end
    $menued_parms(base).menus.controls.underline insert 0 $underline
    if {$cm > 0} {
	# We're configuring a menu item
	if {![string compare [$curmenu type 0] "tearoff"]} {
	    set noTearoff 0
	} else {
	    set noTearoff 1
	}
	set rcm [expr $cm-$noTearoff]
	
	if {[$curmenu type $rcm] != "separator"} {
	    eval "$curmenu entryconfig $rcm -label \"$result\""
	    $curmenu entryconfig $rcm -underline $underline
	}
	set menued_parms(configlist) [stripconfig [$curmenu entryconfig $rcm]]
    } else {
	# We're configuring a menu button
	eval "$a.$cmbn config -text \"$result\""
	$a.$cmbn config -underline $underline
    }
}

#
# menued_unhighlight
#
# Returns: nothing
#
# Side effect: unhighlights the 'current' menu selection.
#

proc menued_unhighlight {} {
    global menued_parms
    set a "$menued_parms(base).f"
    set cmb $menued_parms(curMenuButton)
    set cmbn $menued_parms(mb$cmb)    
    set cm [lindex $menued_parms(curMenuItem) 0]

    if {$menued_parms(cascademenu) != {}} {
	set curmenu [lindex $menued_parms(cascademenu) 0]
	set isCascade 1
    } else {
	set curmenu "$a.$cmbn.m"
	set isCascade 0
    }    
    
    if {$isCascade == 0 && $cm == 0} {
	if {$menued_parms(lastbackground) != {}} {
	    $a.$cmbn config -background $menued_parms(lastbackground)
	    set menued_parms(lastbackground) {}
	} else {
	    $a.$cmbn config -background $menued_parms(menudefbackground)
	}
    } else {
	if {[$curmenu type 0] == "tearoff"} {
	    set noTearOff 0
	} else {
	    set noTearOff 1
	}
	if {$menued_parms(lastbackground) != {}} {
	    $curmenu entryconfig [expr $cm-$noTearOff] -background $menued_parms(lastbackground)
	    set menued_parms(lastbackground) {}
	} else {
	    $curmenu entryconfig [expr $cm-$noTearOff] -background {}
	}
    }
    update idletasks
}

#  
# menued_menulist
#
# returns: a list of widget names that are the menu buttons
#

proc menued_menulist {} {
    global menued_parms
    
    return [winfo children "$menued_parms(base)"]
}

#
# menued_itemlist 
#
# returns: a list of item's labels on a menu
#

proc menued_itemlist {m} {
    global menued_parms
    set result {}
    set l [$m index last]
    
    if {$l != "none"} {
	for {set i 0} {$i <= $l} {incr i} {
	    if {[catch {append result "[$m entrycget $i -label] "}] == 1} {
		append result "[$m type $i] "
	    } 
	}
    }
    return $result
}

# Unhighlight all menus.
proc menued_unhighlightall {} {
    global menued_parms
    foreach i $menued_parms(curMenuItem) j $menued_parms(cascademenu) {
	if {$i != {} && $j != {}} {
	    if {[$j type 0] == "tearoff"} {
		$j entryconfig $i -background {}
	    } else {
		$j entryconfig [expr $i-1] -background {}
	    }
	}
    }
}

# Sets the 'current' menu item to be the one clicked on.
proc menued_thisMenuItem {w y} {
    global menued_parms

    set a "$menued_parms(base).f"
    set cm [lindex $menued_parms(curMenuItem) 0]
    set cmb $menued_parms(curMenuButton)
    set nmb $menued_parms(menuButtons)
    set cmbn $menued_parms(mb$cmb)    
    
    menued_unhighlight

    while {[llength $menued_parms(cascademenu)] > 0 && $w != [lindex $menued_parms(cascademenu) 0]} {
	[lindex $menued_parms(cascademenu) 0] unpost
	set menued_parms(cascademenu) [lrange $menued_parms(cascademenu) 1 900]
	set menued_parms(curMenuItem) [lrange $menued_parms(curMenuItem) 1 900]
    }
    if {$menued_parms(cascademenu) != {}} {
	set curmenu [lindex $menued_parms(cascademenu) 0]
	if {[$curmenu type $cm] == "cascade"} {
	    if {[$curmenu entrycget $cm -menu] != {}} {
		set nummenus [expr [[$curmenu entrycget $cm -menu] index last]+1]
	    } else {
		set nummenus 0
	    }
	}
    } else {
	set curmenu "$a.$cmbn.m"
	set nummenus 0
    }    
    if {[$curmenu type 0] == "tearoff"} {
	set noTearoff 0
    } else {
	set noTearoff 1
    }
    set nmi [$curmenu index last]
    if {$nmi == "none"} {
	set nmi 0
    } else {
	incr nmi
    }
    if {$cm >= $nmi && [$curmenu type $cm] != "separator" && !([$curmenu type $cm] == "cascade" && $nummenus > 0)} {
	if {[$curmenu entrycget $cm -label] == {}} {
	    $curmenu delete [expr $cm-$noTearoff]
	}
    }
    set menued_parms(curMenuItem) [lreplace $menued_parms(curMenuItem) 0 0 [expr [$w index @$y]+$noTearoff]]
    set menued_parms(configlist) [stripconfig [$curmenu entryconfig [$w index @$y]]]
    menued_highlight
    raise $curmenu $menued_parms(base).f
}

# Sets the 'current' menu button to be the one clicked on.
proc menued_thisMenuButton {w} {
    global menued_parms
    set a "$menued_parms(base).f"
    set cm [lindex $menued_parms(curMenuItem) 0]
    set cmb $menued_parms(curMenuButton)
    set nmb $menued_parms(menuButtons)
    set cmbn $menued_parms(mb$cmb)    

    menued_unhighlight
    menued_unhighlightall

    menuedMbPost $w

    while {[llength $menued_parms(cascademenu)] > 0} {
	[lindex $menued_parms(cascademenu) 0] unpost
	set menued_parms(cascademenu) [lrange $menued_parms(cascademenu) 1 900]
	set menued_parms(curMenuItem) [lrange $menued_parms(curMenuItem) 1 900]
    }

    if {$menued_parms(cascademenu) != {}} {
	set curmenu [lindex $menued_parms(cascademenu) 0]
    } else {
	set curmenu "$a.$cmbn.m"
    }    

    if {[$curmenu type 0] == "tearoff"} {
	set noTearoff 0
    } else {
	set noTearoff 1
    }

# if a dangling menu needs to be chopped:
    set type [$curmenu type $cm]
    if {$type == "cascade"} {
	if {[$curmenu entrycget $cm -menu] != {}} {
	    set nummenu [expr [[$curmenu entrycget $cm -menu] index last]+1]
	} else {
	    set nummenu 0
	}
    } else {
	set nummenu 0
    }
    set nmi [$curmenu index last]
    if {$nmi == "none"} {
	set nmi 0
    } else {
	incr nmi
    }
    if {$cm > 0 && $cm >= $nmi && $type != "separator" && $type != "tearoff"
	&& !($type == "cascade" && $nummenu > 0)} {
	if {[$curmenu entrycget $cm -label] == {}} {
	    $curmenu delete [expr $cm-$noTearoff]
	}
    }
    
    set menued_parms(curMenuItem) [lreplace $menued_parms(curMenuItem) 0 0 0]
    set cmb 0
    while {$cmb <= $menued_parms(menuButtons)} {
	if {$w == "$menued_parms(base).f.$menued_parms(mb$cmb)"} {
	    break
	}
	incr cmb
    }
    
    if {$cmb <= $menued_parms(menuButtons)} {
	set menued_parms(curMenuButton) $cmb
    } else {
	set menued_parms(curMenuButton) 0
    }
    set menued_parms(curMenuItem) [lreplace $menued_parms(curMenuItem) 0 0 0]
    set menued_parms(cascademenu) {}
    set cmbn $menued_parms(mb$menued_parms(curMenuButton))    
    set a $menued_parms(base).f.$cmbn
    set temp [menued_underlineEscape [$a cget -text] [$a cget -underline]]
    $menued_parms(base).menus.controls.label delete 0 end
    $menued_parms(base).menus.controls.label insert 0 $temp
    menued_highlight
}

# Beginnings of an undo command
proc undo {} {
    global undoq qhead qtail qhigh Debug
    
    if {$qhead == $qtail} {
	if {$Debug} {
	    puts "No more actions to undo."
	}
	return
    }
    puts "I don't know how to undo a(n) '$undoq($qhead)'"
    if {$qhead > 0} {    
	set qhead [expr $qhead-1]
    }
}

# Beginnings of a redo command
proc redo {} {
    global undoq qhead qtail qhigh Debug
    
    if {$qhead == $qhigh} {
	if {$Debug} {
	    puts "Nothing more to redo!"
	}
	return
    }
    puts "I don't know how to redo a(n) '$undoq($qhead)'"
    incr qhead
}

# log a command for undoability
proc undolog {s} {
    global undoq qhead qtail qhigh Debug
    incr qhead
    set qhigh $qhead
    set undoq($qhead) $s
}

# put a highwater mark in the log
proc undomark {} {
    global undoq qhead qtail qhigh
    incr qhead
    set qhigh $qhead
    set undoq($qhead) "mark"   
}

# Strip the string returned by config to be '-flag option' pairs.
proc stripconfig {l} {
    global menued_parms
    set result {}
    foreach i $l {
	if {[llength $i] > 2} {
	    set t [lindex $i 0]
	    if {$t == "-background"} {
		append result " $t $menued_parms(lastbackground)"
	    } else {
		append result " $t \{[lindex $i 4]\}"
	    }
	}
    }
    set result [string range $result 1 900]
    return $result
}

# When some menus stick to the right side, they must be packed over there.
proc repackmenu {} {
    global menued_parms
    set a "$menued_parms(base).f"
    set nmb $menued_parms(menuButtons)
    
    menuedMenuUnpost $a.$menued_parms(mb$menued_parms(curMenuButton)).m
    for {set i 0} {$i <= [expr $nmb+1]} {incr i} {
	catch {pack forget $a.$menued_parms(mb$i)}
    }
    for {set i 0} {$i <= $nmb && $i < $menued_parms(lrsplit)} {incr i} {
	pack $a.$menued_parms(mb$i) -side left
    }
    for {set i $nmb} {$i >= $menued_parms(lrsplit)} {set i [expr $i-1]} {
	pack $a.$menued_parms(mb$i) -side right
    }
    
    update idletasks
    menuedMbPost $a.$menued_parms(mb$menued_parms(curMenuButton))
}

# Inserts one item into a menu.
proc menued_InsertItem {} {
    global menued_parms
    set a "$menued_parms(base).f"
    set cm $menued_parms(curMenuItem)
    set cmb $menued_parms(curMenuButton)
    set nmb $menued_parms(menuButtons)
    set cmbn $menued_parms(mb$cmb)    
    
    menued_unhighlight
    if {$cm > 0} {
	if {[$a.$cmbn.m type 0] == "tearoff"} {
	    set noTearoff 0
	} else {
	    set noTearoff 1
	}
	
	# inserting a menu item.
	undomark
	undolog "mi insert command -label \"\""
	if {$menued_parms(autofill) > 0} {
	    $a.$cmbn.m insert [expr $cm-$noTearoff] command -label "menuitem$cm"
	} else {
	    $a.$cmbn.m insert [expr $cm-$noTearoff] command -label ""
	}
    } else {
	#inserting a menu button.
	menuedMenuUnpost $a.$cmbn.m
	for {set i $nmb} {$i >= $cmb} {set i [expr $i-1]} {
	    set menued_parms(mb[expr $i+1]) $menued_parms(mb$i)
	}
	set prev $cmbn
	set menued_parms(mb$cmb) "menubutton#[nextidx]"
	set cmbn $menued_parms(mb$cmb)
	menubutton $a.$cmbn -text "$menued_parms(mb$cmb)" -menu $a.$cmbn.m
	bindtags $a.$cmbn [concat meMbResponder meMenubutton [bindtags $a.$cmbn]]
	menu $a.$cmbn.m
	bindtags $a.$cmbn.m [concat meMenu [bindtags $a.$cmbn.m]]
	repackmenu
	incr menued_parms(menuButtons)
	undomark
	undolog "mb insert command $a.$cmbn -text \"\""
    }
    menued_highlight
}

# Deletes one item from a menu
proc menued_DeleteItem {} {
    global menued_parms
    set a "$menued_parms(base).f"
    set cm [lindex $menued_parms(curMenuItem) 0]
    set cmb $menued_parms(curMenuButton)
    set nmb $menued_parms(menuButtons)
    set cmbn $menued_parms(mb$cmb)    
    
    if {$menued_parms(cascademenu) != {}} {
	set curmenu [lindex $menued_parms(cascademenu) 0]
	set isCascade 1
    } else {
	set curmenu "$a.$cmbn.m"
	set isCascade 0
    }

    set nmi [$curmenu index last]
    if {$nmi == "none"} {
	set nmi 0
    } else {
	incr nmi
    }
    menued_unhighlight
    if {$cm > 0 || $isCascade > 0} {
	# deleting a menu item
	if {[$curmenu type 0] == "tearoff"} {
	    set noTearoff 0
	} else {
	    set noTearoff 1
	}
	
	set rcm [expr $cm - $noTearoff]
	set cmtype [$curmenu type $rcm]
	set cmconfig [stripconfig [$curmenu entryconfig $rcm]]
	undomark
	undolog "mi delete $curmenu $cmtype [list $cmconfig]"

	$curmenu delete $rcm
	set nmi [expr $nmi -1]
	if {$rcm == $nmi} {
	    set cm [expr $cm-1]
	}
	if {$isCascade > 0 && ($nmi - (1-$noTearoff)) < 1} {
	    $curmenu add command
	    incr nmi
	    set cm $nmi
	}
	set menued_parms(curMenuItem) [lreplace $menued_parms(curMenuItem) 0 0 $cm]
    } else {
	#deleting a menu button
	undomark
	for {set i $nmi} {$i > -1} {set i [expr $i-1]} {
	    set cmtype [$curmenu type $i]
	    set cmconfig [stripconfig [$curmenu entryconfig $i]]
	    undolog "mi delete $cmtype $cmconfig"
	    $curmenu delete $i
	}
	set cmconfig [stripconfig [$a.$cmbn config]]
	undolog "mb delete $cmconfig"
	destroy $a.$cmbn

	for {set i $cmb} {$i < $nmb} {incr i} {
	    set menued_parms(mb$i) $menued_parms(mb[expr $i+1])
	}
	
	set nmb [expr $nmb - 1]
	if {$cmb > $nmb} {
	    set cmb $nmb
	}
	if {$cmb < 0 && $nmb < 0} {
	    # Oops...deleted the last one.  Create a new one.
	    set cmb 0
	    set nmb 0
	    set menued_parms(mb$cmb) "menubutton#[nextidx]"
	    set cmbn $menued_parms(mb$cmb)
	    menubutton $a.$cmbn -text "$menued_parms(mb$cmb)" -menu $a.$cmbn.m
	    bindtags $a.$cmbn [concat meMbResponder meMenubutton [bindtags $a.$cmbn]]
	    menu $a.$cmbn.m
	    bindtags $a.$cmbn.m [concat meMenu [bindtags $a.$cmbn.m]]
	    set menued_parms(lrsplit) 900
	    pack $a.$cmbn -side left	    
	}
	set cmbn $menued_parms(mb$cmb)    
	set menued_parms(menuButtons) $nmb
	set menued_parms(curMenuButton) $cmb
    }
    menued_highlight
}

proc menued_appendMenuItem {{curmenu {}}} {
    global menued_parms
    menued_unhighlight
    if {$curmenu == {}} {
	set cm [lindex $menued_parms(curMenuItem) 0]
	set cmbn $menued_parms(mb$menued_parms(curMenuButton))    
	if {$menued_parms(cascademenu) != {}} {
	    set curmenu [lindex $menued_parms(cascademenu) 0]
	} else {
	    set curmenu "$menued_parms(base).f.$cmbn.m"
	}
    }
    if {$menued_parms(autofill) > 0} {
	$curmenu add command -label "menuitem[lindex $menued_parms(curMenuItem) 0]"
    } else {
	$curmenu add command -label ""
    }
#    set cm [lindex $menued_parms(curMenuItem) 0]
#    incr cm
#    set menued_parms(curMenuItem) [lreplace $menued_parms(curMenuItem) 0 0 $cm]
#    menued_highlight
}

# move the 'current' menu item to the next one.
proc menued_nextMenuItem {dx} {
    global menued_parms Debug
    
    # Unmark the current selection.
    menued_unhighlight
    
    set a "$menued_parms(base).f"
    set cm [lindex $menued_parms(curMenuItem) 0]
    set cmb $menued_parms(curMenuButton)
    set cmbn $menued_parms(mb$cmb)    
    set type [$a.$cmbn.m type $cm]
    
    if {$menued_parms(cascademenu) != {}} {
	set curmenu [lindex $menued_parms(cascademenu) 0]
	set isCascade 1
    } else {
	set curmenu "$a.$cmbn.m"
	set isCascade 0
    }

    if {[$curmenu type 0] == "tearoff"} {
	set noTearoff 0
    } else {
	set noTearoff 1
    }
    
    set nmi [$curmenu index last]
    if {$nmi == "none"} {
	set nmi 0
    } else {
	set nmi [expr $nmi +1 -(1-$noTearoff)]
    }

    # Check to see if the current selection's attributes have changed.
    if {$type != "tearoff" && $type != "separator"} {
	if {$cm > 0} {
	    set temp [$curmenu entryconfig [expr $cm-$noTearoff]]
	} else {
	    set temp [$a.$cmbn config]
	}
	
	if {$menued_parms(lastConfig) != $temp} {
	    undomark
	    foreach i $menued_parms(lastConfig) j $temp {
		if {$i != $j} {
		    undolog "mi $curmenu $cm {[lindex $i 0]} {[lindex $i 4]} {[lindex $j 4]}"
		}
	    }
	}
    }
    update idletasks
    if {$cm == 0} {
	menuedMbPost $a.$cmbn
#    } else {
#	menuedMbPost $curmenu
    }
    if {$dx == 1} {
	#moving down
	if {$cm >= $nmi} {
	    set temp {-1}
	    if {$cm == 0} {
		if {$nmi == 0} {
		    menued_appendMenuItem $curmenu
		    incr nmi
		    incr cm
		} else {
		    incr cm
		}
	    } else {
		set type [$curmenu type [expr $cm-$noTearoff]]
		if {$type == "cascade"} {
		    if {[$curmenu entrycget [expr $cm-$noTearoff] -menu] != {} } {
			set numCascadeItems [[$curmenu entrycget [expr $cm-$noTearoff] -menu] index last]
			if {$numCascadeItems == "none"} {
			    set numCascadeItems 0
			}
		    } else {
			set numCascadeItems 0
		    }
		} else {
		    set numCascadeItems 0
		}
		catch {set temp [$curmenu entrycget [expr $cm-$noTearoff] -label]}
		if {$menued_parms(autospare)>0} {
		    if {$temp == {} && $type != "separator" && $numCascadeItems == 0 && (($isCascade == 1 && $nmi > 1) || ($isCascade == 0 && $nmi > 0))} {
			#Moving off an empty menu item.  Delete it and clean up.
			$curmenu delete [expr $cm-$noTearoff]
			if {$isCascade > 0} {
			    set menued_parms(curMenuItem) [lreplace $menued_parms(curMenuItem) 0 0 1]
			    set cm 1
			} else {
			    set menued_parms(curMenuItem) [lreplace $menued_parms(curMenuItem) 0 0 0]
			    set cm 0
			}
			set nmi [expr $nmi-1]
			set temp [menued_underlineEscape [$a.$cmbn cget -text] [$a.$cmbn cget -underline]]
			$menued_parms(base).menus.controls.label delete 0 end
			$menued_parms(base).menus.controls.label insert 0 $temp
		    } else {
			#Add a new Menu Item, the last spare was used.
			menued_appendMenuItem $curmenu
			incr nmi
			incr cm
		    }
		} else {
		    set cm 0
		    set temp [menued_underlineEscape [$a.$cmbn cget -text] [$a.$cmbn cget -underline]]
		    $menued_parms(base).menus.controls.label delete 0 end
		    $menued_parms(base).menus.controls.label insert 0 $temp
		}
	    }
	} else {
	    incr cm
	}
    } else {
	# Moving up the menu
	if {$cm == 0 || ($cm == 1 && $isCascade == 1)} {
	    # If already at top, wrap around.
	    set temp {}
	    set type [$curmenu type [expr $nmi-$noTearoff]]
	    catch {set temp [$curmenu entrycget [expr $nmi-$noTearoff] -label]}
	    if {$temp == {} && $type != "separator" && $nmi > 0} {
		# The last entry is a spare
		set cm $nmi
	    } else {
		if {$menued_parms(autospare) > 0} {
		    # The last entry is a separator or not a spare, so we need to make a new one.
		    incr nmi
		    set cm $nmi
		    menued_unhighlight
		    menued_appendMenuItem $curmenu
		    $menued_parms(base).menus.controls.label delete 0 end
		} else {
		    set cm $nmi
		}
	    }
	} else {
	    # if at the top, and it's a spare...delete it.
	    if {$cm >= $nmi} {
		set temp {}
		set type [$curmenu type [expr $nmi-$noTearoff]]
		if {$type == "cascade"} {
		    set numCascadeItems [[$curmenu entrycget [expr $nmi-$noTearoff] -menu] index last]
		} else {
		    set numCascadeItems 0
		}
		catch {set temp [$curmenu entrycget [expr $cm-$noTearoff] -label]}
		if {$temp == {} && $type != "separator" && $numCascadeItems == 0 && $menued_parms(autospare)>0} {
		    $curmenu delete [expr $cm-$noTearoff]
		    set nmi [expr $nmi - 1]
		}
	    }
	    set cm [expr $cm - 1]
	    set menued_parms(curMenuItem) [lreplace $menued_parms(curMenuItem) 0 0 $cm]
	    if {!$cm} {
		# Uh-oh...we're on the menubutton now.
		set temp [menued_underlineEscape [$a.$cmbn cget -text] [$a.$cmbn cget -underline]]
		$menued_parms(base).menus.controls.label delete 0 end
		$menued_parms(base).menus.controls.label insert 0 $temp
	    }
	}
    }
 
    set menued_parms(curMenuItem) [lreplace $menued_parms(curMenuItem) 0 0 $cm]
    if {$cm} {
	set menued_parms(configlist) [stripconfig [$curmenu entryconfig [expr $cm-$noTearoff]]]
	set menued_parms(lastConfig) [$curmenu entryconfig [expr $cm-$noTearoff]]
	$menued_parms(base).menus.controls.label delete 0 end
	set rcm [expr $cm-$noTearoff]
	if {[$curmenu type $rcm] != "tearoff" && [$curmenu type $rcm] != "separator"} {
	    $menued_parms(base).menus.controls.label insert 0 [menued_underlineEscape [$curmenu entrycget $rcm -label] [$curmenu entrycget $rcm -underline]]
	}
    } else {
	set menued_parms(lastConfig) [$a.$cmbn config]
	set menued_parms(configlist) [stripconfig [$a.$cmbn config]]
    }
    if {$menued_parms(optionMenuExists) != "0"} {
	menued_editOptions
    }
    menued_highlight
}

proc menued_addMenuButtonWrapper {} {
    global menued_parms
    menuedMenuUnpost {}
    set menued_temp [expr $menued_parms(menuButtons)+1]
    menued_addMenuButton $menued_temp $menued_temp
    set menued_parms(menuButtons) $menued_temp
    set menued_parms(curMenuButton) $menued_temp
    update idletasks
    menuedMbPost $menued_parms(base).f.$menued_parms(mb$menued_parms(curMenuButton))
#    menued_highlight
}

proc menued_addMenuButton {cmb nmb} {
    global menued_parms

    menued_unhighlight
    set a "$menued_parms(base).f"
    set cm [lindex $menued_parms(curMenuItem) 0]
    menued_unhighlight
    set menued_parms(mb$cmb) "menubutton#[nextidx]"
    set cmbn $menued_parms(mb$cmb)

    if {$menued_parms(autofill) > 0} {
	menubutton $a.$cmbn -text "$menued_parms(mb$cmb)" -menu $a.$cmbn.m
    } else {
	menubutton $a.$cmbn -text "" -menu $a.$cmbn.m
    }
    bindtags $a.$cmbn [concat meMbResponder meMenubutton [bindtags $a.$cmbn]]
    menu $a.$cmbn.m -tearoff $menued_parms(autotearoff)
    bindtags $a.$cmbn.m [concat meMenu [bindtags $a.$cmbn.m]]

    if {$cmb >= $menued_parms(lrsplit)} {
	set menued_parms(menuButtons) $nmb
	repackmenu
    } else {
	pack $a.$cmbn -side left
    }   
#    menued_highlight
}

# move the 'current' menu button to the new one.
proc menued_nextMenu {dx} {
    global menued_parms menutype
    
    set a "$menued_parms(base).f"
    set nmb $menued_parms(menuButtons)
    set cm [lindex $menued_parms(curMenuItem) 0]
    set cmb $menued_parms(curMenuButton)
    set cmbn $menued_parms(mb$cmb)

    if {$menued_parms(cascademenu) != {}} {
	set curmenu [lindex $menued_parms(cascademenu) 0]
    } else {
	set curmenu "$a.$cmbn.m"
    }

    if {[$curmenu type 0] == "tearoff"} {
	set noTearoff 0
    } else {
	set noTearoff 1
    }
    
    menued_unhighlight
    
    # Check to see if the current selection's attributes have changed.
    set temp [$curmenu config]
	
    if {$menued_parms(lastConfig) != $temp} {
	undomark
	foreach i $menued_parms(lastConfig) j $temp {
	    if {$i != $j} {
		undolog "mi $curmenu {[lindex $i 0]} {[lindex $i 4]} {[lindex $j 4]}"
	    }
	}
    }
    if {$cm > 0} {
	if {$dx == 1} {
            # We are editting a cascade menu item, if it's a cascade, or if
            # the autocreatecascade is turned on, add the cascade menu.
	    if {$menued_parms(autocreatecascade) > 0 || [$curmenu type [expr $cm-$noTearoff]] == "cascade"} {
		set menu {}
		if {[$curmenu type [expr $cm-$noTearoff]] == "cascade"} {
		    set menu [$curmenu entrycget [expr $cm-$noTearoff] -menu]
		}
		menued_unhighlight
		if {![winfo exists $menu]} {
		    set menutype "cascade"
		    menued_changetype 0
		    menued_unhighlight
		    update idletasks
		    set menu "$curmenu.[nextidx]m"
		    $curmenu entryconfig [expr $cm-$noTearoff] -menu $menu
		    menu $menu -tearoff $menued_parms(autotearoff)
		    if {$menued_parms(autofill) > 0} {
			$menu add command -label "menuitem$cm"
		    } else {
			$menu add command -label ""
		    }
		    bindtags $menu [concat meMenu [bindtags $menu]]
		}
		set menued_parms(curMenuItem) [concat 1 $menued_parms(curMenuItem)]
		$curmenu postcascade [expr $cm-$noTearoff]
		set menued_parms(cascademenu) [concat $menu $menued_parms(cascademenu)]
		set menued_parms(configlist) [stripconfig [$menu entryconfig [expr $cm-(1-$menued_parms(autotearoff))]]]
		$menued_parms(base).menus.controls.label delete 0 end
	    } else {
		tk_dialog .menued_error "Error" \
                "You must make that menu a cascade menu first." \
                error 0 "Okay."
	    }
	} else {
	    # We're moving to the left, removing the posted cascade menu.
	     if {[llength $menued_parms(curMenuItem)] > 1} {
		 $curmenu unpost
		 set menued_parms(curMenuItem) [lrange $menued_parms(curMenuItem) 1 900]
		 set menued_parms(cascademenu) [lrange $menued_parms(cascademenu) 1 900]
		 set menued_parms(configlist) [stripconfig [$curmenu entryconfig [expr $cm-$noTearoff]]]
		 $menued_parms(base).menus.controls.label delete 0 end
	     }
	}
    } else {
	# We are editting a menu Button
	 menuedMenuUnpost $curmenu
	if {$dx == 1} {
	    if {$cmb >= $nmb} {
		if {$menued_parms(autospare) > 0} {
		    if {[$a.$cmbn cget -text] == {} \
			    && (([$a.$cmbn.m index last] == "none") \
				    ||  ([$a.$cmbn.m index last] == 0 \
					     && [$a.$cmbn.m type 0] == "tearoff"))\
			    && $menued_parms(menuButtons) > 0} {
			# wrapping, get rid of this button.
			set nmb [expr $nmb-1]
			destroy $a.$menued_parms(mb$cmb)
			set cmb 0
		    } else { 
			# Add a new one to play with, the last spare was used.
			incr cmb
			incr nmb
			menued_addMenuButton $cmb $nmb
		    }
		} else {
		    # boring, just wrap around
		    set cmb 0
		}
	    } else {
		incr cmb
	    }
	} else {
	    if {$cmb == 0} {
		if {$menued_parms(autospare)>0} {
		    # This is when wrapping to the left.
		    incr nmb
		    set cmb $nmb
		    menued_addMenuButton $cmb $nmb
		} else {
		    #boring, just wrap around
		    set cmb $nmb
		}
	    } elseif {$cmb == $nmb} {
		if {[$a.$cmbn cget -text] == {} \
                    && (([$a.$cmbn.m index last] == "none") \
                    ||  ([$a.$cmbn.m index last] == 0 && [$a.$cmbn.m type 0] == "tearoff")) } {
		    destroy $a.$menued_parms(mb$cmb)
		    set nmb [expr $nmb-1]
		    set cmb $nmb
		} else {
		    set cmb [expr $cmb-1]
		}
	    } else {
		set cmb [expr $cmb + $dx]
	    }
	}
	set menued_parms(curMenuButton) $cmb
	set menued_parms(menuButtons) $nmb
	set cmbn $menued_parms(mb$cmb)    
	set menued_parms(lastConfig) [$a.$cmbn config]
	$menued_parms(base).menus.controls.label delete 0 end
	$menued_parms(base).menus.controls.label insert 0 [menued_underlineEscape [$a.$cmbn cget -text] [$a.$cmbn cget -underline]]
	update idletasks
	menuedMbPost $a.$cmbn
    }
    if {! $cm} {
	set menued_parms(configlist) [stripconfig [$a.$cmbn config]]
    }
    if {$menued_parms(optionMenuExists) != "0"} {
	menued_editOptions
    }
    menued_highlight
}

wm withdraw .

# main part of the program.

if {[llength $argv]<1} {
    menued_start
} else {
    if {[winfo exists [lindex $argv 0]]} {
	menued_start [lindex $argv 0]
    } else {
	tk_dialog .html_error "Error" \
                "The window '[lindex $argv 0]' doesn't exist. Can't start Menuedit." \
                error 0 "Rats!"
	return
    }
}

menued_highlight

