# mib.tcl

proc Mib_Select {varname {leaf no}} {
    upvar #0 $varname var Copy$varname copy Details$varname details
    set dialog .mibselect
    catch {destroy .mibselect}
    toplevel .mibselect -bd 4 -relief ridge
    wm title .mibselect "MIB Browser"
    set copy $var
    label $dialog.name -textvariable Copy$varname
    set details [MibScrollable $dialog.details text]
    $details config -width 10 -height 3
    label $dialog.pl -text "Up the MIB tree"
    set up [MibScrollable $dialog.parent]
    label $dialog.ch -text "Down the MIB tree"
    set down [MibScrollable $dialog.child]
    label $dialog.al -text "Full MIB tree"
    set all [MibScrollable $dialog.all]
    bind $up <ButtonRelease-1> \
	[list MibListHit %W %x %y $up $down $all Copy$varname]
    bind $down <ButtonRelease-1> \
	[list MibListHit %W %x %y $up $down $all Copy$varname]
    bind $all <ButtonRelease-1> \
	[list MibListHit %W %x %y $up $down $all Copy$varname]
    button $dialog.ok -text OK -command [list MibSelectOK $varname]
#    button $dialog.ball -text "View All" -command [list MibListAll $all]
    button $dialog.cancel -text Cancel -command [list MibSelectCancel $varname]
    grid $dialog.name -	-		-sticky news
    grid $dialog.details - -		-sticky news
    grid $dialog.pl $dialog.ch $dialog.al		-sticky news
    grid $dialog.parent $dialog.child $dialog.all	-sticky news
    grid $dialog.ok x $dialog.cancel	-sticky news
    grid columnconfigure $dialog 0 -weight 1
    grid columnconfigure $dialog 1 -weight 1
    grid columnconfigure $dialog 2 -weight 1
    grid rowconfigure $dialog 1 -weight 1
    grid rowconfigure $dialog 3 -weight 2

    MibSelectList $up $down Copy$varname
    MibListAll $all
}
proc MibSelectList {up down copyname} {
    upvar #0 $copyname copy
    set details .mibselect.details.text
    $details delete 1.0 end
    if ![catch {mib description $copy} d] {
	$details insert insert $d
    }
    $up delete 0 end
    foreach f [MibFullname $copy] {
	$up insert end [MibFormat $f]
    }
    $down delete 0 end
    foreach f [MibChildren $copy] {
	$down insert end [MibFormat $f]
    }
}
proc MibListAll {list} {
    # demo hack
    global Mib
    global WebTk
    if [catch {open [file join $WebTk(library) cat1900.raw]} in] {
	set a [tk_messageBox -type yesno "No device specific information available.  Ok to show the entire MIB tree?" -icon question]
	if {$a == "yes"} {
	    mib walk x iso [list $list insert end $x]
	}
    } else {
	catch {unset Mib}
	while {[gets $in line] >= 0} {
	    set line [lindex $line 0]
	    set name [mib name [lindex $line 0]]
	    $list insert end $name
	    set Mib($name) [$list index end]
	}
	close $in
    }

}
proc MibFormat {name} {
    return $name
# junk
    set details [mib tc $name]
    if {[string length $details] == 0} {
	append name .
    }
    return $name
}
proc MibListHit {l x y up down all copyname} {
    upvar #0 $copyname copy
    global Mib
    set ix [$l index @$x,$y]
    set name [$l get $ix]
    if {$l != $all} {
	set mibnames [lsort -dictionary [array names Mib $name*]]
	if {[llength $mibnames] > 0} {
	    set xname [lindex $mibnames 0]
	    $all see $Mib($xname)
	}
    }
    set copy $name
    MibSelectList $up $down $copyname 
}
proc MibSelectOK {varname} {
    upvar #0 $varname var Copy$varname copy
    set var $copy
    destroy .mibselect
}
proc MibSelectCancel {varname} {
    destroy .mibselect
}

# Return a list that is a path through the mib tree to the named leaf
# MibFullname system
# returns "iso org dod internet mgmt mib-2 system"
proc MibFullname {name} {
    foreach i [split [mib oid $name] .] {
	lappend j $i
	lappend fname [mib name [join $j .]]
    }
    return $fname
}
proc MibChildren {name} {
    if [catch {mib successor $name} result] {
	return {}
    } else {
	return $result
    }
}
proc MibScrollable {name {widget listbox}} {
    frame $name
    $widget $name.$widget -yscrollcommand "$name.scroll set"
    scrollbar $name.scroll -command "$name.$widget yview" -orient vert
    pack $name.scroll $name.$widget -side right -fill y
    pack $name.$widget -fill both -expand true
    return $name.$widget
}
