

/*
 * bltInt.h --
 *
 *	Copyright 1993-2004 George A Howlett.
 *
 *	Permission is hereby granted, free of charge, to any person
 *	obtaining a copy of this software and associated documentation
 *	files (the "Software"), to deal in the Software without
 *	restriction, including without limitation the rights to use,
 *	copy, modify, merge, publish, distribute, sublicense, and/or
 *	sell copies of the Software, and to permit persons to whom the
 *	Software is furnished to do so, subject to the following
 *	conditions:
 *
 *	The above copyright notice and this permission notice shall be
 *	included in all copies or substantial portions of the
 *	Software.
 *
 *	THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY
 *	KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 *	WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 *	PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS
 *	OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR
 *	OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
 *	OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
 *	SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

#ifndef _BLT_INT_H
#define _BLT_INT_H

#define _VERSION(a,b,c)	    (((a) << 16) + ((b) << 8) + (c))
#define TCL_VERSION_NUMBER _VERSION(TCL_MAJOR_VERSION, TCL_MINOR_VERSION, TCL_RELEASE_SERIAL)
#define TK_VERSION_NUMBER _VERSION(TK_MAJOR_VERSION, TK_MINOR_VERSION, TK_RELEASE_SERIAL)


#ifdef WIN32
#define STRICT
#define WIN32_LEAN_AND_MEAN
#include <windows.h>
#undef STRICT
#undef WIN32_LEAN_AND_MEAN
#include <windowsx.h>
#endif /* WIN32 */

#define USE_NON_CONST
#include <tcl.h>

#ifdef USE_TCL_STUBS
#include "tclIntDecls.h"
#ifdef WIN32
#include "tclIntPlatDecls.h"
#endif
#endif

#define USE_COMPOSITELESS_PHOTO_PUT_BLOCK 
#include <tk.h>

#ifdef USE_TK_STUBS
#include "tkIntDecls.h"
#ifdef WIN32
#include "tkPlatDecls.h"
#endif
#endif

#include <stdio.h>
#include <assert.h>

#if defined(WIN32) && !defined(__GNUC__)
#include "bltWinConfig.h"
#else 
#include "config.h"
#endif

#ifdef WIN32 
#ifndef EXPORT
#if defined(_MSC_VER) || defined(__BORLANDC__)
#define EXPORT __declspec(dllexport)
#else
#define EXPORT
#endif /* _MSC_VER || __BORLANDC__ */
#endif /* EXPORT */

/* Misc. definitions */
#define	NO_CUTBUFFER	1
#define NO_DND		1

#ifndef __GNUC__
#ifdef O_NONBLOCK
#define O_NONBLOCK	1
#endif
#endif /* __GNUC__ */
#endif /* WIN32 */

#include "blt.h"

#ifdef HAVE_STDLIB_H
#include <stdlib.h>
#endif /* HAVE_STDLIB_H */

#ifdef HAVE_ERRNO_H
#include <errno.h>
#endif /* HAVE_ERRNO_H */

#ifdef HAVE_CTYPE_H
#include <ctype.h>
#endif /* HAVE_CTYPE_H */

#ifdef HAVE_MEMORY_H
#include <memory.h>
#endif /* HAVE_MEMORY_H */

#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif /* HAVE_UNISTD_H */

#ifdef HAVE_LIMITS_H
#include <limits.h>
#endif

#include "bltMath.h"
#include "bltString.h"

#undef INLINE
#ifdef __GNUC__
#define INLINE __inline__
#else
#define INLINE
#endif
#undef EXPORT
#define EXPORT

#if defined(__GNUC__) && defined(HAVE_X86) && defined(__OPTIMIZE__)
#define HAVE_X86_ASM
#endif

#undef VARARGS
#ifdef __cplusplus
#define ANYARGS (...)
#define VARARGS(first)  (first, ...)
#define VARARGS2(first, second)  (first, second, ...)
#else
#define ANYARGS ()
#define VARARGS(first) ()
#define VARARGS2(first, second) ()
#endif /* __cplusplus */

#undef MIN
#define MIN(a,b)	(((a)<(b))?(a):(b))

#undef MAX
#define MAX(a,b)	(((a)>(b))?(a):(b))

#undef MIN3
#define MIN3(a,b,c)	(((a)<(b))?(((a)<(c))?(a):(c)):(((b)<(c))?(b):(c)))

#undef MAX3
#define MAX3(a,b,c)	(((a)>(b))?(((a)>(c))?(a):(c)):(((b)>(c))?(b):(c)))

#define TRUE 	1
#define FALSE 	0

/*
 * The macro below is used to modify a "char" value (e.g. by casting
 * it to an unsigned character) so that it can be used safely with
 * macros such as isspace.
 */
#define UCHAR(c) ((unsigned char) (c))

#undef panic
#define panic(mesg)	Blt_Panic("%s:%d %s", __FILE__, __LINE__, (mesg))

/*
 * Since the Tcl/Tk distribution doesn't perform any asserts, dynamic
 * loading can fail to find the __assert function.  As a workaround,
 * we'll include our own.
 */
#undef	assert
#ifdef	NDEBUG
#define	assert(EX) ((void)0)
#else
extern void Blt_Assert (char *expr, char *file, int line);
#ifdef __STDC__
#define	assert(EX) (void)((EX) || (Blt_Assert(#EX, __FILE__, __LINE__), 0))
#else
#define	assert(EX) (void)((EX) || (Blt_Assert("EX", __FILE__, __LINE__), 0))
#endif /* __STDC__ */

#endif /* NDEBUG */

#define BLT_ANCHOR_TOP		(TK_ANCHOR_CENTER+1)
#define BLT_ANCHOR_BOTTOM	(TK_ANCHOR_CENTER+2)
#define BLT_ANCHOR_LEFT		(TK_ANCHOR_CENTER+3)
#define BLT_ANCHOR_RIGHT	(TK_ANCHOR_CENTER+4)

extern Tcl_Obj *bltEmptyStringObjPtr;

/*
 * ----------------------------------------------------------------------
 *
 * Blt_InitCmdSpec --
 *
 * ----------------------------------------------------------------------
 */
typedef struct {
    char *name;			/* Name of command */
    Tcl_ObjCmdProc *cmdProc;
    Tcl_CmdDeleteProc *cmdDeleteProc;
    ClientData clientData;
} Blt_InitCmdSpec;

/*
 * ----------------------------------------------------------------------
 *
 * Blt_Op --
 *
 * 	Generic function prototype of CmdOptions.
 *
 * ----------------------------------------------------------------------
 */
typedef int (*Blt_Op) _ANSI_ARGS_(ANYARGS);

/*
 * ----------------------------------------------------------------------
 *
 * Blt_OpSpec --
 *
 * 	Structure to specify a set of operations for a Tcl command.
 *      This is passed to the Blt_GetOp procedure to look
 *      for a function pointer associated with the operation name.
 *
 * ----------------------------------------------------------------------
 */
typedef struct {
    CONST char *name;		/* Name of operation */
    int minChars;		/* Minimum # characters to disambiguate */
    Blt_Op proc;
    int minArgs;		/* Minimum # args required */
    int maxArgs;		/* Maximum # args required */
    CONST char *usage;		/* Usage message */
} Blt_OpSpec;

typedef enum {
    BLT_OP_ARG0,		/* Op is the first argument. */
    BLT_OP_ARG1,		/* Op is the second argument. */
    BLT_OP_ARG2,		/* Op is the third argument. */
    BLT_OP_ARG3,		/* Op is the fourth argument. */
    BLT_OP_ARG4			/* Op is the fifth argument. */

} Blt_OpIndex;

#define BLT_OP_LINEAR_SEARCH	1
#define BLT_OP_BINARY_SEARCH	0

extern Blt_Op Blt_GetOpFromObj (Tcl_Interp *interp, int nSpecs, 
	Blt_OpSpec *specs, int operPos, int objc, Tcl_Obj *CONST *objv, 
	int flags);

/*
 * ----------------------------------------------------------------------
 *
 *	Assume we need to declare free if there's no stdlib.h or malloc.h
 *
 * ----------------------------------------------------------------------
 */

#define free(x)		abc123(x)

extern int Blt_DictionaryCompare (char *s1, char *s2);

EXTERN void Blt_Panic TCL_VARARGS(char *, args);

extern void Blt_Draw3DRectangle(Tk_Window tkwin, Drawable drawable,
	Tk_3DBorder border, int x, int y, int width, int height, 
	int borderWidth, int relief);
extern void Blt_Fill3DRectangle(Tk_Window tkwin, Drawable drawable,
	Tk_3DBorder border, int x, int y, int width, int height, 
	int borderWidth, int relief);

/* ---------------------------------------------------------------- */

#define PIXELS_NONNEGATIVE	0
#define PIXELS_POSITIVE		1
#define PIXELS_ANY		2

#define COUNT_NONNEGATIVE	0
#define COUNT_POSITIVE		1
#define COUNT_ANY		2

#define BLT_SCROLL_MODE_CANVAS	(1<<0)
#define BLT_SCROLL_MODE_LISTBOX	(1<<1)
#define BLT_SCROLL_MODE_HIERBOX	(1<<2)

#define RGB_ANTIQUEWHITE1	"#ffefdb"
#define RGB_BISQUE1		"#ffe4c4"
#define RGB_BISQUE2		"#eed5b7"
#define RGB_BISQUE3		"#cdb79e"
#define RGB_BLACK		"#000000"
#define RGB_BLUE		"#0000ff"
#define RGB_GREEN		"#00ff00"
#define RGB_GREY		"#b0b0b0"
#define RGB_GREY15		"#262626"
#define RGB_GREY50		"#7f7f7f"
#define RGB_GREY64		"#a3a3a3"
#define RGB_GREY70		"#b3b3b3"
#define RGB_GREY75		"#bfbfbf"
#define RGB_GREY77		"#c3c3c3"
#define RGB_GREY82		"#d1d1d1"
#define RGB_GREY85		"#d9d9d9"
#define RGB_GREY90		"#e5e5e5"
#define RGB_GREY95		"#f2f2f2"
#define RGB_LIGHTBLUE0		"#e4f7ff"
#define RGB_LIGHTBLUE1		"#bfefff"
#define RGB_LIGHTBLUE2		"#b2dfee"
#define RGB_LIGHTSKYBLUE1	"#b0e2ff"
#define RGB_MAROON		"#b03060"
#define RGB_NAVYBLUE		"#000080"
#define RGB_PINK		"#ffc0cb"
#define RGB_BISQUE1		"#ffe4c4"
#define RGB_RED			"#ff0000"
#define RGB_WHITE		"#ffffff"
#define RGB_YELLOW		"#ffff00"

#ifdef OLD_TK_COLORS
#define STD_NORMAL_BACKGROUND	RGB_BISQUE1
#define STD_ACTIVE_BACKGROUND	RGB_BISQUE2
#define STD_SELECT_BACKGROUND	RGB_LIGHTBLUE1
#define STD_DISABLED_FOREGROUND	RGB_GREY64
#else
#define STD_NORMAL_BACKGROUND	RGB_GREY85
#define STD_ACTIVE_BACKGROUND	RGB_GREY90
#define STD_SELECT_BACKGROUND	RGB_LIGHTBLUE1
#define STD_DISABLED_FOREGROUND	RGB_GREY64
#endif /* OLD_TK_COLORS */

#define STD_ACTIVE_BG_MONO	RGB_BLACK
#define STD_ACTIVE_FOREGROUND	RGB_BLACK
#define STD_ACTIVE_FG_MONO	RGB_WHITE
#define STD_BORDERWIDTH 	"2"
#define STD_FONT		"*-Helvetica-Medium-R-*-12-120-*"
#define STD_FONT_HUGE		"*-Helvetica-Medium-R-Normal-*-18-180-*"
#define STD_FONT_LARGE		"*-Helvetica-Medium-R-Normal-*-14-140-*"
#define STD_FONT_SMALL		"*-Helvetica-Medium-R-Normal-*-10-100-*"
#define STD_INDICATOR_COLOR	RGB_MAROON
#define STD_NORMAL_BG_MONO	RGB_WHITE
#define STD_NORMAL_FOREGROUND	RGB_BLACK
#define STD_NORMAL_FG_MONO	RGB_BLACK
#define STD_SELECT_BG_MONO	RGB_BLACK
#define STD_SELECT_BORDERWIDTH	"2"
#define STD_SELECT_FOREGROUND	RGB_BLACK
#define STD_SELECT_FG_MONO	RGB_WHITE
#define STD_SHADOW_MONO		RGB_BLACK
#define STD_SELECT_FONT		"*-Helvetica-Bold-R-Normal-*-12-120-*"

#define LineWidth(w)	(((w) > 1) ? (w) : 0)

#ifdef TCL_UTF_MAX
#define HAVE_UTF	1
#else
#define HAVE_UTF	0
#endif /* TCL_UTF_MAX */

typedef char *DestroyData;

#ifndef TK_RELIEF_SOLID
#define TK_RELIEF_SOLID		TK_RELIEF_FLAT
#endif

#ifdef WIN32
#include "bltWin.h"
#else 

#ifdef MACOSX
#include "bltMacOSX.h"
#endif /* MACOSX */

#endif /* WIN32 */

typedef int (QSortCompareProc) (const void *, const void *);

/*
 * -------------------------------------------------------------------
 *
 * Point2D --
 *
 *	2-D coordinate.
 *
 * -------------------------------------------------------------------
 */
typedef struct {
    double x, y;
} Point2D;

/*
 * -------------------------------------------------------------------
 *
 * Point3D --
 *
 *	3-D coordinate.
 *
 * -------------------------------------------------------------------
 */
typedef struct {
    double x, y, z;
} Point3D;

/*
 * -------------------------------------------------------------------
 *
 * Segment2D --
 *
 *	2-D line segment.
 *
 * -------------------------------------------------------------------
 */
typedef struct {
    Point2D p, q;		/* The two end points of the segment. */
} Segment2D;

/*
 * -------------------------------------------------------------------
 *
 * Dim2D --
 *
 *	2-D dimension.
 *
 * -------------------------------------------------------------------
 */
typedef struct {
    short int width, height;
} Dim2D;

/*
 *----------------------------------------------------------------------
 *
 * Region2D --
 *
 *      2-D region.  Used to copy parts of images.
 *
 *----------------------------------------------------------------------
 */
typedef struct {
    double left, right, top, bottom;
} Region2D;

typedef struct {
    double left, right, top, bottom, front, back;
} Region3D;

#define RegionWidth(r)		((r)->right - (r)->left + 1)
#define RegionHeight(r)		((r)->bottom - (r)->top + 1)

#define PointInRegion(e,x,y) \
	(((x) <= (e)->right) && ((x) >= (e)->left) && \
	 ((y) <= (e)->bottom) && ((y) >= (e)->top))

#define PointInRectangle(r,x0,y0) \
	(((x0) <= (int)((r)->x + (r)->width - 1)) && ((x0) >= (int)(r)->x) && \
	 ((y0) <= (int)((r)->y + (r)->height - 1)) && ((y0) >= (int)(r)->y))

/* -------------------------------------------------------------------
 *
 * ColorPair --
 *
 *	Holds a pair of foreground, background colors.
 *
 * -------------------------------------------------------------------
 */
typedef struct {
    XColor *fgColor, *bgColor;
} ColorPair;

#define COLOR_NONE		(XColor *)0
#define COLOR_DEFAULT		(XColor *)1
#define COLOR_ALLOW_DEFAULTS	1

extern int Blt_GetColorPair (Tcl_Interp *interp, Tk_Window tkwin, char *fgColor,
	char *bgColor, ColorPair *pairPtr, int colorFlag);

extern void Blt_FreeColorPair (ColorPair *pairPtr);


#define ARROW_LEFT		(0)
#define ARROW_UP		(1)
#define ARROW_RIGHT		(2)
#define ARROW_DOWN		(3)
#define ARROW_OFFSET		4
#define STD_ARROW_HEIGHT	3
#define STD_ARROW_WIDTH		((2 * (ARROW_OFFSET - 1)) + 1)

/*
 * ----------------------------------------------------------------------
 *
 * 	X11/Xosdefs.h requires XNOSTDHDRS be set for some systems.
 *	This is a guess.  If I can't find STDC headers or unistd.h,
 *	assume that this is non-POSIX and non-STDC environment.
 *	(needed for Encore Umax 3.4 ?)
 *
 * ----------------------------------------------------------------------
 */
#if !defined(STDC_HEADERS) && !defined(HAVE_UNISTD_H)
#define XNOSTDHDRS 	1
#endif

extern FILE *Blt_OpenFile(Tcl_Interp *interp, CONST char *fileName, 
	CONST char *mode);

extern int Blt_ExprDoubleFromObj (Tcl_Interp *interp, Tcl_Obj *objPtr, 
	double *valuePtr);

extern int Blt_ExprIntFromObj (Tcl_Interp *interp, Tcl_Obj *objPtr, 
	int *valuePtr);

extern char *Blt_Itoa (int value);

extern char *Blt_Ltoa (long value);

extern char *Blt_Utoa (unsigned int value);

extern char *Blt_Dtoa (Tcl_Interp *interp, double value);

extern int Blt_InitCmd (Tcl_Interp *interp, char *namespace, 
	Blt_InitCmdSpec *specPtr);

extern int Blt_InitCmds (Tcl_Interp *interp, char *namespace, 
	Blt_InitCmdSpec *specPtr, int nCmds);

#if (TCL_VERSION_NUMBER < _VERSION(8,1,0))
extern char *Tcl_GetString (Tcl_Obj *objPtr);

extern int Tcl_EvalObjv (Tcl_Interp *interp, int objc, Tcl_Obj **objv, 
	int flags);

extern int Tcl_WriteObj (Tcl_Channel channel, Tcl_Obj *objPtr);

extern char *Tcl_SetVar2Ex (Tcl_Interp *interp, char *part1, char *part2, 
	Tcl_Obj *objPtr, int flags);

extern Tcl_Obj *Tcl_GetVar2Ex (Tcl_Interp *interp, char *part1, char *part2, 
	int flags);
#endif /* TCL_VERSION_NUMBER < 8.1.0 */

extern int Blt_NaturalSpline (Point2D *origPts, int nOrigPts, Point2D *intpPts,
	int nIntpPts);

extern int Blt_QuadraticSpline (Point2D *origPts, int nOrigPts, 
	Point2D *intpPts, int nIntpPts);

extern int Blt_SimplifyLine (Point2D *origPts, int low, int high, 
	double tolerance, int *indices);

extern int Blt_NaturalParametricSpline (Point2D *origPts, int nOrigPts, 
	Region2D *extsPtr, int isClosed, Point2D *intpPts, int nIntpPts);

extern int Blt_CatromParametricSpline (Point2D *origPts, int nOrigPts, 
	Point2D *intpPts, int nIntpPts);

extern int Blt_StringToFlag (ClientData clientData, Tcl_Interp *interp, 
	Tk_Window tkwin, char *string, char *widgRec, int flags);

extern char *Blt_FlagToString (ClientData clientData, Tk_Window tkwin, 
	char *string, int offset, Tcl_FreeProc **freeProc);

extern void Blt_InitHexTable (char *table);

extern GC Blt_GetPrivateGC(Tk_Window tkwin, unsigned long gcMask,
	XGCValues *valuePtr);

extern GC Blt_GetPrivateGCFromDrawable(Display *display, Drawable drawable, 
	unsigned long gcMask, XGCValues *valuePtr);

extern void Blt_FreePrivateGC(Display *display, GC gc);

extern int Blt_GetWindowFromObj(Tcl_Interp *interp, Tcl_Obj *objPtr, 
	Window *windowPtr);

extern Window Blt_GetParentWindow(Display *display, Window window);

extern Tk_Window Blt_FindChild(Tk_Window parent, char *name);

extern Tk_Window Blt_FirstChild(Tk_Window parent);

extern Tk_Window Blt_NextChild(Tk_Window tkwin);

extern void Blt_RelinkWindow (Tk_Window tkwin, Tk_Window newParent, int x, 
	int y);

extern Tk_Window Blt_Toplevel(Tk_Window tkwin);

extern int Blt_GetPixels(Tcl_Interp *interp, Tk_Window tkwin, char *string, 
	int check, int *valuePtr);

extern int Blt_GetPosition(Tcl_Interp *interp, char *string, long *valuePtr);

#define Tcl_GetLong(i,s,p)	TclGetLong(i,s,p)

extern int Blt_GetCount(Tcl_Interp *interp, char *string, int check, 
	long *valuePtr);

extern int Blt_GetCountFromObj(Tcl_Interp *interp, Tcl_Obj *objPtr, int check,
	long *valuePtr);

extern char *Blt_NameOfFill (int fill);

extern int Blt_GetXY (Tcl_Interp *interp, Tk_Window tkwin, char *string, 
	int *x, int *y);

extern Point2D Blt_GetProjection (int x, int y, Point2D *p, Point2D *q);

extern void Blt_DrawArrow (Display *display, Drawable drawable, GC gc, 
	int x, int y, int arrowHeight, int orientation);

extern int Blt_OldConfigModified TCL_VARARGS(Tk_ConfigSpec *, specs);

extern void Blt_DStringAppendElements TCL_VARARGS(Tcl_DString *, args);

extern void Blt_MakeTransparentWindowExist (Tk_Window tkwin, Window parent, 
	int isBusy);

extern Window Blt_GetParent (Display *display, Window tkwin);

extern void Blt_GetBoundingBox (int width, int height, double angle, 
	double *widthPtr, double *heightPtr, Point2D *points);

extern void Blt_InitEpsCanvasItem (Tcl_Interp *interp);

extern void Blt_TranslateAnchor (int x, int y, int width, int height, 
	Tk_Anchor anchor, int *transXPtr, int *transYPtr);

extern Point2D Blt_AnchorPoint (double x, double y, double width, 
	double height, Tk_Anchor anchor);

extern void Blt_HSV (XColor *colorPtr, double *huePtr, double *valPtr, 
	double *satPtr);

extern void Blt_RGB (double hue, double sat, double val, XColor *colorPtr);

extern int Blt_ParseFlag (ClientData, Tcl_Interp *, Tk_Window, char *, 
	char *, int);
extern char *Blt_FlagPrint (ClientData, Tk_Window, char *, int, 
	Tcl_FreeProc **);

extern int Blt_MaxRequestSize (Display *display, unsigned int elemSize);

extern Window Blt_GetWindowId (Tk_Window tkwin);

extern int Blt_RootX (Tk_Window tkwin);

extern int Blt_RootY (Tk_Window tkwin);

extern void Blt_RootCoordinates (Tk_Window tkwin, int x, int y, int *rootXPtr, 
	int *rootYPtr);

extern void Blt_MapToplevel (Tk_Window tkwin);

extern void Blt_UnmapToplevel (Tk_Window tkwin);

extern void Blt_RaiseToplevel (Tk_Window tkwin);

extern void Blt_LowerToplevel (Tk_Window tkwin);

extern void Blt_ResizeToplevel (Tk_Window tkwin, int width, int height);

extern void Blt_MoveToplevel (Tk_Window tkwin, int x, int y);

extern void Blt_MoveResizeToplevel (Tk_Window tkwin, int x, int y, int width, 
	int height);

extern int Blt_GetWindowRegion(Display *display, Window window, int *xPtr,
	int *yPtr, int *widthPtr, int *heightPtr);

extern ClientData Blt_GetWindowInstanceData (Tk_Window tkwin);

extern void Blt_SetWindowInstanceData (Tk_Window tkwin, 
	ClientData instanceData);

extern void Blt_DeleteWindowInstanceData (Tk_Window tkwin);

extern int Blt_AdjustViewport (int offset, int worldSize, int windowSize, 
	int scrollUnits, int scrollMode);

extern int Blt_GetScrollInfoFromObj (Tcl_Interp *interp, int objc, 
	Tcl_Obj *CONST *objv, int *offsetPtr, int worldSize, int windowSize,
	int scrollUnits, int scrollMode);

extern void Blt_UpdateScrollbar (Tcl_Interp *interp, char *scrollCmd, 
	double firstFract, double lastFract);

extern int Blt_ReparentWindow (Display *display, Window window, 
	Window newParent, int x, int y);

#if defined(HAVE_JPEGLIB_H) || defined(HAVE_IJL_H)
#define HAVE_JPEG 1
extern int Blt_JPEGToPhoto (Tcl_Interp *interp, char *fileName, 
	Tk_PhotoHandle photo);
#endif /* HAVE_JPEGLIB_H || HAVE_IJL_H */

extern Blt_MallocProc *bltMallocPtr;
extern Blt_FreeProc *bltFreePtr;
extern Blt_ReallocProc *bltReallocPtr;

#define Blt_Malloc(size)	(*bltMallocPtr)(size)
#define Blt_Free		(*bltFreePtr)
#define Blt_Realloc(ptr, size)  (*bltReallocPtr)(ptr, size)

EXTERN char *Blt_Strdup (CONST char *ptr);

EXTERN void *Blt_Calloc (unsigned int nElem, size_t size);

#define Tk_RootWindow(tkwin)	\
	RootWindow(Tk_Display(tkwin),Tk_ScreenNumber(tkwin))

#ifndef WIN32
#define PurifyPrintf  printf
#endif /* WIN32 */

#include "bltConfig.h"

typedef Tk_FontMetrics Blt_FontMetrics;
#ifdef HAVE_LIBXFT
typedef struct Blt_FontStruct *Blt_Font;
extern Blt_Font Blt_GetFont(Tcl_Interp *interp, Tk_Window tkwin, CONST char *string);
extern Blt_Font Blt_AllocFontFromObj(Tcl_Interp *interp, Tk_Window tkwin, 
			      Tcl_Obj *objPtr);
extern char *Blt_NameOfFont(Blt_Font font);
extern void Blt_GetFontMetrics(Blt_Font font, Blt_FontMetrics *metricsPtr);
extern Font Blt_FontId(Blt_Font font);
extern int Blt_TextWidth(Blt_Font font, CONST char *string, int nBytes);
extern void Blt_FreeFont(Blt_Font font);
extern int Blt_MeasureChars(Blt_Font font, CONST char *text, int nBytes, int maxLength,
	int flags, int *lengthPtr);
extern void Blt_DrawChars(Display *display, Drawable drawable, int depth, GC gc,
	Blt_Font font, CONST char *text, int length, int x, int y);
extern void Blt_DrawRotatedChars(Display *display, Drawable drawable, int depth,
	GC gc, Blt_Font font, double angle, CONST char *string, int nBytes, 
	int x, int y);
extern int Blt_PostscriptFontName(Blt_Font font, Tcl_DString *resultPtr);
#else 
#define Blt_Font		Tk_Font
#define Blt_GetFont(interp,tkwin,string) \
    Tk_GetFont(interp,tkwin,string)
#define Blt_GetFontMetrics(font, metricsPtr)  \
    Tk_GetFontMetrics(font, metricsPtr)
#define Blt_NameOfFont(font)	Tk_GetFont(font)
#define Blt_FontId(font)	Tk_FontId(font)
#define Blt_FreeFont(font)	Tk_FreeFont(font)
#define Blt_TextWidth(font, string, nBytes) \
    Tk_TextWidth(font, string, nBytes)
#define Blt_MeasureChars(font, string, nBytes, maxLength, flags, lengthPtr) \
    Tk_MeasureChars(font, string, nBytes, maxLength, flags, lengthPtr) 
#define Blt_DrawChars(dpy, drawable, depth, gc, font, source, nBytes, x, y) \
    Tk_DrawChars(dpy, drawable, gc, font, source, nBytes, x, y)
#define Blt_PostscriptFontName(font, ds)  \
    Tk_PostscriptFontName(font, ds)
#endif /* HAVE_LIBXFT */    

extern CONST char *Blt_FontFamily(Blt_Font font);

#include "bltText.h"

/*
 * Define this if you want to be able to tile to the main window "."
 * This will cause a conflict with Tk if you try to compile and link
 * statically.
 */
#undef TILE_MAINWINDOW

#ifndef WIN32
#define NO_DDE		1
#define NO_PRINTER	1
#endif /* WIN32 */

#ifndef NO_BEEP
extern Tcl_AppInitProc Blt_BeepInit;
#endif
#ifndef NO_BGEXEC
extern Tcl_AppInitProc Blt_BgexecInit;
#endif
#ifndef NO_BITMAP
extern Tcl_AppInitProc Blt_BitmapInit;
#endif
#ifndef NO_BUSY
extern Tcl_AppInitProc Blt_BusyInit;
#endif
#ifndef NO_CONTAINER
extern Tcl_AppInitProc Blt_ContainerInit;
#endif
#ifndef NO_CRC32
extern Tcl_AppInitProc Blt_Crc32Init;
#endif
#ifndef NO_CVS
extern Tcl_AppInitProc Blt_CsvInit;
#endif
#ifndef NO_CUTBUFFER
extern Tcl_AppInitProc Blt_CutbufferInit;
#endif
#ifndef NO_DEBUG
extern Tcl_AppInitProc Blt_DebugInit;
#endif
#ifndef NO_DRAGDROP
extern Tcl_AppInitProc Blt_DragDropInit;
#endif
#ifndef NO_DND
extern Tcl_AppInitProc Blt_DndInit;
#endif
#ifndef NO_GRAPH
extern Tcl_AppInitProc Blt_GraphInit;
#endif
#ifndef NO_HIERBOX
extern Tcl_AppInitProc Blt_HierboxInit;
#endif
#ifndef NO_HIERTABLE
extern Tcl_AppInitProc Blt_HiertableInit;
#endif
#ifndef NO_HTEXT
extern Tcl_AppInitProc Blt_HtextInit;
#endif
#ifdef WIN32
#ifndef NO_PRINTER
extern Tcl_AppInitProc Blt_PrinterInit;
#endif
#endif
#ifndef NO_PICTURE
extern Tcl_AppInitProc Blt_PictureInit;
#endif
#ifndef NO_TABLE
extern Tcl_AppInitProc Blt_TableInit;
#endif
#ifndef NO_VECTOR
extern Tcl_AppInitProc Blt_VectorInit;
#endif
#ifndef NO_WINOP
extern Tcl_AppInitProc Blt_WinopInit;
#endif
#ifndef NO_WATCH
extern Tcl_AppInitProc Blt_WatchInit;
#endif
#ifndef NO_SPLINE
extern Tcl_AppInitProc Blt_SplineInit;
#endif
#ifndef NO_TABSET
extern Tcl_AppInitProc Blt_TabsetInit;
#endif
#ifndef NO_TABNOTEBOOK
extern Tcl_AppInitProc Blt_TabnotebookInit;
#endif
#ifndef NO_DATATABLE
extern Tcl_AppInitProc Blt_DataTableInit;
#endif
#ifndef NO_TREE
extern Tcl_AppInitProc Blt_TreeInit;
#endif
#ifndef NO_TREEVIEW
extern Tcl_AppInitProc Blt_TreeViewInit;
#endif
#ifndef NO_TILEFRAME
extern Tcl_AppInitProc Blt_FrameInit;
#endif
#ifndef NO_TILEBUTTON
extern Tcl_AppInitProc Blt_ButtonInit;
#endif
#ifndef NO_TILESCROLLBAR
extern Tcl_AppInitProc Blt_ScrollbarInit;
#endif
extern Tcl_AppInitProc Blt_BgStyleInit;

#if (BLT_MAJOR_VERSION == 3)
#ifndef NO_MOUNTAIN
extern Tcl_AppInitProc Blt_MountainInit;
#endif
#endif
#ifndef NO_TED
extern Tcl_AppInitProc Blt_TedInit;
#endif

#ifndef NO_DDE
extern Tcl_AppInitProc Blt_DdeInit;
#endif

#ifndef USE_TCL_STUBS
EXTERN int TclGetLong _ANSI_ARGS_((Tcl_Interp *interp, char *string, 
	long *longPtr));
#endif
#endif /*_BLT_INT_H*/
