
/*
 * bltSink.h --
 *
 *	Copyright 2003-2004 George A Howlett.
 *
 *	Permission is hereby granted, free of charge, to any person
 *	obtaining a copy of this software and associated documentation
 *	files (the "Software"), to deal in the Software without
 *	restriction, including without limitation the rights to use,
 *	copy, modify, merge, publish, distribute, sublicense, and/or
 *	sell copies of the Software, and to permit persons to whom the
 *	Software is furnished to do so, subject to the following
 *	conditions:
 *
 *	The above copyright notice and this permission notice shall be
 *	included in all copies or substantial portions of the
 *	Software.
 *
 *	THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY
 *	KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 *	WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 *	PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS
 *	OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR
 *	OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
 *	OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
 *	SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

#ifndef _BLT_SINK_H
#define _BLT_SINK_H

typedef struct Blt_DataSinkStruct {
    unsigned char *bytes;	/* Stores output (malloc-ed).*/
    size_t nBytes;		/* Size of dynamically allocated
				 * buffer. */

    size_t nFilled;		/* # of bytes read into the
				 * # buffer. Marks the current fill
				 * # point of the buffer. */
    size_t cursor;		/* Current position in buffer. */
    size_t chunk;		/* Buffer growth size. */
} *Blt_DataSink;


EXTERN void Blt_SinkVarAppend TCL_VARARGS(Blt_DataSink, sink);

EXTERN void Blt_SinkPrint TCL_VARARGS(Blt_DataSink, sink);

EXTERN void Blt_SinkInit _ANSI_ARGS_((Blt_DataSink sink));
EXTERN void Blt_SinkFree _ANSI_ARGS_((Blt_DataSink sink));
EXTERN int Blt_SinkAppendData _ANSI_ARGS_((Blt_DataSink sink, 
	unsigned char *bytes, int extra));
EXTERN int Blt_SinkSetLength _ANSI_ARGS_((Blt_DataSink sink, size_t length));

#define Blt_SinkBuffer(s)	((s)->bytes)
#define Blt_SinkLength(s)	((s)->nBytes)

#define Blt_SinkBytesLeft(s)    ((s)->nFilled - (s)->cursor)
#define Blt_SinkNextByte(s)	((s)->bytes[(s)->cursor++])

#define Blt_SinkPointer(s)	((s)->bytes + (s)->cursor)
#define Blt_SinkSetPointer(s,p)	((s)->cursor = (p) - (s)->bytes)

#define Blt_SinkResetCursor(s)  ((s)->cursor = 0)
#define Blt_SinkCursor(s)	((s)->cursor)
#define Blt_SinkSetCursor(s,n)  ((s)->cursor = (n))
#define Blt_SinkIncrCursor(s,i)	((s)->cursor += (i))

#define Blt_SinkMark(s)         ((s)->nFilled)
#define Blt_SinkSetMark(s,i)    \
	((s)->nFilled = (i), (s)->bytes[(s)->nFilled] = '\0')

EXTERN int Blt_DecodeBase64 _ANSI_ARGS_((Tcl_Interp *interp, char *string, 
	Blt_DataSink data));

EXTERN unsigned char *Blt_EncodeBase64 _ANSI_ARGS_((Tcl_Interp *interp, 
	Blt_DataSink data));

#endif /*_BLT_SINK_H*/
