/*
@(#)File:            $RCSfile: isqltcl.h,v $
@(#)Version:         $Revision: 1.1.1.1 $
@(#)Last changed:    $Date: 2000/03/01 17:53:40 $
@(#)Purpose:         Header File for ISQL/Tcl
@(#)Author:          J Leffler
@(#)Copyright:       (C) JLSS 1999
@(#)Product:         $Product: ISQLTCL Version 5.00a1 (1999-11-24) $
*/

/*TABSTOP=4*/

#ifndef ISQLTCL_H
#define ISQLTCL_H

#ifdef MAIN_PROGRAM
#ifndef lint
static char const isqltcl_h[] = "@(#)$Id: isqltcl.h,v 1.1.1.1 2000/03/01 17:53:40 stanton Exp $";
#endif	/* lint */
#endif	/* MAIN_PROGRAM */

extern char **sql_sqlca(int *numvalues);
extern char **sql_sqlcols(int fd, int in, char *arg, int *numvalues);
extern char **sql_sqlda(int fd, int in, int num, int *numvalues);
extern char **sql_values(int fd, int *numvalues, int dostrip);
extern char *sql_getdatabase(void);
extern char *sql_geterror(void);
extern int sql_begin(void);
extern int sql_close(int);
extern int sql_commit(void);
extern int sql_connect(char *dbname, char *uid, char *pw, char *cname, int with_contrans);
extern int sql_database(char *dbname, int exclusive);
extern int sql_disconnect(char *arg);
extern int sql_exists(char *table, char *field, char *value, char *where);
extern int sql_explain(int);
extern int sql_fetch(int);
extern int sql_finish(void);
extern int sql_open(char *stmt, int argc, char **argv);
extern int sql_readblob(char *table, char *column, char *rowidclause, char *intofile, int appendmode);
extern int sql_reopen(int fd, int argc, char **argv);
extern int sql_rollback(void);
extern int sql_run(char *stmt, int argc, char **argv);
extern int sql_setconnection(char *arg, int dormant);
extern int sql_sigcmd(char *arg);
extern int sql_sqld(int fd, int in);
extern int sql_writeblob(char *table, char *column, char *rowidclause, char *fromfile, int fromsize);

#endif	/* ISQLTCL_H */
