# ISTAR SERVER 1.1
# Created: Thu Apr  4 09:40:05 EST 1996
# Last Updated: Tue Apr 30 14:17:31 EDT 1996

# Send output back to client
proc send_output {cmd} {
	set len [string length $cmd]
	puts -nonewline stdout [format " %06d" $len]
	puts -nonewline stdout $cmd
	flush stdout
}
# Send Control Commands back to client
proc send_control {state cmd} {
	set len [string length $cmd]
	puts -nonewline stdout [format "%-1.1s%06d" $state $len]
	puts -nonewline stdout $cmd
	flush stdout
}
# Provide inetd service to rpcserv.tcl
proc istar_service_do {args} {
	#puts "GOT $args"
	set sockfd [lindex $args 0]
	set sockhost [lindex $args 1]
	set sockport [lindex $args 2]
	#flush stdout
	#puts "Launched: exec rtclsh istarserv.tcl <@$sockfd >@$sockfd 2>@$sockfd &"
	fconfigure $sockfd -translation binary
	exec rtclsh istarserv.tcl <@$sockfd >@$sockfd 2>@$sockfd &
	#puts "sockfd is $sockfd"
	#flush stdout
	close $sockfd
}
if {"[info commands getenv]" != "getenv"} {
	proc getenv {var} {
		global env
		if {[info exists env($var)]} {
			return $env($var)
		}
		return ""
	}
}
global argv
foreach opt $argv {
	if {$opt == "-server"} {
		set _sockport [getenv ISTARSOCKET]
		if {$_sockport == ""} {
			set _sockport 7028
		}
	}
}
if {[info exists _sockport]} {
	if {[catch {socket -server istar_service_do $_sockport} _mainport] != 0} {
		puts "ERROR: $_mainport Port#: $_sockport"
		exit 1
	}
	vwait any
	exit 0
}
# Loop waiting for requests
# Read request length
# Read request
# Eval Request
# Send Output Back
while {1} {
	set len [read stdin 6]
	scan $len "%d" len
	set line [read stdin $len]
	flush stdout
	if {[eof stdin]} {
		send_control F EOF
		exit 0
	}
	if {$line == ""} {
		send_control X EXIT
		exit 0
	}
	if {[catch {eval $line} out] == 0} {
		send_output $out
	} else {
		send_control E $out
	}
}
