variable stack
variable scalar
variable literal

namespace eval vm {
    # Generic routine to replace the top of stack with an unknown value.
    variable tosUnknown {
	set stack [lreplace $stack end end $vsUnknown]
    }

    variable push1 { lappend stack $literal($op1) }
    variable push4 $push1
    variable pop   { variable stack [lrange $stack 0 end-1] }
    variable dup   { lappend stack [lindex $stack end] }

    variable concat1 {
	set stack [lrange $stack 0 end-${op1}]
	lappend stack $vsUnknown
    }
    variable invokeStk1 $concat1
    variable invokeStk4 $concat1

    variable evalStk $tosUnknown
    variable exprStk $tosUnknown
    
    variable loadScalar1 {
	lappend stack $scalar($op1)
	if {$scalar($op1) == $vsUnused} {
	    puts stderr "Warning: At offset $offset instruction $iname: no value assigned to scalar $op1."
	}
    }
    variable loadScalar4 $loadScalar1

    variable loadScalarStk $tosUnknown
    variable loadArray1 {
	set scalar($op1) $vsArray
	set stack [lreplace $stack end end $vsUnknown]
    }
    variable loadArray4    $tosUnknown
    variable loadArrayStk {
	set stack [lrange $stack 0 end-2]
	lappend stack $vsUnknown
    }
    variable loadStk $tosUnknown

    variable storeScalar1 { set scalar($op1) [lindex $stack end] }
    variable storeScalar4 $storeScalar1
    variable storeScalarStk {
	# Ugly instruction.  This can invalidate everything in the compiled
	# locals array.
	set valueType [lindex $stack end]
	foreach el [array names scalar] {
	    # If they match, we don't need to do anything.
	    if {$scalar($el) == $valueType} { continue }

	    # If they're of mismatched numeric types, then the scalar gets
	    # the abstract numeric type.
	    if {($valueType == $vsInt || $valueType == $vsDouble ||
		 $valueType == $vsNumeric) &&
		($scalar($el) == $vsInt || $scalar($el) == $vsDouble ||
		 $scalar($el) == $vsNumeric)} {
		set scalar($el) $vsNumeric
	    } else {
		# Otherwise, the scalar is invalidated.
		set scalar($el) $vsUnknown
	    }
	}

	set stack [lrange $stack 0 end-2]
	lappend stack $vsUnknown
    }

    variable storeArray1 {
	set scalar($op1) $vsArray
	set stack [lrange $stack 0 end-2]
	lappend stack $vsUnknown
    }
    variable storeArray4 $storeArray1
    variable storeArrayStk {
	# Another horrendous instruction.  Any scalar can now be an array.
	# Change all non-array elements to unknown.
	foreach el [array names scalar] {
	    if {$scalar($el) == $vsArray} { continue }
	    set scalar($el) $vsUnknown
	}

	set stack [lrange $stack 0 end-3]
	lappend stack $vsUnknown
    }
    variable storeStk $storeScalarStk

    variable incrScalar1 { set scalar($op1) $vsInt }
    variable incrScalar1Imm {
	set scalar($op1) $vsInt
	lappend stack $vsInt
    }
    variable incrScalarStk {
	set stack [lrange $stack 0 end-2 $vsInt]
    }
    variable incrStk $incrScalarStk
    variable incrArray1 {
	set scalar($op1) $vsArray
	set stack [lrange $stack 0 end-2 $vsInt]
	lappend stack $vsInt
    }
    variable incrArrayStk {
	set stack [lrange $stack 0 end-3 $vsInt]
    }
    variable incrScalarStkImm {
	set stack [lreplace $stack end end $vsInt]
    }
    variable incrStkImm $incrScalarStkImm
    variable incrArray1Imm {
	set scalar($op1) $vsArray
	set stack [lreplace $stack end end $vsInt]
    }
    variable incrArrayStkImm {
	set stack [lreplace $stack 0 end-2 $vsInt]
    }

    variable eq { set stack [lreplace $stack end-1 end $vsInt] }
    variable neq $eq
    variable lt  $eq
    variable gt  $eq
    variable le  $eq
    variable ge  $eq

    variable add {
	set se0 [lindex $stack end]
	set se1 [lindex $stack end-1]
	set stack [lrange $stack 0 end-2]

	if {$se0 == $vsInt && $se1 == $vsInt} {
	    lappend stack $vsInt
	} elseif {$se0 == $vsDouble || $se1 == $vsDouble} {
	    lappend stack $vsDouble
	} else {
	    lappend stack $vsNumeric
	}
    }
    variable sub $add
    variable mult $add
    variable div $add

    variable foreach_start4 {
	set scalar($foreach_scalar($op1)) $vsInt
    }

    variable foreach_step4 {
	set scalar($foreach_scalar($op1)) $vsInt
	lappend stack $vsInt
    }

    variable beginCatch4 {
	# FIXME: We need to keep track of the catch stack
    }

    variable endCatch {
	# FIXME: We need to keep track of the catch stack
    }

    variable tryCvtToNumeric {
	# No change.  If the topmost stack item is an int or double, it
	# will remain as such.  Otherwise, we have no way of knowing if
	# the conversion will succeed.
    }
}
