##############################################################################
#
#   File: Basic_001.tcl
#   Basic functionality test.
#
##############################################################################
#
#   Copyright (c) 2000 David Cuthbert / Kanga International Group.
#   All rights reserved.
#
#   Permission to use, copy, modify, distribute and sell this software
#   and its documentation for any purpose is hereby granted without fee,
#   provided that the above copyright notice appear in all copies and
#   that both that copyright notice and this permission notice appear
#   in supporting documentation.  The author(s) make no representations
#   about the suitability of this software for any purpose.  It is 
#   provided "as is" without express or implied warranty.
#
##############################################################################

package require kt2c

set base   Basic_001

# Simple routine to exercise variables, etc.
proc GetArg {} {
    upvar 1 arg arg
    return $arg
}

proc Hello {i args} {
    puts "Hello called with [join $args]"
    set retval 0

    foreach arg $args {
	set retval [expr {[GetArg] + $retval}]
    }

    return $retval
}

puts "Normal test:"
puts "Result was [Hello 1 2.2 3]"

set ccode [kt2c::Translate Hello]

set fd [open ${base}.c w]
puts $fd [kt2c::FileHeader]
puts $fd [lindex $ccode 1]
puts $fd ""
puts $fd [kt2c::LibraryInitialiser $base [lindex $ccode 0]]
close $fd

set libname [kt2c::Compile ${base}.c]
load ${libname} ${base}

puts "Compiled test:"
puts "Result was [Hello 1 2.2 3]"
