/*
 * tclIntDecls.h --
 *
 *	This file contains the declarations for all unsupported
 *	functions that are exported by the Tcl library.  These
 *	interfaces are not guaranteed to remain the same between
 *	versions.  Use at your own risk.
 *
 * Copyright (c) 1998-1999 by Scriptics Corporation.
 *
 * See the file "license.terms" for information on usage and redistribution
 * of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 *
 * RCS: @(#) $Id: tclIntDecls.h,v 1.3.2.4 1999/03/14 18:56:09 stanton Exp $
 */

#ifndef _TCLINTDECLS
#define _TCLINTDECLS

/*
 * WARNING: This file is automatically generated by the tools/genStubs.tcl
 * script.  Any modifications to the function declarations below should be made
 * in the generic/tclInt.decls script.
 */

/* !BEGIN!: Do not edit below this line. */

/*
 * Exported function declarations:
 */

/* 0 */
EXTERN int		TclAccess _ANSI_ARGS_((CONST char * path, int mode));
/* 1 */
EXTERN int		TclAccessDeleteProc _ANSI_ARGS_((
				TclAccessProc_ * proc));
/* 2 */
EXTERN int		TclAccessInsertProc _ANSI_ARGS_((
				TclAccessProc_ * proc));
/* 3 */
EXTERN void		TclAllocateFreeObjects _ANSI_ARGS_((void));
/* Slot 4 is reserved */
/* 5 */
EXTERN int		TclCleanupChildren _ANSI_ARGS_((Tcl_Interp * interp, 
				int numPids, Tcl_Pid * pidPtr, 
				Tcl_Channel errorChan));
/* 6 */
EXTERN void		TclCleanupCommand _ANSI_ARGS_((Command * cmdPtr));
/* 7 */
EXTERN int		TclCopyAndCollapse _ANSI_ARGS_((int count, 
				CONST char * src, char * dst));
/* 8 */
EXTERN int		TclCopyChannel _ANSI_ARGS_((Tcl_Interp * interp, 
				Tcl_Channel inChan, Tcl_Channel outChan, 
				int toRead, Tcl_Obj * cmdPtr));
/* 9 */
EXTERN int		TclCreatePipeline _ANSI_ARGS_((Tcl_Interp * interp, 
				int argc, char ** argv, 
				Tcl_Pid ** pidArrayPtr, TclFile * inPipePtr, 
				TclFile * outPipePtr, TclFile * errFilePtr));
/* 10 */
EXTERN int		TclCreateProc _ANSI_ARGS_((Tcl_Interp * interp, 
				Namespace * nsPtr, char * procName, 
				Tcl_Obj * argsPtr, Tcl_Obj * bodyPtr, 
				Proc ** procPtrPtr));
/* 11 */
EXTERN void		TclDeleteCompiledLocalVars _ANSI_ARGS_((
				Interp * iPtr, CallFrame * framePtr));
/* 12 */
EXTERN void		TclDeleteVars _ANSI_ARGS_((Interp * iPtr, 
				Tcl_HashTable * tablePtr));
/* 13 */
EXTERN int		TclDoGlob _ANSI_ARGS_((Tcl_Interp * interp, 
				char * separators, Tcl_DString * headPtr, 
				char * tail));
/* 14 */
EXTERN void		TclDumpMemoryInfo _ANSI_ARGS_((FILE * outFile));
/* Slot 15 is reserved */
/* 16 */
EXTERN void		TclExprFloatError _ANSI_ARGS_((Tcl_Interp * interp, 
				double value));
/* 17 */
EXTERN int		TclFileAttrsCmd _ANSI_ARGS_((Tcl_Interp * interp, 
				int objc, Tcl_Obj *CONST objv[]));
/* 18 */
EXTERN int		TclFileCopyCmd _ANSI_ARGS_((Tcl_Interp * interp, 
				int argc, char ** argv));
/* 19 */
EXTERN int		TclFileDeleteCmd _ANSI_ARGS_((Tcl_Interp * interp, 
				int argc, char ** argv));
/* 20 */
EXTERN int		TclFileMakeDirsCmd _ANSI_ARGS_((Tcl_Interp * interp, 
				int argc, char ** argv));
/* 21 */
EXTERN int		TclFileRenameCmd _ANSI_ARGS_((Tcl_Interp * interp, 
				int argc, char ** argv));
/* 22 */
EXTERN int		TclFindElement _ANSI_ARGS_((Tcl_Interp * interp, 
				CONST char * list, int listLength, 
				CONST char ** elementPtr, 
				CONST char ** nextPtr, int * sizePtr, 
				int * bracePtr));
/* 23 */
EXTERN Proc *		TclFindProc _ANSI_ARGS_((Interp * iPtr, 
				char * procName));
/* 24 */
EXTERN int		TclFormatInt _ANSI_ARGS_((char * buffer, long n));
/* 25 */
EXTERN void		TclFreePackageInfo _ANSI_ARGS_((Interp * iPtr));
/* Slot 26 is reserved */
/* 27 */
EXTERN int		TclGetDate _ANSI_ARGS_((char * p, unsigned long now, 
				long zone, unsigned long * timePtr));
/* 28 */
EXTERN Tcl_Channel	TclpGetDefaultStdChannel _ANSI_ARGS_((int type));
/* 29 */
EXTERN Tcl_Obj *	TclGetElementOfIndexedArray _ANSI_ARGS_((
				Tcl_Interp * interp, int localIndex, 
				Tcl_Obj * elemPtr, int leaveErrorMsg));
/* Slot 30 is reserved */
/* 31 */
EXTERN char *		TclGetExtension _ANSI_ARGS_((char * name));
/* 32 */
EXTERN int		TclGetFrame _ANSI_ARGS_((Tcl_Interp * interp, 
				char * string, CallFrame ** framePtrPtr));
/* 33 */
EXTERN TclCmdProcType	TclGetInterpProc _ANSI_ARGS_((void));
/* 34 */
EXTERN int		TclGetIntForIndex _ANSI_ARGS_((Tcl_Interp * interp, 
				Tcl_Obj * objPtr, int endValue, 
				int * indexPtr));
/* 35 */
EXTERN Tcl_Obj *	TclGetIndexedScalar _ANSI_ARGS_((Tcl_Interp * interp, 
				int localIndex, int leaveErrorMsg));
/* 36 */
EXTERN int		TclGetLong _ANSI_ARGS_((Tcl_Interp * interp, 
				char * string, long * longPtr));
/* 37 */
EXTERN int		TclGetLoadedPackages _ANSI_ARGS_((
				Tcl_Interp * interp, char * targetName));
/* 38 */
EXTERN int		TclGetNamespaceForQualName _ANSI_ARGS_((
				Tcl_Interp * interp, char * qualName, 
				Namespace * cxtNsPtr, int flags, 
				Namespace ** nsPtrPtr, 
				Namespace ** altNsPtrPtr, 
				Namespace ** actualCxtPtrPtr, 
				char ** simpleNamePtr));
/* 39 */
EXTERN TclObjCmdProcType TclGetObjInterpProc _ANSI_ARGS_((void));
/* 40 */
EXTERN int		TclGetOpenMode _ANSI_ARGS_((Tcl_Interp * interp, 
				char * string, int * seekFlagPtr));
/* 41 */
EXTERN Tcl_Command	TclGetOriginalCommand _ANSI_ARGS_((
				Tcl_Command command));
/* 42 */
EXTERN char *		TclpGetUserHome _ANSI_ARGS_((CONST char * name, 
				Tcl_DString * bufferPtr));
/* 43 */
EXTERN int		TclGlobalInvoke _ANSI_ARGS_((Tcl_Interp * interp, 
				int argc, char ** argv, int flags));
/* 44 */
EXTERN int		TclGuessPackageName _ANSI_ARGS_((char * fileName, 
				Tcl_DString * bufPtr));
/* 45 */
EXTERN int		TclHideUnsafeCommands _ANSI_ARGS_((
				Tcl_Interp * interp));
/* 46 */
EXTERN int		TclInExit _ANSI_ARGS_((void));
/* 47 */
EXTERN Tcl_Obj *	TclIncrElementOfIndexedArray _ANSI_ARGS_((
				Tcl_Interp * interp, int localIndex, 
				Tcl_Obj * elemPtr, long incrAmount));
/* 48 */
EXTERN Tcl_Obj *	TclIncrIndexedScalar _ANSI_ARGS_((
				Tcl_Interp * interp, int localIndex, 
				long incrAmount));
/* 49 */
EXTERN Tcl_Obj *	TclIncrVar2 _ANSI_ARGS_((Tcl_Interp * interp, 
				Tcl_Obj * part1Ptr, Tcl_Obj * part2Ptr, 
				long incrAmount, int part1NotParsed));
/* 50 */
EXTERN void		TclInitCompiledLocals _ANSI_ARGS_((
				Tcl_Interp * interp, CallFrame * framePtr, 
				Namespace * nsPtr));
/* 51 */
EXTERN int		TclInterpInit _ANSI_ARGS_((Tcl_Interp * interp));
/* 52 */
EXTERN int		TclInvoke _ANSI_ARGS_((Tcl_Interp * interp, int argc, 
				char ** argv, int flags));
/* 53 */
EXTERN int		TclInvokeObjectCommand _ANSI_ARGS_((
				ClientData clientData, Tcl_Interp * interp, 
				int argc, char ** argv));
/* 54 */
EXTERN int		TclInvokeStringCommand _ANSI_ARGS_((
				ClientData clientData, Tcl_Interp * interp, 
				int objc, Tcl_Obj *CONST objv[]));
/* 55 */
EXTERN Proc *		TclIsProc _ANSI_ARGS_((Command * cmdPtr));
/* Slot 56 is reserved */
/* Slot 57 is reserved */
/* 58 */
EXTERN Var *		TclLookupVar _ANSI_ARGS_((Tcl_Interp * interp, 
				char * part1, char * part2, int flags, 
				char * msg, int createPart1, int createPart2, 
				Var ** arrayPtrPtr));
/* 59 */
EXTERN int		TclpMatchFiles _ANSI_ARGS_((Tcl_Interp * interp, 
				char * separators, Tcl_DString * dirPtr, 
				char * pattern, char * tail));
/* 60 */
EXTERN int		TclNeedSpace _ANSI_ARGS_((char * start, char * end));
/* 61 */
EXTERN Tcl_Obj *	TclNewProcBodyObj _ANSI_ARGS_((Proc * procPtr));
/* 62 */
EXTERN int		TclObjCommandComplete _ANSI_ARGS_((Tcl_Obj * cmdPtr));
/* 63 */
EXTERN int		TclObjInterpProc _ANSI_ARGS_((ClientData clientData, 
				Tcl_Interp * interp, int objc, 
				Tcl_Obj *CONST objv[]));
/* 64 */
EXTERN int		TclObjInvoke _ANSI_ARGS_((Tcl_Interp * interp, 
				int objc, Tcl_Obj *CONST objv[], int flags));
/* 65 */
EXTERN int		TclObjInvokeGlobal _ANSI_ARGS_((Tcl_Interp * interp, 
				int objc, Tcl_Obj *CONST objv[], int flags));
/* 66 */
EXTERN int		TclOpenFileChannelDeleteProc _ANSI_ARGS_((
				TclOpenFileChannelProc_ * proc));
/* 67 */
EXTERN int		TclOpenFileChannelInsertProc _ANSI_ARGS_((
				TclOpenFileChannelProc_ * proc));
/* 68 */
EXTERN int		TclpAccess _ANSI_ARGS_((CONST char * path, int mode));
/* 69 */
EXTERN char *		TclpAlloc _ANSI_ARGS_((unsigned int size));
/* 70 */
EXTERN int		TclpCopyFile _ANSI_ARGS_((CONST char * source, 
				CONST char * dest));
/* 71 */
EXTERN int		TclpCopyDirectory _ANSI_ARGS_((CONST char * source, 
				CONST char * dest, Tcl_DString * errorPtr));
/* 72 */
EXTERN int		TclpCreateDirectory _ANSI_ARGS_((CONST char * path));
/* 73 */
EXTERN int		TclpDeleteFile _ANSI_ARGS_((CONST char * path));
/* 74 */
EXTERN void		TclpFree _ANSI_ARGS_((char * ptr));
/* 75 */
EXTERN unsigned long	TclpGetClicks _ANSI_ARGS_((void));
/* 76 */
EXTERN unsigned long	TclpGetSeconds _ANSI_ARGS_((void));
/* 77 */
EXTERN void		TclpGetTime _ANSI_ARGS_((Tcl_Time * time));
/* 78 */
EXTERN int		TclpGetTimeZone _ANSI_ARGS_((unsigned long time));
/* 79 */
EXTERN int		TclpListVolumes _ANSI_ARGS_((Tcl_Interp * interp));
/* 80 */
EXTERN Tcl_Channel	TclpOpenFileChannel _ANSI_ARGS_((Tcl_Interp * interp, 
				char * fileName, char * modeString, 
				int permissions));
/* 81 */
EXTERN char *		TclpRealloc _ANSI_ARGS_((char * ptr, 
				unsigned int size));
/* 82 */
EXTERN int		TclpRemoveDirectory _ANSI_ARGS_((CONST char * path, 
				int recursive, Tcl_DString * errorPtr));
/* 83 */
EXTERN int		TclpRenameFile _ANSI_ARGS_((CONST char * source, 
				CONST char * dest));
/* Slot 84 is reserved */
/* Slot 85 is reserved */
/* Slot 86 is reserved */
/* Slot 87 is reserved */
/* 88 */
EXTERN char *		TclPrecTraceProc _ANSI_ARGS_((ClientData clientData, 
				Tcl_Interp * interp, char * name1, 
				char * name2, int flags));
/* 89 */
EXTERN int		TclPreventAliasLoop _ANSI_ARGS_((Tcl_Interp * interp, 
				Tcl_Interp * cmdInterp, Tcl_Command cmd));
/* Slot 90 is reserved */
/* 91 */
EXTERN void		TclProcCleanupProc _ANSI_ARGS_((Proc * procPtr));
/* 92 */
EXTERN int		TclProcCompileProc _ANSI_ARGS_((Tcl_Interp * interp, 
				Proc * procPtr, Tcl_Obj * bodyPtr, 
				Namespace * nsPtr, CONST char * description, 
				CONST char * procName));
/* 93 */
EXTERN void		TclProcDeleteProc _ANSI_ARGS_((ClientData clientData));
/* 94 */
EXTERN int		TclProcInterpProc _ANSI_ARGS_((ClientData clientData, 
				Tcl_Interp * interp, int argc, char ** argv));
/* 95 */
EXTERN int		TclpStat _ANSI_ARGS_((CONST char * path, 
				struct stat * buf));
/* 96 */
EXTERN int		TclRenameCommand _ANSI_ARGS_((Tcl_Interp * interp, 
				char * oldName, char * newName));
/* 97 */
EXTERN void		TclResetShadowedCmdRefs _ANSI_ARGS_((
				Tcl_Interp * interp, Command * newCmdPtr));
/* 98 */
EXTERN int		TclServiceIdle _ANSI_ARGS_((void));
/* 99 */
EXTERN Tcl_Obj *	TclSetElementOfIndexedArray _ANSI_ARGS_((
				Tcl_Interp * interp, int localIndex, 
				Tcl_Obj * elemPtr, Tcl_Obj * objPtr, 
				int leaveErrorMsg));
/* 100 */
EXTERN Tcl_Obj *	TclSetIndexedScalar _ANSI_ARGS_((Tcl_Interp * interp, 
				int localIndex, Tcl_Obj * objPtr, 
				int leaveErrorMsg));
/* Slot 101 is reserved */
/* 102 */
EXTERN void		TclSetupEnv _ANSI_ARGS_((Tcl_Interp * interp));
/* 103 */
EXTERN int		TclSockGetPort _ANSI_ARGS_((Tcl_Interp * interp, 
				char * string, char * proto, int * portPtr));
/* 104 */
EXTERN int		TclSockMinimumBuffers _ANSI_ARGS_((int sock, 
				int size));
/* 105 */
EXTERN int		TclStat _ANSI_ARGS_((CONST char * path, 
				TclStat_ * buf));
/* 106 */
EXTERN int		TclStatDeleteProc _ANSI_ARGS_((TclStatProc_ * proc));
/* 107 */
EXTERN int		TclStatInsertProc _ANSI_ARGS_((TclStatProc_ * proc));
/* 108 */
EXTERN void		TclTeardownNamespace _ANSI_ARGS_((Namespace * nsPtr));
/* 109 */
EXTERN int		TclUpdateReturnInfo _ANSI_ARGS_((Interp * iPtr));
/* Slot 110 is reserved */
/* 111 */
EXTERN void		Tcl_AddInterpResolvers _ANSI_ARGS_((
				Tcl_Interp * interp, char * name, 
				Tcl_ResolveCmdProc * cmdProc, 
				Tcl_ResolveVarProc * varProc, 
				Tcl_ResolveCompiledVarProc * compiledVarProc));
/* 112 */
EXTERN int		Tcl_AppendExportList _ANSI_ARGS_((
				Tcl_Interp * interp, Tcl_Namespace * nsPtr, 
				Tcl_Obj * objPtr));
/* 113 */
EXTERN Tcl_Namespace *	Tcl_CreateNamespace _ANSI_ARGS_((Tcl_Interp * interp, 
				char * name, ClientData clientData, 
				Tcl_NamespaceDeleteProc * deleteProc));
/* 114 */
EXTERN void		Tcl_DeleteNamespace _ANSI_ARGS_((
				Tcl_Namespace * nsPtr));
/* 115 */
EXTERN int		Tcl_Export _ANSI_ARGS_((Tcl_Interp * interp, 
				Tcl_Namespace * nsPtr, char * pattern, 
				int resetListFirst));
/* 116 */
EXTERN Tcl_Command	Tcl_FindCommand _ANSI_ARGS_((Tcl_Interp * interp, 
				char * name, Tcl_Namespace * contextNsPtr, 
				int flags));
/* 117 */
EXTERN Tcl_Namespace *	Tcl_FindNamespace _ANSI_ARGS_((Tcl_Interp * interp, 
				char * name, Tcl_Namespace * contextNsPtr, 
				int flags));
/* 118 */
EXTERN int		Tcl_GetInterpResolvers _ANSI_ARGS_((
				Tcl_Interp * interp, char * name, 
				Tcl_ResolverInfo * resInfo));
/* 119 */
EXTERN int		Tcl_GetNamespaceResolvers _ANSI_ARGS_((
				Tcl_Namespace * namespacePtr, 
				Tcl_ResolverInfo * resInfo));
/* 120 */
EXTERN Tcl_Var		Tcl_FindNamespaceVar _ANSI_ARGS_((
				Tcl_Interp * interp, char * name, 
				Tcl_Namespace * contextNsPtr, int flags));
/* 121 */
EXTERN int		Tcl_ForgetImport _ANSI_ARGS_((Tcl_Interp * interp, 
				Tcl_Namespace * nsPtr, char * pattern));
/* 122 */
EXTERN Tcl_Command	Tcl_GetCommandFromObj _ANSI_ARGS_((
				Tcl_Interp * interp, Tcl_Obj * objPtr));
/* 123 */
EXTERN void		Tcl_GetCommandFullName _ANSI_ARGS_((
				Tcl_Interp * interp, Tcl_Command command, 
				Tcl_Obj * objPtr));
/* 124 */
EXTERN Tcl_Namespace *	Tcl_GetCurrentNamespace _ANSI_ARGS_((
				Tcl_Interp * interp));
/* 125 */
EXTERN Tcl_Namespace *	Tcl_GetGlobalNamespace _ANSI_ARGS_((
				Tcl_Interp * interp));
/* 126 */
EXTERN void		Tcl_GetVariableFullName _ANSI_ARGS_((
				Tcl_Interp * interp, Tcl_Var variable, 
				Tcl_Obj * objPtr));
/* 127 */
EXTERN int		Tcl_Import _ANSI_ARGS_((Tcl_Interp * interp, 
				Tcl_Namespace * nsPtr, char * pattern, 
				int allowOverwrite));
/* 128 */
EXTERN void		Tcl_PopCallFrame _ANSI_ARGS_((Tcl_Interp* interp));
/* 129 */
EXTERN int		Tcl_PushCallFrame _ANSI_ARGS_((Tcl_Interp* interp, 
				Tcl_CallFrame * framePtr, 
				Tcl_Namespace * nsPtr, int isProcCallFrame));
/* 130 */
EXTERN int		Tcl_RemoveInterpResolvers _ANSI_ARGS_((
				Tcl_Interp * interp, char * name));
/* 131 */
EXTERN void		Tcl_SetNamespaceResolvers _ANSI_ARGS_((
				Tcl_Namespace * namespacePtr, 
				Tcl_ResolveCmdProc * cmdProc, 
				Tcl_ResolveVarProc * varProc, 
				Tcl_ResolveCompiledVarProc * compiledVarProc));
/* 132 */
EXTERN int		TclpHasSockets _ANSI_ARGS_((Tcl_Interp * interp));
/* 133 */
EXTERN struct tm *	TclpGetDate _ANSI_ARGS_((TclpTime_t time, int useGMT));
/* 134 */
EXTERN size_t		TclpStrftime _ANSI_ARGS_((char * s, size_t maxsize, 
				CONST char * format, CONST struct tm * t));
/* 135 */
EXTERN int		TclpCheckStackSpace _ANSI_ARGS_((void));
/* Slot 136 is reserved */
/* 137 */
EXTERN int		TclpChdir _ANSI_ARGS_((CONST char * dirName));
/* 138 */
EXTERN char *		TclGetEnv _ANSI_ARGS_((CONST char * name, 
				Tcl_DString * valuePtr));
/* 139 */
EXTERN int		TclpLoadFile _ANSI_ARGS_((Tcl_Interp * interp, 
				char * fileName, char * sym1, char * sym2, 
				Tcl_PackageInitProc ** proc1Ptr, 
				Tcl_PackageInitProc ** proc2Ptr, 
				ClientData * clientDataPtr));
/* 140 */
EXTERN int		TclLooksLikeInt _ANSI_ARGS_((char * bytes, 
				int length));

typedef struct TclIntStubs {
    int magic;
    struct TclIntStubHooks *hooks;

    int (*tclAccess) _ANSI_ARGS_((CONST char * path, int mode)); /* 0 */
    int (*tclAccessDeleteProc) _ANSI_ARGS_((TclAccessProc_ * proc)); /* 1 */
    int (*tclAccessInsertProc) _ANSI_ARGS_((TclAccessProc_ * proc)); /* 2 */
    void (*tclAllocateFreeObjects) _ANSI_ARGS_((void)); /* 3 */
    void *reserved4;
    int (*tclCleanupChildren) _ANSI_ARGS_((Tcl_Interp * interp, int numPids, Tcl_Pid * pidPtr, Tcl_Channel errorChan)); /* 5 */
    void (*tclCleanupCommand) _ANSI_ARGS_((Command * cmdPtr)); /* 6 */
    int (*tclCopyAndCollapse) _ANSI_ARGS_((int count, CONST char * src, char * dst)); /* 7 */
    int (*tclCopyChannel) _ANSI_ARGS_((Tcl_Interp * interp, Tcl_Channel inChan, Tcl_Channel outChan, int toRead, Tcl_Obj * cmdPtr)); /* 8 */
    int (*tclCreatePipeline) _ANSI_ARGS_((Tcl_Interp * interp, int argc, char ** argv, Tcl_Pid ** pidArrayPtr, TclFile * inPipePtr, TclFile * outPipePtr, TclFile * errFilePtr)); /* 9 */
    int (*tclCreateProc) _ANSI_ARGS_((Tcl_Interp * interp, Namespace * nsPtr, char * procName, Tcl_Obj * argsPtr, Tcl_Obj * bodyPtr, Proc ** procPtrPtr)); /* 10 */
    void (*tclDeleteCompiledLocalVars) _ANSI_ARGS_((Interp * iPtr, CallFrame * framePtr)); /* 11 */
    void (*tclDeleteVars) _ANSI_ARGS_((Interp * iPtr, Tcl_HashTable * tablePtr)); /* 12 */
    int (*tclDoGlob) _ANSI_ARGS_((Tcl_Interp * interp, char * separators, Tcl_DString * headPtr, char * tail)); /* 13 */
    void (*tclDumpMemoryInfo) _ANSI_ARGS_((FILE * outFile)); /* 14 */
    void *reserved15;
    void (*tclExprFloatError) _ANSI_ARGS_((Tcl_Interp * interp, double value)); /* 16 */
    int (*tclFileAttrsCmd) _ANSI_ARGS_((Tcl_Interp * interp, int objc, Tcl_Obj *CONST objv[])); /* 17 */
    int (*tclFileCopyCmd) _ANSI_ARGS_((Tcl_Interp * interp, int argc, char ** argv)); /* 18 */
    int (*tclFileDeleteCmd) _ANSI_ARGS_((Tcl_Interp * interp, int argc, char ** argv)); /* 19 */
    int (*tclFileMakeDirsCmd) _ANSI_ARGS_((Tcl_Interp * interp, int argc, char ** argv)); /* 20 */
    int (*tclFileRenameCmd) _ANSI_ARGS_((Tcl_Interp * interp, int argc, char ** argv)); /* 21 */
    int (*tclFindElement) _ANSI_ARGS_((Tcl_Interp * interp, CONST char * list, int listLength, CONST char ** elementPtr, CONST char ** nextPtr, int * sizePtr, int * bracePtr)); /* 22 */
    Proc * (*tclFindProc) _ANSI_ARGS_((Interp * iPtr, char * procName)); /* 23 */
    int (*tclFormatInt) _ANSI_ARGS_((char * buffer, long n)); /* 24 */
    void (*tclFreePackageInfo) _ANSI_ARGS_((Interp * iPtr)); /* 25 */
    void *reserved26;
    int (*tclGetDate) _ANSI_ARGS_((char * p, unsigned long now, long zone, unsigned long * timePtr)); /* 27 */
    Tcl_Channel (*tclpGetDefaultStdChannel) _ANSI_ARGS_((int type)); /* 28 */
    Tcl_Obj * (*tclGetElementOfIndexedArray) _ANSI_ARGS_((Tcl_Interp * interp, int localIndex, Tcl_Obj * elemPtr, int leaveErrorMsg)); /* 29 */
    void *reserved30;
    char * (*tclGetExtension) _ANSI_ARGS_((char * name)); /* 31 */
    int (*tclGetFrame) _ANSI_ARGS_((Tcl_Interp * interp, char * string, CallFrame ** framePtrPtr)); /* 32 */
    TclCmdProcType (*tclGetInterpProc) _ANSI_ARGS_((void)); /* 33 */
    int (*tclGetIntForIndex) _ANSI_ARGS_((Tcl_Interp * interp, Tcl_Obj * objPtr, int endValue, int * indexPtr)); /* 34 */
    Tcl_Obj * (*tclGetIndexedScalar) _ANSI_ARGS_((Tcl_Interp * interp, int localIndex, int leaveErrorMsg)); /* 35 */
    int (*tclGetLong) _ANSI_ARGS_((Tcl_Interp * interp, char * string, long * longPtr)); /* 36 */
    int (*tclGetLoadedPackages) _ANSI_ARGS_((Tcl_Interp * interp, char * targetName)); /* 37 */
    int (*tclGetNamespaceForQualName) _ANSI_ARGS_((Tcl_Interp * interp, char * qualName, Namespace * cxtNsPtr, int flags, Namespace ** nsPtrPtr, Namespace ** altNsPtrPtr, Namespace ** actualCxtPtrPtr, char ** simpleNamePtr)); /* 38 */
    TclObjCmdProcType (*tclGetObjInterpProc) _ANSI_ARGS_((void)); /* 39 */
    int (*tclGetOpenMode) _ANSI_ARGS_((Tcl_Interp * interp, char * string, int * seekFlagPtr)); /* 40 */
    Tcl_Command (*tclGetOriginalCommand) _ANSI_ARGS_((Tcl_Command command)); /* 41 */
    char * (*tclpGetUserHome) _ANSI_ARGS_((CONST char * name, Tcl_DString * bufferPtr)); /* 42 */
    int (*tclGlobalInvoke) _ANSI_ARGS_((Tcl_Interp * interp, int argc, char ** argv, int flags)); /* 43 */
    int (*tclGuessPackageName) _ANSI_ARGS_((char * fileName, Tcl_DString * bufPtr)); /* 44 */
    int (*tclHideUnsafeCommands) _ANSI_ARGS_((Tcl_Interp * interp)); /* 45 */
    int (*tclInExit) _ANSI_ARGS_((void)); /* 46 */
    Tcl_Obj * (*tclIncrElementOfIndexedArray) _ANSI_ARGS_((Tcl_Interp * interp, int localIndex, Tcl_Obj * elemPtr, long incrAmount)); /* 47 */
    Tcl_Obj * (*tclIncrIndexedScalar) _ANSI_ARGS_((Tcl_Interp * interp, int localIndex, long incrAmount)); /* 48 */
    Tcl_Obj * (*tclIncrVar2) _ANSI_ARGS_((Tcl_Interp * interp, Tcl_Obj * part1Ptr, Tcl_Obj * part2Ptr, long incrAmount, int part1NotParsed)); /* 49 */
    void (*tclInitCompiledLocals) _ANSI_ARGS_((Tcl_Interp * interp, CallFrame * framePtr, Namespace * nsPtr)); /* 50 */
    int (*tclInterpInit) _ANSI_ARGS_((Tcl_Interp * interp)); /* 51 */
    int (*tclInvoke) _ANSI_ARGS_((Tcl_Interp * interp, int argc, char ** argv, int flags)); /* 52 */
    int (*tclInvokeObjectCommand) _ANSI_ARGS_((ClientData clientData, Tcl_Interp * interp, int argc, char ** argv)); /* 53 */
    int (*tclInvokeStringCommand) _ANSI_ARGS_((ClientData clientData, Tcl_Interp * interp, int objc, Tcl_Obj *CONST objv[])); /* 54 */
    Proc * (*tclIsProc) _ANSI_ARGS_((Command * cmdPtr)); /* 55 */
    void *reserved56;
    void *reserved57;
    Var * (*tclLookupVar) _ANSI_ARGS_((Tcl_Interp * interp, char * part1, char * part2, int flags, char * msg, int createPart1, int createPart2, Var ** arrayPtrPtr)); /* 58 */
    int (*tclpMatchFiles) _ANSI_ARGS_((Tcl_Interp * interp, char * separators, Tcl_DString * dirPtr, char * pattern, char * tail)); /* 59 */
    int (*tclNeedSpace) _ANSI_ARGS_((char * start, char * end)); /* 60 */
    Tcl_Obj * (*tclNewProcBodyObj) _ANSI_ARGS_((Proc * procPtr)); /* 61 */
    int (*tclObjCommandComplete) _ANSI_ARGS_((Tcl_Obj * cmdPtr)); /* 62 */
    int (*tclObjInterpProc) _ANSI_ARGS_((ClientData clientData, Tcl_Interp * interp, int objc, Tcl_Obj *CONST objv[])); /* 63 */
    int (*tclObjInvoke) _ANSI_ARGS_((Tcl_Interp * interp, int objc, Tcl_Obj *CONST objv[], int flags)); /* 64 */
    int (*tclObjInvokeGlobal) _ANSI_ARGS_((Tcl_Interp * interp, int objc, Tcl_Obj *CONST objv[], int flags)); /* 65 */
    int (*tclOpenFileChannelDeleteProc) _ANSI_ARGS_((TclOpenFileChannelProc_ * proc)); /* 66 */
    int (*tclOpenFileChannelInsertProc) _ANSI_ARGS_((TclOpenFileChannelProc_ * proc)); /* 67 */
    int (*tclpAccess) _ANSI_ARGS_((CONST char * path, int mode)); /* 68 */
    char * (*tclpAlloc) _ANSI_ARGS_((unsigned int size)); /* 69 */
    int (*tclpCopyFile) _ANSI_ARGS_((CONST char * source, CONST char * dest)); /* 70 */
    int (*tclpCopyDirectory) _ANSI_ARGS_((CONST char * source, CONST char * dest, Tcl_DString * errorPtr)); /* 71 */
    int (*tclpCreateDirectory) _ANSI_ARGS_((CONST char * path)); /* 72 */
    int (*tclpDeleteFile) _ANSI_ARGS_((CONST char * path)); /* 73 */
    void (*tclpFree) _ANSI_ARGS_((char * ptr)); /* 74 */
    unsigned long (*tclpGetClicks) _ANSI_ARGS_((void)); /* 75 */
    unsigned long (*tclpGetSeconds) _ANSI_ARGS_((void)); /* 76 */
    void (*tclpGetTime) _ANSI_ARGS_((Tcl_Time * time)); /* 77 */
    int (*tclpGetTimeZone) _ANSI_ARGS_((unsigned long time)); /* 78 */
    int (*tclpListVolumes) _ANSI_ARGS_((Tcl_Interp * interp)); /* 79 */
    Tcl_Channel (*tclpOpenFileChannel) _ANSI_ARGS_((Tcl_Interp * interp, char * fileName, char * modeString, int permissions)); /* 80 */
    char * (*tclpRealloc) _ANSI_ARGS_((char * ptr, unsigned int size)); /* 81 */
    int (*tclpRemoveDirectory) _ANSI_ARGS_((CONST char * path, int recursive, Tcl_DString * errorPtr)); /* 82 */
    int (*tclpRenameFile) _ANSI_ARGS_((CONST char * source, CONST char * dest)); /* 83 */
    void *reserved84;
    void *reserved85;
    void *reserved86;
    void *reserved87;
    char * (*tclPrecTraceProc) _ANSI_ARGS_((ClientData clientData, Tcl_Interp * interp, char * name1, char * name2, int flags)); /* 88 */
    int (*tclPreventAliasLoop) _ANSI_ARGS_((Tcl_Interp * interp, Tcl_Interp * cmdInterp, Tcl_Command cmd)); /* 89 */
    void *reserved90;
    void (*tclProcCleanupProc) _ANSI_ARGS_((Proc * procPtr)); /* 91 */
    int (*tclProcCompileProc) _ANSI_ARGS_((Tcl_Interp * interp, Proc * procPtr, Tcl_Obj * bodyPtr, Namespace * nsPtr, CONST char * description, CONST char * procName)); /* 92 */
    void (*tclProcDeleteProc) _ANSI_ARGS_((ClientData clientData)); /* 93 */
    int (*tclProcInterpProc) _ANSI_ARGS_((ClientData clientData, Tcl_Interp * interp, int argc, char ** argv)); /* 94 */
    int (*tclpStat) _ANSI_ARGS_((CONST char * path, struct stat * buf)); /* 95 */
    int (*tclRenameCommand) _ANSI_ARGS_((Tcl_Interp * interp, char * oldName, char * newName)); /* 96 */
    void (*tclResetShadowedCmdRefs) _ANSI_ARGS_((Tcl_Interp * interp, Command * newCmdPtr)); /* 97 */
    int (*tclServiceIdle) _ANSI_ARGS_((void)); /* 98 */
    Tcl_Obj * (*tclSetElementOfIndexedArray) _ANSI_ARGS_((Tcl_Interp * interp, int localIndex, Tcl_Obj * elemPtr, Tcl_Obj * objPtr, int leaveErrorMsg)); /* 99 */
    Tcl_Obj * (*tclSetIndexedScalar) _ANSI_ARGS_((Tcl_Interp * interp, int localIndex, Tcl_Obj * objPtr, int leaveErrorMsg)); /* 100 */
    void *reserved101;
    void (*tclSetupEnv) _ANSI_ARGS_((Tcl_Interp * interp)); /* 102 */
    int (*tclSockGetPort) _ANSI_ARGS_((Tcl_Interp * interp, char * string, char * proto, int * portPtr)); /* 103 */
    int (*tclSockMinimumBuffers) _ANSI_ARGS_((int sock, int size)); /* 104 */
    int (*tclStat) _ANSI_ARGS_((CONST char * path, TclStat_ * buf)); /* 105 */
    int (*tclStatDeleteProc) _ANSI_ARGS_((TclStatProc_ * proc)); /* 106 */
    int (*tclStatInsertProc) _ANSI_ARGS_((TclStatProc_ * proc)); /* 107 */
    void (*tclTeardownNamespace) _ANSI_ARGS_((Namespace * nsPtr)); /* 108 */
    int (*tclUpdateReturnInfo) _ANSI_ARGS_((Interp * iPtr)); /* 109 */
    void *reserved110;
    void (*tcl_AddInterpResolvers) _ANSI_ARGS_((Tcl_Interp * interp, char * name, Tcl_ResolveCmdProc * cmdProc, Tcl_ResolveVarProc * varProc, Tcl_ResolveCompiledVarProc * compiledVarProc)); /* 111 */
    int (*tcl_AppendExportList) _ANSI_ARGS_((Tcl_Interp * interp, Tcl_Namespace * nsPtr, Tcl_Obj * objPtr)); /* 112 */
    Tcl_Namespace * (*tcl_CreateNamespace) _ANSI_ARGS_((Tcl_Interp * interp, char * name, ClientData clientData, Tcl_NamespaceDeleteProc * deleteProc)); /* 113 */
    void (*tcl_DeleteNamespace) _ANSI_ARGS_((Tcl_Namespace * nsPtr)); /* 114 */
    int (*tcl_Export) _ANSI_ARGS_((Tcl_Interp * interp, Tcl_Namespace * nsPtr, char * pattern, int resetListFirst)); /* 115 */
    Tcl_Command (*tcl_FindCommand) _ANSI_ARGS_((Tcl_Interp * interp, char * name, Tcl_Namespace * contextNsPtr, int flags)); /* 116 */
    Tcl_Namespace * (*tcl_FindNamespace) _ANSI_ARGS_((Tcl_Interp * interp, char * name, Tcl_Namespace * contextNsPtr, int flags)); /* 117 */
    int (*tcl_GetInterpResolvers) _ANSI_ARGS_((Tcl_Interp * interp, char * name, Tcl_ResolverInfo * resInfo)); /* 118 */
    int (*tcl_GetNamespaceResolvers) _ANSI_ARGS_((Tcl_Namespace * namespacePtr, Tcl_ResolverInfo * resInfo)); /* 119 */
    Tcl_Var (*tcl_FindNamespaceVar) _ANSI_ARGS_((Tcl_Interp * interp, char * name, Tcl_Namespace * contextNsPtr, int flags)); /* 120 */
    int (*tcl_ForgetImport) _ANSI_ARGS_((Tcl_Interp * interp, Tcl_Namespace * nsPtr, char * pattern)); /* 121 */
    Tcl_Command (*tcl_GetCommandFromObj) _ANSI_ARGS_((Tcl_Interp * interp, Tcl_Obj * objPtr)); /* 122 */
    void (*tcl_GetCommandFullName) _ANSI_ARGS_((Tcl_Interp * interp, Tcl_Command command, Tcl_Obj * objPtr)); /* 123 */
    Tcl_Namespace * (*tcl_GetCurrentNamespace) _ANSI_ARGS_((Tcl_Interp * interp)); /* 124 */
    Tcl_Namespace * (*tcl_GetGlobalNamespace) _ANSI_ARGS_((Tcl_Interp * interp)); /* 125 */
    void (*tcl_GetVariableFullName) _ANSI_ARGS_((Tcl_Interp * interp, Tcl_Var variable, Tcl_Obj * objPtr)); /* 126 */
    int (*tcl_Import) _ANSI_ARGS_((Tcl_Interp * interp, Tcl_Namespace * nsPtr, char * pattern, int allowOverwrite)); /* 127 */
    void (*tcl_PopCallFrame) _ANSI_ARGS_((Tcl_Interp* interp)); /* 128 */
    int (*tcl_PushCallFrame) _ANSI_ARGS_((Tcl_Interp* interp, Tcl_CallFrame * framePtr, Tcl_Namespace * nsPtr, int isProcCallFrame)); /* 129 */
    int (*tcl_RemoveInterpResolvers) _ANSI_ARGS_((Tcl_Interp * interp, char * name)); /* 130 */
    void (*tcl_SetNamespaceResolvers) _ANSI_ARGS_((Tcl_Namespace * namespacePtr, Tcl_ResolveCmdProc * cmdProc, Tcl_ResolveVarProc * varProc, Tcl_ResolveCompiledVarProc * compiledVarProc)); /* 131 */
    int (*tclpHasSockets) _ANSI_ARGS_((Tcl_Interp * interp)); /* 132 */
    struct tm * (*tclpGetDate) _ANSI_ARGS_((TclpTime_t time, int useGMT)); /* 133 */
    size_t (*tclpStrftime) _ANSI_ARGS_((char * s, size_t maxsize, CONST char * format, CONST struct tm * t)); /* 134 */
    int (*tclpCheckStackSpace) _ANSI_ARGS_((void)); /* 135 */
    void *reserved136;
    int (*tclpChdir) _ANSI_ARGS_((CONST char * dirName)); /* 137 */
    char * (*tclGetEnv) _ANSI_ARGS_((CONST char * name, Tcl_DString * valuePtr)); /* 138 */
    int (*tclpLoadFile) _ANSI_ARGS_((Tcl_Interp * interp, char * fileName, char * sym1, char * sym2, Tcl_PackageInitProc ** proc1Ptr, Tcl_PackageInitProc ** proc2Ptr, ClientData * clientDataPtr)); /* 139 */
    int (*tclLooksLikeInt) _ANSI_ARGS_((char * bytes, int length)); /* 140 */
} TclIntStubs;

extern TclIntStubs *tclIntStubsPtr;

#if defined(USE_TCL_STUBS) && !defined(USE_TCL_STUB_PROCS)

/*
 * Inline function declarations:
 */

#ifndef TclAccess
#define TclAccess(path, mode) \
	(tclIntStubsPtr->tclAccess)(path, mode) /* 0 */
#endif
#ifndef TclAccessDeleteProc
#define TclAccessDeleteProc(proc) \
	(tclIntStubsPtr->tclAccessDeleteProc)(proc) /* 1 */
#endif
#ifndef TclAccessInsertProc
#define TclAccessInsertProc(proc) \
	(tclIntStubsPtr->tclAccessInsertProc)(proc) /* 2 */
#endif
#ifndef TclAllocateFreeObjects
#define TclAllocateFreeObjects() \
	(tclIntStubsPtr->tclAllocateFreeObjects)() /* 3 */
#endif
/* Slot 4 is reserved */
#ifndef TclCleanupChildren
#define TclCleanupChildren(interp, numPids, pidPtr, errorChan) \
	(tclIntStubsPtr->tclCleanupChildren)(interp, numPids, pidPtr, errorChan) /* 5 */
#endif
#ifndef TclCleanupCommand
#define TclCleanupCommand(cmdPtr) \
	(tclIntStubsPtr->tclCleanupCommand)(cmdPtr) /* 6 */
#endif
#ifndef TclCopyAndCollapse
#define TclCopyAndCollapse(count, src, dst) \
	(tclIntStubsPtr->tclCopyAndCollapse)(count, src, dst) /* 7 */
#endif
#ifndef TclCopyChannel
#define TclCopyChannel(interp, inChan, outChan, toRead, cmdPtr) \
	(tclIntStubsPtr->tclCopyChannel)(interp, inChan, outChan, toRead, cmdPtr) /* 8 */
#endif
#ifndef TclCreatePipeline
#define TclCreatePipeline(interp, argc, argv, pidArrayPtr, inPipePtr, outPipePtr, errFilePtr) \
	(tclIntStubsPtr->tclCreatePipeline)(interp, argc, argv, pidArrayPtr, inPipePtr, outPipePtr, errFilePtr) /* 9 */
#endif
#ifndef TclCreateProc
#define TclCreateProc(interp, nsPtr, procName, argsPtr, bodyPtr, procPtrPtr) \
	(tclIntStubsPtr->tclCreateProc)(interp, nsPtr, procName, argsPtr, bodyPtr, procPtrPtr) /* 10 */
#endif
#ifndef TclDeleteCompiledLocalVars
#define TclDeleteCompiledLocalVars(iPtr, framePtr) \
	(tclIntStubsPtr->tclDeleteCompiledLocalVars)(iPtr, framePtr) /* 11 */
#endif
#ifndef TclDeleteVars
#define TclDeleteVars(iPtr, tablePtr) \
	(tclIntStubsPtr->tclDeleteVars)(iPtr, tablePtr) /* 12 */
#endif
#ifndef TclDoGlob
#define TclDoGlob(interp, separators, headPtr, tail) \
	(tclIntStubsPtr->tclDoGlob)(interp, separators, headPtr, tail) /* 13 */
#endif
#ifndef TclDumpMemoryInfo
#define TclDumpMemoryInfo(outFile) \
	(tclIntStubsPtr->tclDumpMemoryInfo)(outFile) /* 14 */
#endif
/* Slot 15 is reserved */
#ifndef TclExprFloatError
#define TclExprFloatError(interp, value) \
	(tclIntStubsPtr->tclExprFloatError)(interp, value) /* 16 */
#endif
#ifndef TclFileAttrsCmd
#define TclFileAttrsCmd(interp, objc, objv) \
	(tclIntStubsPtr->tclFileAttrsCmd)(interp, objc, objv) /* 17 */
#endif
#ifndef TclFileCopyCmd
#define TclFileCopyCmd(interp, argc, argv) \
	(tclIntStubsPtr->tclFileCopyCmd)(interp, argc, argv) /* 18 */
#endif
#ifndef TclFileDeleteCmd
#define TclFileDeleteCmd(interp, argc, argv) \
	(tclIntStubsPtr->tclFileDeleteCmd)(interp, argc, argv) /* 19 */
#endif
#ifndef TclFileMakeDirsCmd
#define TclFileMakeDirsCmd(interp, argc, argv) \
	(tclIntStubsPtr->tclFileMakeDirsCmd)(interp, argc, argv) /* 20 */
#endif
#ifndef TclFileRenameCmd
#define TclFileRenameCmd(interp, argc, argv) \
	(tclIntStubsPtr->tclFileRenameCmd)(interp, argc, argv) /* 21 */
#endif
#ifndef TclFindElement
#define TclFindElement(interp, list, listLength, elementPtr, nextPtr, sizePtr, bracePtr) \
	(tclIntStubsPtr->tclFindElement)(interp, list, listLength, elementPtr, nextPtr, sizePtr, bracePtr) /* 22 */
#endif
#ifndef TclFindProc
#define TclFindProc(iPtr, procName) \
	(tclIntStubsPtr->tclFindProc)(iPtr, procName) /* 23 */
#endif
#ifndef TclFormatInt
#define TclFormatInt(buffer, n) \
	(tclIntStubsPtr->tclFormatInt)(buffer, n) /* 24 */
#endif
#ifndef TclFreePackageInfo
#define TclFreePackageInfo(iPtr) \
	(tclIntStubsPtr->tclFreePackageInfo)(iPtr) /* 25 */
#endif
/* Slot 26 is reserved */
#ifndef TclGetDate
#define TclGetDate(p, now, zone, timePtr) \
	(tclIntStubsPtr->tclGetDate)(p, now, zone, timePtr) /* 27 */
#endif
#ifndef TclpGetDefaultStdChannel
#define TclpGetDefaultStdChannel(type) \
	(tclIntStubsPtr->tclpGetDefaultStdChannel)(type) /* 28 */
#endif
#ifndef TclGetElementOfIndexedArray
#define TclGetElementOfIndexedArray(interp, localIndex, elemPtr, leaveErrorMsg) \
	(tclIntStubsPtr->tclGetElementOfIndexedArray)(interp, localIndex, elemPtr, leaveErrorMsg) /* 29 */
#endif
/* Slot 30 is reserved */
#ifndef TclGetExtension
#define TclGetExtension(name) \
	(tclIntStubsPtr->tclGetExtension)(name) /* 31 */
#endif
#ifndef TclGetFrame
#define TclGetFrame(interp, string, framePtrPtr) \
	(tclIntStubsPtr->tclGetFrame)(interp, string, framePtrPtr) /* 32 */
#endif
#ifndef TclGetInterpProc
#define TclGetInterpProc() \
	(tclIntStubsPtr->tclGetInterpProc)() /* 33 */
#endif
#ifndef TclGetIntForIndex
#define TclGetIntForIndex(interp, objPtr, endValue, indexPtr) \
	(tclIntStubsPtr->tclGetIntForIndex)(interp, objPtr, endValue, indexPtr) /* 34 */
#endif
#ifndef TclGetIndexedScalar
#define TclGetIndexedScalar(interp, localIndex, leaveErrorMsg) \
	(tclIntStubsPtr->tclGetIndexedScalar)(interp, localIndex, leaveErrorMsg) /* 35 */
#endif
#ifndef TclGetLong
#define TclGetLong(interp, string, longPtr) \
	(tclIntStubsPtr->tclGetLong)(interp, string, longPtr) /* 36 */
#endif
#ifndef TclGetLoadedPackages
#define TclGetLoadedPackages(interp, targetName) \
	(tclIntStubsPtr->tclGetLoadedPackages)(interp, targetName) /* 37 */
#endif
#ifndef TclGetNamespaceForQualName
#define TclGetNamespaceForQualName(interp, qualName, cxtNsPtr, flags, nsPtrPtr, altNsPtrPtr, actualCxtPtrPtr, simpleNamePtr) \
	(tclIntStubsPtr->tclGetNamespaceForQualName)(interp, qualName, cxtNsPtr, flags, nsPtrPtr, altNsPtrPtr, actualCxtPtrPtr, simpleNamePtr) /* 38 */
#endif
#ifndef TclGetObjInterpProc
#define TclGetObjInterpProc() \
	(tclIntStubsPtr->tclGetObjInterpProc)() /* 39 */
#endif
#ifndef TclGetOpenMode
#define TclGetOpenMode(interp, string, seekFlagPtr) \
	(tclIntStubsPtr->tclGetOpenMode)(interp, string, seekFlagPtr) /* 40 */
#endif
#ifndef TclGetOriginalCommand
#define TclGetOriginalCommand(command) \
	(tclIntStubsPtr->tclGetOriginalCommand)(command) /* 41 */
#endif
#ifndef TclpGetUserHome
#define TclpGetUserHome(name, bufferPtr) \
	(tclIntStubsPtr->tclpGetUserHome)(name, bufferPtr) /* 42 */
#endif
#ifndef TclGlobalInvoke
#define TclGlobalInvoke(interp, argc, argv, flags) \
	(tclIntStubsPtr->tclGlobalInvoke)(interp, argc, argv, flags) /* 43 */
#endif
#ifndef TclGuessPackageName
#define TclGuessPackageName(fileName, bufPtr) \
	(tclIntStubsPtr->tclGuessPackageName)(fileName, bufPtr) /* 44 */
#endif
#ifndef TclHideUnsafeCommands
#define TclHideUnsafeCommands(interp) \
	(tclIntStubsPtr->tclHideUnsafeCommands)(interp) /* 45 */
#endif
#ifndef TclInExit
#define TclInExit() \
	(tclIntStubsPtr->tclInExit)() /* 46 */
#endif
#ifndef TclIncrElementOfIndexedArray
#define TclIncrElementOfIndexedArray(interp, localIndex, elemPtr, incrAmount) \
	(tclIntStubsPtr->tclIncrElementOfIndexedArray)(interp, localIndex, elemPtr, incrAmount) /* 47 */
#endif
#ifndef TclIncrIndexedScalar
#define TclIncrIndexedScalar(interp, localIndex, incrAmount) \
	(tclIntStubsPtr->tclIncrIndexedScalar)(interp, localIndex, incrAmount) /* 48 */
#endif
#ifndef TclIncrVar2
#define TclIncrVar2(interp, part1Ptr, part2Ptr, incrAmount, part1NotParsed) \
	(tclIntStubsPtr->tclIncrVar2)(interp, part1Ptr, part2Ptr, incrAmount, part1NotParsed) /* 49 */
#endif
#ifndef TclInitCompiledLocals
#define TclInitCompiledLocals(interp, framePtr, nsPtr) \
	(tclIntStubsPtr->tclInitCompiledLocals)(interp, framePtr, nsPtr) /* 50 */
#endif
#ifndef TclInterpInit
#define TclInterpInit(interp) \
	(tclIntStubsPtr->tclInterpInit)(interp) /* 51 */
#endif
#ifndef TclInvoke
#define TclInvoke(interp, argc, argv, flags) \
	(tclIntStubsPtr->tclInvoke)(interp, argc, argv, flags) /* 52 */
#endif
#ifndef TclInvokeObjectCommand
#define TclInvokeObjectCommand(clientData, interp, argc, argv) \
	(tclIntStubsPtr->tclInvokeObjectCommand)(clientData, interp, argc, argv) /* 53 */
#endif
#ifndef TclInvokeStringCommand
#define TclInvokeStringCommand(clientData, interp, objc, objv) \
	(tclIntStubsPtr->tclInvokeStringCommand)(clientData, interp, objc, objv) /* 54 */
#endif
#ifndef TclIsProc
#define TclIsProc(cmdPtr) \
	(tclIntStubsPtr->tclIsProc)(cmdPtr) /* 55 */
#endif
/* Slot 56 is reserved */
/* Slot 57 is reserved */
#ifndef TclLookupVar
#define TclLookupVar(interp, part1, part2, flags, msg, createPart1, createPart2, arrayPtrPtr) \
	(tclIntStubsPtr->tclLookupVar)(interp, part1, part2, flags, msg, createPart1, createPart2, arrayPtrPtr) /* 58 */
#endif
#ifndef TclpMatchFiles
#define TclpMatchFiles(interp, separators, dirPtr, pattern, tail) \
	(tclIntStubsPtr->tclpMatchFiles)(interp, separators, dirPtr, pattern, tail) /* 59 */
#endif
#ifndef TclNeedSpace
#define TclNeedSpace(start, end) \
	(tclIntStubsPtr->tclNeedSpace)(start, end) /* 60 */
#endif
#ifndef TclNewProcBodyObj
#define TclNewProcBodyObj(procPtr) \
	(tclIntStubsPtr->tclNewProcBodyObj)(procPtr) /* 61 */
#endif
#ifndef TclObjCommandComplete
#define TclObjCommandComplete(cmdPtr) \
	(tclIntStubsPtr->tclObjCommandComplete)(cmdPtr) /* 62 */
#endif
#ifndef TclObjInterpProc
#define TclObjInterpProc(clientData, interp, objc, objv) \
	(tclIntStubsPtr->tclObjInterpProc)(clientData, interp, objc, objv) /* 63 */
#endif
#ifndef TclObjInvoke
#define TclObjInvoke(interp, objc, objv, flags) \
	(tclIntStubsPtr->tclObjInvoke)(interp, objc, objv, flags) /* 64 */
#endif
#ifndef TclObjInvokeGlobal
#define TclObjInvokeGlobal(interp, objc, objv, flags) \
	(tclIntStubsPtr->tclObjInvokeGlobal)(interp, objc, objv, flags) /* 65 */
#endif
#ifndef TclOpenFileChannelDeleteProc
#define TclOpenFileChannelDeleteProc(proc) \
	(tclIntStubsPtr->tclOpenFileChannelDeleteProc)(proc) /* 66 */
#endif
#ifndef TclOpenFileChannelInsertProc
#define TclOpenFileChannelInsertProc(proc) \
	(tclIntStubsPtr->tclOpenFileChannelInsertProc)(proc) /* 67 */
#endif
#ifndef TclpAccess
#define TclpAccess(path, mode) \
	(tclIntStubsPtr->tclpAccess)(path, mode) /* 68 */
#endif
#ifndef TclpAlloc
#define TclpAlloc(size) \
	(tclIntStubsPtr->tclpAlloc)(size) /* 69 */
#endif
#ifndef TclpCopyFile
#define TclpCopyFile(source, dest) \
	(tclIntStubsPtr->tclpCopyFile)(source, dest) /* 70 */
#endif
#ifndef TclpCopyDirectory
#define TclpCopyDirectory(source, dest, errorPtr) \
	(tclIntStubsPtr->tclpCopyDirectory)(source, dest, errorPtr) /* 71 */
#endif
#ifndef TclpCreateDirectory
#define TclpCreateDirectory(path) \
	(tclIntStubsPtr->tclpCreateDirectory)(path) /* 72 */
#endif
#ifndef TclpDeleteFile
#define TclpDeleteFile(path) \
	(tclIntStubsPtr->tclpDeleteFile)(path) /* 73 */
#endif
#ifndef TclpFree
#define TclpFree(ptr) \
	(tclIntStubsPtr->tclpFree)(ptr) /* 74 */
#endif
#ifndef TclpGetClicks
#define TclpGetClicks() \
	(tclIntStubsPtr->tclpGetClicks)() /* 75 */
#endif
#ifndef TclpGetSeconds
#define TclpGetSeconds() \
	(tclIntStubsPtr->tclpGetSeconds)() /* 76 */
#endif
#ifndef TclpGetTime
#define TclpGetTime(time) \
	(tclIntStubsPtr->tclpGetTime)(time) /* 77 */
#endif
#ifndef TclpGetTimeZone
#define TclpGetTimeZone(time) \
	(tclIntStubsPtr->tclpGetTimeZone)(time) /* 78 */
#endif
#ifndef TclpListVolumes
#define TclpListVolumes(interp) \
	(tclIntStubsPtr->tclpListVolumes)(interp) /* 79 */
#endif
#ifndef TclpOpenFileChannel
#define TclpOpenFileChannel(interp, fileName, modeString, permissions) \
	(tclIntStubsPtr->tclpOpenFileChannel)(interp, fileName, modeString, permissions) /* 80 */
#endif
#ifndef TclpRealloc
#define TclpRealloc(ptr, size) \
	(tclIntStubsPtr->tclpRealloc)(ptr, size) /* 81 */
#endif
#ifndef TclpRemoveDirectory
#define TclpRemoveDirectory(path, recursive, errorPtr) \
	(tclIntStubsPtr->tclpRemoveDirectory)(path, recursive, errorPtr) /* 82 */
#endif
#ifndef TclpRenameFile
#define TclpRenameFile(source, dest) \
	(tclIntStubsPtr->tclpRenameFile)(source, dest) /* 83 */
#endif
/* Slot 84 is reserved */
/* Slot 85 is reserved */
/* Slot 86 is reserved */
/* Slot 87 is reserved */
#ifndef TclPrecTraceProc
#define TclPrecTraceProc(clientData, interp, name1, name2, flags) \
	(tclIntStubsPtr->tclPrecTraceProc)(clientData, interp, name1, name2, flags) /* 88 */
#endif
#ifndef TclPreventAliasLoop
#define TclPreventAliasLoop(interp, cmdInterp, cmd) \
	(tclIntStubsPtr->tclPreventAliasLoop)(interp, cmdInterp, cmd) /* 89 */
#endif
/* Slot 90 is reserved */
#ifndef TclProcCleanupProc
#define TclProcCleanupProc(procPtr) \
	(tclIntStubsPtr->tclProcCleanupProc)(procPtr) /* 91 */
#endif
#ifndef TclProcCompileProc
#define TclProcCompileProc(interp, procPtr, bodyPtr, nsPtr, description, procName) \
	(tclIntStubsPtr->tclProcCompileProc)(interp, procPtr, bodyPtr, nsPtr, description, procName) /* 92 */
#endif
#ifndef TclProcDeleteProc
#define TclProcDeleteProc(clientData) \
	(tclIntStubsPtr->tclProcDeleteProc)(clientData) /* 93 */
#endif
#ifndef TclProcInterpProc
#define TclProcInterpProc(clientData, interp, argc, argv) \
	(tclIntStubsPtr->tclProcInterpProc)(clientData, interp, argc, argv) /* 94 */
#endif
#ifndef TclpStat
#define TclpStat(path, buf) \
	(tclIntStubsPtr->tclpStat)(path, buf) /* 95 */
#endif
#ifndef TclRenameCommand
#define TclRenameCommand(interp, oldName, newName) \
	(tclIntStubsPtr->tclRenameCommand)(interp, oldName, newName) /* 96 */
#endif
#ifndef TclResetShadowedCmdRefs
#define TclResetShadowedCmdRefs(interp, newCmdPtr) \
	(tclIntStubsPtr->tclResetShadowedCmdRefs)(interp, newCmdPtr) /* 97 */
#endif
#ifndef TclServiceIdle
#define TclServiceIdle() \
	(tclIntStubsPtr->tclServiceIdle)() /* 98 */
#endif
#ifndef TclSetElementOfIndexedArray
#define TclSetElementOfIndexedArray(interp, localIndex, elemPtr, objPtr, leaveErrorMsg) \
	(tclIntStubsPtr->tclSetElementOfIndexedArray)(interp, localIndex, elemPtr, objPtr, leaveErrorMsg) /* 99 */
#endif
#ifndef TclSetIndexedScalar
#define TclSetIndexedScalar(interp, localIndex, objPtr, leaveErrorMsg) \
	(tclIntStubsPtr->tclSetIndexedScalar)(interp, localIndex, objPtr, leaveErrorMsg) /* 100 */
#endif
/* Slot 101 is reserved */
#ifndef TclSetupEnv
#define TclSetupEnv(interp) \
	(tclIntStubsPtr->tclSetupEnv)(interp) /* 102 */
#endif
#ifndef TclSockGetPort
#define TclSockGetPort(interp, string, proto, portPtr) \
	(tclIntStubsPtr->tclSockGetPort)(interp, string, proto, portPtr) /* 103 */
#endif
#ifndef TclSockMinimumBuffers
#define TclSockMinimumBuffers(sock, size) \
	(tclIntStubsPtr->tclSockMinimumBuffers)(sock, size) /* 104 */
#endif
#ifndef TclStat
#define TclStat(path, buf) \
	(tclIntStubsPtr->tclStat)(path, buf) /* 105 */
#endif
#ifndef TclStatDeleteProc
#define TclStatDeleteProc(proc) \
	(tclIntStubsPtr->tclStatDeleteProc)(proc) /* 106 */
#endif
#ifndef TclStatInsertProc
#define TclStatInsertProc(proc) \
	(tclIntStubsPtr->tclStatInsertProc)(proc) /* 107 */
#endif
#ifndef TclTeardownNamespace
#define TclTeardownNamespace(nsPtr) \
	(tclIntStubsPtr->tclTeardownNamespace)(nsPtr) /* 108 */
#endif
#ifndef TclUpdateReturnInfo
#define TclUpdateReturnInfo(iPtr) \
	(tclIntStubsPtr->tclUpdateReturnInfo)(iPtr) /* 109 */
#endif
/* Slot 110 is reserved */
#ifndef Tcl_AddInterpResolvers
#define Tcl_AddInterpResolvers(interp, name, cmdProc, varProc, compiledVarProc) \
	(tclIntStubsPtr->tcl_AddInterpResolvers)(interp, name, cmdProc, varProc, compiledVarProc) /* 111 */
#endif
#ifndef Tcl_AppendExportList
#define Tcl_AppendExportList(interp, nsPtr, objPtr) \
	(tclIntStubsPtr->tcl_AppendExportList)(interp, nsPtr, objPtr) /* 112 */
#endif
#ifndef Tcl_CreateNamespace
#define Tcl_CreateNamespace(interp, name, clientData, deleteProc) \
	(tclIntStubsPtr->tcl_CreateNamespace)(interp, name, clientData, deleteProc) /* 113 */
#endif
#ifndef Tcl_DeleteNamespace
#define Tcl_DeleteNamespace(nsPtr) \
	(tclIntStubsPtr->tcl_DeleteNamespace)(nsPtr) /* 114 */
#endif
#ifndef Tcl_Export
#define Tcl_Export(interp, nsPtr, pattern, resetListFirst) \
	(tclIntStubsPtr->tcl_Export)(interp, nsPtr, pattern, resetListFirst) /* 115 */
#endif
#ifndef Tcl_FindCommand
#define Tcl_FindCommand(interp, name, contextNsPtr, flags) \
	(tclIntStubsPtr->tcl_FindCommand)(interp, name, contextNsPtr, flags) /* 116 */
#endif
#ifndef Tcl_FindNamespace
#define Tcl_FindNamespace(interp, name, contextNsPtr, flags) \
	(tclIntStubsPtr->tcl_FindNamespace)(interp, name, contextNsPtr, flags) /* 117 */
#endif
#ifndef Tcl_GetInterpResolvers
#define Tcl_GetInterpResolvers(interp, name, resInfo) \
	(tclIntStubsPtr->tcl_GetInterpResolvers)(interp, name, resInfo) /* 118 */
#endif
#ifndef Tcl_GetNamespaceResolvers
#define Tcl_GetNamespaceResolvers(namespacePtr, resInfo) \
	(tclIntStubsPtr->tcl_GetNamespaceResolvers)(namespacePtr, resInfo) /* 119 */
#endif
#ifndef Tcl_FindNamespaceVar
#define Tcl_FindNamespaceVar(interp, name, contextNsPtr, flags) \
	(tclIntStubsPtr->tcl_FindNamespaceVar)(interp, name, contextNsPtr, flags) /* 120 */
#endif
#ifndef Tcl_ForgetImport
#define Tcl_ForgetImport(interp, nsPtr, pattern) \
	(tclIntStubsPtr->tcl_ForgetImport)(interp, nsPtr, pattern) /* 121 */
#endif
#ifndef Tcl_GetCommandFromObj
#define Tcl_GetCommandFromObj(interp, objPtr) \
	(tclIntStubsPtr->tcl_GetCommandFromObj)(interp, objPtr) /* 122 */
#endif
#ifndef Tcl_GetCommandFullName
#define Tcl_GetCommandFullName(interp, command, objPtr) \
	(tclIntStubsPtr->tcl_GetCommandFullName)(interp, command, objPtr) /* 123 */
#endif
#ifndef Tcl_GetCurrentNamespace
#define Tcl_GetCurrentNamespace(interp) \
	(tclIntStubsPtr->tcl_GetCurrentNamespace)(interp) /* 124 */
#endif
#ifndef Tcl_GetGlobalNamespace
#define Tcl_GetGlobalNamespace(interp) \
	(tclIntStubsPtr->tcl_GetGlobalNamespace)(interp) /* 125 */
#endif
#ifndef Tcl_GetVariableFullName
#define Tcl_GetVariableFullName(interp, variable, objPtr) \
	(tclIntStubsPtr->tcl_GetVariableFullName)(interp, variable, objPtr) /* 126 */
#endif
#ifndef Tcl_Import
#define Tcl_Import(interp, nsPtr, pattern, allowOverwrite) \
	(tclIntStubsPtr->tcl_Import)(interp, nsPtr, pattern, allowOverwrite) /* 127 */
#endif
#ifndef Tcl_PopCallFrame
#define Tcl_PopCallFrame(interp) \
	(tclIntStubsPtr->tcl_PopCallFrame)(interp) /* 128 */
#endif
#ifndef Tcl_PushCallFrame
#define Tcl_PushCallFrame(interp, framePtr, nsPtr, isProcCallFrame) \
	(tclIntStubsPtr->tcl_PushCallFrame)(interp, framePtr, nsPtr, isProcCallFrame) /* 129 */
#endif
#ifndef Tcl_RemoveInterpResolvers
#define Tcl_RemoveInterpResolvers(interp, name) \
	(tclIntStubsPtr->tcl_RemoveInterpResolvers)(interp, name) /* 130 */
#endif
#ifndef Tcl_SetNamespaceResolvers
#define Tcl_SetNamespaceResolvers(namespacePtr, cmdProc, varProc, compiledVarProc) \
	(tclIntStubsPtr->tcl_SetNamespaceResolvers)(namespacePtr, cmdProc, varProc, compiledVarProc) /* 131 */
#endif
#ifndef TclpHasSockets
#define TclpHasSockets(interp) \
	(tclIntStubsPtr->tclpHasSockets)(interp) /* 132 */
#endif
#ifndef TclpGetDate
#define TclpGetDate(time, useGMT) \
	(tclIntStubsPtr->tclpGetDate)(time, useGMT) /* 133 */
#endif
#ifndef TclpStrftime
#define TclpStrftime(s, maxsize, format, t) \
	(tclIntStubsPtr->tclpStrftime)(s, maxsize, format, t) /* 134 */
#endif
#ifndef TclpCheckStackSpace
#define TclpCheckStackSpace() \
	(tclIntStubsPtr->tclpCheckStackSpace)() /* 135 */
#endif
/* Slot 136 is reserved */
#ifndef TclpChdir
#define TclpChdir(dirName) \
	(tclIntStubsPtr->tclpChdir)(dirName) /* 137 */
#endif
#ifndef TclGetEnv
#define TclGetEnv(name, valuePtr) \
	(tclIntStubsPtr->tclGetEnv)(name, valuePtr) /* 138 */
#endif
#ifndef TclpLoadFile
#define TclpLoadFile(interp, fileName, sym1, sym2, proc1Ptr, proc2Ptr, clientDataPtr) \
	(tclIntStubsPtr->tclpLoadFile)(interp, fileName, sym1, sym2, proc1Ptr, proc2Ptr, clientDataPtr) /* 139 */
#endif
#ifndef TclLooksLikeInt
#define TclLooksLikeInt(bytes, length) \
	(tclIntStubsPtr->tclLooksLikeInt)(bytes, length) /* 140 */
#endif

#endif /* defined(USE_TCL_STUBS) && !defined(USE_TCL_STUB_PROCS) */

/* !END!: Do not edit above this line. */

#endif /* _TCLINTDECLS */
