#
# Packer chapter
#
# Use place to position resize grab points.
# This doesn't work that great, but gives an idea of how the placer works...
#
. config -borderwidth 10 -bg white

frame .north -width 50 -height 50 -bg grey50
frame .south -width 50 -height 50 -bg grey75
pack .north .south -side top -fill both

frame .nw -width 10 -height 10 -bg black -cursor ul_angle -class Grab
place .nw -in .north -relx 0 -rely 0 -anchor center
frame .ne -width 10 -height 10 -bg black -cursor ur_angle -class Grab
place .ne -in .north -relx 1 -rely 0 -anchor center

frame .sw -width 10 -height 10 -bg black -cursor ll_angle -class Grab
place .sw -in .south -relx 0 -rely 1 -anchor center
frame .se -width 10 -height 10 -bg black -cursor lr_angle -class Grab
place .se -in .south -relx 1 -rely 1 -anchor center

frame .mid -width 10 -height 10 -bg black -cursor double_arrow -class Grab
place .mid -in .north -relx 0.5 -rely 1 -anchor center

bind Grab <Button-1> {Mark %W %x %y}
bind Grab <B1-Motion> {Move %W %x %y}

proc Mark { w x y } {
    global grab
    set grab($w,x) $x
    set grab($w,y) $y
}
proc Move { w x y } {
    global grab
    switch $w {
	.nw -
	.ne {
	    set dx [expr $grab($w,x) - $x]
	    set width [.north cget -width]
	    set dy [expr $grab($w,y) - $y]
	    set height [.north cget -height]
	    .north configure -width [expr $width - $dx] \
		-height [expr $height - $dy]
	}
	.sw -
	.se {
	    set dx [expr $grab($w,x) - $x]
	    set width [.south cget -width]
	    set dy [expr $grab($w,y) - $y]
	    set height [.south cget -height]
	    .south configure -width [expr $width - $dx] \
		-height [expr $height - $dy]
	}
	.mid {
	    set dy [expr $grab($w,y) - $y]
	    set h1 [.north cget -height]
	    set h2 [.south cget -height]
	    .north configure -height [expr $h1 - $dy]
	    .south configure -height [expr $h2 + $dy]
	}
    }
    set grab($w,x) $x
    set grab($w,y) $y
}
