# Canvas chapter
proc StrokeInit {} {
	catch {destroy .c}
	canvas .c -bg white ; pack .c
	bind .c <Button-1> {StrokeBegin %W %x %y}
	bind .c <B1-Motion> {Stroke %W %x %y}
	bind .c <ButtonRelease-1> {StrokeEnd %W %x %y}
}
proc StrokeBegin { w x y } {
	global stroke
	catch {unset stroke}
	set stroke(N) 0
	set stroke(0) [list $x $y]
}
proc Stroke { w x y } {
	global stroke
	set last $stroke($stroke(N))
	incr stroke(N)
	set stroke($stroke(N)) [list $x $y]
	eval {$w create line} $last {$x $y -tag segments}
}
proc StrokeEnd { w x y } {
	global stroke
	set points {}
	for {set i 0} {$i <= $stroke(N)} {incr i} {
		append points $stroke($i) " "
	}
	$w delete segments
	puts [eval {$w create line} $points \
		{-tag line -smooth true -arrow last}]
}
StrokeInit
